/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.LongProgression;
import kotlin.ranges.LongRange;
import kotlinx.datetime.internal.MathJvmKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0002\u0010\t\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0002\b\u0007\u001a\u0013\u0010\u0002\u001a\u00020\u0001*\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a'\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\u0007\u0010\b\u001a\u001b\u0010\f\u001a\u00020\u000b*\u00020\t2\u0006\u0010\n\u001a\u00020\u0000H\u0000\u00a2\u0006\u0004\b\f\u0010\r\"\u001a\u0010\u000f\u001a\u00020\u000e8\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\"\u0018\u0010\u0015\u001a\u00020\u0001*\u00020\t8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014"}, d2={"", "", "clampToInt", "(J)I", "d", "n", "r", "multiplyAndAdd", "(JJJ)J", "Lkotlin/ranges/LongProgression;", "value", "", "containsUnsafe", "(Lkotlin/ranges/LongProgression;J)Z", "", "POWERS_OF_TEN", "[I", "getPOWERS_OF_TEN", "()[I", "getSizeUnsafe", "(Lkotlin/ranges/LongProgression;)I", "sizeUnsafe"})
@SourceDebugExtension(value={"SMAP\nmath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 math.kt\nkotlinx/datetime/internal/MathKt\n*L\n1#1,288:1\n155#1:289\n157#1:290\n155#1:291\n157#1:292\n155#1:293\n155#1,3:294\n155#1:297\n157#1:298\n155#1,3:299\n155#1:302\n157#1:303\n155#1:304\n160#1:305\n160#1:306\n*S KotlinDebug\n*F\n+ 1 math.kt\nkotlinx/datetime/internal/MathKt\n*L\n88#1:289\n89#1:290\n90#1:291\n91#1:292\n102#1:293\n103#1:294,3\n104#1:297\n105#1:298\n105#1:299,3\n106#1:302\n109#1:303\n109#1:304\n115#1:305\n133#1:306\n*E\n"})
public final class MathKt {
    private static final int[] POWERS_OF_TEN;

    public static final int clampToInt(long $this$clampToInt) {
        long l;
        if ($this$clampToInt > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        if ($this$clampToInt < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        return (int)l;
    }

    /*
     * WARNING - void declaration
     */
    public static final long multiplyAndAdd(long d, long n, long r) {
        void var2_2;
        long l;
        long md = d;
        long mr = r;
        if (d > 0L && r < 0L) {
            long l2 = md;
            md = l2 + -1L;
            mr += n;
        } else if (l < 0L && r > 0L) {
            long l3 = md;
            md = l3 + 1L;
            mr -= n;
        }
        return MathJvmKt.safeAdd(MathJvmKt.safeMultiply(md, (long)var2_2), mr);
    }

    public static final int[] getPOWERS_OF_TEN() {
        return POWERS_OF_TEN;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean containsUnsafe(LongProgression $this$containsUnsafe, long value) {
        LongProgression longProgression;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$containsUnsafe, (String)"<this>");
        LongRange longRange = $this$containsUnsafe.getStep() > 0L ? new LongRange($this$containsUnsafe.getFirst(), $this$containsUnsafe.getLast()) : new LongRange($this$containsUnsafe.getLast(), $this$containsUnsafe.getFirst());
        long l = longRange.getFirst();
        return (value <= longRange.getLast() ? l <= value : false) && (var1_1 - $this$containsUnsafe.getFirst()) % longProgression.getStep() == 0L;
    }

    public static final int getSizeUnsafe(LongProgression $this$sizeUnsafe) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$sizeUnsafe, (String)"<this>");
        if ($this$sizeUnsafe.isEmpty()) {
            return 0;
        }
        try {
            LongProgression longProgression;
            n = MathKt.clampToInt(MathJvmKt.safeAdd($this$sizeUnsafe.getLast(), -$this$sizeUnsafe.getFirst()) / longProgression.getStep() + 1L);
        }
        catch (ArithmeticException arithmeticException) {
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    static {
        int[] nArray = new int[10];
        int[] nArray2 = nArray;
        nArray[0] = 1;
        nArray2[1] = 10;
        nArray2[2] = 100;
        nArray2[3] = 1000;
        nArray2[4] = 10000;
        nArray2[5] = 100000;
        nArray2[6] = 1000000;
        nArray2[7] = 10000000;
        nArray2[8] = 100000000;
        nArray2[9] = 1000000000;
        POWERS_OF_TEN = nArray2;
    }
}

