/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.datetime.internal.MathKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u000b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0000H\u0096\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u000f\u001a\u00020\u000e2\b\u0010\n\u001a\u0004\u0018\u00010\rH\u0096\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0016"}, d2={"Lkotlinx/datetime/internal/DecimalFraction;", "", "", "fractionalPart", "digits", "<init>", "(II)V", "newDigits", "fractionalPartWithNDigits", "(I)I", "other", "compareTo", "(Lkotlinx/datetime/internal/DecimalFraction;)I", "", "", "equals", "(Ljava/lang/Object;)Z", "", "toString", "()Ljava/lang/String;", "hashCode", "()I", "I"})
@SourceDebugExtension(value={"SMAP\nmath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 math.kt\nkotlinx/datetime/internal/DecimalFraction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,288:1\n1#2:289\n*E\n"})
public final class DecimalFraction
implements Comparable<DecimalFraction> {
    public final int fractionalPart;
    public final int digits;

    /*
     * WARNING - void declaration
     */
    public DecimalFraction(int fractionalPart, int digits) {
        void var2_3;
        void var1_1;
        this.fractionalPart = var1_1;
        this.digits = var2_3;
        if (!(this.digits >= 0)) {
            String string = "Digits must be non-negative, but was " + this.digits;
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final int fractionalPartWithNDigits(int newDigits) {
        void var1_1;
        if (newDigits == this.digits) {
            return this.fractionalPart;
        }
        if (newDigits > this.digits) {
            return this.fractionalPart * MathKt.getPOWERS_OF_TEN()[newDigits - this.digits];
        }
        return this.fractionalPart / MathKt.getPOWERS_OF_TEN()[this.digits - var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(DecimalFraction other) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        int maxPrecision = Math.max(this.digits, other.digits);
        return Intrinsics.compare((int)this.fractionalPartWithNDigits(maxPrecision), (int)var1_1.fractionalPartWithNDigits((int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return other instanceof DecimalFraction && this.compareTo((DecimalFraction)var1_1) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var3_3;
        void var2_2;
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u242 = stringBuilder = new StringBuilder();
        int denominator = MathKt.getPOWERS_OF_TEN()[this.digits];
        $this$toString_u24lambda_u242.append(this.fractionalPart / denominator);
        $this$toString_u24lambda_u242.append('.');
        var2_2.append(StringsKt.removePrefix((String)String.valueOf(denominator + this.fractionalPart % var3_3), (CharSequence)"1"));
        return stringBuilder.toString();
    }

    public final int hashCode() {
        throw new UnsupportedOperationException("DecimalFraction is not supposed to be used as a hash key");
    }
}

