/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.OpenEndRange;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.YearMonth;
import kotlinx.datetime.YearMonthKt;
import kotlinx.datetime.YearMonthProgression;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \u00172\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0012\u0004\u0012\u00020\u00030\u0004:\u0001\u0017B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0003H\u0096\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0005\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013"}, d2={"Lkotlinx/datetime/YearMonthRange;", "Lkotlinx/datetime/YearMonthProgression;", "Lkotlin/ranges/ClosedRange;", "Lkotlinx/datetime/YearMonth;", "Lkotlin/ranges/OpenEndRange;", "start", "endInclusive", "<init>", "(Lkotlinx/datetime/YearMonth;Lkotlinx/datetime/YearMonth;)V", "value", "", "contains", "(Lkotlinx/datetime/YearMonth;)Z", "isEmpty", "()Z", "", "toString", "()Ljava/lang/String;", "getStart", "()Lkotlinx/datetime/YearMonth;", "getEndInclusive", "getEndExclusive", "endExclusive", "Companion"})
public final class YearMonthRange
extends YearMonthProgression
implements ClosedRange<YearMonth>,
OpenEndRange<YearMonth> {
    public static final Companion Companion = new Companion(null);
    private static final YearMonthRange EMPTY = new YearMonthRange(new YearMonth(0, 2), new YearMonth(0, 1));

    /*
     * WARNING - void declaration
     */
    public YearMonthRange(YearMonth start, YearMonth endInclusive) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)endInclusive, (String)"endInclusive");
        super((YearMonth)var1_1, (YearMonth)var2_2, 1L);
    }

    public final YearMonth getStart() {
        return this.getFirst();
    }

    public final YearMonth getEndInclusive() {
        return this.getLast();
    }

    public final YearMonth getEndExclusive() {
        if (Intrinsics.areEqual((Object)this.getLast(), (Object)YearMonthKt.getMAX(YearMonth.Companion))) {
            throw new IllegalStateException("Cannot return the exclusive upper bound of a range that includes YearMonth.MAX.".toString());
        }
        return YearMonthKt.plus(this.getEndInclusive(), 1, DateTimeUnit.Companion.getMONTH());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(YearMonth value) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.getFirst().compareTo(value) <= 0 && var1_1.compareTo(this.getLast()) <= 0;
    }

    @Override
    public final boolean isEmpty() {
        return this.getFirst().compareTo(this.getLast()) > 0;
    }

    @Override
    public final String toString() {
        return this.getFirst() + ".." + this.getLast();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\n\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\r\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\f\u0010\tR\u0017\u0010\u000e\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011"}, d2={"Lkotlinx/datetime/YearMonthRange$Companion;", "", "<init>", "()V", "Lkotlinx/datetime/YearMonth;", "start", "endExclusive", "Lkotlinx/datetime/YearMonthRange;", "fromRangeUntil$kotlinx_datetime", "(Lkotlinx/datetime/YearMonth;Lkotlinx/datetime/YearMonth;)Lkotlinx/datetime/YearMonthRange;", "fromRangeUntil", "endInclusive", "fromRangeTo$kotlinx_datetime", "fromRangeTo", "EMPTY", "Lkotlinx/datetime/YearMonthRange;", "getEMPTY", "()Lkotlinx/datetime/YearMonthRange;"})
    public static final class Companion {
        private Companion() {
        }

        public final YearMonthRange getEMPTY() {
            return EMPTY;
        }

        /*
         * WARNING - void declaration
         */
        public final YearMonthRange fromRangeUntil$kotlinx_datetime(YearMonth start, YearMonth endExclusive) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)endExclusive, (String)"endExclusive");
            if (Intrinsics.areEqual((Object)endExclusive, (Object)YearMonthKt.getMIN(YearMonth.Companion))) {
                return this.getEMPTY();
            }
            return this.fromRangeTo$kotlinx_datetime((YearMonth)var1_1, YearMonthKt.minus((YearMonth)var2_2, 1, DateTimeUnit.Companion.getMONTH()));
        }

        /*
         * WARNING - void declaration
         */
        public final YearMonthRange fromRangeTo$kotlinx_datetime(YearMonth start, YearMonth endInclusive) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)endInclusive, (String)"endInclusive");
            return new YearMonthRange((YearMonth)var1_1, (YearMonth)var2_2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

