/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.DateTimeArithmeticException;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.YearMonth;
import kotlinx.datetime.internal.MathJvmKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u001a!\u0010\u0005\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a!\u0010\u0007\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\u0006\u001a!\u0010\u0005\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\t\u001a!\u0010\u0007\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\t\u001a\u001b\u0010\f\u001a\u00020\u0000*\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0000\u00a2\u0006\u0004\b\f\u0010\r\"\u0015\u0010\u0011\u001a\u00020\u0000*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0018\u0010\u000b\u001a\u00020\b*\u00020\u00008@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0018\u0010\u0016\u001a\u00020\u0000*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u0018\u0010\u0018\u001a\u00020\u0000*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015"}, d2={"Lkotlinx/datetime/YearMonth;", "", "value", "Lkotlinx/datetime/DateTimeUnit$MonthBased;", "unit", "plus", "(Lkotlinx/datetime/YearMonth;ILkotlinx/datetime/DateTimeUnit$MonthBased;)Lkotlinx/datetime/YearMonth;", "minus", "", "(Lkotlinx/datetime/YearMonth;JLkotlinx/datetime/DateTimeUnit$MonthBased;)Lkotlinx/datetime/YearMonth;", "Lkotlinx/datetime/YearMonth$Companion;", "prolepticMonth", "fromProlepticMonth", "(Lkotlinx/datetime/YearMonth$Companion;J)Lkotlinx/datetime/YearMonth;", "Lkotlinx/datetime/LocalDate;", "getYearMonth", "(Lkotlinx/datetime/LocalDate;)Lkotlinx/datetime/YearMonth;", "yearMonth", "getProlepticMonth", "(Lkotlinx/datetime/YearMonth;)J", "getMAX", "(Lkotlinx/datetime/YearMonth$Companion;)Lkotlinx/datetime/YearMonth;", "MAX", "getMIN", "MIN"})
public final class YearMonthKt {
    public static final YearMonth getYearMonth(LocalDate $this$yearMonth) {
        LocalDate localDate;
        Intrinsics.checkNotNullParameter((Object)$this$yearMonth, (String)"<this>");
        return new YearMonth($this$yearMonth.getYear(), localDate.getMonth());
    }

    /*
     * WARNING - void declaration
     */
    public static final YearMonth plus(YearMonth $this$plus, int value, DateTimeUnit.MonthBased unit) {
        void var2_2;
        void var1_1;
        YearMonth yearMonth;
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return YearMonthKt.plus(yearMonth, (long)var1_1, (DateTimeUnit.MonthBased)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final YearMonth minus(YearMonth $this$minus, int value, DateTimeUnit.MonthBased unit) {
        void var2_2;
        void var1_1;
        YearMonth yearMonth;
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        return YearMonthKt.minus(yearMonth, (long)var1_1, (DateTimeUnit.MonthBased)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final YearMonth plus(YearMonth $this$plus, long value, DateTimeUnit.MonthBased unit) {
        YearMonth yearMonth;
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        try {
            long monthsToAdd = MathJvmKt.safeMultiply(value, (long)unit.getMonths());
            yearMonth = monthsToAdd == 0L ? $this$plus : YearMonthKt.fromProlepticMonth(YearMonth.Companion, MathJvmKt.safeAdd(YearMonthKt.getProlepticMonth($this$plus), monthsToAdd));
        }
        catch (ArithmeticException e) {
            throw new DateTimeArithmeticException("Arithmetic overflow when adding " + value + " of " + unit + " to " + $this$plus, e);
        }
        catch (IllegalArgumentException e) {
            YearMonth yearMonth2;
            void var3_2;
            void var1_1;
            throw new DateTimeArithmeticException("Boundaries of YearMonth exceeded when adding " + (long)var1_1 + " of " + var3_2 + " to " + yearMonth2, e);
        }
        return yearMonth;
    }

    /*
     * WARNING - void declaration
     */
    public static final YearMonth minus(YearMonth $this$minus, long value, DateTimeUnit.MonthBased unit) {
        void var3_2;
        YearMonth yearMonth;
        Intrinsics.checkNotNullParameter((Object)$this$minus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        if (value != Long.MIN_VALUE) {
            void var1_1;
            return YearMonthKt.plus($this$minus, (long)(-var1_1), unit);
        }
        return YearMonthKt.plus(YearMonthKt.plus(yearMonth, Long.MAX_VALUE, unit), 1, (DateTimeUnit.MonthBased)var3_2);
    }

    public static final long getProlepticMonth(YearMonth $this$prolepticMonth) {
        YearMonth yearMonth;
        Intrinsics.checkNotNullParameter((Object)$this$prolepticMonth, (String)"<this>");
        return (long)$this$prolepticMonth.getYear() * 12L + (long)(yearMonth.getMonthNumber$kotlinx_datetime() - 1);
    }

    /*
     * WARNING - void declaration
     */
    public static final YearMonth fromProlepticMonth(YearMonth.Companion $this$fromProlepticMonth22, long prolepticMonth) {
        void var0_1;
        void var3_6;
        void var11_8;
        void var1_3;
        Intrinsics.checkNotNullParameter((Object)$this$fromProlepticMonth22, (String)"<this>");
        long l = prolepticMonth;
        long l2 = l / 12L;
        if ((l ^ 0xCL) < 0L && l2 * 12L != l) {
            l2 += -1L;
        }
        long year2 = l2;
        int $this$fromProlepticMonth22 = LocalDate.Companion.getMIN$kotlinx_datetime().getYear();
        if (!(year2 <= (long)LocalDate.Companion.getMAX$kotlinx_datetime().getYear() ? (long)$this$fromProlepticMonth22 <= year2 : false)) {
            String $this$fromProlepticMonth22 = "Year " + year2 + " is out of range: " + LocalDate.Companion.getMIN$kotlinx_datetime().getYear() + ".." + LocalDate.Companion.getMAX$kotlinx_datetime().getYear();
            throw new IllegalArgumentException($this$fromProlepticMonth22.toString());
        }
        void var8_7 = var1_3;
        void v0 = var11_8 = var8_7 % 12L;
        int month2 = (int)(var11_8 + (0xCL & ((var11_8 ^ 0xCL) & (v0 | -v0)) >> 63)) + 1;
        return new YearMonth((int)var3_6, (int)var0_1);
    }

    public static final YearMonth getMAX(YearMonth.Companion $this$MAX) {
        Intrinsics.checkNotNullParameter((Object)$this$MAX, (String)"<this>");
        return YearMonthKt.getYearMonth(LocalDate.Companion.getMAX$kotlinx_datetime());
    }

    public static final YearMonth getMIN(YearMonth.Companion $this$MIN) {
        Intrinsics.checkNotNullParameter((Object)$this$MIN, (String)"<this>");
        return YearMonthKt.getYearMonth(LocalDate.Companion.getMIN$kotlinx_datetime());
    }
}

