/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.format.DateTimeParseException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.DateTimeFormatException;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateRange;
import kotlinx.datetime.Month;
import kotlinx.datetime.Ser;
import kotlinx.datetime.YearMonthJvmKt;
import kotlinx.datetime.YearMonthRange;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.format.YearMonthFormatKt;
import kotlinx.datetime.internal.UtilKt;
import kotlinx.datetime.serializers.YearMonthSerializer;
import kotlinx.serialization.KSerializer;

@kotlinx.serialization.Serializable(with=YearMonthSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 92\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u00029:B\u0011\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\nB\u0019\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0005\u0010\fJ\u0018\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u0018\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0000H\u0096\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001a\u0010\u001a\u001a\u00020\u00192\b\u0010\u0012\u001a\u0004\u0018\u00010\u0018H\u0096\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u000f\u0010\u001c\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010#\u001a\u00020\u0018H\u0002\u00a2\u0006\u0004\b#\u0010$R\u001a\u0010\u0004\u001a\u00020\u00038\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010%\u001a\u0004\b&\u0010'R\u0011\u0010\b\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001dR\u0014\u0010*\u001a\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001dR\u0011\u0010\t\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u0011\u00100\u001a\u00020-8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010/R\u0011\u00102\u001a\u00020-8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010/R\u0011\u00104\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u001dR\u0011\u00108\u001a\u0002058F\u00a2\u0006\u0006\u001a\u0004\b6\u00107"}, d2={"Lkotlinx/datetime/YearMonth;", "", "Ljava/io/Serializable;", "Ljava/time/YearMonth;", "value", "<init>", "(Ljava/time/YearMonth;)V", "", "year", "month", "(II)V", "Lkotlinx/datetime/Month;", "(ILkotlinx/datetime/Month;)V", "that", "Lkotlinx/datetime/YearMonthRange;", "rangeTo", "(Lkotlinx/datetime/YearMonth;)Lkotlinx/datetime/YearMonthRange;", "rangeUntil", "other", "compareTo", "(Lkotlinx/datetime/YearMonth;)I", "", "toString", "()Ljava/lang/String;", "", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "Ljava/io/ObjectInputStream;", "ois", "", "readObject", "(Ljava/io/ObjectInputStream;)V", "writeReplace", "()Ljava/lang/Object;", "Ljava/time/YearMonth;", "getValue$kotlinx_datetime", "()Ljava/time/YearMonth;", "getYear", "getMonthNumber$kotlinx_datetime", "monthNumber", "getMonth", "()Lkotlinx/datetime/Month;", "Lkotlinx/datetime/LocalDate;", "getFirstDay", "()Lkotlinx/datetime/LocalDate;", "firstDay", "getLastDay", "lastDay", "getNumberOfDays", "numberOfDays", "Lkotlinx/datetime/LocalDateRange;", "getDays", "()Lkotlinx/datetime/LocalDateRange;", "days", "Companion", "Formats"})
public final class YearMonth
implements Serializable,
Comparable<YearMonth> {
    public static final Companion Companion = new Companion(null);
    private final java.time.YearMonth value;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    public YearMonth(java.time.YearMonth value) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = var1_1;
    }

    public final java.time.YearMonth getValue$kotlinx_datetime() {
        return this.value;
    }

    public final int getYear() {
        return this.value.getYear();
    }

    public final int getMonthNumber$kotlinx_datetime() {
        return this.value.getMonthValue();
    }

    public final Month getMonth() {
        java.time.Month month2 = this.value.getMonth();
        Intrinsics.checkNotNullExpressionValue((Object)month2, (String)"getMonth(...)");
        return ConvertersKt.toKotlinMonth(month2);
    }

    public final LocalDate getFirstDay() {
        java.time.LocalDate localDate = this.value.atDay(1);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"atDay(...)");
        return new LocalDate(localDate);
    }

    public final LocalDate getLastDay() {
        java.time.LocalDate localDate = this.value.atEndOfMonth();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"atEndOfMonth(...)");
        return new LocalDate(localDate);
    }

    public final int getNumberOfDays() {
        return this.value.lengthOfMonth();
    }

    public final LocalDateRange getDays() {
        return this.getFirstDay().rangeTo(this.getLastDay());
    }

    /*
     * WARNING - void declaration
     */
    public YearMonth(int year22, int month2) {
        void var1_2;
        YearMonth yearMonth;
        YearMonth yearMonth2 = this;
        try {
            void var2_4;
            yearMonth = yearMonth2;
            java.time.YearMonth year22 = java.time.YearMonth.of(year22, (int)var2_4);
        }
        catch (DateTimeException e) {
            void var1_3;
            throw new IllegalArgumentException((Throwable)var1_3);
        }
        Intrinsics.checkNotNull((Object)var1_2);
        yearMonth((java.time.YearMonth)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public YearMonth(int year22, Month month2) {
        void var1_2;
        YearMonth yearMonth;
        Intrinsics.checkNotNullParameter((Object)((Object)month2), (String)"month");
        YearMonth yearMonth2 = this;
        try {
            void var2_4;
            yearMonth = yearMonth2;
            java.time.YearMonth year22 = java.time.YearMonth.of(year22, ConvertersKt.toJavaMonth((Month)var2_4));
        }
        catch (DateTimeException e) {
            void var1_3;
            throw new IllegalArgumentException((Throwable)var1_3);
        }
        Intrinsics.checkNotNull((Object)var1_2);
        yearMonth((java.time.YearMonth)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public final YearMonthRange rangeTo(YearMonth that) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        return YearMonthRange.Companion.fromRangeTo$kotlinx_datetime(this, (YearMonth)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final YearMonthRange rangeUntil(YearMonth that) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        return YearMonthRange.Companion.fromRangeUntil$kotlinx_datetime(this, (YearMonth)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(YearMonth other) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.value.compareTo(var1_1.value);
    }

    public final String toString() {
        String string = YearMonthJvmKt.access$getIsoFormat().format(this.value);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return this == other || other instanceof YearMonth && Intrinsics.areEqual((Object)this.value, (Object)((YearMonth)var1_1).value);
    }

    public final int hashCode() {
        return this.value.hashCode();
    }

    private final void readObject(ObjectInputStream ois) {
        throw new InvalidObjectException("kotlinx.datetime.YearMonth must be deserialized via kotlinx.datetime.Ser");
    }

    private final Object writeReplace() {
        return new Ser(11, this);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\t\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0013\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u000b\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0083T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010"}, d2={"Lkotlinx/datetime/YearMonth$Companion;", "", "<init>", "()V", "", "input", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/YearMonth;", "format", "parse", "(Ljava/lang/CharSequence;Lkotlinx/datetime/format/DateTimeFormat;)Lkotlinx/datetime/YearMonth;", "Lkotlinx/serialization/KSerializer;", "serializer", "()Lkotlinx/serialization/KSerializer;", "", "serialVersionUID", "J"})
    @SourceDebugExtension(value={"SMAP\nYearMonthJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YearMonthJvm.kt\nkotlinx/datetime/YearMonth$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final YearMonth parse(CharSequence input, DateTimeFormat<YearMonth> format) {
            void var2_3;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter(format, (String)"format");
            if (format == Formats.INSTANCE.getISO()) {
                try {
                    input = UtilKt.removeLeadingZerosFromLongYearFormYearMonth(((Object)input).toString());
                    Comparable<java.time.YearMonth> p0 = java.time.YearMonth.parse(input);
                    p0 = new YearMonth((java.time.YearMonth)p0);
                }
                catch (DateTimeParseException e) {
                    void var1_2;
                    throw new DateTimeFormatException((Throwable)var1_2);
                }
                return var1_1;
            }
            return (YearMonth)var2_3.parse((CharSequence)var1_1);
        }

        public static /* synthetic */ YearMonth parse$default(Companion companion, CharSequence charSequence, DateTimeFormat dateTimeFormat, int n, Object object) {
            if ((n & 2) != 0) {
                dateTimeFormat = Formats.INSTANCE.getISO();
            }
            return companion.parse(charSequence, dateTimeFormat);
        }

        public final KSerializer<YearMonth> serializer() {
            return YearMonthSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007"}, d2={"Lkotlinx/datetime/YearMonth$Formats;", "", "<init>", "()V", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/YearMonth;", "getISO", "()Lkotlinx/datetime/format/DateTimeFormat;", "ISO"})
    public static final class Formats {
        public static final Formats INSTANCE = new Formats();

        private Formats() {
        }

        public final DateTimeFormat<YearMonth> getISO() {
            return YearMonthFormatKt.getISO_YEAR_MONTH();
        }
    }
}

