/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.time.DateTimeException;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.DateTimeFormatException;
import kotlinx.datetime.UtcOffset;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\u001a1\u0010\u0005\u001a\u00020\u00042\n\b\u0002\u0010\u0001\u001a\u0004\u0018\u00010\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u001f\u0010\u000b\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u000b\u0010\f\"\u001f\u0010\u0011\u001a\u0006*\u00020\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\"\u001f\u0010\u0014\u001a\u0006*\u00020\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u000e\u001a\u0004\b\u0013\u0010\u0010\"\u001f\u0010\u0017\u001a\u0006*\u00020\t0\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000e\u001a\u0004\b\u0016\u0010\u0010"}, d2={"", "hours", "minutes", "seconds", "Lkotlinx/datetime/UtcOffset;", "UtcOffset", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Integer;)Lkotlinx/datetime/UtcOffset;", "", "input", "Ljava/time/format/DateTimeFormatter;", "format", "parseWithFormat", "(Ljava/lang/CharSequence;Ljava/time/format/DateTimeFormatter;)Lkotlinx/datetime/UtcOffset;", "isoFormat$delegate", "Lkotlin/Lazy;", "getIsoFormat", "()Ljava/time/format/DateTimeFormatter;", "isoFormat", "isoBasicFormat$delegate", "getIsoBasicFormat", "isoBasicFormat", "fourDigitsFormat$delegate", "getFourDigitsFormat", "fourDigitsFormat"})
@SourceDebugExtension(value={"SMAP\nUtcOffsetJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UtcOffsetJvm.kt\nkotlinx/datetime/UtcOffsetJvmKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
public final class UtcOffsetJvmKt {
    private static final Lazy isoFormat$delegate = LazyKt.lazy(UtcOffsetJvmKt::isoFormat_delegate$lambda$0);
    private static final Lazy isoBasicFormat$delegate = LazyKt.lazy(UtcOffsetJvmKt::isoBasicFormat_delegate$lambda$1);
    private static final Lazy fourDigitsFormat$delegate = LazyKt.lazy(UtcOffsetJvmKt::fourDigitsFormat_delegate$lambda$2);

    /*
     * WARNING - void declaration
     */
    public static final UtcOffset UtcOffset(Integer hours, Integer minutes, Integer seconds) {
        Integer n;
        try {
            UtcOffset utcOffset;
            if (hours != null) {
                Integer n2 = minutes;
                Integer n3 = seconds;
                ZoneOffset zoneOffset = ZoneOffset.ofHoursMinutesSeconds(hours, n2 != null ? n2 : 0, n3 != null ? n3 : 0);
                Intrinsics.checkNotNullExpressionValue((Object)zoneOffset, (String)"ofHoursMinutesSeconds(...)");
                utcOffset = new UtcOffset(zoneOffset);
            } else if (minutes != null) {
                void var1_2;
                Integer n4 = seconds;
                ZoneOffset zoneOffset = ZoneOffset.ofHoursMinutesSeconds(minutes / 60, var1_2.intValue() % 60, n4 != null ? n4 : 0);
                Intrinsics.checkNotNullExpressionValue((Object)zoneOffset, (String)"ofHoursMinutesSeconds(...)");
                utcOffset = new UtcOffset(zoneOffset);
            } else {
                void var2_3;
                void v6 = var2_3;
                ZoneOffset zoneOffset = ZoneOffset.ofTotalSeconds(v6 != null ? v6.intValue() : 0);
                Intrinsics.checkNotNullExpressionValue((Object)zoneOffset, (String)"ofTotalSeconds(...)");
                utcOffset = new UtcOffset(zoneOffset);
            }
            hours = utcOffset;
        }
        catch (DateTimeException e) {
            void var0_1;
            throw new IllegalArgumentException((Throwable)var0_1);
        }
        return n;
    }

    public static /* synthetic */ UtcOffset UtcOffset$default(Integer n, Integer n2, Integer n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = null;
        }
        if ((n4 & 2) != 0) {
            n2 = null;
        }
        if ((n4 & 4) != 0) {
            n3 = null;
        }
        return UtcOffsetJvmKt.UtcOffset(n, n2, n3);
    }

    private static final DateTimeFormatter getIsoFormat() {
        Lazy lazy = isoFormat$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getIsoBasicFormat() {
        Lazy lazy = isoBasicFormat$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    private static final DateTimeFormatter getFourDigitsFormat() {
        Lazy lazy = fourDigitsFormat$delegate;
        return (DateTimeFormatter)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private static final UtcOffset parseWithFormat(CharSequence input, DateTimeFormatter format) {
        Object object;
        try {
            Object p0 = format.parse(input, ZoneOffset::from);
            p0 = new UtcOffset((ZoneOffset)p0);
        }
        catch (DateTimeException e) {
            void var0_1;
            throw new DateTimeFormatException((Throwable)var0_1);
        }
        return object;
    }

    private static final DateTimeFormatter isoFormat_delegate$lambda$0() {
        return new DateTimeFormatterBuilder().parseCaseInsensitive().appendOffsetId().toFormatter();
    }

    private static final DateTimeFormatter isoBasicFormat_delegate$lambda$1() {
        return new DateTimeFormatterBuilder().parseCaseInsensitive().appendOffset("+HHmmss", "Z").toFormatter();
    }

    private static final DateTimeFormatter fourDigitsFormat_delegate$lambda$2() {
        return new DateTimeFormatterBuilder().parseCaseInsensitive().appendOffset("+HHMM", "+0000").toFormatter();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ UtcOffset access$parseWithFormat(CharSequence input, DateTimeFormatter format) {
        void var1_1;
        return UtcOffsetJvmKt.parseWithFormat(input, (DateTimeFormatter)var1_1);
    }

    public static final /* synthetic */ DateTimeFormatter access$getIsoFormat() {
        return UtcOffsetJvmKt.getIsoFormat();
    }

    public static final /* synthetic */ DateTimeFormatter access$getIsoBasicFormat() {
        return UtcOffsetJvmKt.getIsoBasicFormat();
    }

    public static final /* synthetic */ DateTimeFormatter access$getFourDigitsFormat() {
        return UtcOffsetJvmKt.getFourDigitsFormat();
    }
}

