/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.time.DateTimeException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Instant;
import kotlinx.datetime.FixedOffsetTimeZone;
import kotlinx.datetime.IllegalTimeZoneException;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.OverloadMarker;
import kotlinx.datetime.TimeZoneKt;
import kotlinx.datetime.TimeZoneKt__TimeZoneJvmKt;
import kotlinx.datetime.UtcOffset;
import kotlinx.datetime.serializers.TimeZoneSerializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;

@Serializable(with=TimeZoneSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\b\u0017\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\b\u001a\u00020\u0007*\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\f\u001a\u00020\u0006*\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0003\u001a\u00020\u00028\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001c\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0017"}, d2={"Lkotlinx/datetime/TimeZone;", "", "Ljava/time/ZoneId;", "zoneId", "<init>", "(Ljava/time/ZoneId;)V", "Lkotlin/time/Instant;", "Lkotlinx/datetime/LocalDateTime;", "toLocalDateTime", "(Lkotlin/time/Instant;)Lkotlinx/datetime/LocalDateTime;", "Lkotlinx/datetime/OverloadMarker;", "youShallNotPass", "toInstant", "(Lkotlinx/datetime/LocalDateTime;Lkotlinx/datetime/OverloadMarker;)Lkotlin/time/Instant;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/time/ZoneId;", "getZoneId$kotlinx_datetime", "()Ljava/time/ZoneId;", "getId", "id", "Companion"})
public class TimeZone {
    public static final Companion Companion = new Companion(null);
    private final ZoneId zoneId;
    private static final FixedOffsetTimeZone UTC;

    /*
     * WARNING - void declaration
     */
    public TimeZone(ZoneId zoneId) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        this.zoneId = var1_1;
    }

    public final ZoneId getZoneId$kotlinx_datetime() {
        return this.zoneId;
    }

    public final String getId() {
        String string = this.zoneId.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final LocalDateTime toLocalDateTime(Instant $this$toLocalDateTime) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$toLocalDateTime, (String)"<this>");
        return TimeZoneKt.toLocalDateTime((Instant)var1_1, this);
    }

    /*
     * WARNING - void declaration
     */
    public final Instant toInstant(LocalDateTime $this$toInstant, OverloadMarker youShallNotPass) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)$this$toInstant, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)var2_2, (String)"youShallNotPass");
        return TimeZoneKt.toInstant$default((LocalDateTime)var1_1, this, null, 2, null);
    }

    public static /* synthetic */ Instant toInstant$default(TimeZone timeZone, LocalDateTime localDateTime, OverloadMarker overloadMarker, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: toInstant");
        }
        if ((n & 1) != 0) {
            overloadMarker = OverloadMarker.Companion.getINSTANCE$kotlinx_datetime();
        }
        return timeZone.toInstant(localDateTime, overloadMarker);
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        void var1_1;
        return this == other || other instanceof TimeZone && Intrinsics.areEqual((Object)this.zoneId, (Object)((TimeZone)var1_1).zoneId);
    }

    public int hashCode() {
        return this.zoneId.hashCode();
    }

    public String toString() {
        String string = this.zoneId.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static {
        UtcOffset utcOffset = UtcOffset.Companion.getZERO();
        ZoneId zoneId = ZoneId.of("UTC");
        Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"of(...)");
        UTC = new FixedOffsetTimeZone(utcOffset, zoneId);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0017\u0010\u000e\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u000bH\u0000\u00a2\u0006\u0004\b\f\u0010\rJ\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0013\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016"}, d2={"Lkotlinx/datetime/TimeZone$Companion;", "", "<init>", "()V", "Lkotlinx/datetime/TimeZone;", "currentSystemDefault", "()Lkotlinx/datetime/TimeZone;", "", "zoneId", "of", "(Ljava/lang/String;)Lkotlinx/datetime/TimeZone;", "Ljava/time/ZoneId;", "ofZone$kotlinx_datetime", "(Ljava/time/ZoneId;)Lkotlinx/datetime/TimeZone;", "ofZone", "Lkotlinx/serialization/KSerializer;", "serializer", "()Lkotlinx/serialization/KSerializer;", "Lkotlinx/datetime/FixedOffsetTimeZone;", "UTC", "Lkotlinx/datetime/FixedOffsetTimeZone;", "getUTC", "()Lkotlinx/datetime/FixedOffsetTimeZone;"})
    public static final class Companion {
        private Companion() {
        }

        public final TimeZone currentSystemDefault() {
            ZoneId zoneId = ZoneId.systemDefault();
            Intrinsics.checkNotNullExpressionValue((Object)zoneId, (String)"systemDefault(...)");
            return this.ofZone$kotlinx_datetime(zoneId);
        }

        public final FixedOffsetTimeZone getUTC() {
            return UTC;
        }

        /*
         * WARNING - void declaration
         */
        public final TimeZone of(String zoneId) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
            try {
                ZoneId zoneId2 = ZoneId.of((String)(Intrinsics.areEqual((Object)zoneId, (Object)"z") ? "Z" : zoneId));
                Intrinsics.checkNotNullExpressionValue((Object)zoneId2, (String)"of(...)");
                zoneId = this.ofZone$kotlinx_datetime(zoneId2);
            }
            catch (Exception exception) {
                Exception e = exception;
                if (exception instanceof DateTimeException) {
                    throw new IllegalTimeZoneException(e);
                }
                throw var1_1;
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final TimeZone ofZone$kotlinx_datetime(ZoneId zoneId) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
            if (zoneId instanceof ZoneOffset) {
                return new FixedOffsetTimeZone(new UtcOffset((ZoneOffset)zoneId));
            }
            if (TimeZoneKt__TimeZoneJvmKt.access$isFixedOffset(zoneId)) {
                ZoneId zoneId2 = zoneId.normalized();
                Intrinsics.checkNotNull((Object)zoneId2, (String)"null cannot be cast to non-null type java.time.ZoneOffset");
                return new FixedOffsetTimeZone(new UtcOffset((ZoneOffset)zoneId2), zoneId);
            }
            return new TimeZone((ZoneId)var1_1);
        }

        public final KSerializer<TimeZone> serializer() {
            return TimeZoneSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

