/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.UtcOffset;
import kotlinx.datetime.UtcOffsetJvmKt;
import kotlinx.datetime.YearMonth;
import kotlinx.datetime.YearMonthJvmKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0003\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0012R\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0013"}, d2={"Lkotlinx/datetime/Ser;", "Ljava/io/Externalizable;", "", "typeTag", "", "value", "<init>", "(ILjava/lang/Object;)V", "()V", "Ljava/io/ObjectOutput;", "out", "", "writeExternal", "(Ljava/io/ObjectOutput;)V", "Ljava/io/ObjectInput;", "in", "readExternal", "(Ljava/io/ObjectInput;)V", "I", "Ljava/lang/Object;", "Companion"})
@PublishedApi
public final class Ser
implements Externalizable {
    public static final Companion Companion = new Companion(null);
    private int typeTag;
    private Object value;

    /*
     * WARNING - void declaration
     */
    public Ser(int typeTag, Object value) {
        void var2_2;
        void var1_1;
        this.typeTag = var1_1;
        this.value = var2_2;
    }

    public Ser() {
        this(0, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeExternal(ObjectOutput out) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        out.writeByte(this.typeTag);
        Object value = this.value;
        switch (this.typeTag) {
            case 2: {
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlinx.datetime.LocalDate");
                LocalDate cfr_ignored_0 = (LocalDate)value;
                out.writeLong(((LocalDate)value).getValue$kotlinx_datetime().toEpochDay());
                return;
            }
            case 3: {
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlinx.datetime.LocalTime");
                LocalTime cfr_ignored_1 = (LocalTime)value;
                out.writeLong(((LocalTime)value).toNanosecondOfDay());
                return;
            }
            case 4: {
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlinx.datetime.LocalDateTime");
                LocalDateTime cfr_ignored_2 = (LocalDateTime)value;
                out.writeLong(((LocalDateTime)value).getDate().getValue$kotlinx_datetime().toEpochDay());
                out.writeLong(((LocalDateTime)value).getTime().toNanosecondOfDay());
                return;
            }
            case 10: {
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlinx.datetime.UtcOffset");
                UtcOffset cfr_ignored_3 = (UtcOffset)value;
                out.writeInt(((UtcOffset)value).getTotalSeconds());
                return;
            }
            case 11: {
                void var1_1;
                Intrinsics.checkNotNull((Object)value, (String)"null cannot be cast to non-null type kotlinx.datetime.YearMonth");
                YearMonth cfr_ignored_4 = (YearMonth)value;
                var1_1.writeLong(YearMonthJvmKt.toEpochMonths((YearMonth)value));
                return;
            }
        }
        throw new IllegalStateException("Unknown type tag: " + this.typeTag + " for value: " + var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void readExternal(ObjectInput in) {
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        this.typeTag = in.readByte();
        switch (this.typeTag) {
            case 2: {
                java.time.LocalDate localDate = java.time.LocalDate.ofEpochDay(in.readLong());
                Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"ofEpochDay(...)");
                serializable = new LocalDate(localDate);
                break;
            }
            case 3: {
                serializable = LocalTime.Companion.fromNanosecondOfDay(in.readLong());
                break;
            }
            case 4: {
                java.time.LocalDate localDate = java.time.LocalDate.ofEpochDay(in.readLong());
                Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"ofEpochDay(...)");
                serializable = new LocalDateTime(new LocalDate(localDate), LocalTime.Companion.fromNanosecondOfDay(in.readLong()));
                break;
            }
            case 10: {
                serializable = UtcOffsetJvmKt.UtcOffset$default(null, null, in.readInt(), 3, null);
                break;
            }
            case 11: {
                void var1_1;
                serializable = YearMonthJvmKt.fromEpochMonths(YearMonth.Companion, var1_1.readLong());
                break;
            }
            default: {
                throw new IOException("Unknown type tag: " + this.typeTag);
            }
        }
        this.value = serializable;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Lkotlinx/datetime/Ser$Companion;", "", "<init>", "()V"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

