/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.format.DateTimeParseException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.DateTimeFormatException;
import kotlinx.datetime.LocalTimeKt;
import kotlinx.datetime.Ser;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.format.DateTimeFormatBuilder;
import kotlinx.datetime.format.LocalTimeFormat;
import kotlinx.datetime.format.LocalTimeFormatKt;
import kotlinx.datetime.serializers.LocalTimeSerializer;
import kotlinx.serialization.KSerializer;

@kotlinx.serialization.Serializable(with=LocalTimeSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\r\b\u0007\u0018\u0000 ,2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0002,-B\u0011\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B-\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\fJ\r\u0010\r\u001a\u00020\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000f\u0010\u000eJ\r\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001a\u0010\u0016\u001a\u00020\u00152\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0096\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0018\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u000eJ\u000f\u0010\u001a\u001a\u00020\u0019H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0018\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0000H\u0096\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b!\u0010\"J\u000f\u0010#\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b#\u0010$R\u001a\u0010\u0004\u001a\u00020\u00038\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010%\u001a\u0004\b&\u0010'R\u0011\u0010\b\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u000eR\u0011\u0010\t\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u000eR\u0011\u0010\n\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u000e"}, d2={"Lkotlinx/datetime/LocalTime;", "", "Ljava/io/Serializable;", "Ljava/time/LocalTime;", "value", "<init>", "(Ljava/time/LocalTime;)V", "", "hour", "minute", "second", "nanosecond", "(IIII)V", "toSecondOfDay", "()I", "toMillisecondOfDay", "", "toNanosecondOfDay", "()J", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "compareTo", "(Lkotlinx/datetime/LocalTime;)I", "Ljava/io/ObjectInputStream;", "ois", "", "readObject", "(Ljava/io/ObjectInputStream;)V", "writeReplace", "()Ljava/lang/Object;", "Ljava/time/LocalTime;", "getValue$kotlinx_datetime", "()Ljava/time/LocalTime;", "getHour", "getMinute", "getSecond", "getNanosecond", "Companion", "Formats"})
public final class LocalTime
implements Serializable,
Comparable<LocalTime> {
    public static final Companion Companion = new Companion(null);
    private final java.time.LocalTime value;
    private static final LocalTime MIN;
    private static final LocalTime MAX;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    public LocalTime(java.time.LocalTime value) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = var1_1;
    }

    public final java.time.LocalTime getValue$kotlinx_datetime() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public LocalTime(int hour22, int minute2, int second2, int nanosecond) {
        void var1_2;
        LocalTime localTime;
        LocalTime localTime2 = this;
        try {
            void var3_5;
            void var2_4;
            localTime = localTime2;
            java.time.LocalTime hour22 = java.time.LocalTime.of(hour22, (int)var2_4, (int)var3_5, nanosecond);
        }
        catch (DateTimeException e) {
            void var1_3;
            throw new IllegalArgumentException((Throwable)var1_3);
        }
        Intrinsics.checkNotNull((Object)var1_2);
        localTime((java.time.LocalTime)var1_2);
    }

    public /* synthetic */ LocalTime(int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 4) != 0) {
            n3 = 0;
        }
        if ((n5 & 8) != 0) {
            n4 = 0;
        }
        this(n, n2, n3, n4);
    }

    public final int getHour() {
        return this.value.getHour();
    }

    public final int getMinute() {
        return this.value.getMinute();
    }

    public final int getSecond() {
        return this.value.getSecond();
    }

    public final int getNanosecond() {
        return this.value.getNano();
    }

    public final int toSecondOfDay() {
        return this.value.toSecondOfDay();
    }

    public final int toMillisecondOfDay() {
        return (int)(this.value.toNanoOfDay() / 1000000L);
    }

    public final long toNanosecondOfDay() {
        return this.value.toNanoOfDay();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return this == other || other instanceof LocalTime && Intrinsics.areEqual((Object)this.value, (Object)((LocalTime)var1_1).value);
    }

    public final int hashCode() {
        return this.value.hashCode();
    }

    public final String toString() {
        String string = this.value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(LocalTime other) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.value.compareTo(var1_1.value);
    }

    private final void readObject(ObjectInputStream ois) {
        throw new InvalidObjectException("kotlinx.datetime.LocalTime must be deserialized via kotlinx.datetime.Ser");
    }

    private final Object writeReplace() {
        return new Ser(3, this);
    }

    static {
        java.time.LocalTime localTime = java.time.LocalTime.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"MIN");
        MIN = new LocalTime(localTime);
        java.time.LocalTime localTime2 = java.time.LocalTime.MAX;
        Intrinsics.checkNotNullExpressionValue((Object)localTime2, (String)"MAX");
        MAX = new LocalTime(localTime2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\t\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ,\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0017\u0010\u0013\u001a\u0013\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0013\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u00078\u0000X\u0081\u0004\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u00078\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001a\u001a\u0004\b\u001e\u0010\u001cR\u0014\u0010\u001f\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 "}, d2={"Lkotlinx/datetime/LocalTime$Companion;", "", "<init>", "()V", "", "input", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/LocalTime;", "format", "parse", "(Ljava/lang/CharSequence;Lkotlinx/datetime/format/DateTimeFormat;)Lkotlinx/datetime/LocalTime;", "", "nanosecondOfDay", "fromNanosecondOfDay", "(J)Lkotlinx/datetime/LocalTime;", "Lkotlin/Function1;", "Lkotlinx/datetime/format/DateTimeFormatBuilder$WithTime;", "", "Lkotlin/ExtensionFunctionType;", "builder", "Format", "(Lkotlin/jvm/functions/Function1;)Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/serialization/KSerializer;", "serializer", "()Lkotlinx/serialization/KSerializer;", "MIN", "Lkotlinx/datetime/LocalTime;", "getMIN$kotlinx_datetime", "()Lkotlinx/datetime/LocalTime;", "MAX", "getMAX$kotlinx_datetime", "serialVersionUID", "J"})
    @SourceDebugExtension(value={"SMAP\nLocalTimeJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalTimeJvm.kt\nkotlinx/datetime/LocalTime$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final LocalTime parse(CharSequence input, DateTimeFormat<LocalTime> format) {
            void var2_3;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter(format, (String)"format");
            if (format == Formats.INSTANCE.getISO()) {
                try {
                    Comparable<java.time.LocalTime> p0 = java.time.LocalTime.parse(input);
                    p0 = new LocalTime((java.time.LocalTime)p0);
                }
                catch (DateTimeParseException e) {
                    void var1_2;
                    throw new DateTimeFormatException((Throwable)var1_2);
                }
                return var1_1;
            }
            return (LocalTime)var2_3.parse((CharSequence)var1_1);
        }

        public static /* synthetic */ LocalTime parse$default(Companion companion, CharSequence charSequence, DateTimeFormat dateTimeFormat, int n, Object object) {
            if ((n & 2) != 0) {
                dateTimeFormat = LocalTimeKt.getIsoTimeFormat();
            }
            return companion.parse(charSequence, dateTimeFormat);
        }

        /*
         * WARNING - void declaration
         */
        public final LocalTime fromNanosecondOfDay(long nanosecondOfDay) {
            void var1_2;
            try {
                Comparable<java.time.LocalTime> p0 = java.time.LocalTime.ofNanoOfDay(nanosecondOfDay);
                p0 = new LocalTime((java.time.LocalTime)p0);
            }
            catch (DateTimeException e) {
                void var1_3;
                throw new IllegalArgumentException((Throwable)var1_3);
            }
            return var1_2;
        }

        public final LocalTime getMIN$kotlinx_datetime() {
            return MIN;
        }

        public final LocalTime getMAX$kotlinx_datetime() {
            return MAX;
        }

        /*
         * WARNING - void declaration
         */
        public final DateTimeFormat<LocalTime> Format(Function1<? super DateTimeFormatBuilder.WithTime, Unit> builder) {
            void var1_1;
            Intrinsics.checkNotNullParameter(builder, (String)"builder");
            return LocalTimeFormat.Companion.build((Function1<? super DateTimeFormatBuilder.WithTime, Unit>)var1_1);
        }

        public final KSerializer<LocalTime> serializer() {
            return LocalTimeSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007"}, d2={"Lkotlinx/datetime/LocalTime$Formats;", "", "<init>", "()V", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/LocalTime;", "getISO", "()Lkotlinx/datetime/format/DateTimeFormat;", "ISO"})
    public static final class Formats {
        public static final Formats INSTANCE = new Formats();

        private Formats() {
        }

        public final DateTimeFormat<LocalTime> getISO() {
            return LocalTimeFormatKt.getISO_TIME();
        }
    }
}

