/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.OpenEndRange;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateKt;
import kotlinx.datetime.LocalDateProgression;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u0000 \u00172\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u00022\b\u0012\u0004\u0012\u00020\u00030\u0004:\u0001\u0017B\u0017\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\u0003H\u0096\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00020\nH\u0016\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0005\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0006\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0013R\u0014\u0010\u0016\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013"}, d2={"Lkotlinx/datetime/LocalDateRange;", "Lkotlinx/datetime/LocalDateProgression;", "Lkotlin/ranges/ClosedRange;", "Lkotlinx/datetime/LocalDate;", "Lkotlin/ranges/OpenEndRange;", "start", "endInclusive", "<init>", "(Lkotlinx/datetime/LocalDate;Lkotlinx/datetime/LocalDate;)V", "value", "", "contains", "(Lkotlinx/datetime/LocalDate;)Z", "isEmpty", "()Z", "", "toString", "()Ljava/lang/String;", "getStart", "()Lkotlinx/datetime/LocalDate;", "getEndInclusive", "getEndExclusive", "endExclusive", "Companion"})
public final class LocalDateRange
extends LocalDateProgression
implements ClosedRange<LocalDate>,
OpenEndRange<LocalDate> {
    public static final Companion Companion = new Companion(null);
    private static final LocalDateRange EMPTY = new LocalDateRange(new LocalDate(1970, 1, 2), new LocalDate(1970, 1, 1));

    /*
     * WARNING - void declaration
     */
    public LocalDateRange(LocalDate start, LocalDate endInclusive) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)endInclusive, (String)"endInclusive");
        super((LocalDate)var1_1, (LocalDate)var2_2, 1L);
    }

    public final LocalDate getStart() {
        return this.getFirst();
    }

    public final LocalDate getEndInclusive() {
        return this.getLast();
    }

    public final LocalDate getEndExclusive() {
        if (Intrinsics.areEqual((Object)this.getLast(), (Object)LocalDate.Companion.getMAX$kotlinx_datetime())) {
            throw new IllegalStateException("Cannot return the exclusive upper bound of a range that includes LocalDate.MAX.".toString());
        }
        return LocalDateKt.plus(this.getEndInclusive(), 1, DateTimeUnit.Companion.getDAY());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(LocalDate value) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.getFirst().compareTo(value) <= 0 && var1_1.compareTo(this.getLast()) <= 0;
    }

    @Override
    public final boolean isEmpty() {
        return this.getFirst().compareTo(this.getLast()) > 0;
    }

    @Override
    public final String toString() {
        return this.getFirst() + ".." + this.getLast();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\n\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\r\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004H\u0000\u00a2\u0006\u0004\b\f\u0010\tR\u0017\u0010\u000e\u001a\u00020\u00078\u0006\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011"}, d2={"Lkotlinx/datetime/LocalDateRange$Companion;", "", "<init>", "()V", "Lkotlinx/datetime/LocalDate;", "start", "endExclusive", "Lkotlinx/datetime/LocalDateRange;", "fromRangeUntil$kotlinx_datetime", "(Lkotlinx/datetime/LocalDate;Lkotlinx/datetime/LocalDate;)Lkotlinx/datetime/LocalDateRange;", "fromRangeUntil", "endInclusive", "fromRangeTo$kotlinx_datetime", "fromRangeTo", "EMPTY", "Lkotlinx/datetime/LocalDateRange;", "getEMPTY", "()Lkotlinx/datetime/LocalDateRange;"})
    public static final class Companion {
        private Companion() {
        }

        public final LocalDateRange getEMPTY() {
            return EMPTY;
        }

        /*
         * WARNING - void declaration
         */
        public final LocalDateRange fromRangeUntil$kotlinx_datetime(LocalDate start, LocalDate endExclusive) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)endExclusive, (String)"endExclusive");
            if (Intrinsics.areEqual((Object)endExclusive, (Object)LocalDate.Companion.getMIN$kotlinx_datetime())) {
                return this.getEMPTY();
            }
            return this.fromRangeTo$kotlinx_datetime((LocalDate)var1_1, LocalDateKt.minus((LocalDate)var2_2, 1, DateTimeUnit.Companion.getDAY()));
        }

        /*
         * WARNING - void declaration
         */
        public final LocalDateRange fromRangeTo$kotlinx_datetime(LocalDate start, LocalDate endInclusive) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)endInclusive, (String)"endInclusive");
            return new LocalDateRange((LocalDate)var1_1, (LocalDate)var2_2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

