/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.LongProgression;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateProgressionIterator;
import kotlinx.datetime.internal.MathKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\b\u0017\u0018\u0000 +2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001+B\u0011\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B!\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u0012\u0006\u0010\b\u001a\u00020\u0002\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0096\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u0010\u001a\u00020\u000fH\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0016\u001a\u00020\u000f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0018\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001a\u0010\u001d\u001a\u00020\u000f2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0096\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010 \u001a\u00020\u001fH\u0016\u00a2\u0006\u0004\b \u0010!R\u0014\u0010\u0004\u001a\u00020\u00038\u0000X\u0080\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\"R\u0017\u0010#\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R\u0017\u0010'\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b'\u0010$\u001a\u0004\b(\u0010&R\u0014\u0010*\u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010!"}, d2={"Lkotlinx/datetime/LocalDateProgression;", "", "Lkotlinx/datetime/LocalDate;", "Lkotlin/ranges/LongProgression;", "longProgression", "<init>", "(Lkotlin/ranges/LongProgression;)V", "start", "endInclusive", "", "step", "(Lkotlinx/datetime/LocalDate;Lkotlinx/datetime/LocalDate;J)V", "", "iterator", "()Ljava/util/Iterator;", "", "isEmpty", "()Z", "", "toString", "()Ljava/lang/String;", "elements", "containsAll", "(Ljava/util/Collection;)Z", "value", "contains", "(Lkotlinx/datetime/LocalDate;)Z", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "Lkotlin/ranges/LongProgression;", "first", "Lkotlinx/datetime/LocalDate;", "getFirst", "()Lkotlinx/datetime/LocalDate;", "last", "getLast", "getSize", "size", "Companion"})
@SourceDebugExtension(value={"SMAP\nLocalDateRange.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDateRange.kt\nkotlinx/datetime/LocalDateProgression\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,278:1\n1740#2,3:279\n*S KotlinDebug\n*F\n+ 1 LocalDateRange.kt\nkotlinx/datetime/LocalDateProgression\n*L\n73#1:279,3\n*E\n"})
public class LocalDateProgression
implements Collection<LocalDate>,
KMappedMarker {
    public static final Companion Companion = new Companion(null);
    public final LongProgression longProgression;
    private final LocalDate first;
    private final LocalDate last;

    /*
     * WARNING - void declaration
     */
    public LocalDateProgression(LongProgression longProgression) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)longProgression, (String)"longProgression");
        this.longProgression = var1_1;
        this.first = LocalDate.Companion.fromEpochDays(this.longProgression.getFirst());
        this.last = LocalDate.Companion.fromEpochDays(this.longProgression.getLast());
    }

    /*
     * WARNING - void declaration
     */
    public LocalDateProgression(LocalDate start, LocalDate endInclusive, long step) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)start, (String)"start");
        Intrinsics.checkNotNullParameter((Object)endInclusive, (String)"endInclusive");
        this(LongProgression.Companion.fromClosedRange(var1_1.toEpochDays(), var2_2.toEpochDays(), (long)var3_3));
    }

    public final LocalDate getFirst() {
        return this.first;
    }

    public final LocalDate getLast() {
        return this.last;
    }

    @Override
    public Iterator<LocalDate> iterator() {
        return new LocalDateProgressionIterator(this.longProgression.iterator());
    }

    @Override
    public boolean isEmpty() {
        return this.longProgression.isEmpty();
    }

    public String toString() {
        if (this.longProgression.getStep() > 0L) {
            return this.first + ".." + this.last + " step " + this.longProgression.getStep() + 'D';
        }
        return this.first + " downTo " + this.last + " step " + this.longProgression.getStep() + 'D';
    }

    public int getSize() {
        return MathKt.getSizeUnsafe(this.longProgression);
    }

    @Override
    public boolean containsAll(Collection<?> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        Iterable $this$all$iv = elements;
        if (!((Collection)$this$all$iv).isEmpty()) {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Object t;
                Object it = t = iterator.next();
                if (t instanceof LocalDate && this.contains(t)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(LocalDate value) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return MathKt.containsUnsafe(this.longProgression, var1_1.toEpochDays());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object other) {
        void var1_1;
        return other instanceof LocalDateProgression && Intrinsics.areEqual((Object)this.longProgression, (Object)((LocalDateProgression)var1_1).longProgression);
    }

    @Override
    public int hashCode() {
        return this.longProgression.hashCode();
    }

    @Override
    public boolean remove(Object element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends LocalDate> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<?> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<?> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeIf(Predicate<? super LocalDate> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T[] toArray(T[] array) {
        void var1_1;
        Intrinsics.checkNotNullParameter(array, (String)"array");
        return CollectionToArray.toArray((Collection)this, (Object[])var1_1);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Lkotlinx/datetime/LocalDateProgression$Companion;", "", "<init>", "()V"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

