/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.time.DateTimeException;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.DatePeriod;
import kotlinx.datetime.DateTimeArithmeticException;
import kotlinx.datetime.DateTimeUnit;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.internal.MathJvmKt;
import kotlinx.datetime.internal.MathKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\u001a!\u0010\u0005\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\t\u0010\n\u001a\u001c\u0010\u0005\u001a\u00020\u0000*\u00020\u00002\u0006\u0010\f\u001a\u00020\u000bH\u0086\u0002\u00a2\u0006\u0004\b\u0005\u0010\r\u001a\u0019\u0010\u0010\u001a\u00020\u000f*\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011\"\u0014\u0010\u0012\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013\"\u0014\u0010\u0014\u001a\u00020\u00018\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013"}, d2={"Lkotlinx/datetime/LocalDate;", "", "value", "Lkotlinx/datetime/DateTimeUnit$DateBased;", "unit", "plus", "(Lkotlinx/datetime/LocalDate;JLkotlinx/datetime/DateTimeUnit$DateBased;)Lkotlinx/datetime/LocalDate;", "epochDay", "Ljava/time/LocalDate;", "ofEpochDayChecked", "(J)Ljava/time/LocalDate;", "Lkotlinx/datetime/DatePeriod;", "period", "(Lkotlinx/datetime/LocalDate;Lkotlinx/datetime/DatePeriod;)Lkotlinx/datetime/LocalDate;", "other", "", "daysUntil", "(Lkotlinx/datetime/LocalDate;Lkotlinx/datetime/LocalDate;)I", "minEpochDay", "J", "maxEpochDay"})
@JvmName(name="LocalDateJvmKt")
@SourceDebugExtension(value={"SMAP\nLocalDate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDate.kt\nkotlinx/datetime/LocalDateJvmKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1#2:211\n*E\n"})
public final class LocalDateJvmKt {
    private static final long minEpochDay = java.time.LocalDate.MIN.toEpochDay();
    private static final long maxEpochDay = java.time.LocalDate.MAX.toEpochDay();

    /*
     * WARNING - void declaration
     */
    public static final LocalDate plus(LocalDate $this$plus, long value, DateTimeUnit.DateBased unit) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        try {
            java.time.LocalDate localDate;
            object = unit;
            if (object instanceof DateTimeUnit.DayBased) {
                long addDays = MathJvmKt.safeMultiply(value, (long)((DateTimeUnit.DayBased)unit).getDays());
                localDate = LocalDateJvmKt.ofEpochDayChecked(MathJvmKt.safeAdd($this$plus.getValue$kotlinx_datetime().toEpochDay(), addDays));
            } else if (object instanceof DateTimeUnit.MonthBased) {
                localDate = $this$plus.getValue$kotlinx_datetime().plusMonths(MathJvmKt.safeMultiply(value, (long)((DateTimeUnit.MonthBased)unit).getMonths()));
            } else {
                throw new NoWhenBranchMatchedException();
            }
            java.time.LocalDate p0 = localDate;
            object = new LocalDate(p0);
        }
        catch (Exception exception) {
            LocalDate localDate;
            void var3_2;
            void var1_1;
            Exception e = exception;
            if (!(exception instanceof DateTimeException) && !(e instanceof ArithmeticException)) {
                throw e;
            }
            throw new DateTimeArithmeticException("The result of adding " + (long)var1_1 + " of " + var3_2 + " to " + localDate + " is out of LocalDate range.", e);
        }
        return object;
    }

    private static final java.time.LocalDate ofEpochDayChecked(long epochDay) {
        long l;
        long l2 = minEpochDay;
        if (!(epochDay <= maxEpochDay ? l2 <= epochDay : false)) {
            throw new DateTimeException("The resulting day " + epochDay + " is out of supported LocalDate range.");
        }
        java.time.LocalDate localDate = java.time.LocalDate.ofEpochDay(l);
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"ofEpochDay(...)");
        return localDate;
    }

    /*
     * WARNING - void declaration
     */
    public static final LocalDate plus(LocalDate $this$plus, DatePeriod period) {
        LocalDate localDate;
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)period, (String)"period");
        try {
            void var2_2;
            void $this$plus_u24lambda_u242_u24lambda_u241;
            void $this$plus_u24lambda_u242;
            java.time.LocalDate $this$plus_u24lambda_u242_u24lambda_u240 = $this$plus.getValue$kotlinx_datetime();
            $this$plus_u24lambda_u242_u24lambda_u241 = $this$plus_u24lambda_u242.getTotalMonths$kotlinx_datetime() != 0L ? $this$plus_u24lambda_u242_u24lambda_u240.plusMonths($this$plus_u24lambda_u242.getTotalMonths$kotlinx_datetime()) : $this$plus_u24lambda_u242_u24lambda_u241;
            void p0 = $this$plus_u24lambda_u242.getDays() != 0 ? $this$plus_u24lambda_u242_u24lambda_u241.plusDays($this$plus_u24lambda_u242.getDays()) : var2_2;
            localDate = new LocalDate((java.time.LocalDate)((Object)localDate));
        }
        catch (DateTimeException dateTimeException) {
            LocalDate localDate2;
            throw new DateTimeArithmeticException("The result of adding " + $this$plus.getValue$kotlinx_datetime() + " to " + localDate2 + " is out of LocalDate range.");
        }
        return localDate;
    }

    /*
     * WARNING - void declaration
     */
    public static final int daysUntil(LocalDate $this$daysUntil, LocalDate other) {
        void var1_1;
        LocalDate localDate;
        Intrinsics.checkNotNullParameter((Object)$this$daysUntil, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return MathKt.clampToInt(localDate.getValue$kotlinx_datetime().until(var1_1.getValue$kotlinx_datetime(), ChronoUnit.DAYS));
    }
}

