/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeParseException;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.DateTimeFormatException;
import kotlinx.datetime.DayOfWeek;
import kotlinx.datetime.LocalDateKt;
import kotlinx.datetime.LocalDateRange;
import kotlinx.datetime.Month;
import kotlinx.datetime.MonthKt;
import kotlinx.datetime.Ser;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.format.LocalDateFormatKt;
import kotlinx.datetime.internal.MathKt;
import kotlinx.datetime.internal.UtilKt;
import kotlinx.datetime.serializers.LocalDateSerializer;
import kotlinx.serialization.KSerializer;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@kotlinx.serialization.Serializable(with=LocalDateSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 C2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0002CDB\u0011\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B!\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\u000bB!\b\u0016\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\f\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\rB!\b\u0017\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u000eH\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0014\u001a\u00020\u0013H\u0001\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0002\u00a2\u0006\u0004\b\u001a\u0010\u0019J\u001a\u0010\u001e\u001a\u00020\u001d2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0096\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u000f\u0010 \u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b \u0010!J\u000f\u0010#\u001a\u00020\"H\u0016\u00a2\u0006\u0004\b#\u0010$J\u0018\u0010%\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0000H\u0096\u0002\u00a2\u0006\u0004\b%\u0010&J\r\u0010(\u001a\u00020'\u00a2\u0006\u0004\b(\u0010)J\u000f\u0010*\u001a\u00020\u0007H\u0001\u00a2\u0006\u0004\b(\u0010!J\u0017\u0010.\u001a\u00020-2\u0006\u0010,\u001a\u00020+H\u0002\u00a2\u0006\u0004\b.\u0010/J\u000f\u00100\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b0\u00101R\u001a\u0010\u0004\u001a\u00020\u00038\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0004\u00102\u001a\u0004\b3\u00104R\u0011\u0010\b\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b5\u0010!R\u001a\u00109\u001a\u00020\u00078FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b7\u00108\u001a\u0004\b6\u0010!R\u0011\u0010\t\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010:R\u001a\u0010\u000f\u001a\u00020\u00078FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b<\u00108\u001a\u0004\b;\u0010!R\u0011\u0010\n\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b=\u0010!R\u0011\u0010@\u001a\u00020>8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010?R\u0011\u0010B\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\bA\u0010!"}, d2={"Lkotlinx/datetime/LocalDate;", "", "Ljava/io/Serializable;", "Ljava/time/LocalDate;", "value", "<init>", "(Ljava/time/LocalDate;)V", "", "year", "month", "day", "(III)V", "Lkotlinx/datetime/Month;", "(ILkotlinx/datetime/Month;I)V", "Ljava/time/Month;", "dayOfMonth", "(ILjava/time/Month;I)V", "getMonth", "()Ljava/time/Month;", "Ljava/time/DayOfWeek;", "getDayOfWeek", "()Ljava/time/DayOfWeek;", "that", "Lkotlinx/datetime/LocalDateRange;", "rangeTo", "(Lkotlinx/datetime/LocalDate;)Lkotlinx/datetime/LocalDateRange;", "rangeUntil", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "compareTo", "(Lkotlinx/datetime/LocalDate;)I", "", "toEpochDays", "()J", "toEpochDaysJvm", "Ljava/io/ObjectInputStream;", "ois", "", "readObject", "(Ljava/io/ObjectInputStream;)V", "writeReplace", "()Ljava/lang/Object;", "Ljava/time/LocalDate;", "getValue$kotlinx_datetime", "()Ljava/time/LocalDate;", "getYear", "getMonthNumber", "getMonthNumber$annotations", "()V", "monthNumber", "()Lkotlinx/datetime/Month;", "getDayOfMonth", "getDayOfMonth$annotations", "getDay", "Lkotlinx/datetime/DayOfWeek;", "()Lkotlinx/datetime/DayOfWeek;", "dayOfWeek", "getDayOfYear", "dayOfYear", "Companion", "Formats"})
public final class LocalDate
implements Serializable,
Comparable<LocalDate> {
    public static final Companion Companion = new Companion(null);
    private final java.time.LocalDate value;
    private static final LocalDate MIN;
    private static final LocalDate MAX;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    public LocalDate(java.time.LocalDate value) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = var1_1;
    }

    public final java.time.LocalDate getValue$kotlinx_datetime() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public LocalDate(int year22, int month2, int day2) {
        void var1_2;
        LocalDate localDate;
        LocalDate localDate2 = this;
        try {
            void var3_5;
            void var2_4;
            localDate = localDate2;
            java.time.LocalDate year22 = java.time.LocalDate.of(year22, (int)var2_4, (int)var3_5);
        }
        catch (DateTimeException e) {
            void var1_3;
            throw new IllegalArgumentException((Throwable)var1_3);
        }
        Intrinsics.checkNotNull((Object)var1_2);
        localDate((java.time.LocalDate)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public LocalDate(int year2, Month month2, int day2) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)month2), (String)"month");
        this((int)var1_1, MonthKt.getNumber((Month)var2_2), (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="Use kotlinx.datetime.Month", replaceWith=@ReplaceWith(expression="LocalDate(year, month.toKotlinMonth(), dayOfMonth)", imports={}))
    public LocalDate(int year2, java.time.Month month2, int dayOfMonth) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)month2, (String)"month");
        this((int)var1_1, ConvertersKt.toKotlinMonth((java.time.Month)var2_2), (int)var3_3);
    }

    public final int getYear() {
        return this.value.getYear();
    }

    public final int getMonthNumber() {
        return this.value.getMonthValue();
    }

    @Deprecated(message="Use the 'month' property instead", replaceWith=@ReplaceWith(expression="this.month.number", imports={}), level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getMonthNumber$annotations() {
    }

    public final Month getMonth() {
        java.time.Month month2 = this.value.getMonth();
        Intrinsics.checkNotNullExpressionValue((Object)month2, (String)"getMonth(...)");
        return ConvertersKt.toKotlinMonth(month2);
    }

    @PublishedApi
    public final java.time.Month getMonth() {
        java.time.Month month2 = this.value.getMonth();
        Intrinsics.checkNotNullExpressionValue((Object)month2, (String)"getMonth(...)");
        return month2;
    }

    public final int getDayOfMonth() {
        return this.value.getDayOfMonth();
    }

    @Deprecated(message="Use the 'day' property instead", replaceWith=@ReplaceWith(expression="this.day", imports={}), level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getDayOfMonth$annotations() {
    }

    public final int getDay() {
        return this.value.getDayOfMonth();
    }

    public final DayOfWeek getDayOfWeek() {
        java.time.DayOfWeek dayOfWeek = this.value.getDayOfWeek();
        Intrinsics.checkNotNullExpressionValue((Object)dayOfWeek, (String)"getDayOfWeek(...)");
        return ConvertersKt.toKotlinDayOfWeek(dayOfWeek);
    }

    @PublishedApi
    public final java.time.DayOfWeek getDayOfWeek() {
        java.time.DayOfWeek dayOfWeek = this.value.getDayOfWeek();
        Intrinsics.checkNotNullExpressionValue((Object)dayOfWeek, (String)"getDayOfWeek(...)");
        return dayOfWeek;
    }

    public final int getDayOfYear() {
        return this.value.getDayOfYear();
    }

    /*
     * WARNING - void declaration
     */
    public final LocalDateRange rangeTo(LocalDate that) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        return LocalDateRange.Companion.fromRangeTo$kotlinx_datetime(this, (LocalDate)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final LocalDateRange rangeUntil(LocalDate that) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        return LocalDateRange.Companion.fromRangeUntil$kotlinx_datetime(this, (LocalDate)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return this == other || other instanceof LocalDate && Intrinsics.areEqual((Object)this.value, (Object)((LocalDate)var1_1).value);
    }

    public final int hashCode() {
        return this.value.hashCode();
    }

    public final String toString() {
        String string = this.value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(LocalDate other) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.value.compareTo(var1_1.value);
    }

    public final long toEpochDays() {
        return this.value.toEpochDay();
    }

    @PublishedApi
    @JvmName(name="toEpochDays")
    public final int toEpochDays() {
        return MathKt.clampToInt(this.value.toEpochDay());
    }

    private final void readObject(ObjectInputStream ois) {
        throw new InvalidObjectException("kotlinx.datetime.LocalDate must be deserialized via kotlinx.datetime.Ser");
    }

    private final Object writeReplace() {
        return new Ser(2, this);
    }

    static {
        java.time.LocalDate localDate = java.time.LocalDate.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"MIN");
        MIN = new LocalDate(localDate);
        java.time.LocalDate localDate2 = java.time.LocalDate.MAX;
        Intrinsics.checkNotNullExpressionValue((Object)localDate2, (String)"MAX");
        MAX = new LocalDate(localDate2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\t\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u00078\u0000X\u0081\u0004\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u00078\u0000X\u0080\u0004\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0013\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\u000b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0019"}, d2={"Lkotlinx/datetime/LocalDate$Companion;", "", "<init>", "()V", "", "input", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/LocalDate;", "format", "parse", "(Ljava/lang/CharSequence;Lkotlinx/datetime/format/DateTimeFormat;)Lkotlinx/datetime/LocalDate;", "", "epochDays", "fromEpochDays", "(J)Lkotlinx/datetime/LocalDate;", "Lkotlinx/serialization/KSerializer;", "serializer", "()Lkotlinx/serialization/KSerializer;", "MIN", "Lkotlinx/datetime/LocalDate;", "getMIN$kotlinx_datetime", "()Lkotlinx/datetime/LocalDate;", "MAX", "getMAX$kotlinx_datetime", "serialVersionUID", "J"})
    @SourceDebugExtension(value={"SMAP\nLocalDate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDate.kt\nkotlinx/datetime/LocalDate$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1#2:211\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final LocalDate parse(CharSequence input, DateTimeFormat<LocalDate> format) {
            void var2_3;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter(format, (String)"format");
            if (format == Formats.INSTANCE.getISO()) {
                try {
                    input = UtilKt.removeLeadingZerosFromLongYearFormLocalDate(((Object)input).toString());
                    Comparable<ChronoLocalDate> p0 = java.time.LocalDate.parse(input);
                    p0 = new LocalDate((java.time.LocalDate)p0);
                }
                catch (DateTimeParseException e) {
                    void var1_2;
                    throw new DateTimeFormatException((Throwable)var1_2);
                }
                return var1_1;
            }
            return (LocalDate)var2_3.parse((CharSequence)var1_1);
        }

        public static /* synthetic */ LocalDate parse$default(Companion companion, CharSequence charSequence, DateTimeFormat dateTimeFormat, int n, Object object) {
            if ((n & 2) != 0) {
                dateTimeFormat = LocalDateKt.getIsoDateFormat();
            }
            return companion.parse(charSequence, dateTimeFormat);
        }

        public final LocalDate getMIN$kotlinx_datetime() {
            return MIN;
        }

        public final LocalDate getMAX$kotlinx_datetime() {
            return MAX;
        }

        /*
         * WARNING - void declaration
         */
        public final LocalDate fromEpochDays(long epochDays2) {
            void var1_2;
            try {
                java.time.LocalDate localDate = java.time.LocalDate.ofEpochDay(epochDays2);
                Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"ofEpochDay(...)");
                LocalDate epochDays2 = new LocalDate(localDate);
            }
            catch (DateTimeException e) {
                void var1_3;
                throw new IllegalArgumentException((Throwable)var1_3);
            }
            return var1_2;
        }

        public final KSerializer<LocalDate> serializer() {
            return LocalDateSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006\u00a2\u0006\u0006\n\u0004\b\t\u0010\n"}, d2={"Lkotlinx/datetime/LocalDate$Formats;", "", "<init>", "()V", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/LocalDate;", "getISO", "()Lkotlinx/datetime/format/DateTimeFormat;", "ISO", "ISO_BASIC", "Lkotlinx/datetime/format/DateTimeFormat;"})
    public static final class Formats {
        public static final Formats INSTANCE = new Formats();
        public static final DateTimeFormat<LocalDate> ISO_BASIC = LocalDateFormatKt.getISO_DATE_BASIC();

        private Formats() {
        }

        public final DateTimeFormat<LocalDate> getISO() {
            return LocalDateFormatKt.getISO_DATE();
        }
    }
}

