/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.datetime.internal.MathJvmKt;
import kotlinx.datetime.serializers.DateBasedDateTimeUnitSerializer;
import kotlinx.datetime.serializers.DateTimeUnitSerializer;
import kotlinx.datetime.serializers.DayBasedDateTimeUnitSerializer;
import kotlinx.datetime.serializers.MonthBasedDateTimeUnitSerializer;
import kotlinx.datetime.serializers.TimeBasedDateTimeUnitSerializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;

@Serializable(with=DateTimeUnitSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b7\u0018\u0000 \u000f2\u00020\u0001:\u0005\u0010\u0011\u0012\u0013\u000fB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004H\u00a6\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\u000b\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\tH\u0004\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001f\u0010\u000b\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\tH\u0004\u00a2\u0006\u0004\b\u000b\u0010\u000e\u0082\u0001\u0002\u0014\u0015"}, d2={"Lkotlinx/datetime/DateTimeUnit;", "", "<init>", "()V", "", "scalar", "times", "(I)Lkotlinx/datetime/DateTimeUnit;", "value", "", "unit", "formatToString", "(ILjava/lang/String;)Ljava/lang/String;", "", "(JLjava/lang/String;)Ljava/lang/String;", "Companion", "TimeBased", "DateBased", "DayBased", "MonthBased", "Lkotlinx/datetime/DateTimeUnit$DateBased;", "Lkotlinx/datetime/DateTimeUnit$TimeBased;"})
public abstract class DateTimeUnit {
    public static final Companion Companion = new Companion(null);
    private static final TimeBased NANOSECOND = new TimeBased(1L);
    private static final TimeBased MICROSECOND = NANOSECOND.times(1000);
    private static final TimeBased MILLISECOND = MICROSECOND.times(1000);
    private static final TimeBased SECOND = MILLISECOND.times(1000);
    private static final TimeBased MINUTE = SECOND.times(60);
    private static final TimeBased HOUR = MINUTE.times(60);
    private static final DayBased DAY = new DayBased(1);
    private static final DayBased WEEK = DAY.times(7);
    private static final MonthBased MONTH = new MonthBased(1);
    private static final MonthBased QUARTER = MONTH.times(3);
    private static final MonthBased YEAR = MONTH.times(12);
    private static final MonthBased CENTURY = YEAR.times(100);

    private DateTimeUnit() {
    }

    public abstract DateTimeUnit times(int var1);

    /*
     * WARNING - void declaration
     */
    protected final String formatToString(int value, String unit) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        if (value == 1) {
            return unit;
        }
        return "" + (int)var1_1 + '-' + (String)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected final String formatToString(long value, String unit) {
        void var3_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        if (value == 1L) {
            return unit;
        }
        return "" + (long)var1_1 + '-' + (String)var3_2;
    }

    public /* synthetic */ DateTimeUnit(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u001a\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\u000e\u0010\fR\u0017\u0010\u000f\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\u0010\u0010\fR\u0017\u0010\u0011\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\u0011\u0010\n\u001a\u0004\b\u0012\u0010\fR\u0017\u0010\u0013\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\u0013\u0010\n\u001a\u0004\b\u0014\u0010\fR\u0017\u0010\u0015\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\n\u001a\u0004\b\u0016\u0010\fR\u0017\u0010\u0018\u001a\u00020\u00178\u0006\u00a2\u0006\f\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\u00020\u00178\u0006\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0019\u001a\u0004\b\u001d\u0010\u001bR\u0017\u0010\u001f\u001a\u00020\u001e8\u0006\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\"R\u0017\u0010#\u001a\u00020\u001e8\u0006\u00a2\u0006\f\n\u0004\b#\u0010 \u001a\u0004\b$\u0010\"R\u0017\u0010%\u001a\u00020\u001e8\u0006\u00a2\u0006\f\n\u0004\b%\u0010 \u001a\u0004\b&\u0010\"R\u0017\u0010'\u001a\u00020\u001e8\u0006\u00a2\u0006\f\n\u0004\b'\u0010 \u001a\u0004\b(\u0010\""}, d2={"Lkotlinx/datetime/DateTimeUnit$Companion;", "", "<init>", "()V", "Lkotlinx/serialization/KSerializer;", "Lkotlinx/datetime/DateTimeUnit;", "serializer", "()Lkotlinx/serialization/KSerializer;", "Lkotlinx/datetime/DateTimeUnit$TimeBased;", "NANOSECOND", "Lkotlinx/datetime/DateTimeUnit$TimeBased;", "getNANOSECOND", "()Lkotlinx/datetime/DateTimeUnit$TimeBased;", "MICROSECOND", "getMICROSECOND", "MILLISECOND", "getMILLISECOND", "SECOND", "getSECOND", "MINUTE", "getMINUTE", "HOUR", "getHOUR", "Lkotlinx/datetime/DateTimeUnit$DayBased;", "DAY", "Lkotlinx/datetime/DateTimeUnit$DayBased;", "getDAY", "()Lkotlinx/datetime/DateTimeUnit$DayBased;", "WEEK", "getWEEK", "Lkotlinx/datetime/DateTimeUnit$MonthBased;", "MONTH", "Lkotlinx/datetime/DateTimeUnit$MonthBased;", "getMONTH", "()Lkotlinx/datetime/DateTimeUnit$MonthBased;", "QUARTER", "getQUARTER", "YEAR", "getYEAR", "CENTURY", "getCENTURY"})
    public static final class Companion {
        private Companion() {
        }

        public final TimeBased getNANOSECOND() {
            return NANOSECOND;
        }

        public final TimeBased getMICROSECOND() {
            return MICROSECOND;
        }

        public final TimeBased getMILLISECOND() {
            return MILLISECOND;
        }

        public final TimeBased getSECOND() {
            return SECOND;
        }

        public final TimeBased getMINUTE() {
            return MINUTE;
        }

        public final TimeBased getHOUR() {
            return HOUR;
        }

        public final DayBased getDAY() {
            return DAY;
        }

        public final DayBased getWEEK() {
            return WEEK;
        }

        public final MonthBased getMONTH() {
            return MONTH;
        }

        public final MonthBased getQUARTER() {
            return QUARTER;
        }

        public final MonthBased getYEAR() {
            return YEAR;
        }

        public final MonthBased getCENTURY() {
            return CENTURY;
        }

        public final KSerializer<DateTimeUnit> serializer() {
            return (KSerializer)DateTimeUnitSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Serializable(with=DateBasedDateTimeUnitSerializer.class)
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b7\u0018\u0000 \b2\u00020\u0001:\u0001\bB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003Z\n\u0010\u0005\"\u00020\u00042\u00020\u0004Z\n\u0010\u0007\"\u00020\u00062\u00020\u0006\u0082\u0001\u0002\u0004\u0006"}, d2={"Lkotlinx/datetime/DateTimeUnit$DateBased;", "Lkotlinx/datetime/DateTimeUnit;", "<init>", "()V", "Lkotlinx/datetime/DateTimeUnit$DayBased;", "DayBased", "Lkotlinx/datetime/DateTimeUnit$MonthBased;", "MonthBased", "Companion"})
    public static abstract class DateBased
    extends DateTimeUnit {
        public static final Companion Companion = new Companion(null);

        private DateBased() {
            super(null);
        }

        public /* synthetic */ DateBased(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007"}, d2={"Lkotlinx/datetime/DateTimeUnit$DateBased$Companion;", "", "<init>", "()V", "Lkotlinx/serialization/KSerializer;", "Lkotlinx/datetime/DateTimeUnit$DateBased;", "serializer", "()Lkotlinx/serialization/KSerializer;"})
        public static final class Companion {
            private Companion() {
            }

            public final KSerializer<DateBased> serializer() {
                return (KSerializer)DateBasedDateTimeUnitSerializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable(with=DayBasedDateTimeUnitSerializer.class)
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0096\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\u000f"}, d2={"Lkotlinx/datetime/DateTimeUnit$DayBased;", "Lkotlinx/datetime/DateTimeUnit$DateBased;", "", "days", "<init>", "(I)V", "scalar", "times", "(I)Lkotlinx/datetime/DateTimeUnit$DayBased;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "I", "getDays", "Companion"})
    @SourceDebugExtension(value={"SMAP\nDateTimeUnit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateTimeUnit.kt\nkotlinx/datetime/DateTimeUnit$DayBased\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,310:1\n1#2:311\n*E\n"})
    public static final class DayBased
    extends DateBased {
        public static final Companion Companion = new Companion(null);
        private final int days;

        /*
         * WARNING - void declaration
         */
        public DayBased(int days) {
            super(null);
            void var1_1;
            this.days = var1_1;
            if (!(this.days > 0)) {
                String string = "Unit duration must be positive, but was " + this.days + " days.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final int getDays() {
            return this.days;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final DayBased times(int scalar) {
            void var1_1;
            return new DayBased(MathJvmKt.safeMultiply(this.days, (int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            void var1_1;
            return this == other || other instanceof DayBased && this.days == ((DayBased)var1_1).days;
        }

        public final int hashCode() {
            return this.days ^ 0x10000;
        }

        public final String toString() {
            if (this.days % 7 == 0) {
                DayBased dayBased = this;
                return dayBased.formatToString(dayBased.days / 7, "WEEK");
            }
            DayBased dayBased = this;
            return dayBased.formatToString(dayBased.days, "DAY");
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007"}, d2={"Lkotlinx/datetime/DateTimeUnit$DayBased$Companion;", "", "<init>", "()V", "Lkotlinx/serialization/KSerializer;", "Lkotlinx/datetime/DateTimeUnit$DayBased;", "serializer", "()Lkotlinx/serialization/KSerializer;"})
        public static final class Companion {
            private Companion() {
            }

            public final KSerializer<DayBased> serializer() {
                return DayBasedDateTimeUnitSerializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable(with=MonthBasedDateTimeUnitSerializer.class)
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\tH\u0096\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0013\u001a\u0004\b\u0014\u0010\u000f"}, d2={"Lkotlinx/datetime/DateTimeUnit$MonthBased;", "Lkotlinx/datetime/DateTimeUnit$DateBased;", "", "months", "<init>", "(I)V", "scalar", "times", "(I)Lkotlinx/datetime/DateTimeUnit$MonthBased;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "I", "getMonths", "Companion"})
    @SourceDebugExtension(value={"SMAP\nDateTimeUnit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateTimeUnit.kt\nkotlinx/datetime/DateTimeUnit$MonthBased\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,310:1\n1#2:311\n*E\n"})
    public static final class MonthBased
    extends DateBased {
        public static final Companion Companion = new Companion(null);
        private final int months;

        /*
         * WARNING - void declaration
         */
        public MonthBased(int months) {
            super(null);
            void var1_1;
            this.months = var1_1;
            if (!(this.months > 0)) {
                String string = "Unit duration must be positive, but was " + this.months + " months.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final int getMonths() {
            return this.months;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final MonthBased times(int scalar) {
            void var1_1;
            return new MonthBased(MathJvmKt.safeMultiply(this.months, (int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            void var1_1;
            return this == other || other instanceof MonthBased && this.months == ((MonthBased)var1_1).months;
        }

        public final int hashCode() {
            return this.months ^ 0x20000;
        }

        public final String toString() {
            if (this.months % 1200 == 0) {
                MonthBased monthBased = this;
                return monthBased.formatToString(monthBased.months / 1200, "CENTURY");
            }
            if (this.months % 12 == 0) {
                MonthBased monthBased = this;
                return monthBased.formatToString(monthBased.months / 12, "YEAR");
            }
            if (this.months % 3 == 0) {
                MonthBased monthBased = this;
                return monthBased.formatToString(monthBased.months / 3, "QUARTER");
            }
            MonthBased monthBased = this;
            return monthBased.formatToString(monthBased.months, "MONTH");
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007"}, d2={"Lkotlinx/datetime/DateTimeUnit$MonthBased$Companion;", "", "<init>", "()V", "Lkotlinx/serialization/KSerializer;", "Lkotlinx/datetime/DateTimeUnit$MonthBased;", "serializer", "()Lkotlinx/serialization/KSerializer;"})
        public static final class Companion {
            private Companion() {
            }

            public final KSerializer<MonthBased> serializer() {
                return MonthBasedDateTimeUnitSerializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Serializable(with=TimeBasedDateTimeUnitSerializer.class)
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006H\u0096\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\r\u001a\u00020\f2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0096\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0014R\u0011\u0010\u001c\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0016"}, d2={"Lkotlinx/datetime/DateTimeUnit$TimeBased;", "Lkotlinx/datetime/DateTimeUnit;", "", "nanoseconds", "<init>", "(J)V", "", "scalar", "times", "(I)Lkotlinx/datetime/DateTimeUnit$TimeBased;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "J", "getNanoseconds", "()J", "unitName", "Ljava/lang/String;", "unitScale", "Lkotlin/time/Duration;", "getDuration-UwyO8pc", "duration", "Companion"})
    @SourceDebugExtension(value={"SMAP\nDateTimeUnit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateTimeUnit.kt\nkotlinx/datetime/DateTimeUnit$TimeBased\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,310:1\n1#2:311\n*E\n"})
    public static final class TimeBased
    extends DateTimeUnit {
        public static final Companion Companion = new Companion(null);
        private final long nanoseconds;
        private final String unitName;
        private final long unitScale;

        /*
         * WARNING - void declaration
         */
        public TimeBased(long nanoseconds) {
            super(null);
            void var1_1;
            this.nanoseconds = var1_1;
            if (!(this.nanoseconds > 0L)) {
                String string = "Unit duration must be positive, but was " + this.nanoseconds + " ns.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.nanoseconds % 3600000000000L == 0L) {
                this.unitName = "HOUR";
                this.unitScale = this.nanoseconds / 3600000000000L;
                return;
            }
            if (this.nanoseconds % 60000000000L == 0L) {
                this.unitName = "MINUTE";
                this.unitScale = this.nanoseconds / 60000000000L;
                return;
            }
            if (this.nanoseconds % 1000000000L == 0L) {
                this.unitName = "SECOND";
                this.unitScale = this.nanoseconds / 1000000000L;
                return;
            }
            if (this.nanoseconds % 1000000L == 0L) {
                this.unitName = "MILLISECOND";
                this.unitScale = this.nanoseconds / 1000000L;
                return;
            }
            if (this.nanoseconds % 1000L == 0L) {
                this.unitName = "MICROSECOND";
                this.unitScale = this.nanoseconds / 1000L;
                return;
            }
            this.unitName = "NANOSECOND";
            this.unitScale = this.nanoseconds;
        }

        public final long getNanoseconds() {
            return this.nanoseconds;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final TimeBased times(int scalar) {
            void var1_1;
            return new TimeBased(MathJvmKt.safeMultiply(this.nanoseconds, (long)var1_1));
        }

        public final long getDuration-UwyO8pc() {
            return DurationKt.toDuration((long)this.nanoseconds, (DurationUnit)DurationUnit.NANOSECONDS);
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            void var1_1;
            return this == other || other instanceof TimeBased && this.nanoseconds == ((TimeBased)var1_1).nanoseconds;
        }

        public final int hashCode() {
            return (int)this.nanoseconds ^ (int)(this.nanoseconds >> 32);
        }

        public final String toString() {
            TimeBased timeBased = this;
            return timeBased.formatToString(timeBased.unitScale, this.unitName);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007"}, d2={"Lkotlinx/datetime/DateTimeUnit$TimeBased$Companion;", "", "<init>", "()V", "Lkotlinx/serialization/KSerializer;", "Lkotlinx/datetime/DateTimeUnit$TimeBased;", "serializer", "()Lkotlinx/serialization/KSerializer;"})
        public static final class Companion {
            private Companion() {
            }

            public final KSerializer<TimeBased> serializer() {
                return TimeBasedDateTimeUnitSerializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

