/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import kotlinx.datetime.DateTimeFormatException;
import kotlinx.datetime.DateTimePeriodKt;
import kotlinx.datetime.internal.MathJvmKt;
import kotlinx.datetime.serializers.DateTimePeriodSerializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;

@Serializable(with=DateTimePeriodSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b7\u0018\u0000 $2\u00020\u0001:\u0001$B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000f\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\u000b\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\u000e\u001a\u00020\rH\u0016\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0013\u001a\u00020\u00108 X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0015\u001a\u00020\r8&X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000fR\u0014\u0010\u0017\u001a\u00020\u00108 X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0019\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000fR\u0011\u0010\u001b\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000fR\u0014\u0010\u001d\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000fR\u0014\u0010\u001f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000fR\u0014\u0010!\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000fR\u0014\u0010#\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000f\u0082\u0001\u0002%&"}, d2={"Lkotlinx/datetime/DateTimePeriod;", "", "<init>", "()V", "", "allNonpositive", "()Z", "", "toString", "()Ljava/lang/String;", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "getTotalMonths$kotlinx_datetime", "()J", "totalMonths", "getDays", "days", "getTotalNanoseconds$kotlinx_datetime", "totalNanoseconds", "getYears", "years", "getMonths", "months", "getHours", "hours", "getMinutes", "minutes", "getSeconds", "seconds", "getNanoseconds", "nanoseconds", "Companion", "Lkotlinx/datetime/DatePeriod;", "Lkotlinx/datetime/DateTimePeriodImpl;"})
@SourceDebugExtension(value={"SMAP\nDateTimePeriod.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateTimePeriod.kt\nkotlinx/datetime/DateTimePeriod\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,614:1\n1#2:615\n*E\n"})
public abstract class DateTimePeriod {
    public static final Companion Companion = new Companion(null);

    private DateTimePeriod() {
    }

    public abstract long getTotalMonths$kotlinx_datetime();

    public abstract int getDays();

    public abstract long getTotalNanoseconds$kotlinx_datetime();

    public final int getYears() {
        return (int)(this.getTotalMonths$kotlinx_datetime() / 12L);
    }

    public final int getMonths() {
        return (int)(this.getTotalMonths$kotlinx_datetime() % 12L);
    }

    public int getHours() {
        return (int)(this.getTotalNanoseconds$kotlinx_datetime() / 3600000000000L);
    }

    public int getMinutes() {
        return (int)(this.getTotalNanoseconds$kotlinx_datetime() % 3600000000000L / 60000000000L);
    }

    public int getSeconds() {
        return (int)(this.getTotalNanoseconds$kotlinx_datetime() % 60000000000L / 1000000000L);
    }

    public int getNanoseconds() {
        return (int)(this.getTotalNanoseconds$kotlinx_datetime() % 1000000000L);
    }

    private final boolean allNonpositive() {
        return this.getTotalMonths$kotlinx_datetime() <= 0L && this.getDays() <= 0 && this.getTotalNanoseconds$kotlinx_datetime() <= 0L && ((this.getTotalMonths$kotlinx_datetime() | this.getTotalNanoseconds$kotlinx_datetime()) != 0L || this.getDays() != 0);
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        int n;
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u242 = stringBuilder = new StringBuilder();
        if (this.allNonpositive()) {
            $this$toString_u24lambda_u242.append('-');
            n = -1;
        } else {
            n = 1;
        }
        int sign2 = n;
        $this$toString_u24lambda_u242.append('P');
        if (this.getYears() != 0) {
            $this$toString_u24lambda_u242.append(this.getYears() * sign2).append('Y');
        }
        if (this.getMonths() != 0) {
            $this$toString_u24lambda_u242.append(this.getMonths() * sign2).append('M');
        }
        if (this.getDays() != 0) {
            $this$toString_u24lambda_u242.append(this.getDays() * sign2).append('D');
        }
        String t = "T";
        if (this.getHours() != 0) {
            $this$toString_u24lambda_u242.append(t).append(this.getHours() * sign2).append('H');
            t = "";
        }
        if (this.getMinutes() != 0) {
            $this$toString_u24lambda_u242.append(t).append(this.getMinutes() * sign2).append('M');
            t = "";
        }
        if ((this.getSeconds() | this.getNanoseconds()) != 0) {
            void var3_3;
            $this$toString_u24lambda_u242.append(t);
            $this$toString_u24lambda_u242.append(this.getSeconds() != 0 ? Integer.valueOf(this.getSeconds() * sign2) : (this.getNanoseconds() * var3_3 < 0 ? "-0" : "0"));
            if (this.getNanoseconds() != 0) {
                $this$toString_u24lambda_u242.append('.').append(StringsKt.padStart((String)String.valueOf(Math.abs(this.getNanoseconds())), (int)9, (char)'0'));
            }
            $this$toString_u24lambda_u242.append('S');
        }
        if ($this$toString_u24lambda_u242.length() == 1) {
            void var2_2;
            var2_2.append("0D");
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        void var1_1;
        if (this == other) {
            return true;
        }
        if (!(other instanceof DateTimePeriod)) {
            return false;
        }
        if (this.getTotalMonths$kotlinx_datetime() != ((DateTimePeriod)other).getTotalMonths$kotlinx_datetime()) {
            return false;
        }
        if (this.getDays() != ((DateTimePeriod)other).getDays()) {
            return false;
        }
        return this.getTotalNanoseconds$kotlinx_datetime() == ((DateTimePeriod)var1_1).getTotalNanoseconds$kotlinx_datetime();
    }

    /*
     * WARNING - void declaration
     */
    public int hashCode() {
        void var1_1;
        int result = Long.hashCode(this.getTotalMonths$kotlinx_datetime());
        result = result * 31 + this.getDays();
        var1_1 = var1_1 * 31 + Long.hashCode(this.getTotalNanoseconds$kotlinx_datetime());
        return (int)var1_1;
    }

    public /* synthetic */ DateTimePeriod(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0013\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\t\u00a2\u0006\u0004\b\n\u0010\u000b"}, d2={"Lkotlinx/datetime/DateTimePeriod$Companion;", "", "<init>", "()V", "", "text", "Lkotlinx/datetime/DateTimePeriod;", "parse", "(Ljava/lang/String;)Lkotlinx/datetime/DateTimePeriod;", "Lkotlinx/serialization/KSerializer;", "serializer", "()Lkotlinx/serialization/KSerializer;"})
    public static final class Companion {
        private Companion() {
        }

        public final DateTimePeriod parse(String text) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            int state = 0;
            int i = 0;
            int sign2 = 1;
            int years = 0;
            int months = 0;
            int weeks = 0;
            int days = 0;
            int hours = 0;
            int minutes = 0;
            int seconds = 0;
            int nanoseconds = 0;
            boolean someComponentParsed = false;
            while (true) {
                int iStart;
                int localSign;
                block47: {
                    char c;
                    block45: {
                        block46: {
                            if (i >= text.length()) {
                                if (state == 0) {
                                    kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("Unexpected end of input; 'P' designator is required", i);
                                    throw new KotlinNothingValueException();
                                }
                                if (state == 6) {
                                    kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("Unexpected end of input; at least one time component is required after 'T'", i);
                                    throw new KotlinNothingValueException();
                                }
                                long n = (long)days + (long)(weeks * 7);
                                if (!(Integer.MIN_VALUE <= n ? n <= Integer.MAX_VALUE : false)) {
                                    kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("The total number of days under 'D' and 'W' designators should fit into an Int", 0);
                                    throw new KotlinNothingValueException();
                                }
                                int daysTotal = (int)n;
                                if (!someComponentParsed) {
                                    kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("At least one component is required, but none were found", 0);
                                    throw new KotlinNothingValueException();
                                }
                                return DateTimePeriodKt.DateTimePeriod(years, months, daysTotal, hours, minutes, seconds, nanoseconds);
                            }
                            if (state == 0) {
                                if (i + 1 >= text.length() && (text.charAt(i) == '+' || text.charAt(i) == '-')) {
                                    kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("Unexpected end of string; 'P' designator is required", i);
                                    throw new KotlinNothingValueException();
                                }
                                switch (text.charAt(i)) {
                                    case '+': 
                                    case '-': {
                                        if (text.charAt(i) == '-') {
                                            sign2 = -1;
                                        }
                                        if (text.charAt(i + 1) != 'P') {
                                            kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("Expected 'P', got '" + text.charAt(i + 1) + '\'', i + 1);
                                            throw new KotlinNothingValueException();
                                        }
                                        i += 2;
                                        break;
                                    }
                                    case 'P': {
                                        ++i;
                                        break;
                                    }
                                    default: {
                                        kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("Expected '+', '-', 'P', got '" + text.charAt(i) + '\'', i);
                                        throw new KotlinNothingValueException();
                                    }
                                }
                                state = 1;
                                continue;
                            }
                            localSign = sign2;
                            iStart = i;
                            c = text.charAt(i);
                            if (c != '+' && c != '-') break block45;
                            if (text.charAt(i) == '-') {
                                localSign = -localSign;
                            }
                            if (++i >= text.length()) break block46;
                            char c2 = text.charAt(i);
                            if ('0' <= c2 ? c2 < ':' : false) break block47;
                        }
                        kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("A number expected after '" + text.charAt(i) + '\'', i);
                        throw new KotlinNothingValueException();
                    }
                    if (!('0' <= c ? c < ':' : false) && c == 'T') {
                        if (state >= 6) {
                            kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("Only one 'T' designator is allowed", i);
                            throw new KotlinNothingValueException();
                        }
                        state = 6;
                        ++i;
                        continue;
                    }
                }
                long number = 0L;
                while (i < text.length()) {
                    char c = text.charAt(i);
                    boolean bl = '0' <= c ? c < ':' : false;
                    if (!bl) break;
                    try {
                        number = MathJvmKt.safeAdd(MathJvmKt.safeMultiply(number, 10L), text.charAt(i) - 48);
                    }
                    catch (ArithmeticException arithmeticException) {
                        kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("The number is too large", iStart);
                        throw new KotlinNothingValueException();
                    }
                    ++i;
                }
                someComponentParsed = true;
                number *= (long)localSign;
                if (i == text.length()) {
                    kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("Expected a designator after the numerical value", i);
                    throw new KotlinNothingValueException();
                }
                String wrongOrder = "Wrong component order: should be 'Y', 'M', 'W', 'D', then designator 'T', then 'H', 'M', 'S'";
                switch (Character.toUpperCase(text.charAt(i))) {
                    case 'Y': {
                        if (state >= 2) {
                            kotlinx.datetime.DateTimePeriod$Companion.parse$parseException(wrongOrder, i);
                            throw new KotlinNothingValueException();
                        }
                        state = 2;
                        years = kotlinx.datetime.DateTimePeriod$Companion.parse$toIntThrowing(number, iStart, 'Y');
                        break;
                    }
                    case 'M': {
                        if (state >= 6) {
                            if (state >= 8) {
                                kotlinx.datetime.DateTimePeriod$Companion.parse$parseException(wrongOrder, i);
                                throw new KotlinNothingValueException();
                            }
                            state = 8;
                            minutes = kotlinx.datetime.DateTimePeriod$Companion.parse$toIntThrowing(number, iStart, 'M');
                            break;
                        }
                        if (state >= 3) {
                            kotlinx.datetime.DateTimePeriod$Companion.parse$parseException(wrongOrder, i);
                            throw new KotlinNothingValueException();
                        }
                        state = 3;
                        months = kotlinx.datetime.DateTimePeriod$Companion.parse$toIntThrowing(number, iStart, 'M');
                        break;
                    }
                    case 'W': {
                        if (state >= 4) {
                            kotlinx.datetime.DateTimePeriod$Companion.parse$parseException(wrongOrder, i);
                            throw new KotlinNothingValueException();
                        }
                        state = 4;
                        weeks = kotlinx.datetime.DateTimePeriod$Companion.parse$toIntThrowing(number, iStart, 'W');
                        break;
                    }
                    case 'D': {
                        if (state >= 5) {
                            kotlinx.datetime.DateTimePeriod$Companion.parse$parseException(wrongOrder, i);
                            throw new KotlinNothingValueException();
                        }
                        state = 5;
                        days = kotlinx.datetime.DateTimePeriod$Companion.parse$toIntThrowing(number, iStart, 'D');
                        break;
                    }
                    case 'H': {
                        if (state >= 7 || state < 6) {
                            kotlinx.datetime.DateTimePeriod$Companion.parse$parseException(wrongOrder, i);
                            throw new KotlinNothingValueException();
                        }
                        state = 7;
                        hours = kotlinx.datetime.DateTimePeriod$Companion.parse$toIntThrowing(number, iStart, 'H');
                        break;
                    }
                    case 'S': {
                        if (state >= 9 || state < 6) {
                            kotlinx.datetime.DateTimePeriod$Companion.parse$parseException(wrongOrder, i);
                            throw new KotlinNothingValueException();
                        }
                        state = 9;
                        seconds = kotlinx.datetime.DateTimePeriod$Companion.parse$toIntThrowing(number, iStart, 'S');
                        break;
                    }
                    case ',': 
                    case '.': {
                        int fractionLength;
                        if (++i >= text.length()) {
                            kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("Expected designator 'S' after " + text.charAt(i - 1), i);
                            throw new KotlinNothingValueException();
                        }
                        int iStartFraction = i;
                        while (i < text.length()) {
                            nanoseconds = text.charAt(i);
                            boolean bl = 48 <= nanoseconds ? nanoseconds < 58 : false;
                            if (!bl) break;
                            ++i;
                        }
                        if ((fractionLength = i - iStartFraction) > 9) {
                            kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("Only the nanosecond fractions of a second are supported", iStartFraction);
                            throw new KotlinNothingValueException();
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        String string = text.substring(iStartFraction, i);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        String string2 = stringBuilder.append(string).append(StringsKt.repeat((CharSequence)"0", (int)(9 - fractionLength))).toString();
                        int n = Integer.parseInt(string2, CharsKt.checkRadix((int)10)) * localSign;
                        if (text.charAt(i) != 'S') {
                            kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("Expected the 'S' designator after a fraction", i);
                            throw new KotlinNothingValueException();
                        }
                        if (state >= 9 || state < 6) {
                            kotlinx.datetime.DateTimePeriod$Companion.parse$parseException(wrongOrder, i);
                            throw new KotlinNothingValueException();
                        }
                        state = 9;
                        int n2 = kotlinx.datetime.DateTimePeriod$Companion.parse$toIntThrowing(number, iStart, 'S');
                        break;
                    }
                    default: {
                        kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("Expected a designator after the numerical value", i);
                        throw new KotlinNothingValueException();
                    }
                }
                ++i;
            }
        }

        public final KSerializer<DateTimePeriod> serializer() {
            return DateTimePeriodSerializer.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        private static final Void parse$parseException(String message, int position) {
            String string;
            void var1_1;
            throw new DateTimeFormatException("Parse error at char " + (int)var1_1 + ": " + string);
        }

        /*
         * WARNING - void declaration
         */
        private static final int parse$toIntThrowing(long $this$parse_u24toIntThrowing, int iStart, char component) {
            long l;
            if ($this$parse_u24toIntThrowing < Integer.MIN_VALUE || $this$parse_u24toIntThrowing > Integer.MAX_VALUE) {
                void var2_1;
                void var3_2;
                kotlinx.datetime.DateTimePeriod$Companion.parse$parseException("Value " + $this$parse_u24toIntThrowing + " does not fit into an Int, which is required for component '" + (char)var3_2 + '\'', (int)var2_1);
                throw new KotlinNothingValueException();
            }
            return (int)l;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

