/*
 * Decompiled with CFR 0.152.
 */
package me.him188.ani.utils.httpdownloader.m3u;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import me.him188.ani.utils.httpdownloader.m3u.ByteRange;
import me.him188.ani.utils.httpdownloader.m3u.M3u8Parser;
import me.him188.ani.utils.httpdownloader.m3u.M3u8Playlist;
import me.him188.ani.utils.httpdownloader.m3u.M3uFormatException;
import me.him188.ani.utils.httpdownloader.m3u.MediaSegment;
import me.him188.ani.utils.httpdownloader.m3u.VariantStream;
import me.him188.ani.utils.ktor.UrlHelpers;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\b\u001a\u00020\u00072\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\b\u0010\tJ#\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\n\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011"}, d2={"Lme/him188/ani/utils/httpdownloader/m3u/DefaultM3u8Parser;", "Lme/him188/ani/utils/httpdownloader/m3u/M3u8Parser;", "<init>", "()V", "", "content", "baseUrl", "Lme/him188/ani/utils/httpdownloader/m3u/M3u8Playlist;", "parse", "(Ljava/lang/String;Ljava/lang/String;)Lme/him188/ani/utils/httpdownloader/m3u/M3u8Playlist;", "attributesString", "", "parseAttributes", "(Ljava/lang/String;)Ljava/util/Map;", "rangeValue", "Lme/him188/ani/utils/httpdownloader/m3u/ByteRange;", "parseByteRange", "(Ljava/lang/String;)Lme/him188/ani/utils/httpdownloader/m3u/ByteRange;"})
@SourceDebugExtension(value={"SMAP\nM3u8Parser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 M3u8Parser.kt\nme/him188/ani/utils/httpdownloader/m3u/DefaultM3u8Parser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,338:1\n774#2:339\n865#2,2:340\n*S KotlinDebug\n*F\n+ 1 M3u8Parser.kt\nme/him188/ani/utils/httpdownloader/m3u/DefaultM3u8Parser\n*L\n106#1:339\n106#1:340,2\n*E\n"})
public final class DefaultM3u8Parser
implements M3u8Parser {
    public static final DefaultM3u8Parser INSTANCE = new DefaultM3u8Parser();

    private DefaultM3u8Parser() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final M3u8Playlist parse(String content, String baseUrl) {
        void var3_4;
        void $this$filterTo$iv$iv;
        Iterable iterable;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)baseUrl, (String)"baseUrl");
        Iterable iterable2 = iterable = (Iterable)StringsKt.lines((CharSequence)content);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String string = (String)element$iv$iv;
            if (!(!StringsKt.isBlank((CharSequence)string))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List lines = (List)destination$iv$iv;
        if (lines.isEmpty() || !StringsKt.startsWith$default((String)((Object)StringsKt.trimStart((CharSequence)((String)lines.get(0)))).toString(), (String)"#EXTM3U", (boolean)false, (int)2, null)) {
            throw new M3uFormatException("Invalid M3U8 format, must start with #EXTM3U");
        }
        int version = 3;
        Integer targetDuration = null;
        int mediaSequence = 0;
        boolean isEndlist = false;
        List segments = new ArrayList();
        List variants = new ArrayList();
        Map tags = new LinkedHashMap();
        int i = 1;
        Float currentSegmentDuration = null;
        String currentSegmentTitle = null;
        boolean currentSegmentDiscontinuity = false;
        ByteRange currentSegmentByteRange = null;
        Map currentSegmentKeys = new LinkedHashMap();
        Map currentSegmentTags = new LinkedHashMap();
        Map<String, String> currentVariantAttributes = new LinkedHashMap();
        while (i < lines.size()) {
            Object absoluteUri;
            String tagValue;
            String line;
            if (StringsKt.startsWith$default((String)(line = ((Object)StringsKt.trim((CharSequence)((String)lines.get(i++)))).toString()), (String)"#", (boolean)false, (int)2, null)) {
                if (StringsKt.startsWith$default((String)line, (String)"#EXT-X-VERSION:", (boolean)false, (int)2, null)) {
                    version = Integer.parseInt(((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)line, (String)":", null, (int)2, null))).toString());
                    continue;
                }
                if (StringsKt.startsWith$default((String)line, (String)"#EXT-X-TARGETDURATION:", (boolean)false, (int)2, null)) {
                    targetDuration = Integer.parseInt(((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)line, (String)":", null, (int)2, null))).toString());
                    continue;
                }
                if (StringsKt.startsWith$default((String)line, (String)"#EXT-X-MEDIA-SEQUENCE:", (boolean)false, (int)2, null)) {
                    mediaSequence = Integer.parseInt(((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)line, (String)":", null, (int)2, null))).toString());
                    continue;
                }
                if (StringsKt.startsWith$default((String)line, (String)"#EXT-X-ENDLIST", (boolean)false, (int)2, null)) {
                    isEndlist = true;
                    continue;
                }
                if (StringsKt.startsWith$default((String)line, (String)"#EXTINF:", (boolean)false, (int)2, null)) {
                    String valueStr = StringsKt.substringAfter$default((String)line, (String)":", null, (int)2, null);
                    currentSegmentDuration = Float.valueOf(Float.parseFloat(StringsKt.substringBefore$default((String)valueStr, (String)",", null, (int)2, null)));
                    if (!StringsKt.contains$default((CharSequence)valueStr, (CharSequence)",", (boolean)false, (int)2, null)) continue;
                    currentSegmentTitle = ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)valueStr, (String)",", null, (int)2, null))).toString();
                    continue;
                }
                if (StringsKt.startsWith$default((String)line, (String)"#EXT-X-DISCONTINUITY", (boolean)false, (int)2, null)) {
                    currentSegmentDiscontinuity = true;
                    continue;
                }
                if (StringsKt.startsWith$default((String)line, (String)"#EXT-X-BYTERANGE:", (boolean)false, (int)2, null)) {
                    currentSegmentByteRange = this.parseByteRange(((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)line, (String)":", null, (int)2, null))).toString());
                    continue;
                }
                if (StringsKt.startsWith$default((String)line, (String)"#EXT-X-KEY:", (boolean)false, (int)2, null)) {
                    Map<String, String> keyAttributes = this.parseAttributes(((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)line, (String)":", null, (int)2, null))).toString());
                    currentSegmentKeys.putAll(keyAttributes);
                    continue;
                }
                if (StringsKt.startsWith$default((String)line, (String)"#EXT-X-STREAM-INF:", (boolean)false, (int)2, null)) {
                    currentVariantAttributes = this.parseAttributes(((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)line, (String)":", null, (int)2, null))).toString());
                    continue;
                }
                if (StringsKt.contains$default((CharSequence)line, (CharSequence)":", (boolean)false, (int)2, null)) {
                    String tagName = StringsKt.substringBefore$default((String)line, (String)":", null, (int)2, null);
                    tagValue = StringsKt.substringAfter$default((String)line, (String)":", null, (int)2, null);
                    if (currentSegmentDuration != null) {
                        currentSegmentTags.put(tagName, tagValue);
                        continue;
                    }
                    tags.put(tagName, tagValue);
                    continue;
                }
                if (currentSegmentDuration != null) {
                    currentSegmentTags.put(tagValue, "");
                    continue;
                }
                tags.put(tagValue, "");
                continue;
            }
            void uri = tagValue;
            if (!currentVariantAttributes.isEmpty()) {
                String string;
                absoluteUri = UrlHelpers.INSTANCE.computeAbsoluteUrl(baseUrl, (String)uri);
                Object object = (String)currentVariantAttributes.get("BANDWIDTH");
                int n = object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 0;
                String string2 = (String)currentVariantAttributes.get("AVERAGE-BANDWIDTH");
                Integer n2 = string2 != null ? StringsKt.toIntOrNull((String)string2) : null;
                String string3 = (String)currentVariantAttributes.get("CODECS");
                if (string3 != null) {
                    char[] cArray = new char[1];
                    absoluteUri = cArray;
                    cArray[0] = 34;
                    string = StringsKt.trim((String)string3, (char[])absoluteUri);
                } else {
                    string = null;
                }
                String string4 = (String)currentVariantAttributes.get("FRAME-RATE");
                variants.add(new VariantStream((String)absoluteUri, n, n2, string, (String)currentVariantAttributes.get("RESOLUTION"), string4 != null ? StringsKt.toFloatOrNull((String)string4) : null, (String)currentVariantAttributes.get("AUDIO"), (String)currentVariantAttributes.get("VIDEO"), (String)currentVariantAttributes.get("SUBTITLES"), (String)currentVariantAttributes.get("CLOSED-CAPTIONS"), MapsKt.toMap((Map)currentVariantAttributes)));
                currentVariantAttributes.clear();
                continue;
            }
            if (currentSegmentDuration == null) continue;
            absoluteUri = UrlHelpers.INSTANCE.computeAbsoluteUrl(baseUrl, (String)uri);
            segments.add(new MediaSegment(currentSegmentDuration.floatValue(), (String)absoluteUri, currentSegmentTitle, currentSegmentDiscontinuity, currentSegmentByteRange, MapsKt.toMap((Map)currentSegmentKeys), MapsKt.toMap((Map)currentSegmentTags)));
            currentSegmentDuration = null;
            currentSegmentTitle = null;
            currentSegmentDiscontinuity = false;
            currentSegmentByteRange = null;
            currentSegmentKeys.clear();
            currentSegmentTags.clear();
        }
        if (!((Collection)variants).isEmpty()) {
            return new M3u8Playlist.MasterPlaylist(version, variants, tags);
        }
        return new M3u8Playlist.MediaPlaylist((int)var3_4, targetDuration, mediaSequence, segments, isEndlist, tags);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> parseAttributes(String attributesString) {
        void var2_2;
        String remaining;
        Map attributes = new LinkedHashMap();
        while (((CharSequence)remaining).length() > 0) {
            void var3_4;
            void cleanValue;
            String string;
            int eqPos;
            void attribute;
            String string2;
            boolean inQuotes = false;
            int commaPos = -1;
            int n = ((CharSequence)remaining).length();
            for (int i = 0; i < n; ++i) {
                char c = remaining.charAt(i);
                if (c == '\"') {
                    inQuotes = !inQuotes;
                    continue;
                }
                if (c != ',' || inQuotes) continue;
                commaPos = i;
                break;
            }
            if (commaPos >= 0) {
                Intrinsics.checkNotNullExpressionValue((Object)remaining.substring(0, commaPos), (String)"substring(...)");
                String string3 = remaining.substring(commaPos + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                remaining = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                string2 = attr;
            } else {
                attr = remaining;
                remaining = "";
                string2 = attribute = attr;
            }
            if ((eqPos = StringsKt.indexOf$default((CharSequence)string2, (char)'=', (int)0, (boolean)false, (int)6, null)) <= 0) continue;
            String string4 = attribute.substring(0, eqPos);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            String key = ((Object)StringsKt.trim((CharSequence)string4)).toString();
            String string5 = attribute.substring(eqPos + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            String value = ((Object)StringsKt.trim((CharSequence)string5)).toString();
            if (StringsKt.startsWith$default((String)value, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value, (String)"\"", (boolean)false, (int)2, null) && value.length() >= 2) {
                String string6 = value.substring(1, value.length() - 1);
                string = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            } else {
                string = cleanValue;
            }
            cleanValue = string;
            attributes.put(key, var3_4);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private final ByteRange parseByteRange(String rangeValue) {
        void var1_1;
        void var3_3;
        Long l;
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = "@";
        List parts = StringsKt.split$default((CharSequence)rangeValue, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        Long l2 = StringsKt.toLongOrNull((String)((String)parts.get(0)));
        if (l2 == null) {
            throw new M3uFormatException("Invalid byte range length: " + parts.get(0));
        }
        long length = l2;
        if (parts.size() > 1) {
            Long l3 = StringsKt.toLongOrNull((String)((String)parts.get(1)));
            if (l3 == null) {
                throw new M3uFormatException("Invalid byte range offset: " + parts.get(1));
            }
            l = (long)l3;
        } else {
            l = null;
        }
        Long offset = l;
        return new ByteRange((long)var3_3, (Long)var1_1);
    }
}

