/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.utils;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.collections.ArraysKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMutableIterator;

@SourceDebugExtension(value={"SMAP\nSmartSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmartSet.kt\norg/jetbrains/kotlin/utils/SmartSet\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public final class SmartSet<T>
extends AbstractSet<T> {
    public static final Companion Companion = new Companion(null);
    private Object data;
    private int size;

    private SmartSet() {
    }

    public final int getSize() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSize(int n) {
        void var1_1;
        this.size = var1_1;
    }

    @Override
    public final Iterator<T> iterator() {
        if (this.size() == 0) {
            return Collections.emptySet().iterator();
        }
        if (this.size() == 1) {
            return new SingletonIterator<Object>(this.data);
        }
        if (this.size() < 5) {
            Object object = this.data;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<T of org.jetbrains.kotlin.utils.SmartSet>");
            return new ArrayIterator<Object>((Object[])object);
        }
        Object object = this.data;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<T of org.jetbrains.kotlin.utils.SmartSet>");
        return TypeIntrinsics.asMutableSet((Object)object).iterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean add(T element) {
        Object object;
        if (this.size() == 0) {
            this.data = element;
        } else if (this.size() == 1) {
            if (Intrinsics.areEqual((Object)this.data, element)) {
                return false;
            }
            Object[] objectArray = new Object[2];
            object = objectArray;
            objectArray[0] = this.data;
            object[1] = element;
            this.data = object;
        } else if (this.size() < 5) {
            Object object2;
            SmartSet smartSet;
            Object object3 = this.data;
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Array<T of org.jetbrains.kotlin.utils.SmartSet>");
            Object arr = (Object[])object3;
            if (ArraysKt.contains((Object[])arr, element)) {
                return false;
            }
            SmartSet smartSet2 = this;
            if (smartSet2.size() == 4) {
                void $this$add_u24lambda_u240;
                arr = SetsKt.linkedSetOf((Object[])Arrays.copyOf(arr, ((Object[])arr).length));
                LinkedHashSet linkedHashSet = arr;
                SmartSet smartSet3 = smartSet2;
                $this$add_u24lambda_u240.add(element);
                smartSet = smartSet3;
                object2 = arr;
            } else {
                void var3_5;
                Object[] objectArray = Arrays.copyOf(object, this.size() + 1);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"copyOf(...)");
                object = objectArray;
                Object[] $this$add_u24lambda_u240 = objectArray;
                SmartSet smartSet4 = smartSet2;
                void v6 = var3_5;
                v6[((void)v6).length - 1] = element;
                smartSet = smartSet4;
                object2 = object;
            }
            smartSet.data = object2;
        } else {
            void var1_1;
            Object object4 = this.data;
            Intrinsics.checkNotNull((Object)object4, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<T of org.jetbrains.kotlin.utils.SmartSet>");
            object = TypeIntrinsics.asMutableSet((Object)object4);
            if (!object.add(var1_1)) {
                return false;
            }
        }
        int n = this.size();
        this.setSize(n + 1);
        return true;
    }

    @Override
    public final void clear() {
        this.data = null;
        this.setSize(0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Object element) {
        void var1_1;
        if (this.size() == 0) {
            return false;
        }
        if (this.size() == 1) {
            return Intrinsics.areEqual((Object)this.data, (Object)element);
        }
        if (this.size() < 5) {
            Object object = this.data;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Array<T of org.jetbrains.kotlin.utils.SmartSet>");
            return ArraysKt.contains((Object[])((Object[])object), (Object)element);
        }
        Object object = this.data;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Set<T of org.jetbrains.kotlin.utils.SmartSet>");
        return ((Set)object).contains(var1_1);
    }

    @JvmStatic
    public static final <T> SmartSet<T> create() {
        return Companion.create();
    }

    public /* synthetic */ SmartSet(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    private static final class ArrayIterator<T>
    implements Iterator<T>,
    KMutableIterator {
        private final Iterator<T> arrayIterator;

        /*
         * WARNING - void declaration
         */
        public ArrayIterator(T[] array) {
            void var1_1;
            Intrinsics.checkNotNullParameter(array, (String)"array");
            this.arrayIterator = ArrayIteratorKt.iterator((Object[])var1_1);
        }

        @Override
        public final boolean hasNext() {
            return this.arrayIterator.hasNext();
        }

        @Override
        public final T next() {
            return this.arrayIterator.next();
        }

        public final Void remove() {
            throw new UnsupportedOperationException();
        }
    }

    @SourceDebugExtension(value={"SMAP\nSmartSet.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SmartSet.kt\norg/jetbrains/kotlin/utils/SmartSet$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final <T> SmartSet<T> create() {
            return new SmartSet(null);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final <T> SmartSet<T> create(Collection<? extends T> set) {
            void var1_1;
            SmartSet smartSet;
            Intrinsics.checkNotNullParameter(set, (String)"set");
            SmartSet smartSet2 = smartSet = new SmartSet(null);
            smartSet.addAll(var1_1);
            return smartSet;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    private static final class SingletonIterator<T>
    implements Iterator<T>,
    KMutableIterator {
        private final T element;
        private boolean hasNext;

        /*
         * WARNING - void declaration
         */
        public SingletonIterator(T element) {
            void var1_1;
            this.element = var1_1;
            this.hasNext = true;
        }

        @Override
        public final T next() {
            if (this.hasNext) {
                this.hasNext = false;
                return this.element;
            }
            throw new NoSuchElementException();
        }

        @Override
        public final boolean hasNext() {
            return this.hasNext;
        }

        public final Void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

