/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.utils;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public class SmartList<E>
extends AbstractList<E>
implements RandomAccess {
    private int mySize;
    private Object myElem;

    /*
     * WARNING - void declaration
     */
    @Override
    public E get(int index) {
        void var1_1;
        if (index < 0 || index >= this.mySize) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
        if (this.mySize == 1) {
            return (E)this.myElem;
        }
        return (E)((Object[])this.myElem)[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(E e) {
        if (this.mySize == 0) {
            this.myElem = e;
        } else if (this.mySize == 1) {
            Object[] objectArray = new Object[2];
            Object[] array = objectArray;
            objectArray[0] = this.myElem;
            array[1] = e;
            this.myElem = array;
        } else {
            void var1_1;
            Object[] array = (Object[])this.myElem;
            int oldCapacity = array.length;
            if (this.mySize >= oldCapacity) {
                void var3_4;
                int newCapacity = oldCapacity * 3 / 2 + 1;
                int minCapacity = this.mySize + 1;
                if (newCapacity < minCapacity) {
                    newCapacity = minCapacity;
                }
                Object[] oldArray = array;
                array = new Object[newCapacity];
                this.myElem = array;
                System.arraycopy(oldArray, 0, array, 0, (int)var3_4);
            }
            var2_3[this.mySize] = var1_1;
        }
        ++this.mySize;
        ++this.modCount;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(int index, E e) {
        if (index < 0 || index > this.mySize) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
        if (this.mySize == 0) {
            this.myElem = e;
        } else if (this.mySize == 1 && index == 0) {
            Object[] objectArray = new Object[2];
            Object[] array = objectArray;
            objectArray[0] = e;
            array[1] = this.myElem;
            this.myElem = array;
        } else {
            void var3_4;
            void var2_2;
            Object[] array = new Object[this.mySize + 1];
            if (this.mySize == 1) {
                array[0] = this.myElem;
            } else {
                Object[] oldArray = (Object[])this.myElem;
                System.arraycopy(oldArray, 0, array, 0, index);
                System.arraycopy(oldArray, index, array, index + 1, this.mySize - index);
            }
            array[var1_1] = var2_2;
            this.myElem = var3_4;
        }
        ++this.mySize;
        ++this.modCount;
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    public void clear() {
        this.myElem = null;
        this.mySize = 0;
        ++this.modCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E set(int index, E element) {
        void var3_3;
        Object oldValue;
        if (index < 0 || index >= this.mySize) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
        if (this.mySize == 1) {
            oldValue = this.myElem;
            this.myElem = element;
        } else {
            void var2_2;
            Object[] array = (Object[])this.myElem;
            oldValue = array[index];
            array[var1_1] = var2_2;
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E remove(int index) {
        void var2_2;
        Object oldValue;
        if (index < 0 || index >= this.mySize) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.mySize);
        }
        if (this.mySize == 1) {
            oldValue = this.myElem;
            this.myElem = null;
        } else {
            Object[] array = (Object[])this.myElem;
            oldValue = array[index];
            if (this.mySize == 2) {
                this.myElem = array[1 - index];
            } else {
                int numMoved = this.mySize - index - 1;
                if (numMoved > 0) {
                    void var1_1;
                    System.arraycopy(array, index + 1, array, (int)var1_1, numMoved);
                }
                var3_3[this.mySize - 1] = null;
            }
        }
        --this.mySize;
        ++this.modCount;
        return var2_2;
    }

    @Override
    public Iterator<E> iterator() {
        if (this.mySize == 0) {
            EmptyIterator emptyIterator = EmptyIterator.getInstance();
            if (emptyIterator == null) {
                SmartList.$$$reportNull$$$0(2);
            }
            return emptyIterator;
        }
        if (this.mySize == 1) {
            return new SingletonIterator();
        }
        Iterator iterator2 = super.iterator();
        if (iterator2 == null) {
            SmartList.$$$reportNull$$$0(3);
        }
        return iterator2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void sort(Comparator<? super E> comparator) {
        if (this.mySize >= 2) {
            void var1_1;
            Arrays.sort((Object[])this.myElem, 0, this.mySize, var1_1);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public <T> T[] toArray(T[] a) {
        void var2_2;
        void var1_1;
        block10: {
            if (a == null) {
                SmartList.$$$reportNull$$$0(4);
            }
            int aLength = a.length;
            if (this.mySize == 1) {
                if (aLength != 0) {
                    a[0] = this.myElem;
                    break block10;
                } else {
                    Object[] objectArray = (Object[])Array.newInstance(a.getClass().getComponentType(), 1);
                    Object[] r = objectArray;
                    objectArray[0] = this.myElem;
                    void v1 = var1_1;
                    if (v1 == null) {
                        SmartList.$$$reportNull$$$0(5);
                    }
                    return v1;
                }
            }
            if (aLength < this.mySize) {
                T[] TArray = Arrays.copyOf((Object[])this.myElem, this.mySize, var1_1.getClass());
                if (TArray == null) {
                    SmartList.$$$reportNull$$$0(6);
                }
                return TArray;
            }
            if (this.mySize != 0) {
                System.arraycopy(this.myElem, 0, var1_1, 0, this.mySize);
            }
        }
        if (var2_2 > this.mySize) {
            var1_1[this.mySize] = null;
        }
        void v3 = var1_1;
        if (v3 == null) {
            SmartList.$$$reportNull$$$0(7);
        }
        return v3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlin/reflect/jvm/internal/impl/utils/SmartList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "kotlin/reflect/jvm/internal/impl/utils/SmartList";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
            }
        }
        throw runtimeException;
    }

    private class SingletonIterator
    extends SingletonIteratorBase<E> {
        private final int myInitialModCount;

        public SingletonIterator() {
            this.myInitialModCount = SmartList.this.modCount;
        }

        @Override
        protected E getElement() {
            return SmartList.this.myElem;
        }

        @Override
        protected void checkCoModification() {
            if (SmartList.this.modCount != this.myInitialModCount) {
                throw new ConcurrentModificationException("ModCount: " + SmartList.this.modCount + "; expected: " + this.myInitialModCount);
            }
        }

        @Override
        public void remove() {
            this.checkCoModification();
            SmartList.this.clear();
        }
    }

    private static abstract class SingletonIteratorBase<T>
    implements Iterator<T> {
        private boolean myVisited;

        private SingletonIteratorBase() {
        }

        @Override
        public final boolean hasNext() {
            return !this.myVisited;
        }

        @Override
        public final T next() {
            if (this.myVisited) {
                throw new NoSuchElementException();
            }
            this.myVisited = true;
            this.checkCoModification();
            return this.getElement();
        }

        protected abstract void checkCoModification();

        protected abstract T getElement();
    }

    private static class EmptyIterator<T>
    implements Iterator<T> {
        private static final EmptyIterator INSTANCE = new EmptyIterator();

        private EmptyIterator() {
        }

        public static <T> EmptyIterator<T> getInstance() {
            return INSTANCE;
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public T next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }
}

