/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.util.Check;

public abstract class ValueParameterCountCheck
implements Check {
    private final String description;

    /*
     * WARNING - void declaration
     */
    private ValueParameterCountCheck(String description2) {
        void var1_1;
        this.description = var1_1;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String invoke(FunctionDescriptor functionDescriptor) {
        void var1_1;
        return Check.DefaultImpls.invoke(this, (FunctionDescriptor)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ ValueParameterCountCheck(String description2, DefaultConstructorMarker $constructor_marker) {
        this((String)var1_1);
        void var1_1;
    }

    public static final class AtLeast
    extends ValueParameterCountCheck {
        private final int n;

        /*
         * WARNING - void declaration
         */
        public AtLeast(int n) {
            super("must have at least " + n + " value parameter" + (n > 1 ? "s" : ""), null);
            void var1_1;
            this.n = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean check(FunctionDescriptor functionDescriptor) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
            return var1_1.getValueParameters().size() >= this.n;
        }
    }

    public static final class Equals
    extends ValueParameterCountCheck {
        private final int n;

        /*
         * WARNING - void declaration
         */
        public Equals(int n) {
            super("must have exactly " + n + " value parameters", null);
            void var1_1;
            this.n = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean check(FunctionDescriptor functionDescriptor) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
            return var1_1.getValueParameters().size() == this.n;
        }
    }

    public static final class NoValueParameters
    extends ValueParameterCountCheck {
        public static final NoValueParameters INSTANCE = new NoValueParameters();

        private NoValueParameters() {
            super("must have no value parameters", null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean check(FunctionDescriptor functionDescriptor) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
            return var1_1.getValueParameters().isEmpty();
        }
    }

    public static final class SingleValueParameter
    extends ValueParameterCountCheck {
        public static final SingleValueParameter INSTANCE = new SingleValueParameter();

        private SingleValueParameter() {
            super("must have a single value parameter", null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean check(FunctionDescriptor functionDescriptor) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
            return var1_1.getValueParameters().size() == 1;
        }
    }
}

