/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.ReflectionTypes;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.util.Check;

final class IsKPropertyCheck
implements Check {
    public static final IsKPropertyCheck INSTANCE = new IsKPropertyCheck();
    private static final String description = "second parameter must be of type KProperty<*> or its supertype";

    private IsKPropertyCheck() {
    }

    @Override
    public final String getDescription() {
        return description;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean check(FunctionDescriptor functionDescriptor) {
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
        ValueParameterDescriptor secondParameter = functionDescriptor.getValueParameters().get(1);
        Intrinsics.checkNotNull((Object)secondParameter);
        KotlinType kotlinType = ReflectionTypes.Companion.createKPropertyStarType(DescriptorUtilsKt.getModule(secondParameter));
        if (kotlinType != null) {
            void var1_1;
            KotlinType kotlinType2 = var1_1.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
            return TypeUtilsKt.isSubtypeOf(kotlinType, TypeUtilsKt.makeNotNullable(kotlinType2));
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String invoke(FunctionDescriptor functionDescriptor) {
        void var1_1;
        return Check.DefaultImpls.invoke(this, (FunctionDescriptor)var1_1);
    }
}

