/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.util;

import java.util.Arrays;
import java.util.Collection;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.FunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.util.Check;
import kotlin.reflect.jvm.internal.impl.util.CheckResult;
import kotlin.text.Regex;

public final class Checks {
    private final Name name;
    private final Regex regex;
    private final Collection<Name> nameList;
    private final Function1<FunctionDescriptor, String> additionalCheck;
    private final Check[] checks;

    /*
     * WARNING - void declaration
     */
    private Checks(Name name, Regex regex, Collection<Name> nameList, Function1<? super FunctionDescriptor, String> additionalCheck, Check ... checks2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.name = var1_1;
        this.regex = var2_2;
        this.nameList = var3_3;
        this.additionalCheck = additionalCheck;
        this.checks = checks2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isApplicable(FunctionDescriptor functionDescriptor) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
        if (this.name != null && !Intrinsics.areEqual((Object)functionDescriptor.getName(), (Object)this.name)) {
            return false;
        }
        if (this.regex != null) {
            String string = functionDescriptor.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            CharSequence charSequence = string;
            if (!this.regex.matches(charSequence)) {
                return false;
            }
        }
        return this.nameList == null || this.nameList.contains(var1_1.getName());
    }

    /*
     * WARNING - void declaration
     */
    public final CheckResult checkAll(FunctionDescriptor functionDescriptor) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
        Check[] checkArray = this.checks;
        int n = checkArray.length;
        for (int i = 0; i < n; ++i) {
            Check check = checkArray[i];
            String checkResult = check.invoke(functionDescriptor);
            if (checkResult == null) continue;
            return new CheckResult.IllegalSignature(checkResult);
        }
        String additionalCheckResult = (String)this.additionalCheck.invoke((Object)var1_1);
        if (additionalCheckResult != null) {
            return new CheckResult.IllegalSignature((String)checkArray);
        }
        return CheckResult.SuccessCheck.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public Checks(Name name, Check[] checks2, Function1<? super FunctionDescriptor, String> additionalChecks) {
        void var3_3;
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)checks2, (String)"checks");
        Intrinsics.checkNotNullParameter(additionalChecks, (String)"additionalChecks");
        void v0 = var2_2;
        this((Name)var1_1, null, null, (Function1<? super FunctionDescriptor, String>)var3_3, (Check[])Arrays.copyOf(v0, ((void)v0).length));
    }

    public /* synthetic */ Checks(Name name, Check[] checkArray, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 2.INSTANCE;
        }
        this(name, checkArray, (Function1<? super FunctionDescriptor, String>)function1);
    }

    /*
     * WARNING - void declaration
     */
    public Checks(Regex regex, Check[] checks2, Function1<? super FunctionDescriptor, String> additionalChecks) {
        void var3_3;
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)regex, (String)"regex");
        Intrinsics.checkNotNullParameter((Object)checks2, (String)"checks");
        Intrinsics.checkNotNullParameter(additionalChecks, (String)"additionalChecks");
        void v0 = var2_2;
        this(null, (Regex)var1_1, null, (Function1<? super FunctionDescriptor, String>)var3_3, (Check[])Arrays.copyOf(v0, ((void)v0).length));
    }

    public /* synthetic */ Checks(Regex regex, Check[] checkArray, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 3.INSTANCE;
        }
        this(regex, checkArray, (Function1<? super FunctionDescriptor, String>)function1);
    }

    /*
     * WARNING - void declaration
     */
    public Checks(Collection<Name> nameList, Check[] checks2, Function1<? super FunctionDescriptor, String> additionalChecks) {
        void var3_3;
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter(nameList, (String)"nameList");
        Intrinsics.checkNotNullParameter((Object)checks2, (String)"checks");
        Intrinsics.checkNotNullParameter(additionalChecks, (String)"additionalChecks");
        void v0 = var2_2;
        this(null, null, (Collection<Name>)var1_1, (Function1<? super FunctionDescriptor, String>)var3_3, (Check[])Arrays.copyOf(v0, ((void)v0).length));
    }

    public /* synthetic */ Checks(Collection collection, Check[] checkArray, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 4.INSTANCE;
        }
        this(collection, checkArray, (Function1<? super FunctionDescriptor, String>)function1);
    }
}

