/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types.error;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorClassDescriptor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorEntity;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorPropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorScope;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorScopeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ThrowingScope;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class ErrorUtils {
    public static final ErrorUtils INSTANCE = new ErrorUtils();
    private static final ModuleDescriptor errorModule = ErrorModuleDescriptor.INSTANCE;
    private static final ErrorClassDescriptor errorClass;
    private static final KotlinType errorTypeForLoopInSupertypes;
    private static final KotlinType errorPropertyType;
    private static final PropertyDescriptor errorProperty;
    private static final Set<PropertyDescriptor> errorPropertyGroup;

    private ErrorUtils() {
    }

    public final ModuleDescriptor getErrorModule() {
        return errorModule;
    }

    public final ErrorClassDescriptor getErrorClass() {
        return errorClass;
    }

    public final KotlinType getErrorTypeForLoopInSupertypes() {
        return errorTypeForLoopInSupertypes;
    }

    public final KotlinType getErrorPropertyType() {
        return errorPropertyType;
    }

    public final Set<PropertyDescriptor> getErrorPropertyGroup() {
        return errorPropertyGroup;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final ErrorScope createErrorScope(ErrorScopeKind kind, String ... formatParams) {
        ErrorScopeKind errorScopeKind;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)formatParams, (String)"formatParams");
        void v0 = var1_1;
        return ErrorUtils.createErrorScope(errorScopeKind, false, (String[])Arrays.copyOf(v0, ((void)v0).length));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final ErrorScope createErrorScope(ErrorScopeKind kind, boolean throwExceptions, String ... formatParams) {
        ErrorScopeKind errorScopeKind;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)formatParams, (String)"formatParams");
        if (var1_1 != false) {
            return new ThrowingScope(kind, Arrays.copyOf(formatParams, formatParams.length));
        }
        void v0 = var2_2;
        return new ErrorScope(errorScopeKind, (String[])Arrays.copyOf(v0, ((void)v0).length));
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final ErrorType createErrorType(ErrorTypeKind kind, String ... formatParams) {
        ErrorTypeKind errorTypeKind;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)formatParams, (String)"formatParams");
        void v0 = var1_1;
        return INSTANCE.createErrorTypeWithArguments(errorTypeKind, (List<? extends TypeProjection>)CollectionsKt.emptyList(), (String[])Arrays.copyOf(v0, ((void)v0).length));
    }

    /*
     * WARNING - void declaration
     */
    public final ErrorType createErrorType(ErrorTypeKind kind, TypeConstructor typeConstructor2, String ... formatParams) {
        void var2_2;
        void var1_1;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)typeConstructor2, (String)"typeConstructor");
        Intrinsics.checkNotNullParameter((Object)formatParams, (String)"formatParams");
        void v0 = var3_3;
        return this.createErrorTypeWithArguments((ErrorTypeKind)var1_1, (List<? extends TypeProjection>)CollectionsKt.emptyList(), (TypeConstructor)var2_2, (String[])Arrays.copyOf(v0, ((void)v0).length));
    }

    /*
     * WARNING - void declaration
     */
    public final ErrorType createErrorTypeWithArguments(ErrorTypeKind kind, List<? extends TypeProjection> arguments2, String ... formatParams) {
        void var1_1;
        void var2_2;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)formatParams, (String)"formatParams");
        void v0 = var3_3;
        return this.createErrorTypeWithArguments(kind, (List<? extends TypeProjection>)var2_2, this.createErrorTypeConstructor((ErrorTypeKind)var1_1, Arrays.copyOf(formatParams, formatParams.length)), (String[])Arrays.copyOf(v0, ((void)v0).length));
    }

    /*
     * WARNING - void declaration
     */
    public final ErrorType createErrorTypeWithArguments(ErrorTypeKind kind, List<? extends TypeProjection> arguments2, TypeConstructor typeConstructor2, String ... formatParams) {
        void var2_2;
        void var1_1;
        void var3_3;
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)typeConstructor2, (String)"typeConstructor");
        Intrinsics.checkNotNullParameter((Object)formatParams, (String)"formatParams");
        String[] stringArray = new String[1];
        String[] stringArray2 = stringArray;
        stringArray[0] = var3_3.toString();
        return new ErrorType(typeConstructor2, (MemberScope)ErrorUtils.createErrorScope(ErrorScopeKind.ERROR_TYPE_SCOPE, stringArray2), (ErrorTypeKind)var1_1, (List<? extends TypeProjection>)var2_2, false, Arrays.copyOf(formatParams, formatParams.length));
    }

    /*
     * WARNING - void declaration
     */
    public final ErrorTypeConstructor createErrorTypeConstructor(ErrorTypeKind kind, String ... formatParams) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)((Object)kind), (String)"kind");
        Intrinsics.checkNotNullParameter((Object)formatParams, (String)"formatParams");
        void v0 = var2_2;
        return new ErrorTypeConstructor((ErrorTypeKind)var1_1, (String[])Arrays.copyOf(v0, ((void)v0).length));
    }

    @JvmStatic
    public static final boolean isError(DeclarationDescriptor candidate) {
        DeclarationDescriptor declarationDescriptor;
        return candidate != null && (INSTANCE.isErrorClass(candidate) || INSTANCE.isErrorClass(candidate.getContainingDeclaration()) || declarationDescriptor == errorModule);
    }

    private final boolean isErrorClass(DeclarationDescriptor candidate) {
        return candidate instanceof ErrorClassDescriptor;
    }

    @JvmStatic
    public static final boolean isUninferredTypeVariable(KotlinType type2) {
        TypeConstructor typeConstructor2;
        if (type2 == null) {
            return false;
        }
        TypeConstructor constructor = type2.getConstructor();
        return constructor instanceof ErrorTypeConstructor && ((ErrorTypeConstructor)typeConstructor2).getKind() == ErrorTypeKind.UNINFERRED_TYPE_VARIABLE;
    }

    /*
     * WARNING - void declaration
     */
    public final String unresolvedTypeAsItIs(KotlinType type2) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        boolean bl = TypeUtilsKt.isUnresolvedType((KotlinType)type2);
        if (_Assertions.ENABLED && !bl) {
            type2 = "Assertion failed";
            throw new AssertionError(type2);
        }
        TypeConstructor typeConstructor2 = var1_1.getConstructor();
        Intrinsics.checkNotNull((Object)typeConstructor2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.types.error.ErrorTypeConstructor");
        return ((ErrorTypeConstructor)typeConstructor2).getParam(0);
    }

    static {
        String string = ErrorEntity.ERROR_CLASS.getDebugText();
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = "unknown class";
        String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        Name name = Name.special(string2);
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"special(...)");
        errorClass = new ErrorClassDescriptor(name);
        errorTypeForLoopInSupertypes = ErrorUtils.createErrorType(ErrorTypeKind.CYCLIC_SUPERTYPES, new String[0]);
        errorPropertyType = ErrorUtils.createErrorType(ErrorTypeKind.ERROR_PROPERTY_TYPE, new String[0]);
        errorProperty = new ErrorPropertyDescriptor();
        errorPropertyGroup = SetsKt.setOf((Object)errorProperty);
    }
}

