/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.AnnotationsTypeAttributeKt;
import kotlin.reflect.jvm.internal.impl.types.DynamicType;
import kotlin.reflect.jvm.internal.impl.types.DynamicTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeAliasExpansion;
import kotlin.reflect.jvm.internal.impl.types.TypeAliasExpansionReportStrategy;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutionKt;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

@SourceDebugExtension(value={"SMAP\nTypeAliasExpander.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeAliasExpander.kt\norg/jetbrains/kotlin/types/TypeAliasExpander\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,278:1\n1#2:279\n1620#3,3:280\n1559#3:283\n1590#3,4:284\n1559#3:288\n1590#3,4:289\n1864#3,3:293\n*S KotlinDebug\n*F\n+ 1 TypeAliasExpander.kt\norg/jetbrains/kotlin/types/TypeAliasExpander\n*L\n148#1:280,3\n197#1:283\n197#1:284,4\n232#1:288\n232#1:289,4\n249#1:293,3\n*E\n"})
public final class TypeAliasExpander {
    public static final Companion Companion = new Companion(null);
    private final TypeAliasExpansionReportStrategy reportStrategy;
    private final boolean shouldCheckBounds;
    private static final TypeAliasExpander NON_REPORTING = new TypeAliasExpander(TypeAliasExpansionReportStrategy.DO_NOTHING.INSTANCE, false);

    /*
     * WARNING - void declaration
     */
    public TypeAliasExpander(TypeAliasExpansionReportStrategy reportStrategy, boolean shouldCheckBounds) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)reportStrategy, (String)"reportStrategy");
        this.reportStrategy = var1_1;
        this.shouldCheckBounds = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final SimpleType expand(TypeAliasExpansion typeAliasExpansion, TypeAttributes attributes) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)typeAliasExpansion, (String)"typeAliasExpansion");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        return this.expandRecursively((TypeAliasExpansion)var1_1, (TypeAttributes)var2_2, false, 0, true);
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleType expandRecursively(TypeAliasExpansion typeAliasExpansion, TypeAttributes attributes, boolean isNullable, int recursionDepth, boolean withAbbreviatedType) {
        boolean bl;
        TypeProjectionImpl underlyingProjection = new TypeProjectionImpl(Variance.INVARIANT, ((TypeAliasExpansion)typeAliasExpansion).getDescriptor().getUnderlyingType());
        TypeProjection expandedProjection = this.expandTypeProjection(underlyingProjection, (TypeAliasExpansion)typeAliasExpansion, null, recursionDepth);
        KotlinType kotlinType = expandedProjection.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        SimpleType expandedType = TypeSubstitutionKt.asSimpleType(kotlinType);
        if (KotlinTypeKt.isError(expandedType)) {
            return expandedType;
        }
        boolean bl2 = bl = expandedProjection.getProjectionKind() == Variance.INVARIANT;
        if (_Assertions.ENABLED && !bl) {
            typeAliasExpansion = "Type alias expansion: result for " + ((TypeAliasExpansion)typeAliasExpansion).getDescriptor() + " is " + (Object)((Object)expandedProjection.getProjectionKind()) + ", should be invariant";
            throw new AssertionError(typeAliasExpansion);
        }
        this.checkRepeatedAnnotations(expandedType.getAnnotations(), AnnotationsTypeAttributeKt.getAnnotations(attributes));
        SimpleType simpleType2 = this.combineAttributes(expandedType, attributes);
        SimpleType simpleType3 = TypeUtils.makeNullableIfNeeded(simpleType2, isNullable);
        Intrinsics.checkNotNullExpressionValue((Object)simpleType3, (String)"let(...)");
        SimpleType expandedTypeWithExtraAnnotations = simpleType3;
        if (withAbbreviatedType) {
            void var3_3;
            void var2_2;
            void var1_1;
            return SpecialTypesKt.withAbbreviation(expandedTypeWithExtraAnnotations, this.createAbbreviation((TypeAliasExpansion)var1_1, (TypeAttributes)var2_2, (boolean)var3_3));
        }
        return expandedTypeWithExtraAnnotations;
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleType createAbbreviation(TypeAliasExpansion $this$createAbbreviation, TypeAttributes attributes, boolean isNullable) {
        void var3_3;
        void var1_1;
        TypeConstructor typeConstructor2 = $this$createAbbreviation.getDescriptor().getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"getTypeConstructor(...)");
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(attributes, typeConstructor2, var1_1.getArguments(), (boolean)var3_3, MemberScope.Empty.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final TypeProjection expandTypeProjection(TypeProjection underlyingProjection, TypeAliasExpansion typeAliasExpansion, TypeParameterDescriptor typeParameterDescriptor, int recursionDepth) {
        void var2_2;
        void var1_1;
        Variance resultingVariance;
        Variance variance;
        Object object;
        Variance substitutionVariance;
        Variance variance2;
        kotlin.reflect.jvm.internal.impl.types.TypeAliasExpander$Companion.access$assertRecursionDepth(Companion, recursionDepth, typeAliasExpansion.getDescriptor());
        if (underlyingProjection.isStarProjection()) {
            TypeParameterDescriptor typeParameterDescriptor2 = typeParameterDescriptor;
            Intrinsics.checkNotNull((Object)typeParameterDescriptor2);
            TypeProjection typeProjection = TypeUtils.makeStarProjection(typeParameterDescriptor2);
            Intrinsics.checkNotNullExpressionValue((Object)typeProjection, (String)"makeStarProjection(...)");
            return typeProjection;
        }
        KotlinType kotlinType = underlyingProjection.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        KotlinType underlyingType = kotlinType;
        TypeProjection typeProjection = typeAliasExpansion.getReplacement(underlyingType.getConstructor());
        if (typeProjection == null) {
            return this.expandNonArgumentTypeProjection(underlyingProjection, typeAliasExpansion, recursionDepth);
        }
        TypeProjection argument = typeProjection;
        if (typeProjection.isStarProjection()) {
            TypeParameterDescriptor typeParameterDescriptor3 = typeParameterDescriptor;
            Intrinsics.checkNotNull((Object)typeParameterDescriptor3);
            TypeProjection typeProjection2 = TypeUtils.makeStarProjection(typeParameterDescriptor3);
            Intrinsics.checkNotNullExpressionValue((Object)typeProjection2, (String)"makeStarProjection(...)");
            return typeProjection2;
        }
        UnwrappedType argumentType = argument.getType().unwrap();
        TypeAliasExpander $this$expandTypeProjection_u24lambda_u242 = this;
        Variance variance3 = argument.getProjectionKind();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)variance3), (String)"getProjectionKind(...)");
        Object argumentVariance = variance3;
        Variance variance4 = underlyingProjection.getProjectionKind();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)variance4), (String)"getProjectionKind(...)");
        Variance underlyingVariance = variance4;
        if (variance4 == argumentVariance) {
            variance2 = argumentVariance;
        } else if (underlyingVariance == Variance.INVARIANT) {
            variance2 = argumentVariance;
        } else if (argumentVariance == Variance.INVARIANT) {
            variance2 = underlyingVariance;
        } else {
            $this$expandTypeProjection_u24lambda_u242.reportStrategy.conflictingProjection(typeAliasExpansion.getDescriptor(), typeParameterDescriptor, argumentType);
            variance2 = substitutionVariance = argumentVariance;
        }
        if ((object = typeParameterDescriptor) == null || (object = object.getVariance()) == null) {
            object = Variance.INVARIANT;
        }
        argumentVariance = object;
        Intrinsics.checkNotNull((Object)object);
        Object parameterVariance = argumentVariance;
        if (parameterVariance == substitutionVariance) {
            variance = substitutionVariance;
        } else if (parameterVariance == Variance.INVARIANT) {
            variance = substitutionVariance;
        } else if (substitutionVariance == Variance.INVARIANT) {
            variance = Variance.INVARIANT;
        } else {
            void var3_3;
            $this$expandTypeProjection_u24lambda_u242.reportStrategy.conflictingProjection(typeAliasExpansion.getDescriptor(), (TypeParameterDescriptor)var3_3, argumentType);
            variance = resultingVariance;
        }
        resultingVariance = variance;
        this.checkRepeatedAnnotations(underlyingType.getAnnotations(), argumentType.getAnnotations());
        UnwrappedType substitutedType = argumentType instanceof DynamicType ? (UnwrappedType)this.combineAttributes((DynamicType)argumentType, underlyingType.getAttributes()) : (UnwrappedType)this.combineNullabilityAndAnnotations(TypeSubstitutionKt.asSimpleType(argumentType), underlyingType);
        return new TypeProjectionImpl((Variance)var1_1, (KotlinType)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final DynamicType combineAttributes(DynamicType $this$combineAttributes, TypeAttributes newAttributes) {
        void var2_2;
        void var1_1;
        return $this$combineAttributes.replaceAttributes(this.createdCombinedAttributes((KotlinType)var1_1, (TypeAttributes)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleType combineAttributes(SimpleType $this$combineAttributes, TypeAttributes newAttributes) {
        void var2_2;
        void var1_1;
        if (KotlinTypeKt.isError($this$combineAttributes)) {
            return $this$combineAttributes;
        }
        return TypeSubstitutionKt.replace$default($this$combineAttributes, null, this.createdCombinedAttributes((KotlinType)var1_1, (TypeAttributes)var2_2), 1, null);
    }

    /*
     * WARNING - void declaration
     */
    private final TypeAttributes createdCombinedAttributes(KotlinType $this$createdCombinedAttributes, TypeAttributes newAttributes) {
        void var1_1;
        void var2_2;
        if (KotlinTypeKt.isError($this$createdCombinedAttributes)) {
            return $this$createdCombinedAttributes.getAttributes();
        }
        return var2_2.add(var1_1.getAttributes());
    }

    /*
     * WARNING - void declaration
     */
    private final void checkRepeatedAnnotations(Annotations existingAnnotations, Annotations newAnnotations) {
        void var2_2;
        void $this$mapTo$iv;
        Iterable iterable = (Iterable)existingAnnotations;
        Collection destination$iv = new HashSet();
        for (Object item$iv : $this$mapTo$iv) {
            item$iv = (AnnotationDescriptor)item$iv;
            Collection collection = destination$iv;
            collection.add(iterable.getFqName());
        }
        HashSet existingAnnotationFqNames = (HashSet)destination$iv;
        for (AnnotationDescriptor annotation : var2_2) {
            if (!existingAnnotationFqNames.contains(annotation.getFqName())) continue;
            this.reportStrategy.repeatedAnnotation(annotation);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleType combineNullability(SimpleType $this$combineNullability, KotlinType fromType) {
        void var2_2;
        SimpleType simpleType2 = TypeUtils.makeNullableIfNeeded($this$combineNullability, var2_2.isMarkedNullable());
        Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"makeNullableIfNeeded(...)");
        return simpleType2;
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleType combineNullabilityAndAnnotations(SimpleType $this$combineNullabilityAndAnnotations, KotlinType fromType) {
        void var2_2;
        void var1_1;
        TypeAliasExpander typeAliasExpander = this;
        return typeAliasExpander.combineAttributes(typeAliasExpander.combineNullability((SimpleType)var1_1, fromType), var2_2.getAttributes());
    }

    /*
     * WARNING - void declaration
     */
    private final TypeProjection expandNonArgumentTypeProjection(TypeProjection originalProjection, TypeAliasExpansion typeAliasExpansion, int recursionDepth) {
        void var1_1;
        void var3_3;
        void var2_2;
        boolean bl;
        UnwrappedType originalType = originalProjection.getType().unwrap();
        if (DynamicTypesKt.isDynamic(originalType)) {
            return originalProjection;
        }
        SimpleType type2 = TypeSubstitutionKt.asSimpleType(originalType);
        if (KotlinTypeKt.isError(type2) || !TypeUtilsKt.requiresTypeAliasExpansion(type2)) {
            return originalProjection;
        }
        String[] typeConstructor2 = type2.getConstructor();
        ClassifierDescriptor typeDescriptor = typeConstructor2.getDeclarationDescriptor();
        boolean bl2 = bl = typeConstructor2.getParameters().size() == type2.getArguments().size();
        if (_Assertions.ENABLED && !bl) {
            typeConstructor2 = "Unexpected malformed type: " + type2;
            throw new AssertionError(typeConstructor2);
        }
        ClassifierDescriptor classifierDescriptor = typeDescriptor;
        if (classifierDescriptor instanceof TypeParameterDescriptor) {
            return originalProjection;
        }
        if (classifierDescriptor instanceof TypeAliasDescriptor) {
            Iterator $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv;
            if (typeAliasExpansion.isRecursion((TypeAliasDescriptor)typeDescriptor)) {
                this.reportStrategy.recursiveTypeAlias((TypeAliasDescriptor)typeDescriptor);
                String[] stringArray = new String[1];
                typeConstructor2 = stringArray;
                String string = ((TypeAliasDescriptor)typeDescriptor).getName().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                stringArray[0] = string;
                return new TypeProjectionImpl(Variance.INVARIANT, ErrorUtils.createErrorType(ErrorTypeKind.RECURSIVE_TYPE_ALIAS, typeConstructor2));
            }
            Iterable iterable = $this$mapIndexed$iv = (Iterable)type2.getArguments();
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            int index$iv$iv = 0;
            $this$mapIndexedTo$iv$iv = $this$mapIndexedTo$iv$iv.iterator();
            while ($this$mapIndexedTo$iv$iv.hasNext()) {
                void i;
                void typeAliasArgument;
                int n;
                Object item$iv$iv = $this$mapIndexedTo$iv$iv.next();
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                item$iv$iv = (TypeProjection)item$iv$iv;
                Collection collection = destination$iv$iv;
                collection.add(this.expandTypeProjection((TypeProjection)typeAliasArgument, typeAliasExpansion, typeConstructor2.getParameters().get((int)i), recursionDepth + 1));
            }
            List expandedArguments = (List)destination$iv$iv;
            TypeAliasExpansion nestedExpansion = TypeAliasExpansion.Companion.create(typeAliasExpansion, (TypeAliasDescriptor)typeDescriptor, expandedArguments);
            SimpleType nestedExpandedType = this.expandRecursively(nestedExpansion, type2.getAttributes(), type2.isMarkedNullable(), recursionDepth + 1, false);
            SimpleType substitutedType = this.substituteArguments(type2, typeAliasExpansion, recursionDepth);
            SimpleType typeWithAbbreviation = DynamicTypesKt.isDynamic(nestedExpandedType) ? nestedExpandedType : SpecialTypesKt.withAbbreviation(nestedExpandedType, substitutedType);
            return new TypeProjectionImpl(originalProjection.getProjectionKind(), typeWithAbbreviation);
        }
        SimpleType substitutedType = this.substituteArguments(type2, (TypeAliasExpansion)var2_2, (int)var3_3);
        this.checkTypeArgumentsSubstitution(type2, substitutedType);
        return new TypeProjectionImpl(var1_1.getProjectionKind(), substitutedType);
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleType substituteArguments(SimpleType $this$substituteArguments, TypeAliasExpansion typeAliasExpansion, int recursionDepth) {
        void var2_2;
        void var1_1;
        void $this$mapIndexedTo$iv$iv;
        TypeConstructor typeConstructor2 = $this$substituteArguments.getConstructor();
        Iterable $this$mapIndexed$iv = $this$substituteArguments.getArguments();
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void i;
            void originalArgument;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            item$iv$iv = (TypeProjection)item$iv$iv;
            Collection collection = destination$iv$iv;
            TypeProjection projection = this.expandTypeProjection((TypeProjection)originalArgument, typeAliasExpansion, typeConstructor2.getParameters().get((int)i), recursionDepth + 1);
            collection.add(projection.isStarProjection() ? projection : (TypeProjection)new TypeProjectionImpl(projection.getProjectionKind(), TypeUtils.makeNullableIfNeeded(projection.getType(), originalArgument.getType().isMarkedNullable())));
        }
        List substitutedArguments = (List)destination$iv$iv;
        return TypeSubstitutionKt.replace$default((SimpleType)var1_1, (List)var2_2, null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeArgumentsSubstitution(KotlinType unsubstitutedType, KotlinType substitutedType) {
        Iterator iterator2;
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(substitutedType);
        Intrinsics.checkNotNullExpressionValue((Object)typeSubstitutor2, (String)"create(...)");
        TypeSubstitutor typeSubstitutor3 = typeSubstitutor2;
        Iterable $this$forEachIndexed$iv = substitutedType.getArguments();
        int index$iv = 0;
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            void substitutedArgument;
            int n;
            Object item$iv = iterator2.next();
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            item$iv = (TypeProjection)item$iv;
            int i = n;
            if (substitutedArgument.isStarProjection()) continue;
            KotlinType kotlinType = substitutedArgument.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            if (TypeUtilsKt.containsTypeAliasParameters(kotlinType)) continue;
            TypeProjection unsubstitutedArgument = unsubstitutedType.getArguments().get(i);
            TypeParameterDescriptor typeParameter = unsubstitutedType.getConstructor().getParameters().get(i);
            if (!this.shouldCheckBounds) continue;
            KotlinType kotlinType2 = unsubstitutedArgument.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
            KotlinType kotlinType3 = substitutedArgument.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType3, (String)"getType(...)");
            Intrinsics.checkNotNull((Object)typeParameter);
            this.reportStrategy.boundsViolationInSubstitution(typeSubstitutor3, kotlinType2, kotlinType3, typeParameter);
        }
    }

    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final void assertRecursionDepth(int recursionDepth, TypeAliasDescriptor typeAliasDescriptor) {
            if (recursionDepth > 100) {
                void var2_2;
                throw new AssertionError((Object)("Too deep recursion while expanding type alias " + var2_2.getName()));
            }
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ void access$assertRecursionDepth(Companion $this, int recursionDepth, TypeAliasDescriptor typeAliasDescriptor) {
            void var2_2;
            void var1_1;
            $this.assertRecursionDepth((int)var1_1, (TypeAliasDescriptor)var2_2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

