/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.Collection;
import java.util.List;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitution;

@SourceDebugExtension(value={"SMAP\nTypeSubstitution.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeSubstitution.kt\norg/jetbrains/kotlin/types/IndexedParametersSubstitution\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,207:1\n37#2,2:208\n*S KotlinDebug\n*F\n+ 1 TypeSubstitution.kt\norg/jetbrains/kotlin/types/IndexedParametersSubstitution\n*L\n127#1:208,2\n*E\n"})
public final class IndexedParametersSubstitution
extends TypeSubstitution {
    private final TypeParameterDescriptor[] parameters;
    private final TypeProjection[] arguments;
    private final boolean approximateContravariantCapturedTypes;

    /*
     * WARNING - void declaration
     */
    public IndexedParametersSubstitution(TypeParameterDescriptor[] parameters2, TypeProjection[] arguments2, boolean approximateContravariantCapturedTypes) {
        boolean bl;
        void var3_5;
        void var2_4;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)arguments2, (String)"arguments");
        this.parameters = var1_1;
        this.arguments = var2_4;
        this.approximateContravariantCapturedTypes = var3_5;
        boolean bl2 = bl = this.parameters.length <= this.arguments.length;
        if (_Assertions.ENABLED && !bl) {
            String string = "Number of arguments should not be less than number of parameters, but: parameters=" + this.parameters.length + ", args=" + this.arguments.length;
            throw new AssertionError((Object)string);
        }
    }

    public /* synthetic */ IndexedParametersSubstitution(TypeParameterDescriptor[] typeParameterDescriptorArray, TypeProjection[] typeProjectionArray, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(typeParameterDescriptorArray, typeProjectionArray, bl);
    }

    public final TypeParameterDescriptor[] getParameters() {
        return this.parameters;
    }

    public final TypeProjection[] getArguments() {
        return this.arguments;
    }

    /*
     * WARNING - void declaration
     */
    public IndexedParametersSubstitution(List<? extends TypeParameterDescriptor> parameters2, List<? extends TypeProjection> argumentsList) {
        void var2_2;
        Collection collection;
        Intrinsics.checkNotNullParameter(parameters2, (String)"parameters");
        Intrinsics.checkNotNullParameter(argumentsList, (String)"argumentsList");
        Collection collection2 = collection;
        collection = collection2;
        collection = collection2;
        Collection collection3 = (Collection)var2_2;
        collection = collection3;
        collection = collection3;
        this(collection2.toArray(new TypeParameterDescriptor[0]), collection3.toArray(new TypeProjection[0]), false, 4, null);
    }

    @Override
    public final boolean isEmpty() {
        return this.arguments.length == 0;
    }

    @Override
    public final boolean approximateContravariantCapturedTypes() {
        return this.approximateContravariantCapturedTypes;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final TypeProjection get(KotlinType key) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        key = key.getConstructor().getDeclarationDescriptor();
        TypeParameterDescriptor typeParameterDescriptor = key instanceof TypeParameterDescriptor ? (TypeParameterDescriptor)key : null;
        if (typeParameterDescriptor == null) {
            return null;
        }
        TypeParameterDescriptor parameter = typeParameterDescriptor;
        int index = typeParameterDescriptor.getIndex();
        if (index < this.parameters.length && Intrinsics.areEqual((Object)this.parameters[index].getTypeConstructor(), (Object)var1_1.getTypeConstructor())) {
            void var2_2;
            return this.arguments[var2_2];
        }
        return null;
    }
}

