/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptions;
import kotlin.reflect.jvm.internal.impl.types.CustomTypeParameter;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

@SourceDebugExtension(value={"SMAP\nflexibleTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 flexibleTypes.kt\norg/jetbrains/kotlin/types/FlexibleTypeImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1#2:175\n*E\n"})
public final class FlexibleTypeImpl
extends FlexibleType
implements CustomTypeParameter {
    public static final Companion Companion = new Companion(null);
    private boolean assertionsDone;
    @JvmField
    public static boolean RUN_SLOW_ASSERTIONS;

    /*
     * WARNING - void declaration
     */
    public FlexibleTypeImpl(SimpleType lowerBound, SimpleType upperBound) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)lowerBound, (String)"lowerBound");
        Intrinsics.checkNotNullParameter((Object)upperBound, (String)"upperBound");
        super((SimpleType)var1_1, (SimpleType)var2_2);
    }

    private final void runAssertions() {
        boolean bl;
        if (!RUN_SLOW_ASSERTIONS || this.assertionsDone) {
            return;
        }
        this.assertionsDone = true;
        boolean bl2 = bl = !FlexibleTypesKt.isFlexible(this.getLowerBound());
        if (_Assertions.ENABLED && !bl) {
            String string = "Lower bound of a flexible type can not be flexible: " + this.getLowerBound();
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = !FlexibleTypesKt.isFlexible(this.getUpperBound());
        if (_Assertions.ENABLED && !bl) {
            String string = "Upper bound of a flexible type can not be flexible: " + this.getUpperBound();
            throw new AssertionError((Object)string);
        }
        boolean bl4 = bl = !Intrinsics.areEqual((Object)this.getLowerBound(), (Object)this.getUpperBound());
        if (_Assertions.ENABLED && !bl) {
            String string = "Lower and upper bounds are equal: " + this.getLowerBound() + " == " + this.getUpperBound();
            throw new AssertionError((Object)string);
        }
        bl = KotlinTypeChecker.DEFAULT.isSubtypeOf(this.getLowerBound(), this.getUpperBound());
        if (_Assertions.ENABLED && !bl) {
            String string = "Lower bound " + this.getLowerBound() + " of a flexible type must be a subtype of the upper bound " + this.getUpperBound();
            throw new AssertionError((Object)string);
        }
    }

    @Override
    public final SimpleType getDelegate() {
        this.runAssertions();
        return this.getLowerBound();
    }

    @Override
    public final boolean isTypeParameter() {
        return this.getLowerBound().getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor && Intrinsics.areEqual((Object)this.getLowerBound().getConstructor(), (Object)this.getUpperBound().getConstructor());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final KotlinType substitutionResult(KotlinType replacement) {
        void var1_1;
        UnwrappedType unwrappedType;
        UnwrappedType unwrapped;
        Intrinsics.checkNotNullParameter((Object)replacement, (String)"replacement");
        UnwrappedType unwrappedType2 = unwrapped = replacement.unwrap();
        if (unwrapped instanceof FlexibleType) {
            unwrappedType = unwrapped;
        } else if (unwrappedType2 instanceof SimpleType) {
            unwrappedType = KotlinTypeFactory.flexibleType((SimpleType)unwrapped, ((SimpleType)unwrapped).makeNullableAsSpecified(true));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return TypeWithEnhancementKt.inheritEnhancement(unwrappedType, (KotlinType)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final UnwrappedType replaceAttributes(TypeAttributes newAttributes) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)newAttributes, (String)"newAttributes");
        return KotlinTypeFactory.flexibleType(this.getLowerBound().replaceAttributes(newAttributes), this.getUpperBound().replaceAttributes((TypeAttributes)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String render(DescriptorRenderer renderer, DescriptorRendererOptions options) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)renderer, (String)"renderer");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        if (var2_2.getDebugMode()) {
            return "(" + renderer.renderType(this.getLowerBound()) + ".." + renderer.renderType(this.getUpperBound()) + ')';
        }
        DescriptorRenderer descriptorRenderer2 = renderer;
        return descriptorRenderer2.renderFlexibleType(descriptorRenderer2.renderType(this.getLowerBound()), var1_1.renderType(this.getUpperBound()), TypeUtilsKt.getBuiltIns(this));
    }

    @Override
    public final String toString() {
        return "(" + this.getLowerBound() + ".." + this.getUpperBound() + ')';
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final UnwrappedType makeNullableAsSpecified(boolean newNullability) {
        void var1_1;
        return KotlinTypeFactory.flexibleType(this.getLowerBound().makeNullableAsSpecified(newNullability), this.getUpperBound().makeNullableAsSpecified((boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final FlexibleType refine(KotlinTypeRefiner kotlinTypeRefiner) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"kotlinTypeRefiner");
        KotlinType kotlinType = kotlinTypeRefiner.refineType(this.getLowerBound());
        Intrinsics.checkNotNull((Object)kotlinType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.types.SimpleType");
        SimpleType simpleType2 = (SimpleType)kotlinType;
        KotlinType kotlinType2 = var1_1.refineType(this.getUpperBound());
        Intrinsics.checkNotNull((Object)kotlinType2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.types.SimpleType");
        return new FlexibleTypeImpl(simpleType2, (SimpleType)kotlinType2);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

