/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.BinaryVersion;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassDataFinder;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolverUtilKt;

@SourceDebugExtension(value={"SMAP\nProtoBasedClassDataFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtoBasedClassDataFinder.kt\norg/jetbrains/kotlin/serialization/deserialization/ProtoBasedClassDataFinder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n1194#2,2:44\n1222#2,4:46\n*S KotlinDebug\n*F\n+ 1 ProtoBasedClassDataFinder.kt\norg/jetbrains/kotlin/serialization/deserialization/ProtoBasedClassDataFinder\n*L\n32#1:44,2\n32#1:46,4\n*E\n"})
public final class ProtoBasedClassDataFinder
implements ClassDataFinder {
    private final NameResolver nameResolver;
    private final BinaryVersion metadataVersion;
    private final Function1<ClassId, SourceElement> classSource;
    private final Map<ClassId, ProtoBuf.Class> classIdToProto;

    /*
     * WARNING - void declaration
     */
    public ProtoBasedClassDataFinder(ProtoBuf.PackageFragment proto, NameResolver nameResolver, BinaryVersion metadataVersion, Function1<? super ClassId, ? extends SourceElement> classSource) {
        void var2_4;
        Iterator iterator2;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"nameResolver");
        Intrinsics.checkNotNullParameter((Object)metadataVersion, (String)"metadataVersion");
        Intrinsics.checkNotNullParameter(classSource, (String)"classSource");
        this.nameResolver = nameResolver;
        this.metadataVersion = metadataVersion;
        this.classSource = classSource;
        List<ProtoBuf.Class> list = ((ProtoBuf.PackageFragment)proto).getClass_List();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getClass_List(...)");
        proto = list;
        ProtoBasedClassDataFinder protoBasedClassDataFinder = this;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            void var3_5;
            void klass;
            Object element$iv$iv = iterator2.next();
            classSource = (ProtoBuf.Class)element$iv$iv;
            Map map = destination$iv$iv;
            map.put(NameResolverUtilKt.getClassId(this.nameResolver, klass.getFqName()), var3_5);
        }
        protoBasedClassDataFinder.classIdToProto = var2_4;
    }

    public final Collection<ClassId> getAllClassIds() {
        return this.classIdToProto.keySet();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ClassData findClassData(ClassId classId) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        ProtoBuf.Class clazz = this.classIdToProto.get(classId);
        if (clazz == null) {
            return null;
        }
        ProtoBuf.Class classProto = clazz;
        return new ClassData(this.nameResolver, (ProtoBuf.Class)var2_2, this.metadataVersion, (SourceElement)this.classSource.invoke((Object)var1_1));
    }
}

