/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.jvm;

import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.load.java.components.JavaResolverCache;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaPackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaPackageFragment;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.LightClassOriginKind;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;

public final class JavaDescriptorResolver {
    private final LazyJavaPackageFragmentProvider packageFragmentProvider;
    private final JavaResolverCache javaResolverCache;

    /*
     * WARNING - void declaration
     */
    public JavaDescriptorResolver(LazyJavaPackageFragmentProvider packageFragmentProvider, JavaResolverCache javaResolverCache) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)packageFragmentProvider, (String)"packageFragmentProvider");
        Intrinsics.checkNotNullParameter((Object)javaResolverCache, (String)"javaResolverCache");
        this.packageFragmentProvider = var1_1;
        this.javaResolverCache = var2_2;
    }

    public final LazyJavaPackageFragmentProvider getPackageFragmentProvider() {
        return this.packageFragmentProvider;
    }

    /*
     * WARNING - void declaration
     */
    public final ClassDescriptor resolveClass(JavaClass javaClass) {
        MemberScope memberScope2;
        Intrinsics.checkNotNullParameter((Object)javaClass, (String)"javaClass");
        FqName fqName2 = javaClass.getFqName();
        if (fqName2 != null && javaClass.getLightClassOriginKind() == LightClassOriginKind.SOURCE) {
            return this.javaResolverCache.getClassResolvedFromSource(fqName2);
        }
        JavaClass javaClass2 = javaClass.getOuterClass();
        if (javaClass2 != null) {
            JavaClass outerClass = javaClass2;
            ClassDescriptor classDescriptor = this.resolveClass((JavaClass)((Object)memberScope2));
            memberScope2 = classDescriptor != null ? classDescriptor.getUnsubstitutedInnerClassesScope() : null;
            javaClass = memberScope2 != null ? memberScope2.getContributedClassifier(javaClass.getName(), NoLookupLocation.FROM_JAVA_LOADER) : null;
            if (javaClass instanceof ClassDescriptor) {
                return (ClassDescriptor)javaClass;
            }
            return null;
        }
        if (memberScope2 == null) {
            return null;
        }
        FqName fqName3 = ((FqName)((Object)memberScope2)).parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"parent(...)");
        LazyJavaPackageFragment lazyJavaPackageFragment = (LazyJavaPackageFragment)CollectionsKt.firstOrNull(this.packageFragmentProvider.getPackageFragments(fqName3));
        if (lazyJavaPackageFragment != null) {
            void var1_1;
            return lazyJavaPackageFragment.findClassifierByJavaClass$descriptors_jvm((JavaClass)var1_1);
        }
        return null;
    }
}

