/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.resolve.constants;

import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ClassLiteralValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class KClassValue
extends ConstantValue<Value> {
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public KClassValue(Value value) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        super(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public KClassValue(ClassLiteralValue value) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this(new Value.NormalClass((ClassLiteralValue)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public KClassValue(ClassId classId, int arrayDimensions) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        this(new ClassLiteralValue((ClassId)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final KotlinType getType(ModuleDescriptor module) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        TypeAttributes typeAttributes = TypeAttributes.Companion.getEmpty();
        ClassDescriptor classDescriptor = module.getBuiltIns().getKClass();
        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"getKClass(...)");
        return KotlinTypeFactory.simpleNotNullType(typeAttributes, classDescriptor, CollectionsKt.listOf((Object)new TypeProjectionImpl(this.getArgumentType((ModuleDescriptor)var1_1))));
    }

    /*
     * WARNING - void declaration
     */
    public final KotlinType getArgumentType(ModuleDescriptor module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Object object = (Value)this.getValue();
        if (object instanceof Value.LocalClass) {
            return ((Value.LocalClass)this.getValue()).getType();
        }
        if (object instanceof Value.NormalClass) {
            void var3_4;
            object = ((Value.NormalClass)this.getValue()).getValue();
            Object classId = ((ClassLiteralValue)object).component1();
            int arrayDimensions = ((ClassLiteralValue)object).component2();
            ClassDescriptor classDescriptor = FindClassInModuleKt.findClassAcrossModuleDependencies(module, (ClassId)classId);
            if (classDescriptor == null) {
                String[] stringArray = new String[2];
                String[] stringArray2 = stringArray;
                String string = ((ClassId)classId).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                stringArray[0] = string;
                stringArray2[1] = String.valueOf(arrayDimensions);
                return ErrorUtils.createErrorType(ErrorTypeKind.UNRESOLVED_KCLASS_CONSTANT_VALUE, stringArray2);
            }
            classId = classDescriptor;
            SimpleType simpleType2 = classDescriptor.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType2, (String)"getDefaultType(...)");
            KotlinType type2 = TypeUtilsKt.replaceArgumentsWithStarProjections(simpleType2);
            for (int i = 0; i < arrayDimensions; ++i) {
                Intrinsics.checkNotNullExpressionValue((Object)module.getBuiltIns().getArrayType(Variance.INVARIANT, type2), (String)"getArrayType(...)");
            }
            return (KotlinType)var3_4;
        }
        throw new NoWhenBranchMatchedException();
    }

    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final ConstantValue<?> create(KotlinType argumentType) {
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)argumentType, (String)"argumentType");
            if (KotlinTypeKt.isError(argumentType)) {
                return null;
            }
            KotlinType type2 = argumentType;
            int arrayDimensions = 0;
            while (KotlinBuiltIns.isArray(type2)) {
                Intrinsics.checkNotNullExpressionValue((Object)((TypeProjection)CollectionsKt.single(type2.getArguments())).getType(), (String)"getType(...)");
                ++arrayDimensions;
            }
            ClassifierDescriptor descriptor2 = type2.getConstructor().getDeclarationDescriptor();
            if (descriptor2 instanceof ClassDescriptor) {
                void var3_3;
                void var1_1;
                ClassId classId = DescriptorUtilsKt.getClassId(descriptor2);
                if (classId == null) {
                    return new KClassValue(new Value.LocalClass(argumentType));
                }
                ClassId classId2 = classId;
                return new KClassValue((ClassId)var1_1, (int)var3_3);
            }
            if (var2_2 instanceof TypeParameterDescriptor) {
                ClassId classId = ClassId.topLevel(StandardNames.FqNames.any.toSafe());
                Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(...)");
                return new KClassValue(classId, 0);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static abstract class Value {
        private Value() {
        }

        public /* synthetic */ Value(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final class LocalClass
        extends Value {
            private final KotlinType type;

            /*
             * WARNING - void declaration
             */
            public LocalClass(KotlinType type2) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
                super(null);
                this.type = var1_1;
            }

            public final KotlinType getType() {
                return this.type;
            }

            public final String toString() {
                return "LocalClass(type=" + this.type + ')';
            }

            public final int hashCode() {
                return this.type.hashCode();
            }

            public final boolean equals(Object other) {
                LocalClass localClass;
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LocalClass)) {
                    return false;
                }
                localClass = localClass;
                return Intrinsics.areEqual((Object)this.type, (Object)localClass.type);
            }
        }

        public static final class NormalClass
        extends Value {
            private final ClassLiteralValue value;

            /*
             * WARNING - void declaration
             */
            public NormalClass(ClassLiteralValue value) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                super(null);
                this.value = var1_1;
            }

            public final ClassLiteralValue getValue() {
                return this.value;
            }

            public final ClassId getClassId() {
                return this.value.getClassId();
            }

            public final int getArrayDimensions() {
                return this.value.getArrayNestedness();
            }

            public final String toString() {
                return "NormalClass(value=" + this.value + ')';
            }

            public final int hashCode() {
                return this.value.hashCode();
            }

            public final boolean equals(Object other) {
                NormalClass normalClass;
                if (this == other) {
                    return true;
                }
                if (!(other instanceof NormalClass)) {
                    return false;
                }
                normalClass = normalClass;
                return Intrinsics.areEqual((Object)this.value, (Object)normalClass.value);
            }
        }
    }
}

