/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.NoSuchElementException;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.CodedInputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.RopeByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.Utf8;

class LiteralByteString
extends ByteString {
    protected final byte[] bytes;
    private int hash = 0;

    /*
     * WARNING - void declaration
     */
    LiteralByteString(byte[] bytes) {
        void var1_1;
        this.bytes = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public byte byteAt(int index) {
        void var1_1;
        return this.bytes[var1_1];
    }

    @Override
    public int size() {
        return this.bytes.length;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void copyToInternal(byte[] target, int sourceOffset, int targetOffset, int numberToCopy) {
        void var3_3;
        void var1_1;
        void var2_2;
        System.arraycopy(this.bytes, (int)var2_2, var1_1, (int)var3_3, numberToCopy);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void writeToInternal(OutputStream outputStream, int sourceOffset, int numberToWrite) throws IOException {
        void var3_3;
        void var2_2;
        outputStream.write(this.bytes, this.getOffsetIntoBytes() + var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString(String charsetName) throws UnsupportedEncodingException {
        void var1_1;
        return new String(this.bytes, this.getOffsetIntoBytes(), ((ByteString)this).size(), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isValidUtf8() {
        void var1_1;
        int offset = this.getOffsetIntoBytes();
        void v0 = var1_1;
        return Utf8.isValidUtf8(this.bytes, (int)v0, (int)(v0 + ((ByteString)this).size()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int partialIsValidUtf8(int state, int offset, int length) {
        void var3_3;
        void var1_1;
        void var2_2;
        int index = this.getOffsetIntoBytes() + offset;
        void v0 = var2_2;
        return Utf8.partialIsValidUtf8((int)var1_1, this.bytes, (int)v0, (int)(v0 + var3_3));
    }

    public boolean equals(Object other) {
        String string;
        if (other == this) {
            return true;
        }
        if (!(other instanceof ByteString)) {
            return false;
        }
        if (((ByteString)this).size() != ((ByteString)other).size()) {
            return false;
        }
        if (((ByteString)this).size() == 0) {
            return true;
        }
        if (other instanceof LiteralByteString) {
            return this.equalsRange((LiteralByteString)other, 0, ((ByteString)this).size());
        }
        if (other instanceof RopeByteString) {
            return other.equals(this);
        }
        string = String.valueOf(String.valueOf(string.getClass()));
        throw new IllegalArgumentException(new StringBuilder(49 + string.length()).append("Has a new type of ByteString been created? Found ").append(string).toString());
    }

    /*
     * WARNING - void declaration
     */
    boolean equalsRange(LiteralByteString other, int offset, int length) {
        void var2_3;
        if (length > ((ByteString)other).size()) {
            int n = length;
            int n2 = ((ByteString)this).size();
            throw new IllegalArgumentException(new StringBuilder(40).append("Length too large: ").append(n).append(n2).toString());
        }
        if (offset + length > ((ByteString)other).size()) {
            int n = offset;
            int n3 = length;
            length = ((ByteString)other).size();
            throw new IllegalArgumentException(new StringBuilder(59).append("Ran off end of other: ").append(n).append(", ").append(n3).append(", ").append(length).toString());
        }
        byte[] thisBytes = this.bytes;
        byte[] otherBytes = other.bytes;
        int thisLimit = this.getOffsetIntoBytes() + length;
        int thisIndex = this.getOffsetIntoBytes();
        int otherIndex = other.getOffsetIntoBytes() + var2_3;
        while (thisIndex < thisLimit) {
            if (thisBytes[thisIndex] != otherBytes[otherIndex]) {
                return false;
            }
            ++thisIndex;
            ++otherIndex;
        }
        return true;
    }

    public int hashCode() {
        int n;
        int h = this.hash;
        if (h == 0) {
            int size = ((ByteString)this).size();
            n = this.partialHash(size, 0, n);
            if (n == 0) {
                n = 1;
            }
            this.hash = n;
        }
        return n;
    }

    @Override
    protected int peekCachedHashCode() {
        return this.hash;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int partialHash(int h, int offset, int length) {
        void var3_3;
        void var2_2;
        return LiteralByteString.hashCode(h, this.bytes, this.getOffsetIntoBytes() + var2_2, (int)var3_3);
    }

    static int hashCode(int h, byte[] bytes, int offset, int length) {
        int n;
        for (int i = offset; i < offset + length; ++i) {
            h = h * 31 + bytes[i];
        }
        return n;
    }

    @Override
    public CodedInputStream newCodedInput() {
        return CodedInputStream.newInstance(this);
    }

    @Override
    public ByteString.ByteIterator iterator() {
        return new LiteralByteIterator();
    }

    @Override
    protected int getTreeDepth() {
        return 0;
    }

    @Override
    protected boolean isBalanced() {
        return true;
    }

    protected int getOffsetIntoBytes() {
        return 0;
    }

    private class LiteralByteIterator
    implements ByteString.ByteIterator {
        private int position = 0;
        private final int limit;

        private LiteralByteIterator() {
            this.limit = ((ByteString)LiteralByteString.this).size();
        }

        @Override
        public boolean hasNext() {
            return this.position < this.limit;
        }

        @Override
        public Byte next() {
            return this.nextByte();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public byte nextByte() {
            try {
                return LiteralByteString.this.bytes[this.position++];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                void var1_1;
                throw new NoSuchElementException(var1_1.getMessage());
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

