/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.CodedInputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.CodedOutputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.Internal;
import kotlin.reflect.jvm.internal.impl.protobuf.LazyField;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.protobuf.SmallSortedMap;
import kotlin.reflect.jvm.internal.impl.protobuf.WireFormat;

final class FieldSet<FieldDescriptorType extends FieldDescriptorLite<FieldDescriptorType>> {
    private final SmallSortedMap<FieldDescriptorType, Object> fields;
    private boolean isImmutable;
    private boolean hasLazyField = false;
    private static final FieldSet DEFAULT_INSTANCE = new FieldSet(true);

    private FieldSet() {
        this.fields = SmallSortedMap.newFieldMap(16);
    }

    private FieldSet(boolean dummy) {
        this.fields = SmallSortedMap.newFieldMap(0);
        this.makeImmutable();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> newFieldSet() {
        return new FieldSet();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> emptySet() {
        return DEFAULT_INSTANCE;
    }

    public final void makeImmutable() {
        if (this.isImmutable) {
            return;
        }
        this.fields.makeImmutable();
        this.isImmutable = true;
    }

    /*
     * WARNING - void declaration
     */
    public final FieldSet<FieldDescriptorType> clone() {
        void var1_1;
        FieldDescriptorLite descriptor2;
        FieldSet clone = FieldSet.newFieldSet();
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<FieldDescriptorType, Object> entry = this.fields.getArrayEntryAt(i);
            descriptor2 = (FieldDescriptorLite)entry.getKey();
            clone.setField(descriptor2, entry.getValue());
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            void var3_4;
            descriptor2 = (FieldDescriptorLite)entry.getKey();
            clone.setField(descriptor2, var3_4.getValue());
        }
        clone.hasLazyField = this.hasLazyField;
        return var1_1;
    }

    public final Iterator<Map.Entry<FieldDescriptorType, Object>> iterator() {
        if (this.hasLazyField) {
            return new LazyField.LazyIterator(this.fields.entrySet().iterator());
        }
        return this.fields.entrySet().iterator();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean hasField(FieldDescriptorType descriptor2) {
        void var1_1;
        if (descriptor2.isRepeated()) {
            throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
        }
        return this.fields.get(var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    public final Object getField(FieldDescriptorType descriptor2) {
        void var1_1;
        Object o = this.fields.get(descriptor2);
        if (o instanceof LazyField) {
            return ((LazyField)o).getValue();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setField(FieldDescriptorType descriptor2, Object value) {
        void var1_1;
        void var2_2;
        if (descriptor2.isRepeated()) {
            void var3_3;
            if (!(value instanceof List)) {
                throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
            }
            ArrayList newList = new ArrayList();
            newList.addAll((List)value);
            for (Object element : newList) {
                FieldSet.verifyType(descriptor2.getLiteType(), element);
            }
            var2_2 = var3_3;
        } else {
            FieldSet.verifyType(descriptor2.getLiteType(), var2_2);
        }
        if (var2_2 instanceof LazyField) {
            this.hasLazyField = true;
        }
        this.fields.put(var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final int getRepeatedFieldCount(FieldDescriptorType descriptor2) {
        void var1_1;
        if (!descriptor2.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object value = this.getField(descriptor2);
        if (value == null) {
            return 0;
        }
        return ((List)var1_1).size();
    }

    /*
     * WARNING - void declaration
     */
    public final Object getRepeatedField(FieldDescriptorType descriptor2, int index) {
        void var2_2;
        void var1_1;
        if (!descriptor2.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object value = this.getField(descriptor2);
        if (value == null) {
            throw new IndexOutOfBoundsException();
        }
        return ((List)var1_1).get((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void addRepeatedField(FieldDescriptorType descriptor2, Object value) {
        void var2_2;
        void var3_3;
        ArrayList list;
        if (!descriptor2.isRepeated()) {
            throw new IllegalArgumentException("addRepeatedField() can only be called on repeated fields.");
        }
        FieldSet.verifyType(descriptor2.getLiteType(), value);
        Object existingValue = this.getField(descriptor2);
        if (existingValue == null) {
            void var1_1;
            list = new ArrayList();
            this.fields.put(var1_1, (Object)list);
        } else {
            list = list;
        }
        var3_3.add(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static void verifyType(WireFormat.FieldType type2, Object value) {
        void var2_2;
        WireFormat.FieldType fieldType;
        if (value == null) {
            throw new NullPointerException();
        }
        boolean isValid = false;
        switch (fieldType.getJavaType()) {
            case INT: {
                boolean bl = value instanceof Integer;
                break;
            }
            case LONG: {
                boolean bl = value instanceof Long;
                break;
            }
            case FLOAT: {
                boolean bl = value instanceof Float;
                break;
            }
            case DOUBLE: {
                boolean bl = value instanceof Double;
                break;
            }
            case BOOLEAN: {
                boolean bl = value instanceof Boolean;
                break;
            }
            case STRING: {
                boolean bl = value instanceof String;
                break;
            }
            case BYTE_STRING: {
                isValid = value instanceof ByteString || value instanceof byte[];
                break;
            }
            case ENUM: {
                isValid = value instanceof Integer || value instanceof Internal.EnumLite;
                break;
            }
            case MESSAGE: {
                void var1_1;
                boolean bl = isValid = value instanceof MessageLite || var1_1 instanceof LazyField;
            }
        }
        if (var2_2 == false) {
            throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isInitialized() {
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            FieldSet fieldSet = this;
            if (fieldSet.isInitialized(fieldSet.fields.getArrayEntryAt(i))) continue;
            return false;
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            void var2_3;
            if (this.isInitialized((Map.Entry<FieldDescriptorType, Object>)var2_3)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private boolean isInitialized(Map.Entry<FieldDescriptorType, Object> entry) {
        FieldDescriptorLite descriptor2 = (FieldDescriptorLite)entry.getKey();
        if (descriptor2.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
            MessageLite messageLite2;
            if (messageLite2.isRepeated()) {
                for (MessageLite messageLite2 : (List)entry.getValue()) {
                    if (messageLite2.isInitialized()) continue;
                    return false;
                }
            } else {
                Iterator i$;
                Object value = i$.getValue();
                if (value instanceof MessageLite) {
                    if (!((MessageLite)value).isInitialized()) {
                        return false;
                    }
                } else {
                    void var1_1;
                    if (var1_1 instanceof LazyField) {
                        return true;
                    }
                    throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
                }
            }
        }
        return true;
    }

    static int getWireFormatForFieldType(WireFormat.FieldType type2, boolean isPacked) {
        WireFormat.FieldType fieldType;
        if (isPacked) {
            return 2;
        }
        return fieldType.getWireType();
    }

    /*
     * WARNING - void declaration
     */
    public final void mergeFrom(FieldSet<FieldDescriptorType> other) {
        for (int i = 0; i < other.fields.getNumArrayEntries(); ++i) {
            this.mergeFromField(other.fields.getArrayEntryAt(i));
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : other.fields.getOverflowEntries()) {
            void var1_1;
            this.mergeFromField((Map.Entry<FieldDescriptorType, Object>)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Object cloneIfMutable(Object value) {
        void var1_1;
        if (value instanceof byte[]) {
            void var2_2;
            byte[] bytes = (byte[])value;
            byte[] copy2 = new byte[bytes.length];
            System.arraycopy(bytes, 0, copy2, 0, ((void)var1_1).length);
            return var2_2;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private void mergeFromField(Map.Entry<FieldDescriptorType, Object> entry) {
        void var3_4;
        void var1_1;
        FieldDescriptorLite descriptor2 = (FieldDescriptorLite)entry.getKey();
        Object otherValue = entry.getValue();
        if (otherValue instanceof LazyField) {
            otherValue = ((LazyField)otherValue).getValue();
        }
        if (descriptor2.isRepeated()) {
            ArrayList value = this.getField(descriptor2);
            if (value == null) {
                value = new ArrayList();
            }
            Iterator i$ = ((List)otherValue).iterator();
            while (true) {
                if (!i$.hasNext()) {
                    this.fields.put((FieldDescriptorType)descriptor2, (Object)value);
                    return;
                }
                Object element = i$.next();
                ((List)value).add(this.cloneIfMutable(element));
            }
        }
        if (descriptor2.getLiteJavaType() != WireFormat.JavaType.MESSAGE) {
            void var2_2;
            this.fields.put(var2_2, this.cloneIfMutable(var1_1));
            return;
        }
        Object value = this.getField(descriptor2);
        if (value == null) {
            this.fields.put((FieldDescriptorType)descriptor2, this.cloneIfMutable(var1_1));
            return;
        }
        value = descriptor2.internalMergeFrom(((MessageLite)value).toBuilder(), (MessageLite)var1_1).build();
        this.fields.put((FieldDescriptorType)descriptor2, (Object)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    public static Object readPrimitiveField(CodedInputStream input, WireFormat.FieldType type2, boolean checkUtf8) throws IOException {
        void var1_1;
        switch (1.$SwitchMap$com$google$protobuf$WireFormat$FieldType[var1_1.ordinal()]) {
            case 1: {
                return input.readDouble();
            }
            case 2: {
                return Float.valueOf(input.readFloat());
            }
            case 3: {
                return input.readInt64();
            }
            case 4: {
                return input.readUInt64();
            }
            case 5: {
                return input.readInt32();
            }
            case 6: {
                return input.readFixed64();
            }
            case 7: {
                return input.readFixed32();
            }
            case 8: {
                return input.readBool();
            }
            case 9: {
                void var2_2;
                if (var2_2 != false) {
                    return input.readStringRequireUtf8();
                }
                return input.readString();
            }
            case 10: {
                return input.readBytes();
            }
            case 11: {
                return input.readUInt32();
            }
            case 12: {
                return input.readSFixed32();
            }
            case 13: {
                return input.readSFixed64();
            }
            case 14: {
                return input.readSInt32();
            }
            case 15: {
                CodedInputStream codedInputStream;
                return codedInputStream.readSInt64();
            }
            case 16: {
                throw new IllegalArgumentException("readPrimitiveField() cannot handle nested groups.");
            }
            case 17: {
                throw new IllegalArgumentException("readPrimitiveField() cannot handle embedded messages.");
            }
            case 18: {
                throw new IllegalArgumentException("readPrimitiveField() cannot handle enums.");
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }

    /*
     * WARNING - void declaration
     */
    private static void writeElement(CodedOutputStream output, WireFormat.FieldType type2, int number, Object value) throws IOException {
        void var3_3;
        void var1_1;
        CodedOutputStream codedOutputStream;
        void var2_2;
        if (type2 == WireFormat.FieldType.GROUP) {
            output.writeGroup(number, (MessageLite)value);
            return;
        }
        output.writeTag((int)var2_2, FieldSet.getWireFormatForFieldType(type2, false));
        FieldSet.writeElementNoTag(codedOutputStream, (WireFormat.FieldType)var1_1, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private static void writeElementNoTag(CodedOutputStream output, WireFormat.FieldType type2, Object value) throws IOException {
        void var1_1;
        switch (1.$SwitchMap$com$google$protobuf$WireFormat$FieldType[var1_1.ordinal()]) {
            case 1: {
                output.writeDoubleNoTag((Double)value);
                return;
            }
            case 2: {
                output.writeFloatNoTag(((Float)value).floatValue());
                return;
            }
            case 3: {
                output.writeInt64NoTag((Long)value);
                return;
            }
            case 4: {
                output.writeUInt64NoTag((Long)value);
                return;
            }
            case 5: {
                output.writeInt32NoTag((Integer)value);
                return;
            }
            case 6: {
                output.writeFixed64NoTag((Long)value);
                return;
            }
            case 7: {
                output.writeFixed32NoTag((Integer)value);
                return;
            }
            case 8: {
                output.writeBoolNoTag((Boolean)value);
                return;
            }
            case 9: {
                output.writeStringNoTag((String)value);
                return;
            }
            case 16: {
                output.writeGroupNoTag((MessageLite)value);
                return;
            }
            case 17: {
                output.writeMessageNoTag((MessageLite)value);
                return;
            }
            case 10: {
                if (value instanceof ByteString) {
                    output.writeBytesNoTag((ByteString)value);
                    return;
                }
                output.writeByteArrayNoTag((byte[])value);
                return;
            }
            case 11: {
                output.writeUInt32NoTag((Integer)value);
                return;
            }
            case 12: {
                output.writeSFixed32NoTag((Integer)value);
                return;
            }
            case 13: {
                output.writeSFixed64NoTag((Long)value);
                return;
            }
            case 14: {
                output.writeSInt32NoTag((Integer)value);
                return;
            }
            case 15: {
                output.writeSInt64NoTag((Long)value);
                return;
            }
            case 18: {
                void var2_2;
                CodedOutputStream codedOutputStream;
                if (value instanceof Internal.EnumLite) {
                    output.writeEnumNoTag(((Internal.EnumLite)value).getNumber());
                    return;
                }
                codedOutputStream.writeEnumNoTag((Integer)var2_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public static void writeField(FieldDescriptorLite<?> descriptor2, Object value, CodedOutputStream output) throws IOException {
        void var3_4;
        void var2_3;
        void var4_5;
        void var1_2;
        WireFormat.FieldType type2 = descriptor2.getLiteType();
        int number = descriptor2.getNumber();
        if (descriptor2.isRepeated()) {
            List valueList = (List)value;
            if (descriptor2.isPacked()) {
                output.writeTag(number, 2);
                int dataSize = 0;
                for (Object element : valueList) {
                    dataSize += FieldSet.computeElementSizeNoTag(type2, element);
                }
                output.writeRawVarint32(dataSize);
                for (Object element : valueList) {
                    FieldSet.writeElementNoTag(output, type2, element);
                }
                return;
            } else {
                Iterator i$ = var1_2.iterator();
                while (true) {
                    if (!i$.hasNext()) {
                        return;
                    }
                    Object element = i$.next();
                    FieldSet.writeElement(output, type2, (int)var4_5, element);
                }
            }
        }
        if (var1_2 instanceof LazyField) {
            FieldSet.writeElement(output, type2, (int)var4_5, ((LazyField)var1_2).getValue());
            return;
        }
        FieldSet.writeElement((CodedOutputStream)var2_3, (WireFormat.FieldType)var3_4, (int)var4_5, var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public final int getSerializedSize() {
        void var1_1;
        int size = 0;
        for (int i = 0; i < this.fields.getNumArrayEntries(); ++i) {
            Map.Entry<FieldDescriptorType, Object> entry = this.fields.getArrayEntryAt(i);
            size += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            void var3_4;
            size += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), var3_4.getValue());
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static int computeElementSize(WireFormat.FieldType type2, int number, Object value) {
        void var2_2;
        WireFormat.FieldType fieldType;
        void var1_1;
        int tagSize = CodedOutputStream.computeTagSize(number);
        if (type2 == WireFormat.FieldType.GROUP) {
            tagSize <<= 1;
        }
        return (int)(var1_1 + FieldSet.computeElementSizeNoTag(fieldType, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    private static int computeElementSizeNoTag(WireFormat.FieldType type2, Object value) {
        WireFormat.FieldType fieldType;
        switch (fieldType) {
            case DOUBLE: {
                return CodedOutputStream.computeDoubleSizeNoTag((Double)value);
            }
            case FLOAT: {
                return CodedOutputStream.computeFloatSizeNoTag(((Float)value).floatValue());
            }
            case INT64: {
                return CodedOutputStream.computeInt64SizeNoTag((Long)value);
            }
            case UINT64: {
                return CodedOutputStream.computeUInt64SizeNoTag((Long)value);
            }
            case INT32: {
                return CodedOutputStream.computeInt32SizeNoTag((Integer)value);
            }
            case FIXED64: {
                return CodedOutputStream.computeFixed64SizeNoTag((Long)value);
            }
            case FIXED32: {
                return CodedOutputStream.computeFixed32SizeNoTag((Integer)value);
            }
            case BOOL: {
                return CodedOutputStream.computeBoolSizeNoTag((Boolean)value);
            }
            case STRING: {
                return CodedOutputStream.computeStringSizeNoTag((String)value);
            }
            case GROUP: {
                return CodedOutputStream.computeGroupSizeNoTag((MessageLite)value);
            }
            case BYTES: {
                if (value instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)value);
                }
                return CodedOutputStream.computeByteArraySizeNoTag((byte[])value);
            }
            case UINT32: {
                return CodedOutputStream.computeUInt32SizeNoTag((Integer)value);
            }
            case SFIXED32: {
                return CodedOutputStream.computeSFixed32SizeNoTag((Integer)value);
            }
            case SFIXED64: {
                return CodedOutputStream.computeSFixed64SizeNoTag((Long)value);
            }
            case SINT32: {
                return CodedOutputStream.computeSInt32SizeNoTag((Integer)value);
            }
            case SINT64: {
                return CodedOutputStream.computeSInt64SizeNoTag((Long)value);
            }
            case MESSAGE: {
                if (value instanceof LazyField) {
                    return CodedOutputStream.computeLazyFieldSizeNoTag((LazyField)value);
                }
                return CodedOutputStream.computeMessageSizeNoTag((MessageLite)value);
            }
            case ENUM: {
                void var1_1;
                if (value instanceof Internal.EnumLite) {
                    return CodedOutputStream.computeEnumSizeNoTag(((Internal.EnumLite)value).getNumber());
                }
                return CodedOutputStream.computeEnumSizeNoTag((Integer)var1_1);
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }

    /*
     * WARNING - void declaration
     */
    public static int computeFieldSize(FieldDescriptorLite<?> descriptor2, Object value) {
        void var1_3;
        void var3_5;
        void var2_4;
        WireFormat.FieldType type2 = descriptor2.getLiteType();
        int number = descriptor2.getNumber();
        if (descriptor2.isRepeated()) {
            void var0_2;
            Iterator i$;
            if (descriptor2.isPacked()) {
                int dataSize = 0;
                for (Object element : (List)value) {
                    dataSize += FieldSet.computeElementSizeNoTag(type2, element);
                }
                return dataSize + CodedOutputStream.computeTagSize(number) + CodedOutputStream.computeRawVarint32Size(dataSize);
            }
            int size = 0;
            for (Object element : (List)((Object)i$)) {
                size += FieldSet.computeElementSize(type2, number, element);
            }
            return (int)var0_2;
        }
        return FieldSet.computeElementSize((WireFormat.FieldType)var2_4, (int)var3_5, var1_3);
    }

    public static interface FieldDescriptorLite<T extends FieldDescriptorLite<T>>
    extends Comparable<T> {
        public int getNumber();

        public WireFormat.FieldType getLiteType();

        public WireFormat.JavaType getLiteJavaType();

        public boolean isRepeated();

        public boolean isPacked();

        public MessageLite.Builder internalMergeFrom(MessageLite.Builder var1, MessageLite var2);
    }
}

