/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.LazyFieldLite;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.protobuf.WireFormat;

public final class CodedOutputStream {
    private final byte[] buffer;
    private final int limit;
    private int position;
    private int totalBytesWritten = 0;
    private final OutputStream output;

    static int computePreferredBufferSize(int dataLength) {
        int n;
        if (dataLength > 4096) {
            return 4096;
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private CodedOutputStream(OutputStream output, byte[] buffer) {
        void var2_2;
        void var1_1;
        this.output = var1_1;
        this.buffer = buffer;
        this.position = 0;
        this.limit = ((void)var2_2).length;
    }

    /*
     * WARNING - void declaration
     */
    public static CodedOutputStream newInstance(OutputStream output, int bufferSize) {
        void var1_1;
        OutputStream outputStream;
        return new CodedOutputStream(outputStream, new byte[var1_1]);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeDouble(int fieldNumber, double value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeTag((int)var1_1, 1);
        this.writeDoubleNoTag((double)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeFloat(int fieldNumber, float value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeTag((int)var1_1, 5);
        this.writeFloatNoTag((float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeInt32(int fieldNumber, int value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeTag((int)var1_1, 0);
        this.writeInt32NoTag((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeBool(int fieldNumber, boolean value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeTag((int)var1_1, 0);
        this.writeBoolNoTag((boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeGroup(int fieldNumber, MessageLite value) throws IOException {
        void var1_1;
        void var2_2;
        this.writeTag(fieldNumber, 3);
        this.writeGroupNoTag((MessageLite)var2_2);
        this.writeTag((int)var1_1, 4);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeMessage(int fieldNumber, MessageLite value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeTag((int)var1_1, 2);
        this.writeMessageNoTag((MessageLite)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeBytes(int fieldNumber, ByteString value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeTag((int)var1_1, 2);
        this.writeBytesNoTag((ByteString)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeUInt32(int fieldNumber, int value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeTag((int)var1_1, 0);
        this.writeUInt32NoTag((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeEnum(int fieldNumber, int value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeTag((int)var1_1, 0);
        this.writeEnumNoTag((int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeSInt64(int fieldNumber, long value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeTag((int)var1_1, 0);
        this.writeSInt64NoTag((long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeMessageSetExtension(int fieldNumber, MessageLite value) throws IOException {
        void var2_2;
        void var1_1;
        this.writeTag(1, 3);
        this.writeUInt32(2, (int)var1_1);
        this.writeMessage(3, (MessageLite)var2_2);
        this.writeTag(1, 4);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeDoubleNoTag(double value) throws IOException {
        void var1_1;
        this.writeRawLittleEndian64(Double.doubleToRawLongBits((double)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void writeFloatNoTag(float value) throws IOException {
        void var1_1;
        this.writeRawLittleEndian32(Float.floatToRawIntBits((float)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void writeUInt64NoTag(long value) throws IOException {
        void var1_1;
        this.writeRawVarint64((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeInt64NoTag(long value) throws IOException {
        void var1_1;
        this.writeRawVarint64((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeInt32NoTag(int value) throws IOException {
        void var1_1;
        if (value >= 0) {
            this.writeRawVarint32(value);
            return;
        }
        this.writeRawVarint64((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeFixed64NoTag(long value) throws IOException {
        void var1_1;
        this.writeRawLittleEndian64((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeFixed32NoTag(int value) throws IOException {
        void var1_1;
        this.writeRawLittleEndian32((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeBoolNoTag(boolean value) throws IOException {
        void var1_1;
        this.writeRawByte(var1_1 != false ? 1 : 0);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeStringNoTag(String value) throws IOException {
        void var1_1;
        byte[] bytes = value.getBytes("UTF-8");
        this.writeRawVarint32(bytes.length);
        this.writeRawBytes((byte[])var1_1);
    }

    public final void writeGroupNoTag(MessageLite value) throws IOException {
        value.writeTo(this);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeMessageNoTag(MessageLite value) throws IOException {
        void var1_1;
        this.writeRawVarint32(value.getSerializedSize());
        var1_1.writeTo(this);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeBytesNoTag(ByteString value) throws IOException {
        void var1_1;
        this.writeRawVarint32(value.size());
        this.writeRawBytes((ByteString)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeByteArrayNoTag(byte[] value) throws IOException {
        void var1_1;
        this.writeRawVarint32(value.length);
        this.writeRawBytes((byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeUInt32NoTag(int value) throws IOException {
        void var1_1;
        this.writeRawVarint32((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeEnumNoTag(int value) throws IOException {
        void var1_1;
        this.writeInt32NoTag((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeSFixed32NoTag(int value) throws IOException {
        void var1_1;
        this.writeRawLittleEndian32((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeSFixed64NoTag(long value) throws IOException {
        void var1_1;
        this.writeRawLittleEndian64((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeSInt32NoTag(int value) throws IOException {
        void var1_1;
        this.writeRawVarint32(CodedOutputStream.encodeZigZag32((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void writeSInt64NoTag(long value) throws IOException {
        void var1_1;
        this.writeRawVarint64(CodedOutputStream.encodeZigZag64((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static int computeDoubleSize(int fieldNumber, double value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeDoubleSizeNoTag((double)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeFloatSize(int fieldNumber, float value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeFloatSizeNoTag((float)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeInt32Size(int fieldNumber, int value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeInt32SizeNoTag((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeBoolSize(int fieldNumber, boolean value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeBoolSizeNoTag((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeMessageSize(int fieldNumber, MessageLite value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeMessageSizeNoTag((MessageLite)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeBytesSize(int fieldNumber, ByteString value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeBytesSizeNoTag((ByteString)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeEnumSize(int fieldNumber, int value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeEnumSizeNoTag((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static int computeSInt64Size(int fieldNumber, long value) {
        void var1_1;
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeSInt64SizeNoTag((long)var1_1);
    }

    public static int computeDoubleSizeNoTag(double value) {
        return 8;
    }

    public static int computeFloatSizeNoTag(float value) {
        return 4;
    }

    public static int computeUInt64SizeNoTag(long value) {
        return CodedOutputStream.computeRawVarint64Size(value);
    }

    public static int computeInt64SizeNoTag(long value) {
        return CodedOutputStream.computeRawVarint64Size(value);
    }

    public static int computeInt32SizeNoTag(int value) {
        if (value >= 0) {
            int n;
            return CodedOutputStream.computeRawVarint32Size(n);
        }
        return 10;
    }

    public static int computeFixed64SizeNoTag(long value) {
        return 8;
    }

    public static int computeFixed32SizeNoTag(int value) {
        return 4;
    }

    public static int computeBoolSizeNoTag(boolean value) {
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public static int computeStringSizeNoTag(String value) {
        try {
            byte[] byArray = value.getBytes("UTF-8");
            Object bytes = byArray;
            return CodedOutputStream.computeRawVarint32Size(byArray.length) + ((Object)bytes).length;
        }
        catch (UnsupportedEncodingException e) {
            void var0_1;
            throw new RuntimeException("UTF-8 not supported.", (Throwable)var0_1);
        }
    }

    public static int computeGroupSizeNoTag(MessageLite value) {
        return value.getSerializedSize();
    }

    /*
     * WARNING - void declaration
     */
    public static int computeMessageSizeNoTag(MessageLite value) {
        void var0_1;
        int size = value.getSerializedSize();
        return CodedOutputStream.computeRawVarint32Size(size) + var0_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int computeLazyFieldSizeNoTag(LazyFieldLite value) {
        void var0_1;
        int size = value.getSerializedSize();
        return CodedOutputStream.computeRawVarint32Size(size) + var0_1;
    }

    public static int computeBytesSizeNoTag(ByteString value) {
        ByteString byteString;
        return CodedOutputStream.computeRawVarint32Size(value.size()) + byteString.size();
    }

    public static int computeByteArraySizeNoTag(byte[] value) {
        byte[] byArray;
        return CodedOutputStream.computeRawVarint32Size(value.length) + byArray.length;
    }

    public static int computeUInt32SizeNoTag(int value) {
        return CodedOutputStream.computeRawVarint32Size(value);
    }

    public static int computeEnumSizeNoTag(int value) {
        return CodedOutputStream.computeInt32SizeNoTag(value);
    }

    public static int computeSFixed32SizeNoTag(int value) {
        return 4;
    }

    public static int computeSFixed64SizeNoTag(long value) {
        return 8;
    }

    public static int computeSInt32SizeNoTag(int value) {
        return CodedOutputStream.computeRawVarint32Size(CodedOutputStream.encodeZigZag32(value));
    }

    public static int computeSInt64SizeNoTag(long value) {
        return CodedOutputStream.computeRawVarint64Size(CodedOutputStream.encodeZigZag64(value));
    }

    private void refreshBuffer() throws IOException {
        if (this.output == null) {
            throw new OutOfSpaceException();
        }
        this.output.write(this.buffer, 0, this.position);
        this.position = 0;
    }

    public final void flush() throws IOException {
        if (this.output != null) {
            this.refreshBuffer();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void writeRawByte(byte value) throws IOException {
        void var1_1;
        if (this.position == this.limit) {
            this.refreshBuffer();
        }
        this.buffer[this.position++] = var1_1;
        ++this.totalBytesWritten;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeRawByte(int value) throws IOException {
        void var1_1;
        this.writeRawByte((byte)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeRawBytes(ByteString value) throws IOException {
        void var1_1;
        this.writeRawBytes(value, 0, var1_1.size());
    }

    /*
     * WARNING - void declaration
     */
    public final void writeRawBytes(byte[] value) throws IOException {
        void var1_1;
        this.writeRawBytes(value, 0, ((void)var1_1).length);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeRawBytes(byte[] value, int offset, int length) throws IOException {
        void var3_3;
        if (this.limit - this.position >= length) {
            System.arraycopy(value, offset, this.buffer, this.position, length);
            this.position += length;
        } else {
            int bytesWritten = this.limit - this.position;
            System.arraycopy(value, offset, this.buffer, this.position, bytesWritten);
            offset += bytesWritten;
            this.position = this.limit;
            this.totalBytesWritten += bytesWritten;
            this.refreshBuffer();
            if ((length -= bytesWritten) <= this.limit) {
                System.arraycopy(value, offset, this.buffer, 0, length);
                this.position = length;
            } else {
                void var2_2;
                void var1_1;
                this.output.write((byte[])var1_1, (int)var2_2, length);
            }
        }
        this.totalBytesWritten += var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeRawBytes(ByteString value, int offset, int length) throws IOException {
        void var3_3;
        if (this.limit - this.position >= length) {
            value.copyTo(this.buffer, offset, this.position, length);
            this.position += length;
        } else {
            int bytesWritten = this.limit - this.position;
            value.copyTo(this.buffer, offset, this.position, bytesWritten);
            offset += bytesWritten;
            this.position = this.limit;
            this.totalBytesWritten += bytesWritten;
            this.refreshBuffer();
            if ((length -= bytesWritten) <= this.limit) {
                value.copyTo(this.buffer, offset, 0, length);
                this.position = length;
            } else {
                void var2_2;
                void var1_1;
                var1_1.writeTo(this.output, (int)var2_2, length);
            }
        }
        this.totalBytesWritten += var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeTag(int fieldNumber, int wireType) throws IOException {
        void var2_2;
        void var1_1;
        this.writeRawVarint32(WireFormat.makeTag((int)var1_1, (int)var2_2));
    }

    public static int computeTagSize(int fieldNumber) {
        return CodedOutputStream.computeRawVarint32Size(WireFormat.makeTag(fieldNumber, 0));
    }

    public final void writeRawVarint32(int value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFF80) == 0) {
                this.writeRawByte(value);
                return;
            }
            this.writeRawByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static int computeRawVarint32Size(int value) {
        int n;
        if ((value & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((value & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((value & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    public final void writeRawVarint64(long value) throws IOException {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.writeRawByte((int)value);
                return;
            }
            this.writeRawByte((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
    }

    public static int computeRawVarint64Size(long value) {
        long l;
        if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
            return 1;
        }
        if ((value & 0xFFFFFFFFFFFFC000L) == 0L) {
            return 2;
        }
        if ((value & 0xFFFFFFFFFFE00000L) == 0L) {
            return 3;
        }
        if ((value & 0xFFFFFFFFF0000000L) == 0L) {
            return 4;
        }
        if ((value & 0xFFFFFFF800000000L) == 0L) {
            return 5;
        }
        if ((value & 0xFFFFFC0000000000L) == 0L) {
            return 6;
        }
        if ((value & 0xFFFE000000000000L) == 0L) {
            return 7;
        }
        if ((value & 0xFF00000000000000L) == 0L) {
            return 8;
        }
        if ((l & Long.MIN_VALUE) == 0L) {
            return 9;
        }
        return 10;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeRawLittleEndian32(int value) throws IOException {
        void var1_1;
        this.writeRawByte(value & 0xFF);
        this.writeRawByte(value >> 8 & 0xFF);
        this.writeRawByte(value >> 16 & 0xFF);
        this.writeRawByte((int)(var1_1 >>> 24));
    }

    /*
     * WARNING - void declaration
     */
    public final void writeRawLittleEndian64(long value) throws IOException {
        void var1_1;
        this.writeRawByte((int)value & 0xFF);
        this.writeRawByte((int)(value >> 8) & 0xFF);
        this.writeRawByte((int)(value >> 16) & 0xFF);
        this.writeRawByte((int)(value >> 24) & 0xFF);
        this.writeRawByte((int)(value >> 32) & 0xFF);
        this.writeRawByte((int)(value >> 40) & 0xFF);
        this.writeRawByte((int)(value >> 48) & 0xFF);
        this.writeRawByte((int)(var1_1 >> 56) & 0xFF);
    }

    public static int encodeZigZag32(int n) {
        int n2;
        return n << 1 ^ n2 >> 31;
    }

    public static long encodeZigZag64(long n) {
        long l;
        return n << 1 ^ l >> 63;
    }

    public static class OutOfSpaceException
    extends IOException {
        OutOfSpaceException() {
            super("CodedOutputStream was writing to a flat byte array and ran out of space.");
        }
    }
}

