/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.protobuf;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import kotlin.reflect.jvm.internal.impl.protobuf.BoundedByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.ByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.CodedOutputStream;
import kotlin.reflect.jvm.internal.impl.protobuf.ExtensionRegistryLite;
import kotlin.reflect.jvm.internal.impl.protobuf.Internal;
import kotlin.reflect.jvm.internal.impl.protobuf.InvalidProtocolBufferException;
import kotlin.reflect.jvm.internal.impl.protobuf.LiteralByteString;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.protobuf.Parser;
import kotlin.reflect.jvm.internal.impl.protobuf.Utf8;
import kotlin.reflect.jvm.internal.impl.protobuf.WireFormat;

public final class CodedInputStream {
    private final byte[] buffer;
    private final boolean bufferIsImmutable;
    private int bufferSize;
    private int bufferSizeAfterLimit;
    private int bufferPos;
    private final InputStream input;
    private int lastTag;
    private boolean enableAliasing = false;
    private int totalBytesRetired;
    private int currentLimit = Integer.MAX_VALUE;
    private int recursionDepth;
    private int recursionLimit = 64;
    private int sizeLimit = 0x4000000;
    private RefillCallback refillCallback = null;

    public static CodedInputStream newInstance(InputStream input) {
        InputStream inputStream;
        return new CodedInputStream(inputStream);
    }

    /*
     * WARNING - void declaration
     */
    static CodedInputStream newInstance(LiteralByteString byteString) {
        void var1_2;
        CodedInputStream result = new CodedInputStream(byteString);
        try {
            result.pushLimit(((ByteString)byteString).size());
        }
        catch (InvalidProtocolBufferException ex) {
            void var0_1;
            throw new IllegalArgumentException((Throwable)var0_1);
        }
        return var1_2;
    }

    public final int readTag() throws IOException {
        if (this.isAtEnd()) {
            this.lastTag = 0;
            return 0;
        }
        this.lastTag = this.readRawVarint32();
        if (WireFormat.getTagFieldNumber(this.lastTag) == 0) {
            throw InvalidProtocolBufferException.invalidTag();
        }
        return this.lastTag;
    }

    /*
     * WARNING - void declaration
     */
    public final void checkLastTagWas(int value) throws InvalidProtocolBufferException {
        void var1_1;
        if (this.lastTag != var1_1) {
            throw InvalidProtocolBufferException.invalidEndTag();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean skipField(int tag, CodedOutputStream output) throws IOException {
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                long value = this.readInt64();
                output.writeRawVarint32(tag);
                output.writeUInt64NoTag(value);
                return true;
            }
            case 1: {
                long value = this.readRawLittleEndian64();
                output.writeRawVarint32(tag);
                output.writeFixed64NoTag(value);
                return true;
            }
            case 2: {
                ByteString value = this.readBytes();
                output.writeRawVarint32(tag);
                output.writeBytesNoTag(value);
                return true;
            }
            case 3: {
                output.writeRawVarint32(tag);
                this.skipMessage(output);
                int endtag = WireFormat.makeTag(WireFormat.getTagFieldNumber(tag), 4);
                this.checkLastTagWas(endtag);
                output.writeRawVarint32(endtag);
                return true;
            }
            case 4: {
                return false;
            }
            case 5: {
                void var3_7;
                void var2_2;
                void var1_1;
                int value = this.readRawLittleEndian32();
                output.writeRawVarint32((int)var1_1);
                var2_2.writeFixed32NoTag((int)var3_7);
                return true;
            }
        }
        throw InvalidProtocolBufferException.invalidWireType();
    }

    /*
     * WARNING - void declaration
     */
    public final void skipMessage(CodedOutputStream output) throws IOException {
        void var2_2;
        int tag;
        while ((tag = this.readTag()) != 0 && this.skipField((int)var2_2, output)) {
        }
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readRawLittleEndian64());
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readRawLittleEndian32());
    }

    public final long readUInt64() throws IOException {
        return this.readRawVarint64();
    }

    public final long readInt64() throws IOException {
        return this.readRawVarint64();
    }

    public final int readInt32() throws IOException {
        return this.readRawVarint32();
    }

    public final long readFixed64() throws IOException {
        return this.readRawLittleEndian64();
    }

    public final int readFixed32() throws IOException {
        return this.readRawLittleEndian32();
    }

    public final boolean readBool() throws IOException {
        return this.readRawVarint64() != 0L;
    }

    /*
     * WARNING - void declaration
     */
    public final String readString() throws IOException {
        void var1_1;
        int size = this.readRawVarint32();
        if (size <= this.bufferSize - this.bufferPos && size > 0) {
            void var2_2;
            String result = new String(this.buffer, this.bufferPos, size, "UTF-8");
            this.bufferPos += size;
            return var2_2;
        }
        if (size == 0) {
            return "";
        }
        return new String(this.readRawBytesSlowPath((int)var1_1), "UTF-8");
    }

    /*
     * WARNING - void declaration
     */
    public final String readStringRequireUtf8() throws IOException {
        void var1_1;
        void var3_2;
        void var2_3;
        byte[] bytes;
        int pos;
        int size = this.readRawVarint32();
        if (size <= this.bufferSize - (pos = this.bufferPos) && size > 0) {
            bytes = this.buffer;
            this.bufferPos = pos + size;
        } else {
            if (size == 0) {
                return "";
            }
            bytes = this.readRawBytesSlowPath(size);
            pos = 0;
        }
        int n = pos;
        if (!Utf8.isValidUtf8(bytes, n, n + size)) {
            throw InvalidProtocolBufferException.invalidUtf8();
        }
        return new String((byte[])var2_3, (int)var3_2, (int)var1_1, "UTF-8");
    }

    /*
     * WARNING - void declaration
     */
    public final void readGroup(int fieldNumber, MessageLite.Builder builder, ExtensionRegistryLite extensionRegistry) throws IOException {
        void var1_1;
        void var3_3;
        void var2_2;
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        ++this.recursionDepth;
        var2_2.mergeFrom(this, (ExtensionRegistryLite)var3_3);
        this.checkLastTagWas(WireFormat.makeTag((int)var1_1, 4));
        --this.recursionDepth;
    }

    /*
     * WARNING - void declaration
     */
    public final void readMessage(MessageLite.Builder builder, ExtensionRegistryLite extensionRegistry) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        int length = this.readRawVarint32();
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        int oldLimit = this.pushLimit(length);
        ++this.recursionDepth;
        var1_1.mergeFrom(this, (ExtensionRegistryLite)var2_2);
        this.checkLastTagWas(0);
        --this.recursionDepth;
        this.popLimit((int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public final <T extends MessageLite> T readMessage(Parser<T> parser, ExtensionRegistryLite extensionRegistry) throws IOException {
        void var1_1;
        void var3_3;
        void var2_2;
        int length = this.readRawVarint32();
        if (this.recursionDepth >= this.recursionLimit) {
            throw InvalidProtocolBufferException.recursionLimitExceeded();
        }
        int oldLimit = this.pushLimit(length);
        ++this.recursionDepth;
        MessageLite result = (MessageLite)parser.parsePartialFrom(this, (ExtensionRegistryLite)var2_2);
        this.checkLastTagWas(0);
        --this.recursionDepth;
        this.popLimit((int)var3_3);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final ByteString readBytes() throws IOException {
        void var1_1;
        int size = this.readRawVarint32();
        if (size <= this.bufferSize - this.bufferPos && size > 0) {
            void var2_2;
            ByteString result = this.bufferIsImmutable && this.enableAliasing ? new BoundedByteString(this.buffer, this.bufferPos, size) : ByteString.copyFrom(this.buffer, this.bufferPos, size);
            this.bufferPos += size;
            return var2_2;
        }
        if (size == 0) {
            return ByteString.EMPTY;
        }
        return new LiteralByteString(this.readRawBytesSlowPath((int)var1_1));
    }

    public final int readUInt32() throws IOException {
        return this.readRawVarint32();
    }

    public final int readEnum() throws IOException {
        return this.readRawVarint32();
    }

    public final int readSFixed32() throws IOException {
        return this.readRawLittleEndian32();
    }

    public final long readSFixed64() throws IOException {
        return this.readRawLittleEndian64();
    }

    public final int readSInt32() throws IOException {
        return CodedInputStream.decodeZigZag32(this.readRawVarint32());
    }

    public final long readSInt64() throws IOException {
        return CodedInputStream.decodeZigZag64(this.readRawVarint64());
    }

    /*
     * WARNING - void declaration
     */
    public final int readRawVarint32() throws IOException {
        block4: {
            void var3_3;
            void var1_1;
            block6: {
                void var2_2;
                int x;
                byte[] buffer;
                int pos;
                block8: {
                    block7: {
                        block5: {
                            pos = this.bufferPos;
                            if (this.bufferSize == pos) break block4;
                            buffer = this.buffer;
                            if ((x = this.buffer[pos++]) >= 0) {
                                this.bufferPos = pos;
                                return x;
                            }
                            if (this.bufferSize - pos < 9) break block4;
                            if ((long)(x ^= buffer[pos++] << 7) >= 0L) break block5;
                            x = (int)((long)x ^ 0xFFFFFFFFFFFFFF80L);
                            break block6;
                        }
                        if ((long)(x ^= buffer[pos++] << 14) < 0L) break block7;
                        x = (int)((long)x ^ 0x3F80L);
                        break block6;
                    }
                    if ((long)(x ^= buffer[pos++] << 21) >= 0L) break block8;
                    x = (int)((long)x ^ 0xFFFFFFFFFFE03F80L);
                    break block6;
                }
                byte y = buffer[pos++];
                x ^= y << 28;
                x = (int)((long)x ^ 0xFE03F80L);
                if (y < 0 && buffer[pos++] < 0 && buffer[pos++] < 0 && buffer[pos++] < 0 && buffer[pos++] < 0 && var2_2[pos++] < 0) break block4;
            }
            this.bufferPos = var1_1;
            return (int)var3_3;
        }
        return (int)this.readRawVarint64SlowPath();
    }

    /*
     * WARNING - void declaration
     */
    public static int readRawVarint32(int firstByte, InputStream input) throws IOException {
        int b;
        int offset;
        if ((firstByte & 0x80) == 0) {
            return firstByte;
        }
        int result = firstByte & 0x7F;
        for (offset = 7; offset < 32; offset += 7) {
            b = input.read();
            if (b == -1) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            result |= (b & 0x7F) << offset;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        while (offset < 64) {
            void var3_3;
            b = input.read();
            if (b == -1) {
                throw InvalidProtocolBufferException.truncatedMessage();
            }
            if ((var3_3 & 0x80) == 0) {
                return result;
            }
            offset += 7;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    /*
     * WARNING - void declaration
     */
    public final long readRawVarint64() throws IOException {
        block4: {
            void var3_4;
            void var1_1;
            block6: {
                void var2_2;
                byte[] buffer;
                int pos;
                block12: {
                    block11: {
                        block10: {
                            block9: {
                                block8: {
                                    block7: {
                                        block5: {
                                            long x;
                                            byte y;
                                            pos = this.bufferPos;
                                            if (this.bufferSize == pos) break block4;
                                            buffer = this.buffer;
                                            if ((y = this.buffer[pos++]) >= 0) {
                                                this.bufferPos = pos;
                                                return y;
                                            }
                                            if (this.bufferSize - pos < 9) break block4;
                                            if ((x = (long)(y ^ buffer[pos++] << 7)) >= 0L) break block5;
                                            x ^= 0xFFFFFFFFFFFFFF80L;
                                            break block6;
                                        }
                                        if ((x ^= (long)(buffer[pos++] << 14)) < 0L) break block7;
                                        x ^= 0x3F80L;
                                        break block6;
                                    }
                                    if ((x ^= (long)(buffer[pos++] << 21)) >= 0L) break block8;
                                    x ^= 0xFFFFFFFFFFE03F80L;
                                    break block6;
                                }
                                if ((x ^= (long)buffer[pos++] << 28) < 0L) break block9;
                                x ^= 0xFE03F80L;
                                break block6;
                            }
                            if ((x ^= (long)buffer[pos++] << 35) >= 0L) break block10;
                            x ^= 0xFFFFFFF80FE03F80L;
                            break block6;
                        }
                        if ((x ^= (long)buffer[pos++] << 42) < 0L) break block11;
                        x ^= 0x3F80FE03F80L;
                        break block6;
                    }
                    if ((x ^= (long)buffer[pos++] << 49) >= 0L) break block12;
                    x ^= 0xFFFE03F80FE03F80L;
                    break block6;
                }
                x ^= (long)buffer[pos++] << 56;
                if ((x ^= 0xFE03F80FE03F80L) < 0L && (long)var2_2[pos++] < 0L) break block4;
            }
            this.bufferPos = var1_1;
            return (long)var3_4;
        }
        return this.readRawVarint64SlowPath();
    }

    final long readRawVarint64SlowPath() throws IOException {
        long result = 0L;
        for (int shift = 0; shift < 64; shift += 7) {
            byte b = this.readRawByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw InvalidProtocolBufferException.malformedVarint();
    }

    /*
     * WARNING - void declaration
     */
    public final int readRawLittleEndian32() throws IOException {
        void var1_1;
        void var2_2;
        int pos = this.bufferPos;
        if (this.bufferSize - pos < 4) {
            this.refillBuffer(4);
            pos = this.bufferPos;
        }
        byte[] buffer = this.buffer;
        this.bufferPos = pos + 4;
        return buffer[pos] & 0xFF | (buffer[pos + 1] & 0xFF) << 8 | (buffer[pos + 2] & 0xFF) << 16 | (var2_2[var1_1 + 3] & 0xFF) << 24;
    }

    /*
     * WARNING - void declaration
     */
    public final long readRawLittleEndian64() throws IOException {
        void var1_1;
        void var2_2;
        int pos = this.bufferPos;
        if (this.bufferSize - pos < 8) {
            this.refillBuffer(8);
            pos = this.bufferPos;
        }
        byte[] buffer = this.buffer;
        this.bufferPos = pos + 8;
        return (long)buffer[pos] & 0xFFL | ((long)buffer[pos + 1] & 0xFFL) << 8 | ((long)buffer[pos + 2] & 0xFFL) << 16 | ((long)buffer[pos + 3] & 0xFFL) << 24 | ((long)buffer[pos + 4] & 0xFFL) << 32 | ((long)buffer[pos + 5] & 0xFFL) << 40 | ((long)buffer[pos + 6] & 0xFFL) << 48 | ((long)var2_2[var1_1 + 7] & 0xFFL) << 56;
    }

    public static int decodeZigZag32(int n) {
        int n2;
        return n >>> 1 ^ -(n2 & 1);
    }

    public static long decodeZigZag64(long n) {
        long l;
        return n >>> 1 ^ -(l & 1L);
    }

    /*
     * WARNING - void declaration
     */
    private CodedInputStream(InputStream input) {
        void var1_1;
        this.buffer = new byte[4096];
        this.bufferSize = 0;
        this.bufferPos = 0;
        this.totalBytesRetired = 0;
        this.input = var1_1;
        this.bufferIsImmutable = false;
    }

    /*
     * WARNING - void declaration
     */
    private CodedInputStream(LiteralByteString byteString) {
        void var1_1;
        this.buffer = byteString.bytes;
        this.bufferPos = byteString.getOffsetIntoBytes();
        this.bufferSize = this.bufferPos + var1_1.size();
        this.totalBytesRetired = -this.bufferPos;
        this.input = null;
        this.bufferIsImmutable = true;
    }

    /*
     * WARNING - void declaration
     */
    public final int pushLimit(int byteLimit) throws InvalidProtocolBufferException {
        void var2_2;
        void var1_1;
        if (byteLimit < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        int oldLimit = this.currentLimit;
        if ((byteLimit += this.totalBytesRetired + this.bufferPos) > oldLimit) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        this.currentLimit = var1_1;
        this.recomputeBufferSizeAfterLimit();
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void recomputeBufferSizeAfterLimit() {
        this.bufferSize += this.bufferSizeAfterLimit;
        int bufferEnd = this.totalBytesRetired + this.bufferSize;
        if (bufferEnd > this.currentLimit) {
            void var1_1;
            this.bufferSizeAfterLimit = var1_1 - this.currentLimit;
            this.bufferSize -= this.bufferSizeAfterLimit;
            return;
        }
        this.bufferSizeAfterLimit = 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void popLimit(int oldLimit) {
        void var1_1;
        this.currentLimit = var1_1;
        this.recomputeBufferSizeAfterLimit();
    }

    /*
     * WARNING - void declaration
     */
    public final int getBytesUntilLimit() {
        void var1_1;
        if (this.currentLimit == Integer.MAX_VALUE) {
            return -1;
        }
        int currentAbsolutePosition = this.totalBytesRetired + this.bufferPos;
        return this.currentLimit - var1_1;
    }

    public final boolean isAtEnd() throws IOException {
        return this.bufferPos == this.bufferSize && !this.tryRefillBuffer(1);
    }

    /*
     * WARNING - void declaration
     */
    private void ensureAvailable(int n) throws IOException {
        if (this.bufferSize - this.bufferPos < n) {
            void var1_1;
            this.refillBuffer((int)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void refillBuffer(int n) throws IOException {
        void var1_1;
        if (!this.tryRefillBuffer((int)var1_1)) {
            throw InvalidProtocolBufferException.truncatedMessage();
        }
    }

    private boolean tryRefillBuffer(int n) throws IOException {
        while (true) {
            int bytesRead;
            int n2;
            if (this.bufferPos + n <= this.bufferSize) {
                n2 = n;
                throw new IllegalStateException(new StringBuilder(77).append("refillBuffer() called when ").append(n2).append(" bytes were already available in buffer").toString());
            }
            if (this.totalBytesRetired + this.bufferPos + n > this.currentLimit) {
                return false;
            }
            if (this.refillCallback != null) {
                this.refillCallback.onRefill();
            }
            if (this.input == null) break;
            int pos = this.bufferPos;
            if (pos > 0) {
                if (this.bufferSize > pos) {
                    System.arraycopy(this.buffer, pos, this.buffer, 0, this.bufferSize - pos);
                }
                this.totalBytesRetired += pos;
                this.bufferSize -= pos;
                this.bufferPos = 0;
            }
            if ((bytesRead = this.input.read(this.buffer, this.bufferSize, this.buffer.length - this.bufferSize)) == 0 || bytesRead < -1 || bytesRead > this.buffer.length) {
                n = bytesRead;
                throw new IllegalStateException(new StringBuilder(102).append("InputStream#read(byte[]) returned invalid result: ").append(n).append("\nThe InputStream implementation is buggy.").toString());
            }
            if (bytesRead <= 0) break;
            this.bufferSize += n2;
            if (this.totalBytesRetired + n - this.sizeLimit > 0) {
                throw InvalidProtocolBufferException.sizeLimitExceeded();
            }
            this.recomputeBufferSizeAfterLimit();
            if (this.bufferSize < n) continue;
            return true;
        }
        return false;
    }

    public final byte readRawByte() throws IOException {
        if (this.bufferPos == this.bufferSize) {
            this.refillBuffer(1);
        }
        return this.buffer[this.bufferPos++];
    }

    /*
     * WARNING - void declaration
     */
    private byte[] readRawBytesSlowPath(int size) throws IOException {
        void var2_4;
        void var3_6;
        int pos;
        byte[] chunk;
        if (size <= 0) {
            if (size == 0) {
                return Internal.EMPTY_BYTE_ARRAY;
            }
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (this.totalBytesRetired + this.bufferPos + size > this.currentLimit) {
            CodedInputStream codedInputStream = this;
            codedInputStream.skipRawBytes(codedInputStream.currentLimit - this.totalBytesRetired - this.bufferPos);
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        if (size < 4096) {
            byte[] bytes = new byte[size];
            int pos2 = this.bufferSize - this.bufferPos;
            System.arraycopy(this.buffer, this.bufferPos, bytes, 0, pos2);
            this.bufferPos = this.bufferSize;
            this.ensureAvailable(size - pos2);
            System.arraycopy(this.buffer, 0, bytes, pos2, size - pos2);
            this.bufferPos = size - pos2;
            return bytes;
        }
        int originalBufferPos = this.bufferPos;
        int originalBufferSize = this.bufferSize;
        this.totalBytesRetired += this.bufferSize;
        this.bufferPos = 0;
        this.bufferSize = 0;
        ArrayList<byte[]> chunks = new ArrayList<byte[]>();
        for (int sizeLeft = size - (originalBufferSize - originalBufferPos); sizeLeft > 0; sizeLeft -= chunk.length) {
            int n;
            chunk = new byte[Math.min(sizeLeft, 4096)];
            for (pos = 0; pos < chunk.length; pos += n) {
                n = this.input == null ? -1 : this.input.read(chunk, pos, chunk.length - pos);
                if (n == -1) {
                    throw InvalidProtocolBufferException.truncatedMessage();
                }
                this.totalBytesRetired += n;
            }
            chunks.add(chunk);
        }
        byte[] bytes = new byte[size];
        pos = var3_6 - originalBufferPos;
        System.arraycopy(this.buffer, (int)var2_4, bytes, 0, pos);
        for (byte[] chunk2 : chunks) {
            void var1_2;
            System.arraycopy(chunk2, 0, bytes, pos, chunk2.length);
            pos += ((void)var1_2).length;
        }
        return bytes;
    }

    /*
     * WARNING - void declaration
     */
    public final void skipRawBytes(int size) throws IOException {
        void var1_1;
        if (size <= this.bufferSize - this.bufferPos && size >= 0) {
            this.bufferPos += size;
            return;
        }
        this.skipRawBytesSlowPath((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void skipRawBytesSlowPath(int size) throws IOException {
        void var2_2;
        void var1_1;
        if (size < 0) {
            throw InvalidProtocolBufferException.negativeSize();
        }
        if (this.totalBytesRetired + this.bufferPos + size > this.currentLimit) {
            CodedInputStream codedInputStream = this;
            codedInputStream.skipRawBytes(codedInputStream.currentLimit - this.totalBytesRetired - this.bufferPos);
            throw InvalidProtocolBufferException.truncatedMessage();
        }
        int pos = this.bufferSize - this.bufferPos;
        this.bufferPos = this.bufferSize;
        this.refillBuffer(1);
        while (size - pos > this.bufferSize) {
            pos += this.bufferSize;
            this.bufferPos = this.bufferSize;
            this.refillBuffer(1);
        }
        this.bufferPos = var1_1 - var2_2;
    }

    private static interface RefillCallback {
        public void onRefill();
    }
}

