/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;

public final class ClassId {
    private final FqName packageFqName;
    private final FqName relativeClassName;
    private final boolean local;

    public static ClassId topLevel(FqName topLevelFqName) {
        FqName fqName2;
        if (topLevelFqName == null) {
            ClassId.$$$reportNull$$$0(0);
        }
        return new ClassId(topLevelFqName.parent(), fqName2.shortName());
    }

    /*
     * WARNING - void declaration
     */
    public ClassId(FqName packageFqName, FqName relativeClassName, boolean local) {
        void var3_3;
        void var2_2;
        if (packageFqName == null) {
            ClassId.$$$reportNull$$$0(1);
        }
        if (relativeClassName == null) {
            ClassId.$$$reportNull$$$0(2);
        }
        this.packageFqName = packageFqName;
        if (!$assertionsDisabled && relativeClassName.isRoot()) {
            void var1_1;
            throw new AssertionError((Object)("Class name must not be root: " + var1_1 + (local ? " (local)" : "")));
        }
        this.relativeClassName = var2_2;
        this.local = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public ClassId(FqName packageFqName, Name topLevelName) {
        void var2_2;
        void var1_1;
        if (packageFqName == null) {
            ClassId.$$$reportNull$$$0(3);
        }
        if (topLevelName == null) {
            ClassId.$$$reportNull$$$0(4);
        }
        this((FqName)var1_1, FqName.topLevel((Name)var2_2), false);
    }

    public final FqName getPackageFqName() {
        FqName fqName2 = this.packageFqName;
        if (fqName2 == null) {
            ClassId.$$$reportNull$$$0(5);
        }
        return fqName2;
    }

    public final FqName getRelativeClassName() {
        FqName fqName2 = this.relativeClassName;
        if (fqName2 == null) {
            ClassId.$$$reportNull$$$0(6);
        }
        return fqName2;
    }

    public final Name getShortClassName() {
        Name name = this.relativeClassName.shortName();
        if (name == null) {
            ClassId.$$$reportNull$$$0(7);
        }
        return name;
    }

    public final boolean isLocal() {
        return this.local;
    }

    /*
     * WARNING - void declaration
     */
    public final ClassId createNestedClassId(Name name) {
        void var1_1;
        if (name == null) {
            ClassId.$$$reportNull$$$0(8);
        }
        return new ClassId(this.getPackageFqName(), this.relativeClassName.child((Name)var1_1), this.local);
    }

    /*
     * WARNING - void declaration
     */
    public final ClassId getOuterClassId() {
        void var1_1;
        FqName parent = this.relativeClassName.parent();
        if (parent.isRoot()) {
            return null;
        }
        return new ClassId(this.getPackageFqName(), (FqName)var1_1, this.local);
    }

    public final boolean isNestedClass() {
        return !this.relativeClassName.parent().isRoot();
    }

    public final FqName asSingleFqName() {
        if (this.packageFqName.isRoot()) {
            FqName fqName2 = this.relativeClassName;
            if (fqName2 == null) {
                ClassId.$$$reportNull$$$0(9);
            }
            return fqName2;
        }
        return new FqName(this.packageFqName.asString() + "." + this.relativeClassName.asString());
    }

    public static ClassId fromString(String string) {
        String string2;
        if (string == null) {
            ClassId.$$$reportNull$$$0(11);
        }
        return ClassId.fromString(string2, false);
    }

    /*
     * WARNING - void declaration
     */
    public static ClassId fromString(String string, boolean isLocal) {
        void var1_1;
        String string2;
        void var3_3;
        String packageName;
        int lastSlashIndex;
        if (string == null) {
            ClassId.$$$reportNull$$$0(12);
        }
        if ((lastSlashIndex = string.lastIndexOf("/")) == -1) {
            packageName = "";
        } else {
            void var2_2;
            String className;
            packageName = className.substring(0, lastSlashIndex).replace('/', '.');
            className = className.substring((int)(var2_2 + true));
        }
        return new ClassId(new FqName((String)var3_3), new FqName(string2), (boolean)var1_1);
    }

    public final String asString() {
        if (this.packageFqName.isRoot()) {
            String string = this.relativeClassName.asString();
            if (string == null) {
                ClassId.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = this.packageFqName.asString().replace('.', '/') + "/" + this.relativeClassName.asString();
        if (string == null) {
            ClassId.$$$reportNull$$$0(14);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassId id = (ClassId)o;
        return this.packageFqName.equals(id.packageFqName) && this.relativeClassName.equals(id.relativeClassName) && this.local == var1_1.local;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int result = this.packageFqName.hashCode();
        result = result * 31 + this.relativeClassName.hashCode();
        var1_1 = var1_1 * 31 + Boolean.valueOf(this.local).hashCode();
        return (int)var1_1;
    }

    public final String toString() {
        if (this.packageFqName.isRoot()) {
            return "/" + this.asString();
        }
        return this.asString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelFqName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageFqName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeClassName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelName";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlin/reflect/jvm/internal/impl/name/ClassId";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "segment";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "kotlin/reflect/jvm/internal/impl/name/ClassId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageFqName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativeClassName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortClassName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "asSingleFqName";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "asFqNameString";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "topLevel";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createNestedClassId";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fromString";
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
            }
        }
        throw runtimeException;
    }
}

