/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.SuspendFunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmDescriptorTypeWriter;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactory;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfiguration;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfigurationImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingMode;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeSignatureMappingKt;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.ExpandedTypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeSystemCommonBackendContext;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.SimpleClassicTypeSystemContext;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.utils.FunctionsKt;
import kotlin.text.StringsKt;

@SourceDebugExtension(value={"SMAP\ndescriptorBasedTypeSignatureMapping.kt\nKotlin\n*S Kotlin\n*F\n+ 1 descriptorBasedTypeSignatureMapping.kt\norg/jetbrains/kotlin/load/kotlin/DescriptorBasedTypeSignatureMappingKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,198:1\n1#2:199\n*E\n"})
public final class DescriptorBasedTypeSignatureMappingKt {
    public static final <T> T mapType(KotlinType kotlinType, JvmTypeFactory<T> factory, TypeMappingMode mode, TypeMappingConfiguration<? extends T> typeMappingConfiguration, JvmDescriptorTypeWriter<T> descriptorTypeWriter, Function3<? super KotlinType, ? super T, ? super TypeMappingMode, Unit> writeGenericType) {
        JvmDescriptorTypeWriter<KotlinType> jvmDescriptorTypeWriter;
        while (true) {
            JvmDescriptorTypeWriter<KotlinType> $this$mapType_u24lambda_u243;
            ClassifierDescriptor descriptor2;
            KotlinType jvmType;
            Object object;
            Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
            Intrinsics.checkNotNullParameter(factory, (String)"factory");
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            Intrinsics.checkNotNullParameter(typeMappingConfiguration, (String)"typeMappingConfiguration");
            Intrinsics.checkNotNullParameter(writeGenericType, (String)"writeGenericType");
            KotlinType kotlinType2 = typeMappingConfiguration.preprocessType(kotlinType);
            if (kotlinType2 != null) {
                object = kotlinType2;
                kotlinType = object;
                continue;
            }
            if (FunctionTypesKt.isSuspendFunctionType(kotlinType)) {
                kotlinType = SuspendFunctionTypesKt.transformSuspendFunctionToRuntimeFunctionType(kotlinType);
                continue;
            }
            object = SimpleClassicTypeSystemContext.INSTANCE;
            kotlinType2 = TypeSignatureMappingKt.mapBuiltInType((TypeSystemCommonBackendContext)object, kotlinType, factory, mode);
            if (kotlinType2 != null) {
                KotlinType builtInType = kotlinType2;
                jvmType = TypeSignatureMappingKt.boxTypeIfNeeded(factory, builtInType, mode.getNeedPrimitiveBoxing());
                writeGenericType.invoke((Object)kotlinType, (Object)jvmType, (Object)mode);
                return (T)jvmType;
            }
            Object constructor = kotlinType.getConstructor();
            if (constructor instanceof IntersectionTypeConstructor) {
                KotlinType kotlinType3 = ((IntersectionTypeConstructor)constructor).getAlternativeType();
                if (kotlinType3 == null) {
                    kotlinType3 = typeMappingConfiguration.commonSupertype(((IntersectionTypeConstructor)constructor).getSupertypes());
                }
                constructor = kotlinType3;
                kotlinType = TypeUtilsKt.replaceArgumentsWithStarProjections(kotlinType3);
                continue;
            }
            if (constructor.getDeclarationDescriptor() == null) {
                throw new UnsupportedOperationException("no descriptor for type constructor of " + kotlinType);
            }
            if (ErrorUtils.isError(descriptor2)) {
                jvmType = factory.createObjectType("error/NonExistentClass");
                typeMappingConfiguration.processErrorType(kotlinType, (ClassDescriptor)descriptor2);
                JvmDescriptorTypeWriter<KotlinType> jvmDescriptorTypeWriter2 = descriptorTypeWriter;
                if (jvmDescriptorTypeWriter2 != null) {
                    jvmDescriptorTypeWriter2.writeClass(jvmType);
                }
                return (T)jvmType;
            }
            if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isArray(kotlinType)) {
                T arrayElementType;
                if (kotlinType.getArguments().size() != 1) {
                    throw new UnsupportedOperationException("arrays must have one type argument");
                }
                TypeProjection memberProjection = kotlinType.getArguments().get(0);
                KotlinType kotlinType4 = memberProjection.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType4, (String)"getType(...)");
                JvmDescriptorTypeWriter<KotlinType> memberType = kotlinType4;
                if (memberProjection.getProjectionKind() == Variance.IN_VARIANCE) {
                    arrayElementType = factory.createObjectType("java/lang/Object");
                    JvmDescriptorTypeWriter<KotlinType> jvmDescriptorTypeWriter3 = descriptorTypeWriter;
                    if (jvmDescriptorTypeWriter3 != null) {
                        JvmDescriptorTypeWriter<KotlinType> jvmDescriptorTypeWriter4 = jvmDescriptorTypeWriter3;
                        $this$mapType_u24lambda_u243 = jvmDescriptorTypeWriter3;
                        jvmDescriptorTypeWriter3.writeArrayType();
                        $this$mapType_u24lambda_u243.writeClass((KotlinType)arrayElementType);
                        $this$mapType_u24lambda_u243.writeArrayEnd();
                    }
                } else {
                    JvmDescriptorTypeWriter<KotlinType> jvmDescriptorTypeWriter5 = descriptorTypeWriter;
                    if (jvmDescriptorTypeWriter5 != null) {
                        jvmDescriptorTypeWriter5.writeArrayType();
                    }
                    Variance variance = arrayElementType.getProjectionKind();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)variance), (String)"getProjectionKind(...)");
                    arrayElementType = DescriptorBasedTypeSignatureMappingKt.mapType($this$mapType_u24lambda_u243, factory, mode.toGenericArgumentMode(variance, true), typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
                    JvmDescriptorTypeWriter<KotlinType> jvmDescriptorTypeWriter6 = descriptorTypeWriter;
                    if (jvmDescriptorTypeWriter6 != null) {
                        jvmDescriptorTypeWriter6.writeArrayEnd();
                    }
                }
                return factory.createFromString("[" + factory.toString(arrayElementType));
            }
            if (descriptor2 instanceof ClassDescriptor) {
                T t;
                KotlinType expandedType;
                if (InlineClassesUtilsKt.isInlineClass(descriptor2) && !mode.getNeedInlineClassWrapping() && (expandedType = (KotlinType)ExpandedTypeUtilsKt.computeExpandedTypeForInlineClass(SimpleClassicTypeSystemContext.INSTANCE, (KotlinTypeMarker)((Object)$this$mapType_u24lambda_u243))) != null) {
                    mode = mode.wrapInlineClassesMode();
                    $this$mapType_u24lambda_u243 = expandedType;
                    continue;
                }
                if (mode.isForAnnotationParameter() && KotlinBuiltIns.isKClass((ClassDescriptor)descriptor2)) {
                    t = factory.getJavaLangClassType();
                } else {
                    ClassDescriptor classDescriptor = ((ClassDescriptor)descriptor2).getOriginal();
                    Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"getOriginal(...)");
                    t = typeMappingConfiguration.getPredefinedTypeForClass(classDescriptor);
                    if (t == null) {
                        ClassDescriptor classDescriptor2;
                        if (((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY) {
                            DeclarationDescriptor declarationDescriptor = ((ClassDescriptor)descriptor2).getContainingDeclaration();
                            Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                            classDescriptor2 = (ClassDescriptor)declarationDescriptor;
                        } else {
                            classDescriptor2 = (ClassDescriptor)descriptor2;
                        }
                        ClassDescriptor enumClassIfEnumEntry = classDescriptor2;
                        ClassDescriptor classDescriptor3 = enumClassIfEnumEntry.getOriginal();
                        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor3, (String)"getOriginal(...)");
                        t = factory.createObjectType(DescriptorBasedTypeSignatureMappingKt.computeInternalName(classDescriptor3, typeMappingConfiguration));
                    }
                }
                jvmType = t;
                writeGenericType.invoke((Object)$this$mapType_u24lambda_u243, (Object)jvmType, (Object)mode);
                return (T)jvmType;
            }
            if (descriptor2 instanceof TypeParameterDescriptor) {
                KotlinType upperBound = TypeUtilsKt.getRepresentativeUpperBound((TypeParameterDescriptor)descriptor2);
                object = ((KotlinType)((Object)$this$mapType_u24lambda_u243)).isMarkedNullable() ? TypeUtilsKt.makeNullable(upperBound) : upperBound;
                Function3<Object, Object, Object, Unit> function3 = FunctionsKt.getDO_NOTHING_3();
                JvmDescriptorTypeWriter<KotlinType> type2 = DescriptorBasedTypeSignatureMappingKt.mapType((KotlinType)object, factory, mode, typeMappingConfiguration, null, function3);
                JvmDescriptorTypeWriter<KotlinType> jvmDescriptorTypeWriter7 = descriptorTypeWriter;
                if (jvmDescriptorTypeWriter7 != null) {
                    Name name = descriptor2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getName(...)");
                    jvmDescriptorTypeWriter7.writeTypeVariable(name, (KotlinType)((Object)type2));
                }
                return (T)jvmDescriptorTypeWriter;
            }
            if (!(descriptor2 instanceof TypeAliasDescriptor) || !mode.getMapTypeAliases()) break;
            jvmDescriptorTypeWriter = ((TypeAliasDescriptor)descriptor2).getExpandedType();
        }
        throw new UnsupportedOperationException("Unknown type " + jvmDescriptorTypeWriter);
    }

    public static /* synthetic */ Object mapType$default(KotlinType kotlinType, JvmTypeFactory jvmTypeFactory, TypeMappingMode typeMappingMode, TypeMappingConfiguration typeMappingConfiguration, JvmDescriptorTypeWriter jvmDescriptorTypeWriter, Function3 function3, int n, Object object) {
        if ((n & 0x20) != 0) {
            function3 = FunctionsKt.getDO_NOTHING_3();
        }
        return DescriptorBasedTypeSignatureMappingKt.mapType(kotlinType, jvmTypeFactory, typeMappingMode, typeMappingConfiguration, jvmDescriptorTypeWriter, function3);
    }

    public static final boolean hasVoidReturnType(CallableDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (descriptor2 instanceof ConstructorDescriptor) {
            return true;
        }
        KotlinType kotlinType = descriptor2.getReturnType();
        Intrinsics.checkNotNull((Object)kotlinType);
        if (KotlinBuiltIns.isUnit(kotlinType)) {
            CallableDescriptor callableDescriptor;
            KotlinType kotlinType2 = descriptor2.getReturnType();
            Intrinsics.checkNotNull((Object)kotlinType2);
            if (!TypeUtils.isNullableType(kotlinType2) && !(callableDescriptor instanceof PropertyGetterDescriptor)) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final String computeInternalName(ClassDescriptor klass, TypeMappingConfiguration<?> typeMappingConfiguration) {
        void var3_3;
        String string;
        String fqName2;
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter(typeMappingConfiguration, (String)"typeMappingConfiguration");
        String string2 = typeMappingConfiguration.getPredefinedFullInternalNameForClass((ClassDescriptor)klass);
        if (string2 != null) {
            klass = string2;
            return klass;
        }
        DeclarationDescriptor declarationDescriptor = klass.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        DeclarationDescriptor container = declarationDescriptor;
        String string3 = SpecialNames.safeIdentifier(klass.getName()).getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getIdentifier(...)");
        String name = string3;
        if (container instanceof PackageFragmentDescriptor) {
            fqName2 = ((PackageFragmentDescriptor)container).getFqName();
            if (((FqName)((Object)fqName2)).isRoot()) {
                return name;
            }
            StringBuilder stringBuilder = new StringBuilder();
            String string4 = ((FqName)((Object)fqName2)).asString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"asString(...)");
            return stringBuilder.append(StringsKt.replace$default((String)string4, (char)'.', (char)'/', (boolean)false, (int)4, null)).append('/').append(name).toString();
        }
        ClassDescriptor classDescriptor = container instanceof ClassDescriptor ? (ClassDescriptor)container : null;
        if (classDescriptor == null) {
            throw new IllegalArgumentException("Unexpected container: " + string2 + " for " + fqName2);
        }
        String containerClass = classDescriptor;
        String string5 = typeMappingConfiguration.getPredefinedInternalNameForClass((ClassDescriptor)((Object)containerClass));
        if (string5 == null) {
            void var1_1;
            string5 = DescriptorBasedTypeSignatureMappingKt.computeInternalName((ClassDescriptor)((Object)containerClass), var1_1);
        }
        String containerInternalName = string5;
        return (String)string + '$' + (String)var3_3;
    }

    public static /* synthetic */ String computeInternalName$default(ClassDescriptor classDescriptor, TypeMappingConfiguration typeMappingConfiguration, int n, Object object) {
        if ((n & 2) != 0) {
            typeMappingConfiguration = TypeMappingConfigurationImpl.INSTANCE;
        }
        return DescriptorBasedTypeSignatureMappingKt.computeInternalName(classDescriptor, typeMappingConfiguration);
    }
}

