/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.descriptors.java.JavaVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.Java8ParameterNamesLoader;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotation;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwnerKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaModifierListOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaType;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaValueParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMember;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaValueParameter;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;

@SourceDebugExtension(value={"SMAP\nReflectJavaMember.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReflectJavaMember.kt\norg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaMember\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1#2:106\n*E\n"})
public abstract class ReflectJavaMember
extends ReflectJavaElement
implements ReflectJavaAnnotationOwner,
ReflectJavaModifierListOwner,
JavaMember {
    public abstract Member getMember();

    @Override
    public AnnotatedElement getElement() {
        Member member = this.getMember();
        Intrinsics.checkNotNull((Object)member, (String)"null cannot be cast to non-null type java.lang.reflect.AnnotatedElement");
        return (AnnotatedElement)((Object)member);
    }

    @Override
    public int getModifiers() {
        return this.getMember().getModifiers();
    }

    @Override
    public Name getName() {
        Name name;
        Name name2;
        String string = this.getMember().getName();
        if (string != null) {
            String string2 = string;
            name2 = Name.identifier(string);
        } else {
            name2 = name = null;
        }
        if (name2 == null) {
            name = SpecialNames.NO_NAME_PROVIDED;
        }
        return name;
    }

    @Override
    public ReflectJavaClass getContainingClass() {
        Class<?> clazz = this.getMember().getDeclaringClass();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"getDeclaringClass(...)");
        return new ReflectJavaClass(clazz);
    }

    protected final List<JavaValueParameter> getValueParameters(Type[] parameterTypes, Annotation[][] parameterAnnotations, boolean isVararg) {
        Intrinsics.checkNotNullParameter((Object)parameterTypes, (String)"parameterTypes");
        Intrinsics.checkNotNullParameter((Object)parameterAnnotations, (String)"parameterAnnotations");
        ArrayList<ReflectJavaValueParameter> result = new ArrayList<ReflectJavaValueParameter>(parameterTypes.length);
        List<String> names = Java8ParameterNamesLoader.INSTANCE.loadParameterNames(this.getMember());
        int shift = names != null ? names.size() - parameterTypes.length : 0;
        int n = parameterTypes.length;
        for (int i = 0; i < n; ++i) {
            String string;
            ReflectJavaType type2 = ReflectJavaType.Factory.create(parameterTypes[i]);
            if (names != null) {
                List<String> list;
                string = (String)CollectionsKt.getOrNull(list, (int)(i + shift));
                if (string == null) {
                    throw new IllegalStateException(("No parameter with index " + i + '+' + shift + " (name=" + this.getName() + " type=" + type2 + ") in " + this).toString());
                }
            } else {
                string = null;
            }
            String name = string;
            boolean isParamVararg = isVararg && i == ArraysKt.getLastIndex((Object[])parameterTypes);
            result.add(new ReflectJavaValueParameter(type2, parameterAnnotations[i], name, isParamVararg));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        void var1_1;
        return other instanceof ReflectJavaMember && Intrinsics.areEqual((Object)this.getMember(), (Object)((ReflectJavaMember)var1_1).getMember());
    }

    public int hashCode() {
        return this.getMember().hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.getMember();
    }

    @Override
    public List<ReflectJavaAnnotation> getAnnotations() {
        Object object = this.getElement();
        if (object == null || (object = object.getDeclaredAnnotations()) == null || (object = ReflectJavaAnnotationOwnerKt.getAnnotations(object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ReflectJavaAnnotation findAnnotation(FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Annotation[] annotationArray = this.getElement();
        if (annotationArray != null && (annotationArray = annotationArray.getDeclaredAnnotations()) != null) {
            void var1_1;
            return ReflectJavaAnnotationOwnerKt.findAnnotation(annotationArray, (FqName)var1_1);
        }
        return null;
    }

    @Override
    public boolean isDeprecatedInJavaDoc() {
        return false;
    }

    @Override
    public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    @Override
    public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Visibility getVisibility() {
        int modifiers = this.getModifiers();
        if (Modifier.isPublic(modifiers)) {
            return Visibilities.Public.INSTANCE;
        }
        if (Modifier.isPrivate(modifiers)) {
            return Visibilities.Private.INSTANCE;
        }
        if (Modifier.isProtected(modifiers)) {
            void var1_1;
            if (Modifier.isStatic((int)var1_1)) {
                return JavaVisibilities.ProtectedStaticVisibility.INSTANCE;
            }
            return JavaVisibilities.ProtectedAndPackage.INSTANCE;
        }
        return JavaVisibilities.PackageVisibility.INSTANCE;
    }
}

