/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;
import kotlin.reflect.jvm.internal.impl.descriptors.java.JavaVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.Java16SealedRecordLoader;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectClassUtilKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotation;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaAnnotationOwnerKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClassifierType;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaConstructor;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaElement;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaField;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaMethod;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaModifierListOwner;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaRecordComponent;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaTypeParameter;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifierType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaRecordComponent;
import kotlin.reflect.jvm.internal.impl.load.java.structure.LightClassOriginKind;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;

@SourceDebugExtension(value={"SMAP\nReflectJavaClass.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReflectJavaClass.kt\norg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaClass\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 6 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,208:1\n179#2,2:209\n1#3:211\n1549#4:212\n1620#4,3:213\n11065#5:216\n11400#5,3:217\n11065#5:221\n11400#5,3:222\n11065#5:225\n11400#5,3:226\n26#6:220\n*S KotlinDebug\n*F\n+ 1 ReflectJavaClass.kt\norg/jetbrains/kotlin/descriptors/runtime/structure/ReflectJavaClass\n*L\n51#1:209,2\n64#1:212\n64#1:213,3\n118#1:216\n118#1:217,3\n131#1:221\n131#1:222,3\n138#1:225\n138#1:226,3\n131#1:220\n*E\n"})
public final class ReflectJavaClass
extends ReflectJavaElement
implements ReflectJavaAnnotationOwner,
ReflectJavaModifierListOwner,
JavaClass {
    private final Class<?> klass;

    /*
     * WARNING - void declaration
     */
    public ReflectJavaClass(Class<?> klass) {
        void var1_1;
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        this.klass = var1_1;
    }

    @Override
    public final Class<?> getElement() {
        return this.klass;
    }

    @Override
    public final int getModifiers() {
        return this.klass.getModifiers();
    }

    public final List<Name> getInnerClassNames() {
        Class<?>[] classArray = this.klass.getDeclaredClasses();
        Intrinsics.checkNotNullExpressionValue(classArray, (String)"getDeclaredClasses(...)");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)ArraysKt.asSequence((Object[])classArray), (Function1)innerClassNames.1.INSTANCE), (Function1)innerClassNames.2.INSTANCE));
    }

    @Override
    public final FqName getFqName() {
        FqName fqName2 = ReflectClassUtilKt.getClassId(this.klass).asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"asSingleFqName(...)");
        return fqName2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ReflectJavaClass getOuterClass() {
        Class<?> clazz = this.klass.getDeclaringClass();
        if (clazz != null) {
            void var1_1;
            Class<?> p0 = clazz;
            return new ReflectJavaClass((Class<?>)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Collection<JavaClassifierType> getSupertypes() {
        if (Intrinsics.areEqual(this.klass, Object.class)) {
            return CollectionsKt.emptyList();
        }
        SpreadBuilder spreadBuilder = new SpreadBuilder(2);
        Type type2 = this.klass.getGenericSuperclass();
        if (type2 == null) {
            type2 = (Type)((Object)Object.class);
        }
        spreadBuilder.add((Object)type2);
        Type[] typeArray = this.klass.getGenericInterfaces();
        Intrinsics.checkNotNullExpressionValue((Object)typeArray, (String)"getGenericInterfaces(...)");
        spreadBuilder.addSpread((Object)typeArray);
        SpreadBuilder spreadBuilder2 = spreadBuilder;
        Iterable $this$map$iv = CollectionsKt.listOf((Object[])spreadBuilder2.toArray((Object[])new Type[spreadBuilder2.size()]));
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            void var3_3;
            Object item$iv$iv = object.next();
            item$iv$iv = (Type)item$iv$iv;
            Collection collection = destination$iv$iv;
            collection.add(new ReflectJavaClassifierType((Type)var3_3));
        }
        return (List)spreadBuilder;
    }

    public final List<ReflectJavaMethod> getMethods() {
        Method[] methodArray = this.klass.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getDeclaredMethods(...)");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])methodArray), (Function1)((Function1)new Function1<Method, Boolean>(this){
            final /* synthetic */ ReflectJavaClass this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(1);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public final Boolean invoke(Method method) {
                boolean bl;
                if (method.isSynthetic()) {
                    bl = false;
                    return bl;
                }
                if (this.this$0.isEnum()) {
                    void var1_1;
                    Intrinsics.checkNotNull((Object)method);
                    if (ReflectJavaClass.access$isEnumValuesOrValueOf(this.this$0, (Method)var1_1)) {
                        bl = false;
                        return bl;
                    }
                }
                bl = true;
                return bl;
            }
        })), (Function1)methods.2.INSTANCE));
    }

    private final boolean isEnumValuesOrValueOf(Method method) {
        String string = method.getName();
        if (Intrinsics.areEqual((Object)string, (Object)"values")) {
            Class<?>[] classArray = method.getParameterTypes();
            Intrinsics.checkNotNullExpressionValue(classArray, (String)"getParameterTypes(...)");
            return ((Object[])classArray).length == 0;
        }
        if (Intrinsics.areEqual((Object)string, (Object)"valueOf")) {
            Object[] objectArray;
            Object[] objectArray2 = objectArray.getParameterTypes();
            Object[] objectArray3 = new Class[1];
            objectArray = objectArray3;
            objectArray3[0] = String.class;
            return Arrays.equals(objectArray2, objectArray);
        }
        return false;
    }

    public final List<ReflectJavaField> getFields() {
        Field[] fieldArray = this.klass.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fieldArray, (String)"getDeclaredFields(...)");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)ArraysKt.asSequence((Object[])fieldArray), (Function1)fields.1.INSTANCE), (Function1)fields.2.INSTANCE));
    }

    public final List<ReflectJavaConstructor> getConstructors() {
        Constructor<?>[] constructorArray = this.klass.getDeclaredConstructors();
        Intrinsics.checkNotNullExpressionValue(constructorArray, (String)"getDeclaredConstructors(...)");
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filterNot((Sequence)ArraysKt.asSequence((Object[])constructorArray), (Function1)constructors.1.INSTANCE), (Function1)constructors.2.INSTANCE));
    }

    @Override
    public final boolean hasDefaultConstructor() {
        return false;
    }

    @Override
    public final LightClassOriginKind getLightClassOriginKind() {
        return null;
    }

    @Override
    public final Name getName() {
        if (this.klass.isAnonymousClass()) {
            String string = this.klass.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            Name name = Name.identifier(StringsKt.substringAfterLast$default((String)string, (String)".", null, (int)2, null));
            Intrinsics.checkNotNull((Object)name);
            return name;
        }
        Name name = Name.identifier(this.klass.getSimpleName());
        Intrinsics.checkNotNull((Object)name);
        return name;
    }

    /*
     * WARNING - void declaration
     */
    public final List<ReflectJavaTypeParameter> getTypeParameters() {
        void var1_1;
        void $this$mapTo$iv$iv;
        Object[] $this$map$iv;
        TypeVariable<Class<?>>[] typeVariableArray = this.klass.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(typeVariableArray, (String)"getTypeParameters(...)");
        Object[] objectArray = $this$map$iv = (Object[])typeVariableArray;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        for (TypeVariable item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            item$iv$iv = item$iv$iv;
            Collection collection = destination$iv$iv;
            collection.add(new ReflectJavaTypeParameter((TypeVariable<?>)p0));
        }
        return (List)var1_1;
    }

    @Override
    public final boolean isInterface() {
        return this.klass.isInterface();
    }

    @Override
    public final boolean isAnnotationType() {
        return this.klass.isAnnotation();
    }

    @Override
    public final boolean isEnum() {
        return this.klass.isEnum();
    }

    @Override
    public final boolean isRecord() {
        Boolean bl = Java16SealedRecordLoader.INSTANCE.loadIsRecord(this.klass);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Collection<JavaRecordComponent> getRecordComponents() {
        void var1_1;
        void $this$mapTo$iv$iv;
        Object[] objectArray = Java16SealedRecordLoader.INSTANCE.loadGetRecordComponents(this.klass);
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        Object[] $this$map$iv = objectArray;
        Object[] objectArray2 = objectArray;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Collection collection = destination$iv$iv;
            collection.add(new ReflectJavaRecordComponent(p0));
        }
        return (List)var1_1;
    }

    @Override
    public final boolean isSealed() {
        Boolean bl = Java16SealedRecordLoader.INSTANCE.loadIsSealed(this.klass);
        if (bl != null) {
            return bl;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Collection<JavaClassifierType> getPermittedTypes() {
        Class<?>[] classArray = Java16SealedRecordLoader.INSTANCE.loadGetPermittedSubclasses(this.klass);
        if (classArray != null) {
            void $this$mapTo$iv$iv;
            Class<?>[] $this$map$iv = classArray;
            Class<?>[] classArray2 = classArray;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            for (Type item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                item$iv$iv = item$iv$iv;
                Collection collection = destination$iv$iv;
                collection.add(new ReflectJavaClassifierType((Type)p0));
            }
            return (List)classArray;
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return other instanceof ReflectJavaClass && Intrinsics.areEqual(this.klass, ((ReflectJavaClass)var1_1).klass);
    }

    public final int hashCode() {
        return this.klass.hashCode();
    }

    public final String toString() {
        return this.getClass().getName() + ": " + this.klass;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean access$isEnumValuesOrValueOf(ReflectJavaClass $this, Method method) {
        void var1_1;
        return $this.isEnumValuesOrValueOf((Method)var1_1);
    }

    @Override
    public final List<ReflectJavaAnnotation> getAnnotations() {
        Object object = this.getElement();
        if (object == null || (object = object.getDeclaredAnnotations()) == null || (object = ReflectJavaAnnotationOwnerKt.getAnnotations(object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ReflectJavaAnnotation findAnnotation(FqName fqName2) {
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Annotation[] annotationArray = this.getElement();
        if (annotationArray != null && (annotationArray = annotationArray.getDeclaredAnnotations()) != null) {
            void var1_1;
            return ReflectJavaAnnotationOwnerKt.findAnnotation(annotationArray, (FqName)var1_1);
        }
        return null;
    }

    @Override
    public final boolean isDeprecatedInJavaDoc() {
        return false;
    }

    @Override
    public final boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    @Override
    public final boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    @Override
    public final boolean isFinal() {
        return Modifier.isFinal(this.getModifiers());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Visibility getVisibility() {
        int modifiers = this.getModifiers();
        if (Modifier.isPublic(modifiers)) {
            return Visibilities.Public.INSTANCE;
        }
        if (Modifier.isPrivate(modifiers)) {
            return Visibilities.Private.INSTANCE;
        }
        if (Modifier.isProtected(modifiers)) {
            void var1_1;
            if (Modifier.isStatic((int)var1_1)) {
                return JavaVisibilities.ProtectedStaticVisibility.INSTANCE;
            }
            return JavaVisibilities.ProtectedAndPackage.INSTANCE;
        }
        return JavaVisibilities.PackageVisibility.INSTANCE;
    }
}

