/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.runtime.components;

import java.util.Set;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.components.ReflectJavaClassFinderKt;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaClass;
import kotlin.reflect.jvm.internal.impl.descriptors.runtime.structure.ReflectJavaPackage;
import kotlin.reflect.jvm.internal.impl.load.java.JavaClassFinder;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaPackage;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.text.StringsKt;

public final class ReflectJavaClassFinder
implements JavaClassFinder {
    private final ClassLoader classLoader;

    /*
     * WARNING - void declaration
     */
    public ReflectJavaClassFinder(ClassLoader classLoader) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
        this.classLoader = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final JavaClass findClass(JavaClassFinder.Request request) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        ClassId classId = request.getClassId();
        FqName fqName2 = classId.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"getPackageFqName(...)");
        FqName packageFqName = fqName2;
        String string = classId.getRelativeClassName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String relativeClassName = StringsKt.replace$default((String)string, (char)'.', (char)'$', (boolean)false, (int)4, null);
        String name = packageFqName.isRoot() ? relativeClassName : var2_2.asString() + '.' + relativeClassName;
        Class<?> klass = ReflectJavaClassFinderKt.tryLoadClass(this.classLoader, name);
        if (klass != null) {
            void var1_1;
            return new ReflectJavaClass((Class<?>)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final JavaPackage findPackage(FqName fqName2, boolean mayHaveAnnotations) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return new ReflectJavaPackage((FqName)var1_1);
    }

    @Override
    public final Set<String> knownClassNamesInPackage(FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        return null;
    }
}

