/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptorVisitor;
import kotlin.reflect.jvm.internal.impl.descriptors.InvalidModuleExceptionKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleCapability;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageViewDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.CompositePackageFragmentProvider;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.DeclarationDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDependencies;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ModuleDependenciesImpl;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.PackageViewDescriptorFactory;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.platform.TargetPlatform;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNotNull;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;

@SourceDebugExtension(value={"SMAP\nModuleDescriptorImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleDescriptorImpl.kt\norg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl\n+ 2 coreLib.kt\norg/jetbrains/kotlin/utils/CoreLibKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,180:1\n19#2:181\n19#2:185\n19#2:186\n766#3:182\n857#3,2:183\n1#4:187\n*S KotlinDebug\n*F\n+ 1 ModuleDescriptorImpl.kt\norg/jetbrains/kotlin/descriptors/impl/ModuleDescriptorImpl\n*L\n72#1:181\n75#1:185\n78#1:186\n72#1:182\n72#1:183,2\n*E\n"})
public final class ModuleDescriptorImpl
extends DeclarationDescriptorImpl
implements ModuleDescriptor {
    private final StorageManager storageManager;
    private final KotlinBuiltIns builtIns;
    private final TargetPlatform platform;
    private final Name stableName;
    private final Map<ModuleCapability<?>, Object> capabilities;
    private final PackageViewDescriptorFactory packageViewDescriptorFactory;
    private ModuleDependencies dependencies;
    private PackageFragmentProvider packageFragmentProviderForModuleContent;
    private boolean isValid;
    private final MemoizedFunctionToNotNull<FqName, PackageViewDescriptor> packages;
    private final Lazy packageFragmentProviderForWholeModuleWithDependencies$delegate;

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public ModuleDescriptorImpl(Name moduleName, StorageManager storageManager, KotlinBuiltIns builtIns2, TargetPlatform platform, Map<ModuleCapability<?>, ? extends Object> capabilities, Name stableName) {
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)builtIns2, (String)"builtIns");
        Intrinsics.checkNotNullParameter(capabilities, (String)"capabilities");
        super(Annotations.Companion.getEMPTY(), moduleName);
        this.storageManager = var2_2;
        this.builtIns = var3_3;
        this.platform = platform;
        this.stableName = stableName;
        if (!moduleName.isSpecial()) {
            void var1_1;
            throw new IllegalArgumentException("Module name must be special: " + var1_1);
        }
        this.capabilities = capabilities;
        PackageViewDescriptorFactory packageViewDescriptorFactory = this.getCapability(PackageViewDescriptorFactory.Companion.getCAPABILITY());
        if (packageViewDescriptorFactory == null) {
            packageViewDescriptorFactory = PackageViewDescriptorFactory.Default.INSTANCE;
        }
        this.packageViewDescriptorFactory = packageViewDescriptorFactory;
        this.isValid = true;
        this.packages = this.storageManager.createMemoizedFunction((Function1)new Function1<FqName, PackageViewDescriptor>(this){
            final /* synthetic */ ModuleDescriptorImpl this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final PackageViewDescriptor invoke(FqName fqName2) {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
                return ModuleDescriptorImpl.access$getPackageViewDescriptorFactory$p(this.this$0).compute(this.this$0, (FqName)var1_1, ModuleDescriptorImpl.access$getStorageManager$p(this.this$0));
            }
        });
        this.packageFragmentProviderForWholeModuleWithDependencies$delegate = LazyKt.lazy((Function0)((Function0)new Function0<CompositePackageFragmentProvider>(this){
            final /* synthetic */ ModuleDescriptorImpl this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final CompositePackageFragmentProvider invoke() {
                void $this$mapTo$iv$iv;
                Iterator<T> $this$forEach$iv;
                String $this$sure$iv;
                Object object = ModuleDescriptorImpl.access$getDependencies$p(this.this$0);
                ModuleDescriptorImpl moduleDescriptorImpl = this.this$0;
                void v0 = $this$sure$iv;
                if (v0 == null) {
                    $this$sure$iv = "Dependencies of module " + ModuleDescriptorImpl.access$getId(moduleDescriptorImpl) + " were not set before querying module content";
                    throw new AssertionError((Object)$this$sure$iv);
                }
                $this$sure$iv = v0;
                Object dependenciesDescriptors = v0.getAllDependencies();
                this.this$0.assertValid();
                boolean bl = dependenciesDescriptors.contains(this.this$0);
                ModuleDescriptorImpl moduleDescriptorImpl2 = this.this$0;
                if (_Assertions.ENABLED && !bl) {
                    dependenciesDescriptors = "Module " + ModuleDescriptorImpl.access$getId(moduleDescriptorImpl2) + " is not contained in its own dependencies, this is probably a misconfiguration";
                    throw new AssertionError(dependenciesDescriptors);
                }
                Iterable iterable = (Iterable)dependenciesDescriptors;
                moduleDescriptorImpl2 = this.this$0;
                $this$forEach$iv = $this$forEach$iv.iterator();
                while ($this$forEach$iv.hasNext()) {
                    T t = $this$forEach$iv.next();
                    ModuleDescriptorImpl dependency = (ModuleDescriptorImpl)t;
                    boolean bl2 = ModuleDescriptorImpl.access$isInitialized(dependency);
                    if (!_Assertions.ENABLED || bl2) continue;
                    dependenciesDescriptors = "Dependency module " + ModuleDescriptorImpl.access$getId(dependency) + " was not initialized by the time contents of dependent module " + ModuleDescriptorImpl.access$getId(moduleDescriptorImpl2) + " were queried";
                    throw new AssertionError(dependenciesDescriptors);
                }
                Iterable $this$map$iv = (Iterable)dependenciesDescriptors;
                dependenciesDescriptors = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                for (E item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    ModuleDescriptorImpl moduleDescriptorImpl3 = (ModuleDescriptorImpl)object;
                    object = destination$iv$iv;
                    PackageFragmentProvider packageFragmentProvider = ModuleDescriptorImpl.access$getPackageFragmentProviderForModuleContent$p((ModuleDescriptorImpl)it);
                    Intrinsics.checkNotNull((Object)packageFragmentProvider);
                    object.add(packageFragmentProvider);
                }
                object = "CompositeProvider@ModuleDescriptor for " + this.this$0.getName();
                iterable = (List)iterable;
                return new CompositePackageFragmentProvider((List<? extends PackageFragmentProvider>)iterable, (String)object);
            }
        }));
    }

    public /* synthetic */ ModuleDescriptorImpl(Name name, StorageManager storageManager, KotlinBuiltIns kotlinBuiltIns, TargetPlatform targetPlatform, Map map, Name name2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            targetPlatform = null;
        }
        if ((n & 0x10) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x20) != 0) {
            name2 = null;
        }
        this(name, storageManager, kotlinBuiltIns, targetPlatform, map, name2);
    }

    @Override
    public final KotlinBuiltIns getBuiltIns() {
        return this.builtIns;
    }

    public final boolean isValid() {
        return this.isValid;
    }

    public final void assertValid() {
        if (!this.isValid()) {
            InvalidModuleExceptionKt.moduleInvalidated(this);
        }
    }

    @Override
    public final List<ModuleDescriptor> getExpectedByModules() {
        Object object = this.dependencies;
        if (object == null) {
            object = "Dependencies of module " + this.getId() + " were not set";
            throw new AssertionError(object);
        }
        return object.getDirectExpectedByDependencies();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final PackageViewDescriptor getPackage(FqName fqName2) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        this.assertValid();
        return (PackageViewDescriptor)this.packages.invoke(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Collection<FqName> getSubPackagesOf(FqName fqName2, Function1<? super Name, Boolean> nameFilter) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        Intrinsics.checkNotNullParameter(nameFilter, (String)"nameFilter");
        this.assertValid();
        return this.getPackageFragmentProvider().getSubPackagesOf((FqName)var1_1, (Function1<? super Name, Boolean>)var2_2);
    }

    private final CompositePackageFragmentProvider getPackageFragmentProviderForWholeModuleWithDependencies() {
        Lazy lazy = this.packageFragmentProviderForWholeModuleWithDependencies$delegate;
        return (CompositePackageFragmentProvider)lazy.getValue();
    }

    private final boolean isInitialized() {
        return this.packageFragmentProviderForModuleContent != null;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDependencies(ModuleDependencies dependencies) {
        void var1_1;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)dependencies, (String)"dependencies");
        boolean bl2 = bl = this.dependencies == null;
        if (_Assertions.ENABLED && !bl) {
            dependencies = "Dependencies of " + this.getId() + " were already set";
            throw new AssertionError(dependencies);
        }
        this.dependencies = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDependencies(ModuleDescriptorImpl ... descriptors) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)descriptors, (String)"descriptors");
        this.setDependencies(ArraysKt.toList((Object[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final void setDependencies(List<ModuleDescriptorImpl> descriptors) {
        void var1_1;
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        this.setDependencies((List<ModuleDescriptorImpl>)var1_1, SetsKt.emptySet());
    }

    /*
     * WARNING - void declaration
     */
    public final void setDependencies(List<ModuleDescriptorImpl> descriptors, Set<ModuleDescriptorImpl> friends) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter(friends, (String)"friends");
        this.setDependencies(new ModuleDependenciesImpl((List<ModuleDescriptorImpl>)var1_1, (Set<ModuleDescriptorImpl>)var2_2, CollectionsKt.emptyList(), SetsKt.emptySet()));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean shouldSeeInternalsOf(ModuleDescriptor targetModule) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)targetModule, (String)"targetModule");
        if (Intrinsics.areEqual((Object)this, (Object)targetModule)) {
            return true;
        }
        ModuleDependencies moduleDependencies = this.dependencies;
        Intrinsics.checkNotNull((Object)moduleDependencies);
        if (CollectionsKt.contains((Iterable)moduleDependencies.getModulesWhoseInternalsAreVisible(), (Object)targetModule)) {
            return true;
        }
        if (this.getExpectedByModules().contains(targetModule)) {
            return true;
        }
        return var1_1.getExpectedByModules().contains(this);
    }

    private final String getId() {
        String string = this.getName().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void initialize(PackageFragmentProvider providerForModuleContent) {
        void var1_1;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)providerForModuleContent, (String)"providerForModuleContent");
        boolean bl2 = bl = !this.isInitialized();
        if (_Assertions.ENABLED && !bl) {
            providerForModuleContent = "Attempt to initialize module " + this.getId() + " twice";
            throw new AssertionError(providerForModuleContent);
        }
        this.packageFragmentProviderForModuleContent = var1_1;
    }

    public final PackageFragmentProvider getPackageFragmentProvider() {
        this.assertValid();
        return this.getPackageFragmentProviderForWholeModuleWithDependencies();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T getCapability(ModuleCapability<T> capability) {
        void var1_1;
        Intrinsics.checkNotNullParameter(capability, (String)"capability");
        Object object = this.capabilities.get(var1_1);
        if (object == null) {
            object = null;
        }
        return (T)object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String toString() {
        void var2_2;
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u246 = stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        if (!this.isValid()) {
            $this$toString_u24lambda_u246.append(" !isValid");
        }
        $this$toString_u24lambda_u246.append(" packageFragmentProvider: ");
        Object object = this.packageFragmentProviderForModuleContent;
        var2_2.append(object != null && (object = object.getClass()) != null ? ((Class)object).getSimpleName() : null);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public final DeclarationDescriptor getContainingDeclaration() {
        return ModuleDescriptor.DefaultImpls.getContainingDeclaration(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor2, D data2) {
        void var2_2;
        void var1_1;
        return ModuleDescriptor.DefaultImpls.accept(this, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public ModuleDescriptorImpl(Name moduleName, StorageManager storageManager, KotlinBuiltIns builtIns2, TargetPlatform platform) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)builtIns2, (String)"builtIns");
        this((Name)var1_1, (StorageManager)var2_2, (KotlinBuiltIns)var3_3, platform, null, null, 48, null);
    }

    public static final /* synthetic */ PackageViewDescriptorFactory access$getPackageViewDescriptorFactory$p(ModuleDescriptorImpl $this) {
        return $this.packageViewDescriptorFactory;
    }

    public static final /* synthetic */ StorageManager access$getStorageManager$p(ModuleDescriptorImpl $this) {
        return $this.storageManager;
    }

    public static final /* synthetic */ ModuleDependencies access$getDependencies$p(ModuleDescriptorImpl $this) {
        return $this.dependencies;
    }

    public static final /* synthetic */ String access$getId(ModuleDescriptorImpl $this) {
        return $this.getId();
    }

    public static final /* synthetic */ boolean access$isInitialized(ModuleDescriptorImpl $this) {
        return $this.isInitialized();
    }

    public static final /* synthetic */ PackageFragmentProvider access$getPackageFragmentProviderForModuleContent$p(ModuleDescriptorImpl $this) {
        return $this.packageFragmentProviderForModuleContent;
    }
}

