/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.jvm;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.builtins.CompanionObjectMapping;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionTypeKind;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.FqNamesUtilKt;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.name.StandardClassIds;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.text.StringsKt;

@SourceDebugExtension(value={"SMAP\nJavaToKotlinClassMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JavaToKotlinClassMap.kt\norg/jetbrains/kotlin/builtins/jvm/JavaToKotlinClassMap\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,219:1\n49#1,2:221\n49#1,2:223\n49#1,2:225\n49#1,2:227\n49#1,2:229\n49#1,2:231\n49#1,2:233\n49#1,2:235\n1#2:220\n*S KotlinDebug\n*F\n+ 1 JavaToKotlinClassMap.kt\norg/jetbrains/kotlin/builtins/jvm/JavaToKotlinClassMap\n*L\n54#1:221,2\n55#1:223,2\n56#1:225,2\n57#1:227,2\n58#1:229,2\n59#1:231,2\n60#1:233,2\n61#1:235,2\n*E\n"})
public final class JavaToKotlinClassMap {
    public static final JavaToKotlinClassMap INSTANCE;
    private static final String NUMBERED_FUNCTION_PREFIX;
    private static final String NUMBERED_K_FUNCTION_PREFIX;
    private static final String NUMBERED_SUSPEND_FUNCTION_PREFIX;
    private static final String NUMBERED_K_SUSPEND_FUNCTION_PREFIX;
    private static final ClassId FUNCTION_N_CLASS_ID;
    private static final FqName FUNCTION_N_FQ_NAME;
    private static final ClassId K_FUNCTION_CLASS_ID;
    private static final ClassId K_CLASS_CLASS_ID;
    private static final ClassId CLASS_CLASS_ID;
    private static final HashMap<FqNameUnsafe, ClassId> javaToKotlin;
    private static final HashMap<FqNameUnsafe, ClassId> kotlinToJava;
    private static final HashMap<FqNameUnsafe, FqName> mutableToReadOnly;
    private static final HashMap<FqNameUnsafe, FqName> readOnlyToMutable;
    private static final HashMap<ClassId, ClassId> mutableToReadOnlyClassId;
    private static final HashMap<ClassId, ClassId> readOnlyToMutableClassId;
    private static final List<PlatformMutabilityMapping> mutabilityMappings;

    private JavaToKotlinClassMap() {
    }

    public final FqName getFUNCTION_N_FQ_NAME() {
        return FUNCTION_N_FQ_NAME;
    }

    public final List<PlatformMutabilityMapping> getMutabilityMappings() {
        return mutabilityMappings;
    }

    /*
     * WARNING - void declaration
     */
    public final ClassId mapJavaToKotlin(FqName fqName2) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return javaToKotlin.get(var1_1.toUnsafe());
    }

    /*
     * WARNING - void declaration
     */
    public final ClassId mapKotlinToJava(FqNameUnsafe kotlinFqName) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)kotlinFqName, (String)"kotlinFqName");
        if (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_FUNCTION_PREFIX)) {
            return FUNCTION_N_CLASS_ID;
        }
        if (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_SUSPEND_FUNCTION_PREFIX)) {
            return FUNCTION_N_CLASS_ID;
        }
        if (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_K_FUNCTION_PREFIX)) {
            return K_FUNCTION_CLASS_ID;
        }
        if (this.isKotlinFunctionWithBigArity(kotlinFqName, NUMBERED_K_SUSPEND_FUNCTION_PREFIX)) {
            return K_FUNCTION_CLASS_ID;
        }
        return kotlinToJava.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isKotlinFunctionWithBigArity(FqNameUnsafe kotlinFqName, String prefix) {
        void var2_2;
        String string = kotlinFqName.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String arityString = StringsKt.substringAfter((String)string, (String)var2_2, (String)"");
        if (((CharSequence)arityString).length() > 0 && !StringsKt.startsWith$default((CharSequence)arityString, (char)'0', (boolean)false, (int)2, null)) {
            void var1_1;
            Integer arity = StringsKt.toIntOrNull((String)arityString);
            return arity != null && var1_1.intValue() >= 23;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final void addMapping(PlatformMutabilityMapping platformMutabilityMapping) {
        void var3_3;
        void var2_2;
        void var1_1;
        ClassId javaClassId = platformMutabilityMapping.component1();
        ClassId readOnlyClassId = platformMutabilityMapping.component2();
        ClassId mutableClassId = platformMutabilityMapping.component3();
        this.add(javaClassId, readOnlyClassId);
        FqName fqName2 = mutableClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"asSingleFqName(...)");
        this.addKotlinToJava(fqName2, javaClassId);
        ((Map)mutableToReadOnlyClassId).put(mutableClassId, readOnlyClassId);
        ((Map)readOnlyToMutableClassId).put(readOnlyClassId, mutableClassId);
        FqName fqName3 = readOnlyClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"asSingleFqName(...)");
        FqName readOnlyFqName = fqName3;
        FqName fqName4 = mutableClassId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"asSingleFqName(...)");
        FqName mutableFqName = fqName4;
        Map map = mutableToReadOnly;
        FqNameUnsafe fqNameUnsafe = var1_1.asSingleFqName().toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"toUnsafe(...)");
        map.put(fqNameUnsafe, readOnlyFqName);
        map = readOnlyToMutable;
        FqNameUnsafe fqNameUnsafe2 = var2_2.toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe2, (String)"toUnsafe(...)");
        map.put(fqNameUnsafe2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private final void add(ClassId javaClassId, ClassId kotlinClassId) {
        void var1_1;
        void var2_2;
        this.addJavaToKotlin(javaClassId, kotlinClassId);
        FqName fqName2 = var2_2.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"asSingleFqName(...)");
        this.addKotlinToJava(fqName2, (ClassId)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final void addTopLevel(Class<?> javaClass, FqNameUnsafe kotlinFqName) {
        void var1_1;
        void var2_2;
        FqName fqName2 = var2_2.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"toSafe(...)");
        this.addTopLevel((Class<?>)var1_1, fqName2);
    }

    /*
     * WARNING - void declaration
     */
    private final void addTopLevel(Class<?> javaClass, FqName kotlinFqName) {
        void var2_2;
        void var1_1;
        JavaToKotlinClassMap javaToKotlinClassMap = this;
        ClassId classId = javaToKotlinClassMap.classId((Class<?>)var1_1);
        ClassId classId2 = ClassId.topLevel((FqName)var2_2);
        Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"topLevel(...)");
        javaToKotlinClassMap.add(classId, classId2);
    }

    /*
     * WARNING - void declaration
     */
    private final void addJavaToKotlin(ClassId javaClassId, ClassId kotlinClassId) {
        void var2_2;
        void var1_1;
        Map map = javaToKotlin;
        FqNameUnsafe fqNameUnsafe = var1_1.asSingleFqName().toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"toUnsafe(...)");
        map.put(fqNameUnsafe, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final void addKotlinToJava(FqName kotlinFqNameUnsafe, ClassId javaClassId) {
        void var2_2;
        void var1_1;
        Map map = kotlinToJava;
        FqNameUnsafe fqNameUnsafe = var1_1.toUnsafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"toUnsafe(...)");
        map.put(fqNameUnsafe, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final FqName mutableToReadOnly(FqNameUnsafe fqNameUnsafe) {
        void var1_1;
        return (FqName)((Map)mutableToReadOnly).get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final FqName readOnlyToMutable(FqNameUnsafe fqNameUnsafe) {
        void var1_1;
        return (FqName)((Map)readOnlyToMutable).get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isMutable(FqNameUnsafe fqNameUnsafe) {
        void var1_1;
        return ((Map)mutableToReadOnly).containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isReadOnly(FqNameUnsafe fqNameUnsafe) {
        void var1_1;
        return ((Map)readOnlyToMutable).containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private final ClassId classId(Class<?> clazz) {
        void var1_1;
        void var2_3;
        boolean bl;
        boolean bl2 = bl = !((Class)clazz).isPrimitive() && !((Class)clazz).isArray();
        if (_Assertions.ENABLED && !bl) {
            clazz = "Invalid class: " + clazz;
            throw new AssertionError(clazz);
        }
        Class<?> outer = ((Class)clazz).getDeclaringClass();
        if (outer == null) {
            ClassId classId = ClassId.topLevel(new FqName(((Class)clazz).getCanonicalName()));
            Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(...)");
            return classId;
        }
        ClassId classId = this.classId((Class<?>)var2_3).createNestedClassId(Name.identifier(var1_1.getSimpleName()));
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"createNestedClassId(...)");
        return classId;
    }

    /*
     * WARNING - void declaration
     */
    static {
        int i;
        JavaToKotlinClassMap this_$iv;
        ClassId kotlinReadOnly$iv;
        INSTANCE = new JavaToKotlinClassMap();
        NUMBERED_FUNCTION_PREFIX = FunctionTypeKind.Function.INSTANCE.getPackageFqName().toString() + '.' + FunctionTypeKind.Function.INSTANCE.getClassNamePrefix();
        NUMBERED_K_FUNCTION_PREFIX = FunctionTypeKind.KFunction.INSTANCE.getPackageFqName().toString() + '.' + FunctionTypeKind.KFunction.INSTANCE.getClassNamePrefix();
        NUMBERED_SUSPEND_FUNCTION_PREFIX = FunctionTypeKind.SuspendFunction.INSTANCE.getPackageFqName().toString() + '.' + FunctionTypeKind.SuspendFunction.INSTANCE.getClassNamePrefix();
        NUMBERED_K_SUSPEND_FUNCTION_PREFIX = FunctionTypeKind.KSuspendFunction.INSTANCE.getPackageFqName().toString() + '.' + FunctionTypeKind.KSuspendFunction.INSTANCE.getClassNamePrefix();
        ClassId classId = ClassId.topLevel(new FqName("kotlin.jvm.functions.FunctionN"));
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(...)");
        FUNCTION_N_CLASS_ID = classId;
        FqName fqName2 = classId.asSingleFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"asSingleFqName(...)");
        FUNCTION_N_FQ_NAME = fqName2;
        K_FUNCTION_CLASS_ID = StandardClassIds.INSTANCE.getKFunction();
        K_CLASS_CLASS_ID = StandardClassIds.INSTANCE.getKClass();
        CLASS_CLASS_ID = INSTANCE.classId(Class.class);
        javaToKotlin = new HashMap();
        kotlinToJava = new HashMap();
        mutableToReadOnly = new HashMap();
        readOnlyToMutable = new HashMap();
        mutableToReadOnlyClassId = new HashMap();
        readOnlyToMutableClassId = new HashMap();
        Object[] objectArray = new PlatformMutabilityMapping[8];
        Object[] objectArray2 = objectArray;
        JavaToKotlinClassMap javaToKotlinClassMap = INSTANCE;
        ClassId classId2 = ClassId.topLevel(StandardNames.FqNames.iterable);
        Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"topLevel(...)");
        ClassId classId3 = classId2;
        FqName kotlinMutable$iv = StandardNames.FqNames.mutableIterable;
        FqName fqName3 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName4 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"getPackageFqName(...)");
        ClassId mutableClassId$iv = new ClassId(fqName3, FqNamesUtilKt.tail(kotlinMutable$iv, fqName4), false);
        objectArray[0] = new PlatformMutabilityMapping(super.classId(Iterable.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        ClassId classId4 = ClassId.topLevel(StandardNames.FqNames.iterator);
        Intrinsics.checkNotNullExpressionValue((Object)classId4, (String)"topLevel(...)");
        kotlinReadOnly$iv = classId4;
        kotlinMutable$iv = StandardNames.FqNames.mutableIterator;
        FqName fqName5 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName6 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName6, (String)"getPackageFqName(...)");
        mutableClassId$iv = new ClassId(fqName5, FqNamesUtilKt.tail(kotlinMutable$iv, fqName6), false);
        objectArray2[1] = new PlatformMutabilityMapping(this_$iv.classId(Iterator.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        ClassId classId5 = ClassId.topLevel(StandardNames.FqNames.collection);
        Intrinsics.checkNotNullExpressionValue((Object)classId5, (String)"topLevel(...)");
        kotlinReadOnly$iv = classId5;
        kotlinMutable$iv = StandardNames.FqNames.mutableCollection;
        FqName fqName7 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName8 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName8, (String)"getPackageFqName(...)");
        mutableClassId$iv = new ClassId(fqName7, FqNamesUtilKt.tail(kotlinMutable$iv, fqName8), false);
        objectArray2[2] = new PlatformMutabilityMapping(this_$iv.classId(Collection.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        ClassId classId6 = ClassId.topLevel(StandardNames.FqNames.list);
        Intrinsics.checkNotNullExpressionValue((Object)classId6, (String)"topLevel(...)");
        kotlinReadOnly$iv = classId6;
        kotlinMutable$iv = StandardNames.FqNames.mutableList;
        FqName fqName9 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName10 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName10, (String)"getPackageFqName(...)");
        mutableClassId$iv = new ClassId(fqName9, FqNamesUtilKt.tail(kotlinMutable$iv, fqName10), false);
        objectArray2[3] = new PlatformMutabilityMapping(this_$iv.classId(List.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        ClassId classId7 = ClassId.topLevel(StandardNames.FqNames.set);
        Intrinsics.checkNotNullExpressionValue((Object)classId7, (String)"topLevel(...)");
        kotlinReadOnly$iv = classId7;
        kotlinMutable$iv = StandardNames.FqNames.mutableSet;
        FqName fqName11 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName12 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName12, (String)"getPackageFqName(...)");
        mutableClassId$iv = new ClassId(fqName11, FqNamesUtilKt.tail(kotlinMutable$iv, fqName12), false);
        objectArray2[4] = new PlatformMutabilityMapping(this_$iv.classId(Set.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        ClassId classId8 = ClassId.topLevel(StandardNames.FqNames.listIterator);
        Intrinsics.checkNotNullExpressionValue((Object)classId8, (String)"topLevel(...)");
        kotlinReadOnly$iv = classId8;
        kotlinMutable$iv = StandardNames.FqNames.mutableListIterator;
        FqName fqName13 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName14 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName14, (String)"getPackageFqName(...)");
        mutableClassId$iv = new ClassId(fqName13, FqNamesUtilKt.tail(kotlinMutable$iv, fqName14), false);
        objectArray2[5] = new PlatformMutabilityMapping(this_$iv.classId(ListIterator.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        ClassId classId9 = ClassId.topLevel(StandardNames.FqNames.map);
        Intrinsics.checkNotNullExpressionValue((Object)classId9, (String)"topLevel(...)");
        kotlinReadOnly$iv = classId9;
        kotlinMutable$iv = StandardNames.FqNames.mutableMap;
        FqName fqName15 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName16 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName16, (String)"getPackageFqName(...)");
        mutableClassId$iv = new ClassId(fqName15, FqNamesUtilKt.tail(kotlinMutable$iv, fqName16), false);
        objectArray2[6] = new PlatformMutabilityMapping(this_$iv.classId(Map.class), kotlinReadOnly$iv, mutableClassId$iv);
        this_$iv = INSTANCE;
        ClassId classId10 = ClassId.topLevel(StandardNames.FqNames.map).createNestedClassId(StandardNames.FqNames.mapEntry.shortName());
        Intrinsics.checkNotNullExpressionValue((Object)classId10, (String)"createNestedClassId(...)");
        kotlinReadOnly$iv = classId10;
        kotlinMutable$iv = StandardNames.FqNames.mutableMapEntry;
        FqName fqName17 = kotlinReadOnly$iv.getPackageFqName();
        FqName fqName18 = kotlinReadOnly$iv.getPackageFqName();
        Intrinsics.checkNotNullExpressionValue((Object)fqName18, (String)"getPackageFqName(...)");
        mutableClassId$iv = new ClassId(fqName17, FqNamesUtilKt.tail(kotlinMutable$iv, fqName18), false);
        objectArray2[7] = new PlatformMutabilityMapping(this_$iv.classId(Map.Entry.class), kotlinReadOnly$iv, mutableClassId$iv);
        mutabilityMappings = CollectionsKt.listOf((Object[])objectArray2);
        INSTANCE.addTopLevel(Object.class, StandardNames.FqNames.any);
        INSTANCE.addTopLevel(String.class, StandardNames.FqNames.string);
        INSTANCE.addTopLevel(CharSequence.class, StandardNames.FqNames.charSequence);
        INSTANCE.addTopLevel(Throwable.class, StandardNames.FqNames.throwable);
        INSTANCE.addTopLevel(Cloneable.class, StandardNames.FqNames.cloneable);
        INSTANCE.addTopLevel(Number.class, StandardNames.FqNames.number);
        INSTANCE.addTopLevel(Comparable.class, StandardNames.FqNames.comparable);
        INSTANCE.addTopLevel(Enum.class, StandardNames.FqNames._enum);
        INSTANCE.addTopLevel(Annotation.class, StandardNames.FqNames.annotation);
        for (PlatformMutabilityMapping platformCollection : mutabilityMappings) {
            INSTANCE.addMapping(platformCollection);
        }
        for (JvmPrimitiveType jvmType : JvmPrimitiveType.values()) {
            void var3_9;
            ClassId classId11 = ClassId.topLevel(jvmType.getWrapperFqName());
            Intrinsics.checkNotNullExpressionValue((Object)classId11, (String)"topLevel(...)");
            PrimitiveType primitiveType = var3_9.getPrimitiveType();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)primitiveType), (String)"getPrimitiveType(...)");
            ClassId classId12 = ClassId.topLevel(StandardNames.getPrimitiveFqName(primitiveType));
            Intrinsics.checkNotNullExpressionValue((Object)classId12, (String)"topLevel(...)");
            INSTANCE.add(classId11, classId12);
        }
        for (ClassId classId13 : CompanionObjectMapping.INSTANCE.allClassesWithIntrinsicCompanions()) {
            ClassId classId14 = ClassId.topLevel(new FqName("kotlin.jvm.internal." + classId13.getShortClassName().asString() + "CompanionObject"));
            Intrinsics.checkNotNullExpressionValue((Object)classId14, (String)"topLevel(...)");
            ClassId classId15 = classId13.createNestedClassId(SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT);
            Intrinsics.checkNotNullExpressionValue((Object)classId15, (String)"createNestedClassId(...)");
            INSTANCE.add(classId14, classId15);
        }
        for (i = 0; i < 23; ++i) {
            ClassId classId16 = ClassId.topLevel(new FqName("kotlin.jvm.functions.Function" + i));
            Intrinsics.checkNotNullExpressionValue((Object)classId16, (String)"topLevel(...)");
            INSTANCE.add(classId16, StandardNames.getFunctionClassId(i));
            INSTANCE.addKotlinToJava(new FqName(NUMBERED_K_FUNCTION_PREFIX + i), K_FUNCTION_CLASS_ID);
        }
        for (i = 0; i < 22; ++i) {
            void var2_8;
            void var1_5;
            FunctionTypeKind.KSuspendFunction kSuspendFunction = FunctionTypeKind.KSuspendFunction.INSTANCE;
            String kSuspendFun = kSuspendFunction.getPackageFqName().toString() + '.' + var1_5.getClassNamePrefix();
            INSTANCE.addKotlinToJava(new FqName((String)var2_8 + i), K_FUNCTION_CLASS_ID);
        }
        FqName fqName19 = StandardNames.FqNames.nothing.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName19, (String)"toSafe(...)");
        INSTANCE.addKotlinToJava(fqName19, INSTANCE.classId(Void.class));
    }

    public static final class PlatformMutabilityMapping {
        private final ClassId javaClass;
        private final ClassId kotlinReadOnly;
        private final ClassId kotlinMutable;

        /*
         * WARNING - void declaration
         */
        public PlatformMutabilityMapping(ClassId javaClass, ClassId kotlinReadOnly, ClassId kotlinMutable) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)javaClass, (String)"javaClass");
            Intrinsics.checkNotNullParameter((Object)kotlinReadOnly, (String)"kotlinReadOnly");
            Intrinsics.checkNotNullParameter((Object)kotlinMutable, (String)"kotlinMutable");
            this.javaClass = var1_1;
            this.kotlinReadOnly = var2_2;
            this.kotlinMutable = var3_3;
        }

        public final ClassId getJavaClass() {
            return this.javaClass;
        }

        public final ClassId component1() {
            return this.javaClass;
        }

        public final ClassId component2() {
            return this.kotlinReadOnly;
        }

        public final ClassId component3() {
            return this.kotlinMutable;
        }

        public final String toString() {
            return "PlatformMutabilityMapping(javaClass=" + this.javaClass + ", kotlinReadOnly=" + this.kotlinReadOnly + ", kotlinMutable=" + this.kotlinMutable + ')';
        }

        public final int hashCode() {
            int n = this.javaClass.hashCode();
            n = n * 31 + this.kotlinReadOnly.hashCode();
            n = n * 31 + this.kotlinMutable.hashCode();
            return n;
        }

        public final boolean equals(Object other) {
            PlatformMutabilityMapping platformMutabilityMapping;
            if (this == other) {
                return true;
            }
            if (!(other instanceof PlatformMutabilityMapping)) {
                return false;
            }
            platformMutabilityMapping = platformMutabilityMapping;
            if (!Intrinsics.areEqual((Object)this.javaClass, (Object)platformMutabilityMapping.javaClass)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.kotlinReadOnly, (Object)platformMutabilityMapping.kotlinReadOnly)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.kotlinMutable, (Object)platformMutabilityMapping.kotlinMutable);
        }
    }
}

