/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins.functions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionTypeKind;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.text.StringsKt;

@SourceDebugExtension(value={"SMAP\nFunctionTypeKindExtractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FunctionTypeKindExtractor.kt\norg/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,70:1\n1477#2:71\n1502#2,3:72\n1505#2,3:82\n1747#2,3:85\n372#3,7:75\n*S KotlinDebug\n*F\n+ 1 FunctionTypeKindExtractor.kt\norg/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor\n*L\n32#1:71\n32#1:72,3\n32#1:82,3\n54#1:85,3\n32#1:75,7\n*E\n"})
public final class FunctionTypeKindExtractor {
    public static final Companion Companion = new Companion(null);
    private final List<FunctionTypeKind> kinds;
    private final Map<FqName, List<FunctionTypeKind>> knownKindsByPackageFqName;
    private static final FunctionTypeKindExtractor Default;

    /*
     * WARNING - void declaration
     */
    public FunctionTypeKindExtractor(List<? extends FunctionTypeKind> kinds) {
        void var2_3;
        Iterator iterator2;
        Intrinsics.checkNotNullParameter(kinds, (String)"kinds");
        this.kinds = kinds;
        FunctionTypeKindExtractor functionTypeKindExtractor = this;
        kinds = functionTypeKindExtractor.kinds;
        FunctionTypeKindExtractor functionTypeKindExtractor2 = functionTypeKindExtractor;
        Map destination$iv$iv = new LinkedHashMap();
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            void var3_4;
            List list;
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            Object element$iv$iv = iterator2.next();
            Object object = (FunctionTypeKind)element$iv$iv;
            FqName key$iv$iv = ((FunctionTypeKind)object).getPackageFqName();
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                list = answer$iv$iv$iv;
            } else {
                void var6_7;
                list = var6_7;
            }
            object = list;
            object.add(var3_4);
        }
        functionTypeKindExtractor2.knownKindsByPackageFqName = var2_3;
    }

    /*
     * WARNING - void declaration
     */
    public final FunctionTypeKind getFunctionalClassKind(FqName packageFqName, String className) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        KindWithArity kindWithArity = this.getFunctionalClassKindWithArity((FqName)var1_1, (String)var2_2);
        if (kindWithArity != null) {
            return kindWithArity.getKind();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final KindWithArity getFunctionalClassKindWithArity(FqName packageFqName, String className) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        List<FunctionTypeKind> list = this.knownKindsByPackageFqName.get(packageFqName);
        if (list == null) {
            return null;
        }
        packageFqName = list;
        for (FunctionTypeKind kind : list) {
            void var1_2;
            void var3_4;
            if (!StringsKt.startsWith$default((String)className, (String)kind.getClassNamePrefix(), (boolean)false, (int)2, null)) continue;
            String string = className.substring(kind.getClassNamePrefix().length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            Integer n = this.toInt(string);
            if (n == null) {
                continue;
            }
            int arity = n;
            return new KindWithArity((FunctionTypeKind)var3_4, (int)var1_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Integer toInt(String s) {
        void var2_2;
        if (((CharSequence)s).length() == 0) {
            return null;
        }
        int result = 0;
        int n = s.length();
        for (int i = 0; i < n; ++i) {
            char c = s.charAt(i);
            int d = c - 48;
            if (!(d >= 0 ? d < 10 : false)) {
                return null;
            }
            result = result * 10 + d;
        }
        return (int)var2_2;
    }

    static {
        Object[] objectArray = new FunctionTypeKind[4];
        Object[] objectArray2 = objectArray;
        objectArray[0] = FunctionTypeKind.Function.INSTANCE;
        objectArray2[1] = FunctionTypeKind.SuspendFunction.INSTANCE;
        objectArray2[2] = FunctionTypeKind.KFunction.INSTANCE;
        objectArray2[3] = FunctionTypeKind.KSuspendFunction.INSTANCE;
        Default = new FunctionTypeKindExtractor(CollectionsKt.listOf((Object[])objectArray2));
    }

    public static final class Companion {
        private Companion() {
        }

        public final FunctionTypeKindExtractor getDefault() {
            return Default;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    public static final class KindWithArity {
        private final FunctionTypeKind kind;
        private final int arity;

        /*
         * WARNING - void declaration
         */
        public KindWithArity(FunctionTypeKind kind, int arity) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
            this.kind = var1_1;
            this.arity = var2_2;
        }

        public final FunctionTypeKind getKind() {
            return this.kind;
        }

        public final FunctionTypeKind component1() {
            return this.kind;
        }

        public final int component2() {
            return this.arity;
        }

        public final String toString() {
            return "KindWithArity(kind=" + this.kind + ", arity=" + this.arity + ')';
        }

        public final int hashCode() {
            int n = this.kind.hashCode();
            n = n * 31 + Integer.hashCode(this.arity);
            return n;
        }

        public final boolean equals(Object other) {
            KindWithArity kindWithArity;
            if (this == other) {
                return true;
            }
            if (!(other instanceof KindWithArity)) {
                return false;
            }
            kindWithArity = kindWithArity;
            if (!Intrinsics.areEqual((Object)this.kind, (Object)kindWithArity.kind)) {
                return false;
            }
            return this.arity == kindWithArity.arity;
        }
    }
}

