/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionTypeKind;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.utils.CollectionsKt;

public final class StandardNames {
    public static final StandardNames INSTANCE = new StandardNames();
    @JvmField
    public static final Name BACKING_FIELD;
    @JvmField
    public static final Name DEFAULT_VALUE_PARAMETER;
    @JvmField
    public static final Name ENUM_VALUES;
    @JvmField
    public static final Name ENUM_ENTRIES;
    @JvmField
    public static final Name ENUM_VALUE_OF;
    @JvmField
    public static final Name DATA_CLASS_COPY;
    @JvmField
    public static final String DATA_CLASS_COMPONENT_PREFIX;
    @JvmField
    public static final Name HASHCODE_NAME;
    @JvmField
    public static final Name CHAR_CODE;
    @JvmField
    public static final Name NAME;
    @JvmField
    public static final Name MAIN;
    @JvmField
    public static final Name NEXT_CHAR;
    @JvmField
    public static final Name IMPLICIT_LAMBDA_PARAMETER_NAME;
    @JvmField
    public static final Name CONTEXT_FUNCTION_TYPE_PARAMETER_COUNT_NAME;
    @JvmField
    public static final FqName DYNAMIC_FQ_NAME;
    @JvmField
    public static final FqName COROUTINES_PACKAGE_FQ_NAME;
    @JvmField
    public static final FqName COROUTINES_JVM_INTERNAL_PACKAGE_FQ_NAME;
    @JvmField
    public static final FqName COROUTINES_INTRINSICS_PACKAGE_FQ_NAME;
    @JvmField
    public static final FqName CONTINUATION_INTERFACE_FQ_NAME;
    @JvmField
    public static final FqName RESULT_FQ_NAME;
    @JvmField
    public static final FqName KOTLIN_REFLECT_FQ_NAME;
    @JvmField
    public static final List<String> PREFIXES;
    @JvmField
    public static final Name BUILT_INS_PACKAGE_NAME;
    @JvmField
    public static final FqName BUILT_INS_PACKAGE_FQ_NAME;
    @JvmField
    public static final FqName ANNOTATION_PACKAGE_FQ_NAME;
    @JvmField
    public static final FqName COLLECTIONS_PACKAGE_FQ_NAME;
    @JvmField
    public static final FqName RANGES_PACKAGE_FQ_NAME;
    @JvmField
    public static final FqName TEXT_PACKAGE_FQ_NAME;
    @JvmField
    public static final FqName KOTLIN_INTERNAL_FQ_NAME;
    private static final FqName NON_EXISTENT_CLASS;
    @JvmField
    public static final Set<FqName> BUILT_INS_PACKAGE_FQ_NAMES;

    private StandardNames() {
    }

    @JvmStatic
    public static final String getFunctionName(int parameterCount) {
        int n;
        return "Function" + n;
    }

    @JvmStatic
    public static final ClassId getFunctionClassId(int parameterCount) {
        int n;
        return new ClassId(BUILT_INS_PACKAGE_FQ_NAME, Name.identifier(StandardNames.getFunctionName(n)));
    }

    @JvmStatic
    public static final String getSuspendFunctionName(int parameterCount) {
        int n;
        return FunctionTypeKind.SuspendFunction.INSTANCE.getClassNamePrefix() + n;
    }

    @JvmStatic
    public static final boolean isPrimitiveArray(FqNameUnsafe arrayFqName) {
        FqNameUnsafe fqNameUnsafe;
        Intrinsics.checkNotNullParameter((Object)arrayFqName, (String)"arrayFqName");
        return FqNames.arrayClassFqNameToPrimitiveType.get(fqNameUnsafe) != null;
    }

    @JvmStatic
    public static final FqName getPrimitiveFqName(PrimitiveType primitiveType) {
        PrimitiveType primitiveType2;
        Intrinsics.checkNotNullParameter((Object)((Object)primitiveType), (String)"primitiveType");
        FqName fqName2 = BUILT_INS_PACKAGE_FQ_NAME.child(primitiveType2.getTypeName());
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"child(...)");
        return fqName2;
    }

    static {
        Name name = Name.identifier("field");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        BACKING_FIELD = name;
        Name name2 = Name.identifier("value");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        DEFAULT_VALUE_PARAMETER = name2;
        Name name3 = Name.identifier("values");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        ENUM_VALUES = name3;
        Name name4 = Name.identifier("entries");
        Intrinsics.checkNotNullExpressionValue((Object)name4, (String)"identifier(...)");
        ENUM_ENTRIES = name4;
        Name name5 = Name.identifier("valueOf");
        Intrinsics.checkNotNullExpressionValue((Object)name5, (String)"identifier(...)");
        ENUM_VALUE_OF = name5;
        Name name6 = Name.identifier("copy");
        Intrinsics.checkNotNullExpressionValue((Object)name6, (String)"identifier(...)");
        DATA_CLASS_COPY = name6;
        DATA_CLASS_COMPONENT_PREFIX = "component";
        Name name7 = Name.identifier("hashCode");
        Intrinsics.checkNotNullExpressionValue((Object)name7, (String)"identifier(...)");
        HASHCODE_NAME = name7;
        Name name8 = Name.identifier("code");
        Intrinsics.checkNotNullExpressionValue((Object)name8, (String)"identifier(...)");
        CHAR_CODE = name8;
        Name name9 = Name.identifier("name");
        Intrinsics.checkNotNullExpressionValue((Object)name9, (String)"identifier(...)");
        NAME = name9;
        Name name10 = Name.identifier("main");
        Intrinsics.checkNotNullExpressionValue((Object)name10, (String)"identifier(...)");
        MAIN = name10;
        Name name11 = Name.identifier("nextChar");
        Intrinsics.checkNotNullExpressionValue((Object)name11, (String)"identifier(...)");
        NEXT_CHAR = name11;
        Name name12 = Name.identifier("it");
        Intrinsics.checkNotNullExpressionValue((Object)name12, (String)"identifier(...)");
        IMPLICIT_LAMBDA_PARAMETER_NAME = name12;
        Name name13 = Name.identifier("count");
        Intrinsics.checkNotNullExpressionValue((Object)name13, (String)"identifier(...)");
        CONTEXT_FUNCTION_TYPE_PARAMETER_COUNT_NAME = name13;
        DYNAMIC_FQ_NAME = new FqName("<dynamic>");
        COROUTINES_PACKAGE_FQ_NAME = new FqName("kotlin.coroutines");
        COROUTINES_JVM_INTERNAL_PACKAGE_FQ_NAME = new FqName("kotlin.coroutines.jvm.internal");
        COROUTINES_INTRINSICS_PACKAGE_FQ_NAME = new FqName("kotlin.coroutines.intrinsics");
        FqName fqName2 = COROUTINES_PACKAGE_FQ_NAME.child(Name.identifier("Continuation"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"child(...)");
        CONTINUATION_INTERFACE_FQ_NAME = fqName2;
        RESULT_FQ_NAME = new FqName("kotlin.Result");
        KOTLIN_REFLECT_FQ_NAME = new FqName("kotlin.reflect");
        Object[] objectArray = new String[4];
        Object[] objectArray2 = objectArray;
        objectArray[0] = "KProperty";
        objectArray2[1] = "KMutableProperty";
        objectArray2[2] = "KFunction";
        objectArray2[3] = "KSuspendFunction";
        PREFIXES = kotlin.collections.CollectionsKt.listOf((Object[])objectArray2);
        Name name14 = Name.identifier("kotlin");
        Intrinsics.checkNotNullExpressionValue((Object)name14, (String)"identifier(...)");
        BUILT_INS_PACKAGE_NAME = name14;
        FqName fqName3 = FqName.topLevel(name14);
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"topLevel(...)");
        BUILT_INS_PACKAGE_FQ_NAME = fqName3;
        FqName fqName4 = fqName3.child(Name.identifier("annotation"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"child(...)");
        ANNOTATION_PACKAGE_FQ_NAME = fqName4;
        FqName fqName5 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("collections"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName5, (String)"child(...)");
        COLLECTIONS_PACKAGE_FQ_NAME = fqName5;
        FqName fqName6 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("ranges"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName6, (String)"child(...)");
        RANGES_PACKAGE_FQ_NAME = fqName6;
        FqName fqName7 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("text"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName7, (String)"child(...)");
        TEXT_PACKAGE_FQ_NAME = fqName7;
        FqName fqName8 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier("internal"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName8, (String)"child(...)");
        KOTLIN_INTERNAL_FQ_NAME = fqName8;
        NON_EXISTENT_CLASS = new FqName("error.NonExistentClass");
        FqName[] fqNameArray = new FqName[7];
        objectArray2 = fqNameArray;
        fqNameArray[0] = BUILT_INS_PACKAGE_FQ_NAME;
        objectArray2[1] = COLLECTIONS_PACKAGE_FQ_NAME;
        objectArray2[2] = RANGES_PACKAGE_FQ_NAME;
        objectArray2[3] = ANNOTATION_PACKAGE_FQ_NAME;
        objectArray2[4] = KOTLIN_REFLECT_FQ_NAME;
        objectArray2[5] = KOTLIN_INTERNAL_FQ_NAME;
        objectArray2[6] = COROUTINES_PACKAGE_FQ_NAME;
        BUILT_INS_PACKAGE_FQ_NAMES = SetsKt.setOf((Object[])objectArray2);
    }

    @SourceDebugExtension(value={"SMAP\nStandardNames.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StandardNames.kt\norg/jetbrains/kotlin/builtins/StandardNames$FqNames\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,302:1\n11400#2,3:303\n11400#2,3:306\n*S KotlinDebug\n*F\n+ 1 StandardNames.kt\norg/jetbrains/kotlin/builtins/StandardNames$FqNames\n*L\n198#1:303,3\n202#1:306,3\n*E\n"})
    public static final class FqNames {
        public static final FqNames INSTANCE;
        @JvmField
        public static final FqNameUnsafe any;
        @JvmField
        public static final FqNameUnsafe nothing;
        @JvmField
        public static final FqNameUnsafe cloneable;
        @JvmField
        public static final FqName suppress;
        @JvmField
        public static final FqNameUnsafe unit;
        @JvmField
        public static final FqNameUnsafe charSequence;
        @JvmField
        public static final FqNameUnsafe string;
        @JvmField
        public static final FqNameUnsafe array;
        @JvmField
        public static final FqNameUnsafe _boolean;
        @JvmField
        public static final FqNameUnsafe _char;
        @JvmField
        public static final FqNameUnsafe _byte;
        @JvmField
        public static final FqNameUnsafe _short;
        @JvmField
        public static final FqNameUnsafe _int;
        @JvmField
        public static final FqNameUnsafe _long;
        @JvmField
        public static final FqNameUnsafe _float;
        @JvmField
        public static final FqNameUnsafe _double;
        @JvmField
        public static final FqNameUnsafe number;
        @JvmField
        public static final FqNameUnsafe _enum;
        @JvmField
        public static final FqNameUnsafe functionSupertype;
        @JvmField
        public static final FqName throwable;
        @JvmField
        public static final FqName comparable;
        @JvmField
        public static final FqNameUnsafe intRange;
        @JvmField
        public static final FqNameUnsafe longRange;
        @JvmField
        public static final FqName deprecated;
        @JvmField
        public static final FqName deprecatedSinceKotlin;
        @JvmField
        public static final FqName deprecationLevel;
        @JvmField
        public static final FqName replaceWith;
        @JvmField
        public static final FqName extensionFunctionType;
        @JvmField
        public static final FqName contextFunctionTypeParams;
        @JvmField
        public static final FqName parameterName;
        @JvmField
        public static final ClassId parameterNameClassId;
        @JvmField
        public static final FqName annotation;
        @JvmField
        public static final FqName target;
        @JvmField
        public static final ClassId targetClassId;
        @JvmField
        public static final FqName annotationTarget;
        @JvmField
        public static final FqName annotationRetention;
        @JvmField
        public static final FqName retention;
        @JvmField
        public static final ClassId retentionClassId;
        @JvmField
        public static final FqName repeatable;
        @JvmField
        public static final ClassId repeatableClassId;
        @JvmField
        public static final FqName mustBeDocumented;
        @JvmField
        public static final FqName unsafeVariance;
        @JvmField
        public static final FqName publishedApi;
        @JvmField
        public static final FqName accessibleLateinitPropertyLiteral;
        @JvmField
        public static final FqName iterator;
        @JvmField
        public static final FqName iterable;
        @JvmField
        public static final FqName collection;
        @JvmField
        public static final FqName list;
        @JvmField
        public static final FqName listIterator;
        @JvmField
        public static final FqName set;
        @JvmField
        public static final FqName map;
        @JvmField
        public static final FqName mapEntry;
        @JvmField
        public static final FqName mutableIterator;
        @JvmField
        public static final FqName mutableIterable;
        @JvmField
        public static final FqName mutableCollection;
        @JvmField
        public static final FqName mutableList;
        @JvmField
        public static final FqName mutableListIterator;
        @JvmField
        public static final FqName mutableSet;
        @JvmField
        public static final FqName mutableMap;
        @JvmField
        public static final FqName mutableMapEntry;
        @JvmField
        public static final FqNameUnsafe kClass;
        @JvmField
        public static final FqNameUnsafe kType;
        @JvmField
        public static final FqNameUnsafe kCallable;
        @JvmField
        public static final FqNameUnsafe kProperty0;
        @JvmField
        public static final FqNameUnsafe kProperty1;
        @JvmField
        public static final FqNameUnsafe kProperty2;
        @JvmField
        public static final FqNameUnsafe kMutableProperty0;
        @JvmField
        public static final FqNameUnsafe kMutableProperty1;
        @JvmField
        public static final FqNameUnsafe kMutableProperty2;
        @JvmField
        public static final FqNameUnsafe kPropertyFqName;
        @JvmField
        public static final FqNameUnsafe kMutablePropertyFqName;
        @JvmField
        public static final ClassId kProperty;
        @JvmField
        public static final FqNameUnsafe kDeclarationContainer;
        @JvmField
        public static final FqName uByteFqName;
        @JvmField
        public static final FqName uShortFqName;
        @JvmField
        public static final FqName uIntFqName;
        @JvmField
        public static final FqName uLongFqName;
        @JvmField
        public static final ClassId uByte;
        @JvmField
        public static final ClassId uShort;
        @JvmField
        public static final ClassId uInt;
        @JvmField
        public static final ClassId uLong;
        @JvmField
        public static final FqName uByteArrayFqName;
        @JvmField
        public static final FqName uShortArrayFqName;
        @JvmField
        public static final FqName uIntArrayFqName;
        @JvmField
        public static final FqName uLongArrayFqName;
        @JvmField
        public static final Set<Name> primitiveTypeShortNames;
        @JvmField
        public static final Set<Name> primitiveArrayTypeShortNames;
        @JvmField
        public static final Map<FqNameUnsafe, PrimitiveType> fqNameToPrimitiveType;
        @JvmField
        public static final Map<FqNameUnsafe, PrimitiveType> arrayClassFqNameToPrimitiveType;

        private FqNames() {
        }

        /*
         * WARNING - void declaration
         */
        private final FqNameUnsafe fqNameUnsafe(String simpleName2) {
            void var1_1;
            FqNameUnsafe fqNameUnsafe = this.fqName((String)var1_1).toUnsafe();
            Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"toUnsafe(...)");
            return fqNameUnsafe;
        }

        /*
         * WARNING - void declaration
         */
        private final FqName fqName(String simpleName2) {
            void var1_1;
            FqName fqName2 = BUILT_INS_PACKAGE_FQ_NAME.child(Name.identifier((String)var1_1));
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"child(...)");
            return fqName2;
        }

        /*
         * WARNING - void declaration
         */
        private final FqName collectionsFqName(String simpleName2) {
            void var1_1;
            FqName fqName2 = COLLECTIONS_PACKAGE_FQ_NAME.child(Name.identifier((String)var1_1));
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"child(...)");
            return fqName2;
        }

        /*
         * WARNING - void declaration
         */
        private final FqNameUnsafe rangesFqName(String simpleName2) {
            void var1_1;
            FqNameUnsafe fqNameUnsafe = RANGES_PACKAGE_FQ_NAME.child(Name.identifier((String)var1_1)).toUnsafe();
            Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"toUnsafe(...)");
            return fqNameUnsafe;
        }

        @JvmStatic
        public static final FqNameUnsafe reflect(String simpleName2) {
            String string;
            Intrinsics.checkNotNullParameter((Object)simpleName2, (String)"simpleName");
            FqNameUnsafe fqNameUnsafe = KOTLIN_REFLECT_FQ_NAME.child(Name.identifier(string)).toUnsafe();
            Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"toUnsafe(...)");
            return fqNameUnsafe;
        }

        /*
         * WARNING - void declaration
         */
        private final FqName annotationName(String simpleName2) {
            void var1_1;
            FqName fqName2 = ANNOTATION_PACKAGE_FQ_NAME.child(Name.identifier((String)var1_1));
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"child(...)");
            return fqName2;
        }

        /*
         * WARNING - void declaration
         */
        private final FqName internalName(String simpleName2) {
            void var1_1;
            FqName fqName2 = KOTLIN_INTERNAL_FQ_NAME.child(Name.identifier((String)var1_1));
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"child(...)");
            return fqName2;
        }

        static {
            Object object;
            Object it;
            PrimitiveType primitiveType;
            Object item$iv;
            int n;
            Cloneable cloneable2;
            INSTANCE = new FqNames();
            any = INSTANCE.fqNameUnsafe("Any");
            nothing = INSTANCE.fqNameUnsafe("Nothing");
            cloneable = INSTANCE.fqNameUnsafe("Cloneable");
            suppress = INSTANCE.fqName("Suppress");
            unit = INSTANCE.fqNameUnsafe("Unit");
            charSequence = INSTANCE.fqNameUnsafe("CharSequence");
            string = INSTANCE.fqNameUnsafe("String");
            array = INSTANCE.fqNameUnsafe("Array");
            _boolean = INSTANCE.fqNameUnsafe("Boolean");
            _char = INSTANCE.fqNameUnsafe("Char");
            _byte = INSTANCE.fqNameUnsafe("Byte");
            _short = INSTANCE.fqNameUnsafe("Short");
            _int = INSTANCE.fqNameUnsafe("Int");
            _long = INSTANCE.fqNameUnsafe("Long");
            _float = INSTANCE.fqNameUnsafe("Float");
            _double = INSTANCE.fqNameUnsafe("Double");
            number = INSTANCE.fqNameUnsafe("Number");
            _enum = INSTANCE.fqNameUnsafe("Enum");
            functionSupertype = INSTANCE.fqNameUnsafe("Function");
            throwable = INSTANCE.fqName("Throwable");
            comparable = INSTANCE.fqName("Comparable");
            intRange = INSTANCE.rangesFqName("IntRange");
            longRange = INSTANCE.rangesFqName("LongRange");
            deprecated = INSTANCE.fqName("Deprecated");
            deprecatedSinceKotlin = INSTANCE.fqName("DeprecatedSinceKotlin");
            deprecationLevel = INSTANCE.fqName("DeprecationLevel");
            replaceWith = INSTANCE.fqName("ReplaceWith");
            extensionFunctionType = INSTANCE.fqName("ExtensionFunctionType");
            contextFunctionTypeParams = INSTANCE.fqName("ContextFunctionTypeParams");
            parameterName = INSTANCE.fqName("ParameterName");
            ClassId classId = ClassId.topLevel(parameterName);
            Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(...)");
            parameterNameClassId = classId;
            annotation = INSTANCE.fqName("Annotation");
            target = INSTANCE.annotationName("Target");
            ClassId classId2 = ClassId.topLevel(target);
            Intrinsics.checkNotNullExpressionValue((Object)classId2, (String)"topLevel(...)");
            targetClassId = classId2;
            annotationTarget = INSTANCE.annotationName("AnnotationTarget");
            annotationRetention = INSTANCE.annotationName("AnnotationRetention");
            retention = INSTANCE.annotationName("Retention");
            ClassId classId3 = ClassId.topLevel(retention);
            Intrinsics.checkNotNullExpressionValue((Object)classId3, (String)"topLevel(...)");
            retentionClassId = classId3;
            repeatable = INSTANCE.annotationName("Repeatable");
            ClassId classId4 = ClassId.topLevel(repeatable);
            Intrinsics.checkNotNullExpressionValue((Object)classId4, (String)"topLevel(...)");
            repeatableClassId = classId4;
            mustBeDocumented = INSTANCE.annotationName("MustBeDocumented");
            unsafeVariance = INSTANCE.fqName("UnsafeVariance");
            publishedApi = INSTANCE.fqName("PublishedApi");
            accessibleLateinitPropertyLiteral = INSTANCE.internalName("AccessibleLateinitPropertyLiteral");
            iterator = INSTANCE.collectionsFqName("Iterator");
            iterable = INSTANCE.collectionsFqName("Iterable");
            collection = INSTANCE.collectionsFqName("Collection");
            list = INSTANCE.collectionsFqName("List");
            listIterator = INSTANCE.collectionsFqName("ListIterator");
            set = INSTANCE.collectionsFqName("Set");
            map = INSTANCE.collectionsFqName("Map");
            FqName fqName2 = map.child(Name.identifier("Entry"));
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"child(...)");
            mapEntry = fqName2;
            mutableIterator = INSTANCE.collectionsFqName("MutableIterator");
            mutableIterable = INSTANCE.collectionsFqName("MutableIterable");
            mutableCollection = INSTANCE.collectionsFqName("MutableCollection");
            mutableList = INSTANCE.collectionsFqName("MutableList");
            mutableListIterator = INSTANCE.collectionsFqName("MutableListIterator");
            mutableSet = INSTANCE.collectionsFqName("MutableSet");
            mutableMap = INSTANCE.collectionsFqName("MutableMap");
            FqName fqName3 = mutableMap.child(Name.identifier("MutableEntry"));
            Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"child(...)");
            mutableMapEntry = fqName3;
            kClass = FqNames.reflect("KClass");
            kType = FqNames.reflect("KType");
            kCallable = FqNames.reflect("KCallable");
            kProperty0 = FqNames.reflect("KProperty0");
            kProperty1 = FqNames.reflect("KProperty1");
            kProperty2 = FqNames.reflect("KProperty2");
            kMutableProperty0 = FqNames.reflect("KMutableProperty0");
            kMutableProperty1 = FqNames.reflect("KMutableProperty1");
            kMutableProperty2 = FqNames.reflect("KMutableProperty2");
            kPropertyFqName = FqNames.reflect("KProperty");
            kMutablePropertyFqName = FqNames.reflect("KMutableProperty");
            ClassId classId5 = ClassId.topLevel(kPropertyFqName.toSafe());
            Intrinsics.checkNotNullExpressionValue((Object)classId5, (String)"topLevel(...)");
            kProperty = classId5;
            kDeclarationContainer = FqNames.reflect("KDeclarationContainer");
            uByteFqName = INSTANCE.fqName("UByte");
            uShortFqName = INSTANCE.fqName("UShort");
            uIntFqName = INSTANCE.fqName("UInt");
            uLongFqName = INSTANCE.fqName("ULong");
            ClassId classId6 = ClassId.topLevel(uByteFqName);
            Intrinsics.checkNotNullExpressionValue((Object)classId6, (String)"topLevel(...)");
            uByte = classId6;
            ClassId classId7 = ClassId.topLevel(uShortFqName);
            Intrinsics.checkNotNullExpressionValue((Object)classId7, (String)"topLevel(...)");
            uShort = classId7;
            ClassId classId8 = ClassId.topLevel(uIntFqName);
            Intrinsics.checkNotNullExpressionValue((Object)classId8, (String)"topLevel(...)");
            uInt = classId8;
            ClassId classId9 = ClassId.topLevel(uLongFqName);
            Intrinsics.checkNotNullExpressionValue((Object)classId9, (String)"topLevel(...)");
            uLong = classId9;
            uByteArrayFqName = INSTANCE.fqName("UByteArray");
            uShortArrayFqName = INSTANCE.fqName("UShortArray");
            uIntArrayFqName = INSTANCE.fqName("UIntArray");
            uLongArrayFqName = INSTANCE.fqName("ULongArray");
            HashSet $this$primitiveTypeShortNames_u24lambda_u241 = cloneable2 = CollectionsKt.newHashSetWithExpectedSize(PrimitiveType.values().length);
            PrimitiveType[] $this$mapTo$iv = PrimitiveType.values();
            int n2 = $this$mapTo$iv.length;
            for (n = 0; n < n2; ++n) {
                primitiveType = item$iv = $this$mapTo$iv[n];
                item$iv = $this$primitiveTypeShortNames_u24lambda_u241;
                item$iv.add(it.getTypeName());
            }
            primitiveTypeShortNames = cloneable2;
            cloneable2 = CollectionsKt.newHashSetWithExpectedSize(PrimitiveType.values().length);
            HashSet $this$primitiveArrayTypeShortNames_u24lambda_u243 = cloneable2;
            $this$mapTo$iv = PrimitiveType.values();
            n2 = $this$mapTo$iv.length;
            for (n = 0; n < n2; ++n) {
                it = item$iv = $this$mapTo$iv[n];
                object = $this$primitiveArrayTypeShortNames_u24lambda_u243;
                object.add(primitiveType.getArrayTypeName());
            }
            primitiveArrayTypeShortNames = cloneable2;
            cloneable2 = CollectionsKt.newHashMapWithExpectedSize(PrimitiveType.values().length);
            HashMap $this$fqNameToPrimitiveType_u24lambda_u244 = cloneable2;
            for (PrimitiveType primitiveType2 : PrimitiveType.values()) {
                object = $this$fqNameToPrimitiveType_u24lambda_u244;
                String string = primitiveType2.getTypeName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                object.put(INSTANCE.fqNameUnsafe(string), primitiveType2);
            }
            fqNameToPrimitiveType = (Map)((Object)cloneable2);
            cloneable2 = CollectionsKt.newHashMapWithExpectedSize(PrimitiveType.values().length);
            HashMap $this$arrayClassFqNameToPrimitiveType_u24lambda_u245 = cloneable2;
            for (PrimitiveType primitiveType3 : PrimitiveType.values()) {
                object = $this$arrayClassFqNameToPrimitiveType_u24lambda_u245;
                String string = primitiveType3.getArrayTypeName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                object.put(INSTANCE.fqNameUnsafe(string), primitiveType3);
            }
            arrayClassFqNameToPrimitiveType = (Map)((Object)cloneable2);
        }
    }
}

