/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionTypeKind;
import kotlin.reflect.jvm.internal.impl.builtins.functions.FunctionTypeKindExtractor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.BuiltInAnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.IntValue;
import kotlin.reflect.jvm.internal.impl.resolve.constants.StringValue;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributesKt;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

@SourceDebugExtension(value={"SMAP\nfunctionTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 functionTypes.kt\norg/jetbrains/kotlin/builtins/FunctionTypesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,301:1\n1#2:302\n1549#3:303\n1620#3,3:304\n223#3,2:307\n1549#3:309\n1620#3,3:310\n1549#3:313\n1620#3,3:314\n1590#3,4:317\n*S KotlinDebug\n*F\n+ 1 functionTypes.kt\norg/jetbrains/kotlin/builtins/FunctionTypesKt\n*L\n160#1:303\n160#1:304,3\n195#1:307,2\n200#1:309\n200#1:310,3\n222#1:313\n222#1:314,3\n225#1:317,4\n*E\n"})
public final class FunctionTypesKt {
    public static final FunctionTypeKind getFunctionTypeKind(KotlinType $this$functionTypeKind) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$functionTypeKind, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor != null) {
            return FunctionTypesKt.getFunctionTypeKind(classifierDescriptor);
        }
        return null;
    }

    public static final boolean isFunctionType(KotlinType $this$isFunctionType) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionType, (String)"<this>");
        return Intrinsics.areEqual((Object)FunctionTypesKt.getFunctionTypeKind(kotlinType), (Object)FunctionTypeKind.Function.INSTANCE);
    }

    public static final boolean isSuspendFunctionType(KotlinType $this$isSuspendFunctionType) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$isSuspendFunctionType, (String)"<this>");
        return Intrinsics.areEqual((Object)FunctionTypesKt.getFunctionTypeKind(kotlinType), (Object)FunctionTypeKind.SuspendFunction.INSTANCE);
    }

    public static final boolean isBuiltinFunctionalType(KotlinType $this$isBuiltinFunctionalType) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$isBuiltinFunctionalType, (String)"<this>");
        ClassifierDescriptor classifierDescriptor = kotlinType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor != null) {
            return FunctionTypesKt.isBuiltinFunctionalClassDescriptor(classifierDescriptor);
        }
        return false;
    }

    public static final boolean isBuiltinFunctionalClassDescriptor(DeclarationDescriptor $this$isBuiltinFunctionalClassDescriptor) {
        FunctionTypeKind functionTypeKind;
        Intrinsics.checkNotNullParameter((Object)$this$isBuiltinFunctionalClassDescriptor, (String)"<this>");
        FunctionTypeKind functionalClassKind = FunctionTypesKt.getFunctionTypeKind($this$isBuiltinFunctionalClassDescriptor);
        return Intrinsics.areEqual((Object)functionalClassKind, (Object)FunctionTypeKind.Function.INSTANCE) || Intrinsics.areEqual((Object)functionTypeKind, (Object)FunctionTypeKind.SuspendFunction.INSTANCE);
    }

    public static final boolean isBuiltinExtensionFunctionalType(KotlinType $this$isBuiltinExtensionFunctionalType) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$isBuiltinExtensionFunctionalType, (String)"<this>");
        return FunctionTypesKt.isBuiltinFunctionalType($this$isBuiltinExtensionFunctionalType) && FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType(kotlinType);
    }

    private static final boolean isTypeAnnotatedWithExtensionFunctionType(KotlinType $this$isTypeAnnotatedWithExtensionFunctionType) {
        return $this$isTypeAnnotatedWithExtensionFunctionType.getAnnotations().findAnnotation(StandardNames.FqNames.extensionFunctionType) != null;
    }

    public static final FunctionTypeKind getFunctionTypeKind(DeclarationDescriptor $this$getFunctionTypeKind) {
        DeclarationDescriptor declarationDescriptor;
        Intrinsics.checkNotNullParameter((Object)$this$getFunctionTypeKind, (String)"<this>");
        if (!($this$getFunctionTypeKind instanceof ClassDescriptor)) {
            return null;
        }
        if (!KotlinBuiltIns.isUnderKotlinPackage($this$getFunctionTypeKind)) {
            return null;
        }
        return FunctionTypesKt.getFunctionTypeKind(DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor));
    }

    private static final FunctionTypeKind getFunctionTypeKind(FqNameUnsafe $this$getFunctionTypeKind) {
        FqNameUnsafe fqNameUnsafe;
        if (!$this$getFunctionTypeKind.isSafe() || $this$getFunctionTypeKind.isRoot()) {
            return null;
        }
        FunctionTypeKindExtractor functionTypeKindExtractor = FunctionTypeKindExtractor.Companion.getDefault();
        FqName fqName2 = $this$getFunctionTypeKind.toSafe().parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"parent(...)");
        String string = fqNameUnsafe.shortName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return functionTypeKindExtractor.getFunctionalClassKind(fqName2, string);
    }

    public static final int contextFunctionTypeParamsCount(KotlinType $this$contextFunctionTypeParamsCount) {
        ConstantValue constantValue;
        Intrinsics.checkNotNullParameter((Object)$this$contextFunctionTypeParamsCount, (String)"<this>");
        AnnotationDescriptor annotationDescriptor = ((KotlinType)$this$contextFunctionTypeParamsCount).getAnnotations().findAnnotation(StandardNames.FqNames.contextFunctionTypeParams);
        if (annotationDescriptor == null) {
            return 0;
        }
        $this$contextFunctionTypeParamsCount = annotationDescriptor;
        ConstantValue constantValue2 = (ConstantValue)MapsKt.getValue(annotationDescriptor.getAllValueArguments(), (Object)StandardNames.CONTEXT_FUNCTION_TYPE_PARAMETER_COUNT_NAME);
        Intrinsics.checkNotNull((Object)constantValue2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.resolve.constants.IntValue");
        return ((Number)((IntValue)constantValue).getValue()).intValue();
    }

    public static final KotlinType getReceiverTypeFromFunctionType(KotlinType $this$getReceiverTypeFromFunctionType) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$getReceiverTypeFromFunctionType, (String)"<this>");
        boolean n = FunctionTypesKt.isBuiltinFunctionalType((KotlinType)$this$getReceiverTypeFromFunctionType);
        if (_Assertions.ENABLED && !n) {
            $this$getReceiverTypeFromFunctionType = "Not a function type: " + $this$getReceiverTypeFromFunctionType;
            throw new AssertionError($this$getReceiverTypeFromFunctionType);
        }
        if (!FunctionTypesKt.isTypeAnnotatedWithExtensionFunctionType((KotlinType)$this$getReceiverTypeFromFunctionType)) {
            return null;
        }
        int n2 = FunctionTypesKt.contextFunctionTypeParamsCount((KotlinType)$this$getReceiverTypeFromFunctionType);
        return kotlinType.getArguments().get(n2).getType();
    }

    /*
     * WARNING - void declaration
     */
    public static final List<KotlinType> getContextReceiverTypesFromFunctionType(KotlinType $this$getContextReceiverTypesFromFunctionType) {
        Collection collection;
        Iterator iterator2;
        Intrinsics.checkNotNullParameter((Object)$this$getContextReceiverTypesFromFunctionType, (String)"<this>");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType((KotlinType)$this$getContextReceiverTypesFromFunctionType);
        if (_Assertions.ENABLED && !bl) {
            $this$getContextReceiverTypesFromFunctionType = "Not a function type: " + $this$getContextReceiverTypesFromFunctionType;
            throw new AssertionError($this$getContextReceiverTypesFromFunctionType);
        }
        int contextReceiversCount22 = FunctionTypesKt.contextFunctionTypeParamsCount((KotlinType)$this$getContextReceiverTypesFromFunctionType);
        if (contextReceiversCount22 == 0) {
            return CollectionsKt.emptyList();
        }
        Collection $this$map$iv = ((KotlinType)$this$getContextReceiverTypesFromFunctionType).getArguments().subList(0, contextReceiversCount22);
        Iterable contextReceiversCount22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            void var2_3;
            Object item$iv$iv = iterator2.next();
            TypeProjection it = (TypeProjection)item$iv$iv;
            Collection collection2 = destination$iv$iv;
            KotlinType kotlinType = var2_3.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            collection2.add(kotlinType);
        }
        return (List)collection;
    }

    public static final KotlinType getReturnTypeFromFunctionType(KotlinType $this$getReturnTypeFromFunctionType) {
        KotlinType kotlinType;
        Intrinsics.checkNotNullParameter((Object)$this$getReturnTypeFromFunctionType, (String)"<this>");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType((KotlinType)$this$getReturnTypeFromFunctionType);
        if (_Assertions.ENABLED && !bl) {
            $this$getReturnTypeFromFunctionType = "Not a function type: " + $this$getReturnTypeFromFunctionType;
            throw new AssertionError($this$getReturnTypeFromFunctionType);
        }
        KotlinType kotlinType2 = ((TypeProjection)CollectionsKt.last(kotlinType.getArguments())).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"getType(...)");
        return kotlinType2;
    }

    /*
     * WARNING - void declaration
     */
    public static final List<TypeProjection> getValueParameterTypesFromFunctionType(KotlinType $this$getValueParameterTypesFromFunctionType) {
        void var3_5;
        void var2_4;
        void var1_2;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$getValueParameterTypesFromFunctionType, (String)"<this>");
        boolean bl2 = FunctionTypesKt.isBuiltinFunctionalType($this$getValueParameterTypesFromFunctionType);
        if (_Assertions.ENABLED && !bl2) {
            String string = "Not a function type: " + $this$getValueParameterTypesFromFunctionType;
            throw new AssertionError((Object)string);
        }
        List<TypeProjection> arguments2 = $this$getValueParameterTypesFromFunctionType.getArguments();
        int first = FunctionTypesKt.contextFunctionTypeParamsCount($this$getValueParameterTypesFromFunctionType) + (FunctionTypesKt.isBuiltinExtensionFunctionalType($this$getValueParameterTypesFromFunctionType) ? 1 : 0);
        int last = arguments2.size() - 1;
        boolean bl3 = bl = first <= last;
        if (_Assertions.ENABLED && !bl) {
            String string;
            string = "Not an exact function type: " + string;
            throw new AssertionError((Object)string);
        }
        return var1_2.subList((int)var2_4, (int)var3_5);
    }

    public static final Name extractParameterNameFromFunctionTypeArgument(KotlinType $this$extractParameterNameFromFunctionTypeArgument) {
        Object object;
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)$this$extractParameterNameFromFunctionTypeArgument, (String)"<this>");
                AnnotationDescriptor annotationDescriptor = ((KotlinType)object).getAnnotations().findAnnotation(StandardNames.FqNames.parameterName);
                if (annotationDescriptor == null) {
                    return null;
                }
                object = annotationDescriptor;
                object = CollectionsKt.singleOrNull((Iterable)annotationDescriptor.getAllValueArguments().values());
                object = object instanceof StringValue ? (StringValue)object : null;
                if (object == null || (object = (String)((ConstantValue)object).getValue()) == null) break block4;
                Object object2 = object;
                if ((object = Name.isValidIdentifier((String)object) ? object : null) != null) break block5;
            }
            return null;
        }
        return Name.identifier((String)object);
    }

    /*
     * WARNING - void declaration
     */
    public static final List<TypeProjection> getFunctionTypeArgumentProjections(KotlinType receiverType, List<? extends KotlinType> contextReceiverTypes, List<? extends KotlinType> parameterTypes, List<Name> parameterNames, KotlinType returnType, KotlinBuiltIns builtIns2) {
        Iterator iterator2;
        List<Name> list;
        Collection $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(contextReceiverTypes, (String)"contextReceiverTypes");
        Intrinsics.checkNotNullParameter(parameterTypes, (String)"parameterTypes");
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        Intrinsics.checkNotNullParameter((Object)builtIns2, (String)"builtIns");
        ArrayList<TypeProjection> arguments2 = new ArrayList<TypeProjection>(parameterTypes.size() + contextReceiverTypes.size() + (receiverType != null ? 1 : 0) + 1);
        contextReceiverTypes = contextReceiverTypes;
        Collection<TypeProjection> collection = arguments2;
        void var7_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KotlinType kotlinType = (KotlinType)item$iv$iv;
            $this$mapTo$iv$iv = destination$iv$iv;
            $this$mapTo$iv$iv.add(TypeUtilsKt.asTypeProjection((KotlinType)it));
        }
        ((ArrayList)collection).addAll((List)destination$iv$iv);
        KotlinType kotlinType = receiverType;
        kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.addIfNotNull((Collection)arguments2, kotlinType != null ? TypeUtilsKt.asTypeProjection(kotlinType) : null);
        Iterable $this$mapIndexedTo$iv = list;
        int index$iv = 0;
        iterator2 = iterator2.iterator();
        while (iterator2.hasNext()) {
            KotlinType kotlinType2;
            BuiltInAnnotationDescriptor builtInAnnotationDescriptor;
            void type2;
            BuiltInAnnotationDescriptor name;
            BuiltInAnnotationDescriptor builtInAnnotationDescriptor2;
            void index;
            int n;
            Object item$iv$iv;
            BuiltInAnnotationDescriptor item$iv = iterator2.next();
            Collection collection2 = arguments2;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            item$iv$iv = item$iv;
            int it = n;
            collection = collection2;
            List<Name> list2 = parameterNames;
            if (list2 != null && (list2 = list2.get((int)index)) != null) {
                item$iv = list2;
                list = list2;
                builtInAnnotationDescriptor2 = !((Name)((Object)list2)).isSpecial() ? item$iv : null;
            } else {
                builtInAnnotationDescriptor2 = name = null;
            }
            if (builtInAnnotationDescriptor2 != null) {
                String string = ((Name)((Object)name)).asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                BuiltInAnnotationDescriptor parameterNameAnnotation = new BuiltInAnnotationDescriptor(builtIns2, StandardNames.FqNames.parameterName, MapsKt.mapOf((Pair)TuplesKt.to((Object)StandardNames.NAME, (Object)new StringValue(string))), false, 8, null);
                kotlinType2 = TypeUtilsKt.replaceAnnotations((KotlinType)type2, Annotations.Companion.create(CollectionsKt.plus((Iterable)type2.getAnnotations(), (Object)builtInAnnotationDescriptor)));
            } else {
                kotlinType2 = type2;
            }
            builtInAnnotationDescriptor = kotlinType2;
            collection.add(TypeUtilsKt.asTypeProjection(kotlinType2));
        }
        arguments2.add(TypeUtilsKt.asTypeProjection(returnType));
        return arguments2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public static final SimpleType createFunctionType(KotlinBuiltIns builtIns2, Annotations annotations2, KotlinType receiverType, List<? extends KotlinType> contextReceiverTypes, List<? extends KotlinType> parameterTypes, List<Name> parameterNames, KotlinType returnType, boolean suspendFunction) {
        void var1_1;
        Annotations typeAnnotations;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)builtIns2, (String)"builtIns");
        Intrinsics.checkNotNullParameter((Object)annotations2, (String)"annotations");
        Intrinsics.checkNotNullParameter(contextReceiverTypes, (String)"contextReceiverTypes");
        Intrinsics.checkNotNullParameter(parameterTypes, (String)"parameterTypes");
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        List<TypeProjection> arguments2 = FunctionTypesKt.getFunctionTypeArgumentProjections(receiverType, contextReceiverTypes, parameterTypes, parameterNames, returnType, builtIns2);
        int parameterCount = parameterTypes.size() + contextReceiverTypes.size() + (receiverType == null ? 0 : 1);
        ClassDescriptor classDescriptor = FunctionTypesKt.getFunctionDescriptor(builtIns2, parameterCount, suspendFunction);
        if (var2_2 != null) {
            typeAnnotations = FunctionTypesKt.withExtensionFunctionAnnotation(typeAnnotations, builtIns2);
        }
        if (!((Collection)contextReceiverTypes).isEmpty()) {
            void var3_3;
            KotlinBuiltIns kotlinBuiltIns;
            typeAnnotations = FunctionTypesKt.withContextReceiversFunctionAnnotation(typeAnnotations, kotlinBuiltIns, var3_3.size());
        }
        return KotlinTypeFactory.simpleNotNullType(TypeAttributesKt.toDefaultAttributes((Annotations)var1_1), classDescriptor, arguments2);
    }

    public static /* synthetic */ SimpleType createFunctionType$default(KotlinBuiltIns kotlinBuiltIns, Annotations annotations2, KotlinType kotlinType, List list, List list2, List list3, KotlinType kotlinType2, boolean bl, int n, Object object) {
        if ((n & 0x80) != 0) {
            bl = false;
        }
        return FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType, list, list2, list3, kotlinType2, bl);
    }

    /*
     * WARNING - void declaration
     */
    public static final Annotations withExtensionFunctionAnnotation(Annotations $this$withExtensionFunctionAnnotation, KotlinBuiltIns builtIns2) {
        void var1_1;
        Annotations annotations2;
        Intrinsics.checkNotNullParameter((Object)$this$withExtensionFunctionAnnotation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)builtIns2, (String)"builtIns");
        if ($this$withExtensionFunctionAnnotation.hasAnnotation(StandardNames.FqNames.extensionFunctionType)) {
            return $this$withExtensionFunctionAnnotation;
        }
        return Annotations.Companion.create(CollectionsKt.plus((Iterable)annotations2, (Object)new BuiltInAnnotationDescriptor((KotlinBuiltIns)var1_1, StandardNames.FqNames.extensionFunctionType, MapsKt.emptyMap(), false, 8, null)));
    }

    /*
     * WARNING - void declaration
     */
    public static final Annotations withContextReceiversFunctionAnnotation(Annotations $this$withContextReceiversFunctionAnnotation, KotlinBuiltIns builtIns2, int contextReceiversCount) {
        void var2_2;
        void var1_1;
        Annotations annotations2;
        Intrinsics.checkNotNullParameter((Object)$this$withContextReceiversFunctionAnnotation, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)builtIns2, (String)"builtIns");
        if ($this$withContextReceiversFunctionAnnotation.hasAnnotation(StandardNames.FqNames.contextFunctionTypeParams)) {
            return $this$withContextReceiversFunctionAnnotation;
        }
        return Annotations.Companion.create(CollectionsKt.plus((Iterable)annotations2, (Object)new BuiltInAnnotationDescriptor((KotlinBuiltIns)var1_1, StandardNames.FqNames.contextFunctionTypeParams, MapsKt.mapOf((Pair)TuplesKt.to((Object)StandardNames.CONTEXT_FUNCTION_TYPE_PARAMETER_COUNT_NAME, (Object)new IntValue((int)var2_2))), false, 8, null)));
    }

    /*
     * WARNING - void declaration
     */
    public static final ClassDescriptor getFunctionDescriptor(KotlinBuiltIns builtIns2, int parameterCount, boolean isSuspendFunction) {
        void var1_1;
        ClassDescriptor classDescriptor;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)builtIns2, (String)"builtIns");
        classDescriptor = var2_2 != false ? builtIns2.getSuspendFunction(parameterCount) : ((KotlinBuiltIns)((Object)classDescriptor)).getFunction((int)var1_1);
        Intrinsics.checkNotNull((Object)classDescriptor);
        return classDescriptor;
    }
}

