/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.slf4j;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.MarkerManager;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.slf4j.Log4jMarker;
import org.slf4j.IMarkerFactory;
import org.slf4j.Marker;

public class Log4jMarkerFactory
implements IMarkerFactory {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final ConcurrentMap<String, Marker> markerMap = new ConcurrentHashMap<String, Marker>();

    /*
     * WARNING - void declaration
     */
    public Marker getMarker(String name) {
        void var2_2;
        void var1_1;
        if (name == null) {
            throw new IllegalArgumentException("Marker name must not be null");
        }
        Marker marker = (Marker)this.markerMap.get(name);
        if (marker != null) {
            return marker;
        }
        org.apache.logging.log4j.Marker log4jMarker = MarkerManager.getMarker((String)name);
        return this.addMarkerIfAbsent((String)var1_1, (org.apache.logging.log4j.Marker)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private Marker addMarkerIfAbsent(String name, org.apache.logging.log4j.Marker log4jMarker) {
        void var1_1;
        Log4jMarker marker = new Log4jMarker(this, log4jMarker);
        Marker existing = this.markerMap.putIfAbsent(name, marker);
        if (existing == null) {
            void var2_2;
            return var2_2;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Marker getMarker(Marker marker) {
        void var1_1;
        if (marker == null) {
            throw new IllegalArgumentException("Marker must not be null");
        }
        Marker m = (Marker)this.markerMap.get(marker.getName());
        if (m != null) {
            void var2_2;
            return var2_2;
        }
        return this.addMarkerIfAbsent(marker.getName(), Log4jMarkerFactory.convertMarker((Marker)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    org.apache.logging.log4j.Marker getLog4jMarker(Marker marker) {
        void var1_1;
        if (marker == null) {
            return null;
        }
        if (marker instanceof Log4jMarker) {
            return ((Log4jMarker)marker).getLog4jMarker();
        }
        return ((Log4jMarker)this.getMarker((Marker)var1_1)).getLog4jMarker();
    }

    static org.apache.logging.log4j.Marker convertMarker(Marker original) {
        Marker marker;
        if (original == null) {
            throw new IllegalArgumentException("Marker must not be null");
        }
        return Log4jMarkerFactory.convertMarker(marker, new ArrayList<Marker>());
    }

    /*
     * WARNING - void declaration
     */
    private static org.apache.logging.log4j.Marker convertMarker(Marker original, Collection<Marker> visited) {
        void var2_2;
        org.apache.logging.log4j.Marker marker = MarkerManager.getMarker((String)original.getName());
        if (original.hasReferences()) {
            for (Marker next : original) {
                void var3_3;
                if (visited.contains(next)) {
                    LOGGER.warn("Found a cycle in Marker [{}]. Cycle will be broken.", (Object)next.getName());
                    continue;
                }
                visited.add(next);
                marker.addParents(new org.apache.logging.log4j.Marker[]{Log4jMarkerFactory.convertMarker((Marker)var3_3, visited)});
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean exists(String name) {
        void var1_1;
        return this.markerMap.containsKey(var1_1);
    }

    public boolean detachMarker(String name) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public Marker getDetachedMarker(String name) {
        void var1_1;
        LOGGER.warn("Log4j does not support detached Markers. Returned Marker [{}] will be unchanged.", (Object)name);
        return this.getMarker((String)var1_1);
    }
}

