/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.slf4j;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.status.StatusLogger;
import org.slf4j.spi.MDCAdapter;

public class Log4jMDCAdapter
implements MDCAdapter {
    private static Logger LOGGER = StatusLogger.getLogger();
    private final ThreadLocalMapOfStacks mapOfStacks = new ThreadLocalMapOfStacks();

    /*
     * WARNING - void declaration
     */
    public void put(String key, String val) {
        void var2_2;
        ThreadContext.put((String)key, (String)var2_2);
    }

    public String get(String key) {
        return ThreadContext.get((String)key);
    }

    public void remove(String key) {
        ThreadContext.remove((String)key);
    }

    public void clear() {
        ThreadContext.clearMap();
    }

    public Map<String, String> getCopyOfContextMap() {
        return ThreadContext.getContext();
    }

    /*
     * WARNING - void declaration
     */
    public void setContextMap(Map<String, String> map) {
        void var1_1;
        ThreadContext.clearMap();
        ThreadContext.putAll((Map)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void pushByKey(String key, String value) {
        void var2_2;
        void var1_1;
        void var3_3;
        if (key == null) {
            ThreadContext.push((String)value);
            return;
        }
        String oldValue = this.mapOfStacks.peekByKey(key);
        if (!Objects.equals(ThreadContext.get((String)key), var3_3)) {
            LOGGER.warn("The key {} was used in both the string and stack-valued MDC.", (Object)key);
        }
        this.mapOfStacks.pushByKey(key, value);
        ThreadContext.put((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public String popByKey(String key) {
        void var2_2;
        void var1_1;
        if (key == null) {
            if (ThreadContext.getDepth() > 0) {
                return ThreadContext.pop();
            }
            return null;
        }
        String value = this.mapOfStacks.popByKey(key);
        if (!Objects.equals(ThreadContext.get((String)key), value)) {
            LOGGER.warn("The key {} was used in both the string and stack-valued MDC.", (Object)key);
        }
        ThreadContext.put((String)key, (String)this.mapOfStacks.peekByKey((String)var1_1));
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Deque<String> getCopyOfDequeByKey(String key) {
        void var1_1;
        if (key == null) {
            void var2_2;
            ThreadContext.ContextStack stack = ThreadContext.getImmutableStack();
            ArrayDeque copy = new ArrayDeque(stack.size());
            var1_1.forEach(copy::push);
            return var2_2;
        }
        return this.mapOfStacks.getCopyOfDequeByKey((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void clearDequeByKey(String key) {
        void var1_1;
        if (key == null) {
            ThreadContext.clearStack();
            return;
        }
        this.mapOfStacks.clearByKey(key);
        ThreadContext.put((String)var1_1, null);
    }

    private static class ThreadLocalMapOfStacks {
        private final ThreadLocal<Map<String, Deque<String>>> tlMapOfStacks = ThreadLocal.withInitial(HashMap::new);

        private ThreadLocalMapOfStacks() {
        }

        /*
         * WARNING - void declaration
         */
        public void pushByKey(String key, String value) {
            void var2_2;
            void var1_1;
            this.tlMapOfStacks.get().computeIfAbsent((String)var1_1, ignored -> new ArrayDeque()).push(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public String popByKey(String key) {
            Deque<String> deque = this.tlMapOfStacks.get().get(key);
            if (deque != null) {
                void var1_1;
                return (String)var1_1.poll();
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public Deque<String> getCopyOfDequeByKey(String key) {
            Deque<String> deque = this.tlMapOfStacks.get().get(key);
            if (deque != null) {
                void var1_1;
                return new ArrayDeque<String>((Collection<String>)var1_1);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public void clearByKey(String key) {
            Deque<String> deque = this.tlMapOfStacks.get().get(key);
            if (deque != null) {
                void var1_1;
                var1_1.clear();
            }
        }

        /*
         * WARNING - void declaration
         */
        public String peekByKey(String key) {
            Deque<String> deque = this.tlMapOfStacks.get().get(key);
            if (deque != null) {
                void var1_1;
                return (String)var1_1.peek();
            }
            return null;
        }
    }
}

