/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.slf4j;

import java.io.Serializable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.apache.logging.slf4j.Log4jEventBuilder;
import org.apache.logging.slf4j.Log4jMarkerFactory;
import org.slf4j.Marker;
import org.slf4j.spi.LocationAwareLogger;
import org.slf4j.spi.LoggingEventBuilder;

public class Log4jLogger
implements Serializable,
LocationAwareLogger {
    public static final String FQCN = Log4jLogger.class.getName();
    private transient ExtendedLogger logger;
    private final String name;
    private transient Log4jMarkerFactory markerFactory;

    /*
     * WARNING - void declaration
     */
    public Log4jLogger(Log4jMarkerFactory markerFactory, ExtendedLogger logger, String name) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.markerFactory = var1_1;
        this.logger = var2_2;
        this.name = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public void trace(String format) {
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.TRACE, null, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void trace(String format, Object o) {
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.TRACE, null, (String)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void trace(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.TRACE, null, (String)var1_1, (Object)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void trace(String format, Object ... args) {
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.TRACE, null, (String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void trace(String format, Throwable t) {
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.TRACE, null, (String)var1_1, (Throwable)var2_2);
    }

    public boolean isTraceEnabled() {
        return this.logger.isEnabled(Level.TRACE, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isTraceEnabled(Marker marker) {
        void var1_1;
        return this.logger.isEnabled(Level.TRACE, this.markerFactory.getLog4jMarker((Marker)var1_1), null);
    }

    /*
     * WARNING - void declaration
     */
    public void trace(Marker marker, String s) {
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.TRACE, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void trace(Marker marker, String s, Object o) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.TRACE, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void trace(Marker marker, String s, Object o, Object o1) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.TRACE, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2, (Object)var3_3, o1);
    }

    /*
     * WARNING - void declaration
     */
    public void trace(Marker marker, String s, Object ... objects) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.TRACE, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2, (Object[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void trace(Marker marker, String s, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.TRACE, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void debug(String format) {
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.DEBUG, null, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void debug(String format, Object o) {
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.DEBUG, null, (String)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void debug(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.DEBUG, null, (String)var1_1, (Object)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void debug(String format, Object ... args) {
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.DEBUG, null, (String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void debug(String format, Throwable t) {
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.DEBUG, null, (String)var1_1, (Throwable)var2_2);
    }

    public boolean isDebugEnabled() {
        return this.logger.isEnabled(Level.DEBUG, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isDebugEnabled(Marker marker) {
        void var1_1;
        return this.logger.isEnabled(Level.DEBUG, this.markerFactory.getLog4jMarker((Marker)var1_1), null);
    }

    /*
     * WARNING - void declaration
     */
    public void debug(Marker marker, String s) {
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.DEBUG, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void debug(Marker marker, String s, Object o) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.DEBUG, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void debug(Marker marker, String s, Object o, Object o1) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.DEBUG, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2, (Object)var3_3, o1);
    }

    /*
     * WARNING - void declaration
     */
    public void debug(Marker marker, String s, Object ... objects) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.DEBUG, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2, (Object[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void debug(Marker marker, String s, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.DEBUG, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void info(String format) {
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.INFO, null, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void info(String format, Object o) {
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.INFO, null, (String)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void info(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.INFO, null, (String)var1_1, (Object)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void info(String format, Object ... args) {
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.INFO, null, (String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void info(String format, Throwable t) {
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.INFO, null, (String)var1_1, (Throwable)var2_2);
    }

    public boolean isInfoEnabled() {
        return this.logger.isEnabled(Level.INFO, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isInfoEnabled(Marker marker) {
        void var1_1;
        return this.logger.isEnabled(Level.INFO, this.markerFactory.getLog4jMarker((Marker)var1_1), null);
    }

    /*
     * WARNING - void declaration
     */
    public void info(Marker marker, String s) {
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.INFO, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void info(Marker marker, String s, Object o) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.INFO, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void info(Marker marker, String s, Object o, Object o1) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.INFO, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2, (Object)var3_3, o1);
    }

    /*
     * WARNING - void declaration
     */
    public void info(Marker marker, String s, Object ... objects) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.INFO, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2, (Object[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void info(Marker marker, String s, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.INFO, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void warn(String format) {
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.WARN, null, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void warn(String format, Object o) {
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.WARN, null, (String)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void warn(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.WARN, null, (String)var1_1, (Object)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void warn(String format, Object ... args) {
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.WARN, null, (String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void warn(String format, Throwable t) {
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.WARN, null, (String)var1_1, (Throwable)var2_2);
    }

    public boolean isWarnEnabled() {
        return this.logger.isEnabled(Level.WARN, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isWarnEnabled(Marker marker) {
        void var1_1;
        return this.logger.isEnabled(Level.WARN, this.markerFactory.getLog4jMarker((Marker)var1_1), null);
    }

    /*
     * WARNING - void declaration
     */
    public void warn(Marker marker, String s) {
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.WARN, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void warn(Marker marker, String s, Object o) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.WARN, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void warn(Marker marker, String s, Object o, Object o1) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.WARN, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2, (Object)var3_3, o1);
    }

    /*
     * WARNING - void declaration
     */
    public void warn(Marker marker, String s, Object ... objects) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.WARN, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2, (Object[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void warn(Marker marker, String s, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.WARN, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void error(String format) {
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.ERROR, null, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void error(String format, Object o) {
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.ERROR, null, (String)var1_1, (Object)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void error(String format, Object arg1, Object arg2) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.ERROR, null, (String)var1_1, (Object)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void error(String format, Object ... args) {
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.ERROR, null, (String)var1_1, (Object[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void error(String format, Throwable t) {
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.ERROR, null, (String)var1_1, (Throwable)var2_2);
    }

    public boolean isErrorEnabled() {
        return this.logger.isEnabled(Level.ERROR, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isErrorEnabled(Marker marker) {
        void var1_1;
        return this.logger.isEnabled(Level.ERROR, this.markerFactory.getLog4jMarker((Marker)var1_1), null);
    }

    /*
     * WARNING - void declaration
     */
    public void error(Marker marker, String s) {
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.ERROR, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void error(Marker marker, String s, Object o) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.ERROR, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2, (Object)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void error(Marker marker, String s, Object o, Object o1) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.ERROR, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2, (Object)var3_3, o1);
    }

    /*
     * WARNING - void declaration
     */
    public void error(Marker marker, String s, Object ... objects) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.ERROR, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2, (Object[])var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void error(Marker marker, String s, Throwable throwable) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.logger.logIfEnabled(FQCN, Level.ERROR, this.markerFactory.getLog4jMarker((Marker)var1_1), (String)var2_2, (Throwable)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void log(Marker marker, String fqcn, int level, String message, Object[] params, Throwable throwable) {
        void var1_1;
        void var3_4;
        void var2_2;
        Throwable throwable2;
        SimpleMessage msg;
        org.apache.logging.log4j.Marker log4jMarker;
        Level log4jLevel = Log4jLogger.getLevel(level);
        if (!this.logger.isEnabled(log4jLevel, log4jMarker = this.markerFactory.getLog4jMarker(marker), message, params)) {
            return;
        }
        if (params == null) {
            msg = new SimpleMessage(message);
            throwable2 = throwable;
        } else {
            msg = new ParameterizedMessage((String)msg, params, throwable);
            throwable2 = throwable != null ? throwable : msg.getThrowable();
        }
        Throwable actualThrowable = throwable2;
        this.logger.logMessage((String)var2_2, (Level)var3_4, (org.apache.logging.log4j.Marker)var1_1, (Message)msg, actualThrowable);
    }

    public String getName() {
        return this.name;
    }

    private static Level getLevel(int i) {
        switch (i) {
            case 0: {
                return Level.TRACE;
            }
            case 10: {
                return Level.DEBUG;
            }
            case 20: {
                return Level.INFO;
            }
            case 30: {
                return Level.WARN;
            }
            case 40: {
                return Level.ERROR;
            }
        }
        return Level.ERROR;
    }

    /*
     * WARNING - void declaration
     */
    public LoggingEventBuilder makeLoggingEventBuilder(org.slf4j.event.Level level) {
        void var1_1;
        Level log4jLevel = Log4jLogger.getLevel(level.toInt());
        return new Log4jEventBuilder(this.markerFactory, (Logger)this.logger, (Level)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEnabledForLevel(org.slf4j.event.Level level) {
        void var1_1;
        return this.logger.isEnabled(Log4jLogger.getLevel(var1_1.toInt()));
    }
}

