/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.slf4j;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.logging.log4j.BridgeAware;
import org.apache.logging.log4j.CloseableThreadContext;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogBuilder;
import org.apache.logging.log4j.Logger;
import org.apache.logging.slf4j.Log4jMarkerFactory;
import org.slf4j.Marker;
import org.slf4j.spi.LoggingEventBuilder;

public class Log4jEventBuilder
implements LoggingEventBuilder {
    private static final String FQCN = Log4jEventBuilder.class.getName();
    private final Log4jMarkerFactory markerFactory;
    private final Logger logger;
    private final List<Object> arguments = new ArrayList<Object>();
    private String message = null;
    private org.apache.logging.log4j.Marker marker = null;
    private Throwable throwable = null;
    private Map<String, String> keyValuePairs = null;
    private final Level level;

    /*
     * WARNING - void declaration
     */
    public Log4jEventBuilder(Log4jMarkerFactory markerFactory, Logger logger, Level level) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.markerFactory = var1_1;
        this.logger = var2_2;
        this.level = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public LoggingEventBuilder setCause(Throwable cause) {
        void var1_1;
        this.throwable = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public LoggingEventBuilder addMarker(Marker marker) {
        void var1_1;
        this.marker = this.markerFactory.getLog4jMarker((Marker)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public LoggingEventBuilder addArgument(Object p) {
        void var1_1;
        this.arguments.add(var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public LoggingEventBuilder addArgument(Supplier<?> objectSupplier) {
        void var1_1;
        this.arguments.add(var1_1.get());
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public LoggingEventBuilder addKeyValue(String key, Object value) {
        void var2_2;
        void var1_1;
        if (this.keyValuePairs == null) {
            this.keyValuePairs = new HashMap<String, String>();
        }
        this.keyValuePairs.put((String)var1_1, String.valueOf(var2_2));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public LoggingEventBuilder addKeyValue(String key, Supplier<Object> valueSupplier) {
        void var2_2;
        void var1_1;
        if (this.keyValuePairs == null) {
            this.keyValuePairs = new HashMap<String, String>();
        }
        this.keyValuePairs.put((String)var1_1, String.valueOf(var2_2.get()));
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public LoggingEventBuilder setMessage(String message) {
        void var1_1;
        this.message = var1_1;
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public LoggingEventBuilder setMessage(Supplier<String> messageSupplier) {
        void var1_1;
        this.message = (String)var1_1.get();
        return this;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void log() {
        Throwable throwable;
        LogBuilder logBuilder = this.logger.atLevel(this.level).withMarker(this.marker).withThrowable(this.throwable);
        if (logBuilder instanceof BridgeAware) {
            ((BridgeAware)logBuilder).setEntryPoint(FQCN);
        }
        if (this.keyValuePairs == null || this.keyValuePairs.isEmpty()) {
            logBuilder.log(this.message, this.arguments.toArray());
            return;
        }
        CloseableThreadContext.Instance c2 = CloseableThreadContext.putAll(this.keyValuePairs);
        Throwable throwable2 = null;
        try {
            throwable.log(this.message, this.arguments.toArray());
            if (c2 == null) return;
        }
        catch (Throwable throwable3) {
            try {
                throwable = throwable3;
                throwable2 = throwable3;
                throw throwable;
            }
            catch (Throwable throwable4) {
                if (c2 == null) throw throwable4;
                if (throwable2 != null) {
                    try {
                        c2.close();
                        throw throwable4;
                    }
                    catch (Throwable c2) {
                        throwable2.addSuppressed(c2);
                    }
                    throw throwable4;
                } else {
                    void var2_3;
                    var2_3.close();
                }
                throw throwable4;
            }
        }
        c2.close();
        return;
    }

    /*
     * WARNING - void declaration
     */
    public void log(String message) {
        void var1_1;
        this.setMessage((String)var1_1);
        this.log();
    }

    /*
     * WARNING - void declaration
     */
    public void log(String message, Object arg) {
        void var2_2;
        void var1_1;
        this.setMessage((String)var1_1);
        this.addArgument(var2_2);
        this.log();
    }

    /*
     * WARNING - void declaration
     */
    public void log(String message, Object arg0, Object arg1) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.setMessage((String)var1_1);
        this.addArgument(var2_2);
        this.addArgument(var3_3);
        this.log();
    }

    /*
     * WARNING - void declaration
     */
    public void log(String message, Object ... args) {
        void var2_2;
        void var1_1;
        this.setMessage((String)var1_1);
        for (void arg : var2_2) {
            this.addArgument(arg);
        }
        this.log();
    }

    /*
     * WARNING - void declaration
     */
    public void log(Supplier<String> messageSupplier) {
        void var1_1;
        this.setMessage((Supplier<String>)var1_1);
        this.log();
    }
}

