/*
 * Decompiled with CFR 0.152.
 */
package com.materialkolor.utils;

import com.materialkolor.utils.MathUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0013\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\u0012\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u0015\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0012\u0010\u0010J\u0015\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u0015\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u0004\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0015\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001e\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001f\u0010\u001dJ\u0015\u0010!\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u0004\u00a2\u0006\u0004\b!\u0010\u001bJ\u0015\u0010\"\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u0016\u00a2\u0006\u0004\b\"\u0010\u0019J\r\u0010#\u001a\u00020\n\u00a2\u0006\u0004\b#\u0010$J\u0015\u0010&\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u0016\u00a2\u0006\u0004\b&\u0010\u001dJ\u0015\u0010(\u001a\u00020\u00162\u0006\u0010'\u001a\u00020\u0016\u00a2\u0006\u0004\b(\u0010\u001dR\u001a\u0010*\u001a\b\u0012\u0004\u0012\u00020\n0)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\n0)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010+R\u0014\u0010-\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b-\u0010."}, d2={"Lcom/materialkolor/utils/ColorUtils;", "", "<init>", "()V", "", "red", "green", "blue", "argbFromRgb", "(III)I", "", "linrgb", "argbFromLinrgb", "([D)I", "argb", "redFromArgb", "(I)I", "greenFromArgb", "blueFromArgb", "xyzFromArgb", "(I)[D", "labFromArgb", "", "lstar", "argbFromLstar", "(D)I", "lstarFromArgb", "(I)D", "yFromLstar", "(D)D", "y", "lstarFromY", "rgbComponent", "linearized", "delinearized", "whitePointD65", "()[D", "t", "labF", "ft", "labInvf", "", "SRGB_TO_XYZ", "[[D", "XYZ_TO_SRGB", "WHITE_POINT_D65", "[D"})
public final class ColorUtils {
    public static final ColorUtils INSTANCE = new ColorUtils();
    private static final double[][] SRGB_TO_XYZ;
    private static final double[][] XYZ_TO_SRGB;
    private static final double[] WHITE_POINT_D65;

    private ColorUtils() {
    }

    /*
     * WARNING - void declaration
     */
    public final int argbFromRgb(int red, int green, int blue) {
        void var3_3;
        void var2_2;
        void var1_1;
        return 0xFF000000 | (var1_1 & 0xFF) << 16 | (var2_2 & 0xFF) << 8 | var3_3 & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    public final int argbFromLinrgb(double[] linrgb) {
        void var1_2;
        void var3_4;
        void var2_3;
        Intrinsics.checkNotNullParameter((Object)linrgb, (String)"linrgb");
        int r = this.delinearized(linrgb[0]);
        int g = this.delinearized(linrgb[1]);
        int b = this.delinearized(linrgb[2]);
        return this.argbFromRgb((int)var2_3, (int)var3_4, (int)var1_2);
    }

    public final int redFromArgb(int argb) {
        return argb >> 16 & 0xFF;
    }

    public final int greenFromArgb(int argb) {
        return argb >> 8 & 0xFF;
    }

    public final int blueFromArgb(int argb) {
        return argb & 0xFF;
    }

    /*
     * WARNING - void declaration
     */
    public final double[] xyzFromArgb(int argb) {
        void var2_3;
        void var1_1;
        ColorUtils colorUtils = this;
        double r = colorUtils.linearized(colorUtils.redFromArgb(argb));
        ColorUtils colorUtils2 = this;
        double g = colorUtils2.linearized(colorUtils2.greenFromArgb(argb));
        ColorUtils colorUtils3 = this;
        double b = colorUtils3.linearized(colorUtils3.blueFromArgb((int)var1_1));
        double[] dArray = new double[3];
        double[] dArray2 = dArray;
        dArray[0] = var2_3;
        dArray2[1] = g;
        dArray2[2] = b;
        return MathUtils.INSTANCE.matrixMultiply(dArray2, SRGB_TO_XYZ);
    }

    /*
     * WARNING - void declaration
     */
    public final double[] labFromArgb(int argb) {
        double[] dArray;
        void var2_3;
        ColorUtils colorUtils = this;
        double linearR = colorUtils.linearized(colorUtils.redFromArgb(argb));
        ColorUtils colorUtils2 = this;
        double linearG = colorUtils2.linearized(colorUtils2.greenFromArgb(argb));
        ColorUtils colorUtils3 = this;
        double linearB = colorUtils3.linearized(colorUtils3.blueFromArgb(argb));
        double[][] matrix = SRGB_TO_XYZ;
        double x = SRGB_TO_XYZ[0][0] * linearR + matrix[0][1] * linearG + matrix[0][2] * linearB;
        double y = matrix[1][0] * linearR + matrix[1][1] * linearG + matrix[1][2] * linearB;
        double z = matrix[2][0] * var2_3 + matrix[2][1] * linearG + matrix[2][2] * linearB;
        double[] whitePoint = WHITE_POINT_D65;
        double xNormalized = x / whitePoint[0];
        double yNormalized = y / whitePoint[1];
        double zNormalized = z / dArray[2];
        double fx = this.labF(xNormalized);
        double fy = this.labF(yNormalized);
        double fz = this.labF(zNormalized);
        double l = fy * 116.0 - 16.0;
        double a = 500.0 * (fx - fy);
        double b = 200.0 * (fy - fz);
        double[] dArray2 = new double[3];
        dArray = dArray2;
        dArray2[0] = l;
        dArray[1] = a;
        dArray[2] = b;
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    public final int argbFromLstar(double lstar) {
        void var1_2;
        void var3_3;
        int component;
        double y = this.yFromLstar(lstar);
        int n = component = this.delinearized((double)var3_3);
        return this.argbFromRgb(n, n, (int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    public final double lstarFromArgb(int argb) {
        void var2_2;
        void var1_1;
        double y = this.xyzFromArgb((int)var1_1)[1];
        return 116.0 * this.labF((double)(var2_2 / 100.0)) - 16.0;
    }

    /*
     * WARNING - void declaration
     */
    public final double yFromLstar(double lstar) {
        void var1_1;
        return 100.0 * this.labInvf((double)((var1_1 + 16.0) / 116.0));
    }

    /*
     * WARNING - void declaration
     */
    public final double lstarFromY(double y) {
        void var1_1;
        return this.labF((double)(var1_1 / 100.0)) * 116.0 - 16.0;
    }

    /*
     * WARNING - void declaration
     */
    public final double linearized(int rgbComponent) {
        void var2_2;
        double d;
        double normalized = (double)rgbComponent / 255.0;
        if (d <= 0.040449936) {
            return normalized / 12.92 * 100.0;
        }
        return Math.pow((double)((var2_2 + 0.055) / 1.055), 2.4) * 100.0;
    }

    /*
     * WARNING - void declaration
     */
    public final int delinearized(double rgbComponent) {
        void var3_2;
        double d;
        double normalized = rgbComponent / 100.0;
        double d2 = d <= 0.0031308 ? normalized * 12.92 : 1.055 * Math.pow((double)var3_2, 0.4166666666666667) - 0.055;
        return (int)RangesKt.coerceIn((double)Math.rint(d2 * 255.0), (double)0.0, (double)255.0);
    }

    public final double[] whitePointD65() {
        return WHITE_POINT_D65;
    }

    /*
     * WARNING - void declaration
     */
    public final double labF(double t) {
        void var1_1;
        if (t > 0.008856451679035631) {
            return Math.pow(t, 0.3333333333333333);
        }
        return (double)((var1_1 * 903.2962962962963 + 16.0) / 116.0);
    }

    /*
     * WARNING - void declaration
     */
    public final double labInvf(double ft) {
        void var1_1;
        double d;
        double d2 = ft;
        double ft3 = d2 * d2 * ft;
        if (d > 0.008856451679035631) {
            void var3_2;
            return (double)var3_2;
        }
        return (double)((var1_1 * 116.0 - 16.0) / 903.2962962962963);
    }

    static {
        double[][] dArrayArray = new double[3][];
        Object object = dArrayArray;
        double[] dArray = new double[3];
        double[] dArray2 = dArray;
        dArray[0] = 0.41233895;
        dArray2[1] = 0.35762064;
        dArray2[2] = 0.18051042;
        dArrayArray[0] = dArray2;
        double[] dArray3 = new double[3];
        dArray2 = dArray3;
        dArray3[0] = 0.2126;
        dArray2[1] = 0.7152;
        dArray2[2] = 0.0722;
        object[1] = dArray2;
        double[] dArray4 = new double[3];
        dArray2 = dArray4;
        dArray4[0] = 0.01932141;
        dArray2[1] = 0.11916382;
        dArray2[2] = 0.95034478;
        object[2] = dArray2;
        SRGB_TO_XYZ = object;
        double[][] dArrayArray2 = new double[3][];
        object = dArrayArray2;
        double[] dArray5 = new double[3];
        dArray2 = dArray5;
        dArray5[0] = 3.2413774792388685;
        dArray2[1] = -1.5376652402851851;
        dArray2[2] = -0.49885366846268053;
        dArrayArray2[0] = dArray2;
        double[] dArray6 = new double[3];
        dArray2 = dArray6;
        dArray6[0] = -0.9691452513005321;
        dArray2[1] = 1.8758853451067872;
        dArray2[2] = 0.04156585616912061;
        object[1] = dArray2;
        double[] dArray7 = new double[3];
        dArray2 = dArray7;
        dArray7[0] = 0.05562093689691305;
        dArray2[1] = -0.20395524564742123;
        dArray2[2] = 1.0571799111220335;
        object[2] = dArray2;
        XYZ_TO_SRGB = object;
        double[] dArray8 = new double[3];
        object = dArray8;
        dArray8[0] = 95.047;
        object[1] = (double[])100.0;
        object[2] = (double[])108.883;
        WHITE_POINT_D65 = (double[])object;
    }
}

