/*
 * Decompiled with CFR 0.152.
 */
package com.materialkolor.temperature;

import com.materialkolor.hct.Hct;
import com.materialkolor.utils.ColorUtils;
import com.materialkolor.utils.MathUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010$\n\u0002\b\u0012\u0018\u0000 '2\u00020\u0001:\u0001'B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J#\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0010R\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0010R\u001e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013R$\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\r\u0018\u00010\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0011\u0010\u001a\u001a\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001c\u001a\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0019R\u001c\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u001c\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\"\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\r\u0018\u00010\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010&\u001a\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0019"}, d2={"Lcom/materialkolor/temperature/TemperatureCache;", "", "Lcom/materialkolor/hct/Hct;", "input", "<init>", "(Lcom/materialkolor/hct/Hct;)V", "", "count", "divisions", "", "getAnalogousColors", "(II)Ljava/util/List;", "hct", "", "getRelativeTemperature", "(Lcom/materialkolor/hct/Hct;)D", "Lcom/materialkolor/hct/Hct;", "precomputedComplement", "precomputedHctsByTemp", "Ljava/util/List;", "precomputedHctsByHue", "", "precomputedTempsByHct", "Ljava/util/Map;", "getComplement", "()Lcom/materialkolor/hct/Hct;", "complement", "getColdest", "coldest", "getHctsByHue", "()Ljava/util/List;", "hctsByHue", "getHctsByTemp", "hctsByTemp", "getTempsByHct", "()Ljava/util/Map;", "tempsByHct", "getWarmest", "warmest", "Companion"})
public final class TemperatureCache {
    public static final Companion Companion = new Companion(null);
    private final Hct input;
    private Hct precomputedComplement;
    private List<Hct> precomputedHctsByTemp;
    private List<Hct> precomputedHctsByHue;
    private Map<Hct, Double> precomputedTempsByHct;

    /*
     * WARNING - void declaration
     */
    public TemperatureCache(Hct input) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final Hct getComplement() {
        void var1_2;
        if (this.precomputedComplement != null) {
            Hct hct = this.precomputedComplement;
            Intrinsics.checkNotNull((Object)hct);
            return hct;
        }
        double coldestHue = this.getColdest().getHue();
        Map<Hct, Double> map = this.getTempsByHct();
        Intrinsics.checkNotNull(map);
        Double d = map.get(this.getColdest());
        Intrinsics.checkNotNull((Object)d);
        double coldestTemp = ((Number)d).doubleValue();
        double warmestHue = this.getWarmest().getHue();
        Map<Hct, Double> map2 = this.getTempsByHct();
        Intrinsics.checkNotNull(map2);
        Double d2 = map2.get(this.getWarmest());
        Intrinsics.checkNotNull((Object)d2);
        double d3 = ((Number)d2).doubleValue();
        double range = d3 - coldestTemp;
        boolean startHueIsColdestToWarmest = com.materialkolor.temperature.TemperatureCache$Companion.access$isBetween(Companion, this.input.getHue(), coldestHue, warmestHue);
        double startHue = startHueIsColdestToWarmest ? warmestHue : coldestHue;
        double endHue = startHueIsColdestToWarmest ? coldestHue : warmestHue;
        double smallestError = 1000.0;
        List<Hct> list = this.getHctsByHue();
        Intrinsics.checkNotNull(list);
        Hct answer = list.get((int)Math.rint(this.input.getHue()));
        TemperatureCache temperatureCache = this;
        double complementRelativeTemp = 1.0 - temperatureCache.getRelativeTemperature(temperatureCache.input);
        double hueAddend = 0.0;
        while (hueAddend <= 360.0) {
            double d4;
            double hue = MathUtils.INSTANCE.sanitizeDegrees(startHue + hueAddend * 1.0);
            if (!com.materialkolor.temperature.TemperatureCache$Companion.access$isBetween(Companion, hue, startHue, endHue)) {
                hueAddend += 1.0;
                continue;
            }
            List<Hct> list2 = this.getHctsByHue();
            Intrinsics.checkNotNull(list2);
            Hct possibleAnswer = list2.get((int)Math.rint(hue));
            Map<Hct, Double> map3 = this.getTempsByHct();
            Intrinsics.checkNotNull(map3);
            Double d5 = map3.get(possibleAnswer);
            Intrinsics.checkNotNull((Object)d5);
            double relativeTemp = (((Number)d5).doubleValue() - coldestTemp) / range;
            double error = Math.abs(complementRelativeTemp - relativeTemp);
            if (d4 < smallestError) {
                void var2_13;
                smallestError = error;
                answer = var2_13;
            }
            hueAddend += 1.0;
        }
        Hct hct = this.precomputedComplement = var1_2;
        Intrinsics.checkNotNull((Object)hct);
        return hct;
    }

    /*
     * WARNING - void declaration
     */
    public final List<Hct> getAnalogousColors(int count, int divisions) {
        void var1_1;
        int startHue = (int)Math.rint(this.input.getHue());
        List<Hct> list = this.getHctsByHue();
        Intrinsics.checkNotNull(list);
        Hct startHct = list.get(startHue);
        double lastTemp = this.getRelativeTemperature(startHct);
        List allColors = new ArrayList();
        allColors.add(startHct);
        double absoluteTotalTempDelta = 0.0;
        for (int i = 0; i < 360; ++i) {
            int hue = MathUtils.INSTANCE.sanitizeDegrees(startHue + i);
            List<Hct> list2 = this.getHctsByHue();
            Intrinsics.checkNotNull(list2);
            Hct hct = list2.get(hue);
            double temp = this.getRelativeTemperature(hct);
            double tempDelta = Math.abs(temp - lastTemp);
            lastTemp = temp;
            absoluteTotalTempDelta += tempDelta;
        }
        int hueAddend = 1;
        double tempStep = absoluteTotalTempDelta / (double)divisions;
        double totalTempDelta = 0.0;
        lastTemp = this.getRelativeTemperature(startHct);
        while (allColors.size() < divisions) {
            int hue = MathUtils.INSTANCE.sanitizeDegrees(startHue + hueAddend);
            List<Hct> list3 = this.getHctsByHue();
            Intrinsics.checkNotNull(list3);
            Hct hct = list3.get(hue);
            double temp = this.getRelativeTemperature(hct);
            double tempDelta = Math.abs(temp - lastTemp);
            double desiredTotalTempDeltaForIndex = (double)allColors.size() * tempStep;
            boolean indexSatisfied = (totalTempDelta += tempDelta) >= desiredTotalTempDeltaForIndex;
            int indexAddend = 1;
            while (indexSatisfied && allColors.size() < divisions) {
                allColors.add(hct);
                desiredTotalTempDeltaForIndex = (double)(allColors.size() + indexAddend) * tempStep;
                indexSatisfied = totalTempDelta >= desiredTotalTempDeltaForIndex;
                ++indexAddend;
            }
            double d = temp;
            if (++hueAddend <= 360) continue;
            while (allColors.size() < divisions) {
                allColors.add(hct);
            }
            break block1;
        }
        List answers = new ArrayList();
        answers.add(this.input);
        int ccwCount = (int)Math.floor(((double)count - 1.0) / 2.0);
        int n = ccwCount + 1;
        for (int i = 1; i < n; ++i) {
            int index;
            for (index = 0 - i; index < 0; index += allColors.size()) {
            }
            if (index >= allColors.size()) {
                index %= allColors.size();
            }
            answers.add(0, allColors.get(index));
        }
        void cwCount = var1_1 - ccwCount - true;
        void var19_24 = cwCount + true;
        for (int i = 1; i < var19_24; ++i) {
            int index;
            for (index = i; index < 0; index += allColors.size()) {
            }
            if (index >= allColors.size()) {
                index %= allColors.size();
            }
            answers.add(allColors.get(index));
        }
        return answers;
    }

    /*
     * WARNING - void declaration
     */
    public final double getRelativeTemperature(Hct hct) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)hct, (String)"hct");
        Map<Hct, Double> map = this.getTempsByHct();
        Intrinsics.checkNotNull(map);
        Double d = map.get(this.getWarmest());
        Intrinsics.checkNotNull((Object)d);
        double d2 = ((Number)d).doubleValue();
        Map<Hct, Double> map2 = this.getTempsByHct();
        Intrinsics.checkNotNull(map2);
        Double d3 = map2.get(this.getColdest());
        Intrinsics.checkNotNull((Object)d3);
        double range = d2 - ((Number)d3).doubleValue();
        Map<Hct, Double> map3 = this.getTempsByHct();
        Intrinsics.checkNotNull(map3);
        Double d4 = map3.get(var1_1);
        Intrinsics.checkNotNull((Object)d4);
        double d5 = ((Number)d4).doubleValue();
        Map<Hct, Double> map4 = this.getTempsByHct();
        Intrinsics.checkNotNull(map4);
        Double d6 = map4.get(this.getColdest());
        Intrinsics.checkNotNull((Object)d6);
        double differenceFromColdest = d5 - ((Number)d6).doubleValue();
        if (range == 0.0) {
            return 0.5;
        }
        return differenceFromColdest / var2_2;
    }

    private final Hct getColdest() {
        List<Hct> list = this.getHctsByTemp();
        Intrinsics.checkNotNull(list);
        return list.get(0);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Hct> getHctsByHue() {
        void var1_1;
        if (this.precomputedHctsByHue != null) {
            return this.precomputedHctsByHue;
        }
        List hcts = new ArrayList();
        for (double hue = 0.0; hue <= 360.0; hue += 1.0) {
            Hct colorAtHue = Hct.Companion.from(hue, this.input.getChroma(), this.input.getTone());
            hcts.add(colorAtHue);
        }
        this.precomputedHctsByHue = CollectionsKt.flatten((Iterable)CollectionsKt.listOf((Object)var1_1));
        return this.precomputedHctsByHue;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Hct> getHctsByTemp() {
        void var1_1;
        void var2_2;
        if (this.precomputedHctsByTemp != null) {
            return this.precomputedHctsByTemp;
        }
        List list = this.getHctsByHue();
        if (list == null || (list = CollectionsKt.toMutableList((Collection)list)) == null) {
            list = new ArrayList();
        }
        List hcts = list;
        list.add(this.input);
        Comparator temperaturesComparator = new Comparator(this){
            final /* synthetic */ TemperatureCache this$0;
            {
                this.this$0 = temperatureCache;
            }

            /*
             * WARNING - void declaration
             */
            public final int compare(T a, T b) {
                void var1_1;
                Comparable comparable;
                Hct arg = (Hct)a;
                Map map = TemperatureCache.access$getTempsByHct(this.this$0);
                Intrinsics.checkNotNull((Object)map);
                Comparable comparable2 = (Comparable)map.get(arg);
                arg = (Hct)((Object)comparable);
                comparable = comparable2;
                Map map2 = TemperatureCache.access$getTempsByHct(this.this$0);
                Intrinsics.checkNotNull((Object)map2);
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)map2.get(var1_1)));
            }
        };
        CollectionsKt.sortWith((List)hcts, (Comparator)var2_2);
        this.precomputedHctsByTemp = var1_1;
        return this.precomputedHctsByTemp;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<Hct, Double> getTempsByHct() {
        void var2_2;
        Iterator iterator;
        if (this.precomputedTempsByHct != null) {
            return this.precomputedTempsByHct;
        }
        List list = this.getHctsByHue();
        if (list == null || (list = CollectionsKt.toMutableList((Collection)list)) == null) {
            list = new ArrayList();
        }
        List allHcts = list;
        list.add(this.input);
        Map temperaturesByHct = new HashMap();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Hct hct = (Hct)iterator.next();
            temperaturesByHct.put(hct, Companion.rawTemperature((Hct)var3_3));
        }
        this.precomputedTempsByHct = var2_2;
        return this.precomputedTempsByHct;
    }

    private final Hct getWarmest() {
        List<Hct> list = this.getHctsByTemp();
        Intrinsics.checkNotNull(list);
        List<Hct> list2 = this.getHctsByTemp();
        Intrinsics.checkNotNull(list2);
        return list.get(list2.size() - 1);
    }

    public final boolean equals(Object other) {
        TemperatureCache temperatureCache;
        if (this == other) {
            return true;
        }
        if (!(other instanceof TemperatureCache)) {
            return false;
        }
        temperatureCache = temperatureCache;
        return Intrinsics.areEqual((Object)this.input, (Object)temperatureCache.input);
    }

    public final int hashCode() {
        return this.input.hashCode();
    }

    public final String toString() {
        return "TemperatureCache(input=" + this.input + ")";
    }

    public static final /* synthetic */ Map access$getTempsByHct(TemperatureCache $this) {
        return $this.getTempsByHct();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ'\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\r\u0010\u000e"}, d2={"Lcom/materialkolor/temperature/TemperatureCache$Companion;", "", "<init>", "()V", "Lcom/materialkolor/hct/Hct;", "color", "", "rawTemperature", "(Lcom/materialkolor/hct/Hct;)D", "angle", "a", "b", "", "isBetween", "(DDD)Z"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final double rawTemperature(Hct color) {
            void var3_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            double[] lab = ColorUtils.INSTANCE.labFromArgb(color.toInt());
            MathUtils mathUtils = MathUtils.INSTANCE;
            double hue = mathUtils.sanitizeDegrees(mathUtils.toDegrees(Math.atan2(lab[2], lab[1])));
            double chroma = Math.hypot(lab[1], (double)var1_1[2]);
            MathUtils mathUtils2 = MathUtils.INSTANCE;
            return -0.5 + 0.02 * Math.pow(chroma, 1.07) * Math.cos(mathUtils2.toRadians(mathUtils2.sanitizeDegrees((double)(var3_2 - 50.0))));
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isBetween(double angle, double a, double b) {
            void var1_1;
            void var3_2;
            if (a < b) {
                if (a <= angle) {
                    return angle <= b;
                }
                return false;
            }
            return var3_2 <= angle || var1_1 <= b;
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ boolean access$isBetween(Companion $this, double angle, double a, double b) {
            void var3_2;
            void var1_1;
            return $this.isBetween((double)var1_1, (double)var3_2, b);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

