/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.utils.entity;

import com.mojang.datafixers.util.Pair;
import com.xiaoyue.tinkers_ingenuity.TinkersIngenuity;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;

public class TeleportUtils {
    public static void setPos(String name, IToolStackView tool, LivingEntity entity) {
        tool.getPersistentData().putString(TinkersIngenuity.location(name + "_dim"), entity.m_9236_().m_46472_().m_135782_().toString());
        tool.getPersistentData().putFloat(TinkersIngenuity.location(name + "_x"), (float)entity.m_20097_().m_123341_());
        tool.getPersistentData().putFloat(TinkersIngenuity.location(name + "_y"), (float)entity.m_20097_().m_123342_());
        tool.getPersistentData().putFloat(TinkersIngenuity.location(name + "_z"), (float)entity.m_20097_().m_123343_());
    }

    public static Optional<Pair<ResourceKey<Level>, Vec3>> getPos(String name, IToolStackView tool) {
        return Optional.of(tool.getPersistentData()).map(data -> Pair.of((Object)ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(data.getString(TinkersIngenuity.location(name + "_dim")))), (Object)new Vec3((double)data.getFloat(TinkersIngenuity.location(name + "_x")), (double)data.getFloat(TinkersIngenuity.location(name + "_y")), (double)data.getFloat(TinkersIngenuity.location(name + "_z")))));
    }

    public static void teleportHome(ServerLevel world, ServerPlayer player) {
        Vec3 pos;
        ServerLevel targetWorld = world.m_7654_().m_129880_(player.m_8963_());
        BlockPos blockpos = player.m_8961_();
        float f = player.m_8962_();
        boolean flag = player.m_8964_();
        Optional optional = targetWorld != null && blockpos != null ? Player.m_36130_((ServerLevel)targetWorld, (BlockPos)blockpos, (float)f, (boolean)flag, (boolean)true) : Optional.empty();
        if (targetWorld == null || optional.isEmpty()) {
            targetWorld = world.m_7654_().m_129783_();
            BlockPos bpos = targetWorld.m_220360_();
            pos = new Vec3((double)bpos.m_123341_() + 0.5, (double)(bpos.m_123342_() + 1), (double)bpos.m_123343_() + 0.5);
        } else {
            pos = (Vec3)optional.get();
        }
        if (world == targetWorld) {
            player.m_6021_(pos.f_82479_, pos.f_82480_, pos.f_82481_);
        } else {
            TeleportUtils.performTeleport((Entity)player, targetWorld, pos.f_82479_, pos.f_82480_, pos.f_82481_, player.m_8962_(), player.m_6080_());
        }
    }

    public static void performTeleport(Entity entity, ServerLevel level, double x, double y, double z, float xrot, float yrot) {
        LivingEntity liv;
        EnumSet<ClientboundPlayerPositionPacket.RelativeArgument> set = EnumSet.noneOf(ClientboundPlayerPositionPacket.RelativeArgument.class);
        float f = Mth.m_14177_((float)xrot);
        float f1 = Mth.m_14177_((float)yrot);
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ChunkPos chunkpos = new ChunkPos(new BlockPos(x, y, z));
            level.m_7726_().m_8387_(TicketType.f_9448_, chunkpos, 1, (Object)player.m_19879_());
            player.m_8127_();
            if (player.m_5803_()) {
                player.m_6145_(true, true);
            }
            if (level == player.m_9236_()) {
                player.f_8906_.m_9780_(x, y, z, f, f1, set);
            } else {
                player.m_8999_(level, x, y, z, f, f1);
            }
            player.m_5616_(f);
        } else {
            float f2 = Mth.m_14036_((float)f1, (float)-90.0f, (float)90.0f);
            if (level == entity.m_9236_()) {
                entity.m_7678_(x, y, z, f, f2);
                entity.m_5616_(f);
            } else {
                entity.m_19877_();
                Entity newEntity = entity.m_6095_().m_20615_((Level)level);
                if (newEntity == null) {
                    return;
                }
                newEntity.m_20361_(entity);
                newEntity.m_7678_(x, y, z, f, f2);
                newEntity.m_5616_(f);
                entity.m_142467_(Entity.RemovalReason.CHANGED_DIMENSION);
                level.m_143334_(newEntity);
            }
        }
        if (!(entity instanceof LivingEntity) || !(liv = (LivingEntity)entity).m_21255_()) {
            entity.m_20256_(entity.m_20184_().m_82542_(1.0, 0.0, 1.0));
            entity.m_6853_(true);
        }
        if (entity instanceof PathfinderMob) {
            ((PathfinderMob)entity).m_21573_().m_26573_();
        }
    }
}

