/*
 * Decompiled with CFR 0.152.
 */
package com.xiaoyue.tinkers_ingenuity.utils.entity;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EntityUtils {
    public static List<LivingEntity> getMonsters(LivingEntity center, int range) {
        return center.m_9236_().m_6443_(LivingEntity.class, center.m_20191_().m_82400_((double)range), entity -> entity instanceof Monster);
    }

    public static List<LivingEntity> getExceptForCenterMonsters(LivingEntity center, int range) {
        List entities = center.m_9236_().m_6443_(LivingEntity.class, center.m_20191_().m_82400_((double)range), entity -> entity instanceof Monster);
        entities.remove(center);
        return entities;
    }

    public static void spawnThunder(BlockPos pos, Level level) {
        LightningBolt lightningbolt = (LightningBolt)EntityType.f_20465_.m_20615_(level);
        if (lightningbolt != null) {
            lightningbolt.m_20219_(Vec3.m_82539_((Vec3i)pos));
            level.m_7967_((Entity)lightningbolt);
        }
    }

    public static void spawnThunder(Entity target) {
        EntityUtils.spawnThunder(target.m_20097_(), target.m_9236_());
    }

    public static boolean isEnderEntity(LivingEntity entity) {
        return entity instanceof EnderDragon || entity instanceof Endermite || entity instanceof Shulker || entity instanceof EnderMan;
    }

    public static float getDamageAfterArmor(float damage, LivingEntity entity) {
        return CombatRules.m_19272_((float)damage, (float)entity.m_21230_(), (float)((float)entity.m_21133_(Attributes.f_22285_)));
    }

    public static double getAttackSpeed(Player player) {
        return player.m_21133_(Attributes.f_22283_);
    }

    public static boolean isInTheSun(LivingEntity entity) {
        return entity.m_9236_().m_45527_(entity.m_20097_()) && entity.m_9236_().m_46461_();
    }

    public static void setFullAttackCooldown(Player player) {
        player.m_36334_();
    }

    public static LocalPlayer getClientPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }

    public static boolean isEmptyInHand(LivingEntity entity) {
        return entity.m_21205_().m_41619_() && entity.m_21206_().m_41619_();
    }

    public static void modifyArrowSpeed(AbstractArrow arrow, double value) {
        arrow.m_20256_(arrow.m_20184_().m_82490_(value));
    }

    public static boolean isFullChance(Player player) {
        return player.m_36403_(0.5f) > 0.9f;
    }

    public static int getEffectLevel(LivingEntity entity, MobEffect effect) {
        MobEffectInstance instance = entity.m_21124_(effect);
        return instance == null ? -1 : instance.m_19564_();
    }

    public static float getMissHp(LivingEntity entity) {
        return entity.m_21233_() - entity.m_21223_();
    }

    public static float getPerMissHp(LivingEntity entity) {
        return 1.0f - entity.m_21223_() / entity.m_21233_();
    }

    public static void addEffect(LivingEntity entity, MobEffect effect, int time, int level) {
        entity.m_7292_(new MobEffectInstance(effect, time, level));
    }

    public static void addEffect(LivingEntity entity, MobEffect effect, int time) {
        EntityUtils.addEffect(entity, effect, time, 0);
    }

    public static int getHarmfulEffectCount(LivingEntity entity) {
        return (int)entity.m_21220_().stream().filter(e -> e.m_19544_().m_19483_() == MobEffectCategory.HARMFUL).count();
    }

    public static int getBeneficialEffectCount(LivingEntity entity) {
        return (int)entity.m_21220_().stream().filter(e -> e.m_19544_().m_19483_() == MobEffectCategory.BENEFICIAL).count();
    }

    public static boolean isJumping() {
        return Minecraft.m_91087_().f_91066_.f_92089_.m_90857_();
    }

    public static boolean isLookingBehindTarget(LivingEntity target, Vec3 attackerLocation) {
        if (attackerLocation != null) {
            Vec3 lookingVector = target.m_20252_(1.0f);
            Vec3 attackAngleVector = attackerLocation.m_82546_(target.m_20182_()).m_82541_();
            attackAngleVector = new Vec3(attackAngleVector.f_82479_, 0.0, attackAngleVector.f_82481_);
            return attackAngleVector.m_82526_(lookingVector) < -0.5;
        }
        return false;
    }
}

